// اسم الكاش
const CACHE_NAME = 'ramadan-app-v1';

// الملفات التي سيتم تخزينها
const urlsToCache = [
    './',
    './index.html',
    './assets/css/style.css',
    './assets/js/data.js',
    './assets/js/app.js',
    './assets/js/pwa.js',
    './manifest.json'
];

// تثبيت Service Worker
self.addEventListener('install', (event) => {
    event.waitUntil(
        caches.open(CACHE_NAME)
            .then((cache) => {
                console.log('تم فتح الكاش');
                return cache.addAll(urlsToCache);
            })
            .then(() => {
                // تفعيل فوري بدون انتظار
                return self.skipWaiting();
            })
    );
});

// تفعيل Service Worker
self.addEventListener('activate', (event) => {
    event.waitUntil(
        caches.keys().then((cacheNames) => {
            return Promise.all(
                cacheNames.map((cacheName) => {
                    // حذف الكاش القديم
                    if (cacheName !== CACHE_NAME) {
                        console.log('حذف الكاش القديم:', cacheName);
                        return caches.delete(cacheName);
                    }
                })
            );
        }).then(() => {
            // التحكم في جميع الصفحات فوراً
            return self.clients.claim();
        })
    );
});

// استراتيجية الكاش: Cache First, Network Fallback
self.addEventListener('fetch', (event) => {
    event.respondWith(
        caches.match(event.request)
            .then((response) => {
                // إرجاع الملف من الكاش إذا وُجد
                if (response) {
                    return response;
                }

                // إذا لم يوجد، جلبه من الشبكة
                return fetch(event.request).then((response) => {
                    // التحقق من صحة الاستجابة
                    if (!response || response.status !== 200 || response.type !== 'basic') {
                        return response;
                    }

                    // نسخ الاستجابة للكاش
                    const responseToCache = response.clone();

                    caches.open(CACHE_NAME)
                        .then((cache) => {
                            cache.put(event.request, responseToCache);
                        });

                    return response;
                });
            })
            .catch(() => {
                // في حالة فشل الشبكة والكاش، إرجاع صفحة offline
                return caches.match('./index.html');
            })
    );
});

// الاستماع لرسائل التحديث
self.addEventListener('message', (event) => {
    if (event.data && event.data.type === 'SKIP_WAITING') {
        self.skipWaiting();
    }
});
