/** @type {import('tailwindcss').Config} */
export default {
  content: [
    "./resources/**/*.blade.php",
    "./resources/**/*.js",
    "./resources/**/*.vue",
  ],
  darkMode: 'class',
  safelist: [
    'grid-cols-2',
    'grid-cols-3',
    'grid-cols-4',
    'grid-cols-6',
  ],
  theme: {
    extend: {
      colors: {
        nassaj: {
          primary: {
            DEFAULT: '#442247',
            dark: '#2d1635',
            darker: '#1a0a1e',
            light: '#5a2f5e',
          },
          secondary: {
            DEFAULT: '#B0A262',
            dark: '#c4b890',
            light: '#e4d8b0',
          },
          purple: {
            DEFAULT: '#442247',
            dark: '#2d1635',
            darker: '#1a0a1e',
            light: '#5a2f5e',
          },
          gold: {
            DEFAULT: '#B0A262',
            dark: '#c4b890',
            light: '#e4d8b0',
          },
          cream: {
            DEFAULT: '#E8DFC2',
            dark: '#d4cbaf',
            light: '#f2ebd5',
          },
          black: '#1A1A1A',
          white: '#FFFFFF',
          // Light mode surface colors
          surface: {
            DEFAULT: '#FAFAF8',
            raised: '#FFFFFF',
            overlay: '#FFFFFF',
            sunken: '#F5F4F0',
          },
          // Light mode text hierarchy
          text: {
            primary: '#1A1A1A',
            secondary: '#4A4A4A',
            muted: '#7A7A7A',
            subtle: '#A0A0A0',
          },
          // Border colors for light mode
          border: {
            DEFAULT: 'rgba(68, 34, 71, 0.08)',
            strong: 'rgba(68, 34, 71, 0.12)',
            subtle: 'rgba(68, 34, 71, 0.05)',
            gold: 'rgba(176, 162, 98, 0.25)',
          },
        },
      },
      borderRadius: {
        'card': '16px',
      },
      transitionDuration: {
        '350': '350ms',
      },
      boxShadow: {
        // Light mode shadows (warm-tinted, subtle)
        'light': '0 1px 3px rgba(68, 34, 71, 0.04), 0 1px 2px rgba(68, 34, 71, 0.06)',
        'light-md': '0 4px 6px rgba(68, 34, 71, 0.04), 0 2px 4px rgba(68, 34, 71, 0.06)',
        'light-lg': '0 10px 15px rgba(68, 34, 71, 0.06), 0 4px 6px rgba(68, 34, 71, 0.05)',
        'light-xl': '0 20px 25px rgba(68, 34, 71, 0.08), 0 10px 10px rgba(68, 34, 71, 0.04)',
        'light-2xl': '0 25px 50px rgba(68, 34, 71, 0.12)',
        // Premium card shadow for light mode
        'card': '0 1px 3px rgba(68, 34, 71, 0.06), 0 4px 12px rgba(68, 34, 71, 0.04)',
        'card-hover': '0 8px 24px rgba(68, 34, 71, 0.10), 0 2px 6px rgba(68, 34, 71, 0.06)',
        // Button shadows
        'btn': '0 1px 2px rgba(68, 34, 71, 0.05)',
        'btn-hover': '0 4px 12px rgba(176, 162, 98, 0.25)',
        'btn-gold': '0 4px 14px rgba(176, 162, 98, 0.35)',
        // Legacy shadows (kept for backward compatibility)
        'medium': '0 4px 16px rgba(68, 34, 71, 0.12)',
        'large': '0 8px 32px rgba(68, 34, 71, 0.16)',
        'primary': '0 4px 20px rgba(68, 34, 71, 0.4)',
        'primary-lg': '0 8px 32px rgba(68, 34, 71, 0.5)',
        'secondary': '0 4px 20px rgba(212, 200, 160, 0.4)',
        'secondary-lg': '0 8px 32px rgba(212, 200, 160, 0.5)',
        'gold': '0 4px 20px rgba(212, 200, 160, 0.4)',
        'gold-lg': '0 8px 32px rgba(212, 200, 160, 0.5)',
        // Navbar shadow for light mode
        'navbar': '0 1px 3px rgba(68, 34, 71, 0.08), 0 4px 12px rgba(68, 34, 71, 0.04)',
        // Dropdown shadow
        'dropdown': '0 10px 40px rgba(68, 34, 71, 0.12), 0 2px 6px rgba(68, 34, 71, 0.04)',
      },
      keyframes: {
        fadeInUp: {
          '0%': { opacity: '0', transform: 'translateY(20px)' },
          '100%': { opacity: '1', transform: 'translateY(0)' },
        },
        scaleIn: {
          '0%': { opacity: '0', transform: 'scale(0.95)' },
          '100%': { opacity: '1', transform: 'scale(1)' },
        },
        drawerSlide: {
          '0%': { transform: 'translateX(100%)' },
          '100%': { transform: 'translateX(0)' },
        },
        drawerSlideRTL: {
          '0%': { transform: 'translateX(-100%)' },
          '100%': { transform: 'translateX(0)' },
        },
        toastSlide: {
          '0%': { opacity: '0', transform: 'translateY(-100%)' },
          '100%': { opacity: '1', transform: 'translateY(0)' },
        },
        pulseSoft: {
          '0%, 100%': { opacity: '1' },
          '50%': { opacity: '0.7' },
        },
      },
      animation: {
        'fade-in-up': 'fadeInUp 0.4s ease-out',
        'scale-in': 'scaleIn 0.3s ease-out',
        'drawer-slide': 'drawerSlide 0.3s ease-out',
        'drawer-slide-rtl': 'drawerSlideRTL 0.3s ease-out',
        'toast-slide': 'toastSlide 0.3s ease-out',
        'pulse-soft': 'pulseSoft 2s cubic-bezier(0.4, 0, 0.6, 1) infinite',
      },
      backgroundImage: {
        'gradient-primary': 'linear-gradient(135deg, #442247 0%, #B0A262 100%)',
        'gradient-secondary': 'linear-gradient(135deg, #B0A262 0%, #442247 100%)',
        'gradient-purple-gold': 'linear-gradient(135deg, #442247 0%, #B0A262 100%)',
        'gradient-gold-purple': 'linear-gradient(135deg, #B0A262 0%, #442247 100%)',
        // Light mode hero background
        'hero-light': 'linear-gradient(135deg, #FAFAF8 0%, #F5F4F0 50%, #EDE9E0 100%)',
        // Gold gradient for badges/buttons
        'gradient-gold': 'linear-gradient(135deg, #CCBF79 0%, #A89958 100%)',
        'gradient-gold-hover': 'linear-gradient(135deg, #D4C8A0 0%, #B8A868 100%)',
      },
      typography: {
        DEFAULT: {
          css: {
            maxWidth: 'none',
            color: '#1A1A1A',
            a: {
              color: '#442247',
              '&:hover': {
                color: '#B0A262',
              },
            },
          },
        },
      },
    },
  },
  plugins: [],
}
