<?php $__env->startSection('title', 'تواصل معنا - نساج'); ?>

<?php $__env->startSection('hero_title', 'اتصل بنا'); ?>
<?php $__env->startSection('hero_description', 'نحن هنا للإجابة على أسئلتك وخدمتك على مدار الساعة'); ?>
<?php $__env->startSection('hero_breadcrumbs'); ?>
    <span class="text-white/30 mx-1">›</span>
    <span class="text-nassaj-gold">اتصل بنا</span>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section
        class="py-14 md:py-16
               bg-[#f4f0e6] text-[#111]
               dark:bg-[#07070a] dark:text-white
               relative overflow-hidden">

        
        <div aria-hidden="true" class="pointer-events-none absolute inset-0">
            <div
                class="absolute -top-24 -right-24 h-72 w-72 rounded-full blur-3xl opacity-60
                        bg-[radial-gradient(circle_at_center,rgba(204,191,121,0.45),transparent_60%)]
                        dark:bg-[radial-gradient(circle_at_center,rgba(140,72,140,0.35),transparent_60%)]">
            </div>

            <div
                class="absolute top-10 -left-24 h-80 w-80 rounded-full blur-3xl opacity-60
                        bg-[radial-gradient(circle_at_center,rgba(139,71,137,0.22),transparent_60%)]
                        dark:bg-[radial-gradient(circle_at_center,rgba(204,191,121,0.22),transparent_60%)]">
            </div>

            <div
                class="absolute bottom-0 left-1/2 -translate-x-1/2 h-80 w-[60rem] rounded-full blur-3xl opacity-30
                        bg-[radial-gradient(circle_at_center,rgba(0,0,0,0.20),transparent_60%)]
                        dark:bg-[radial-gradient(circle_at_center,rgba(255,255,255,0.06),transparent_60%)]">
            </div>
        </div>

        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative">
            <?php
                $cardBase = 'rounded-[22px] p-6 md:p-7
                    bg-white/80 border border-black/5
                    shadow-[0_10px_30px_rgba(0,0,0,0.07)]
                    dark:bg-white/[0.04] dark:border-white/10 dark:shadow-[0_18px_55px_rgba(0,0,0,0.35)]';

                $iconBox = 'w-12 h-12 rounded-2xl flex items-center justify-center shrink-0
                    bg-[#CCBF79]/22 dark:bg-[#CCBF79]/10 border border-[#CCBF79]/25 dark:border-[#CCBF79]/15';

                $title = 'font-black text-[#101010] dark:text-white';
                $muted = 'text-sm text-[#4b4b4b] dark:text-white/60';
            ?>

            
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-8">
                <div class="<?php echo e($cardBase); ?>">
                    <div class="flex items-start gap-4">
                        <div class="<?php echo e($iconBox); ?>">
                            <svg class="w-6 h-6 text-[#8b4789] dark:text-[#CCBF79]" fill="none" stroke="currentColor"
                                viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.6"
                                    d="M17.657 16.657L13.414 20.9a2 2 0 01-2.828 0l-4.243-4.243a8 8 0 1111.314 0z" />
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.6"
                                    d="M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
                            </svg>
                        </div>
                        <div class="min-w-0">
                            <h3 class="<?php echo e($title); ?>">العنوان</h3>
                            <p class="<?php echo e($muted); ?> mt-1">بغداد - المنصور </p>
                        </div>
                    </div>
                </div>

                <div class="<?php echo e($cardBase); ?>">
                    <div class="flex items-start gap-4">
                        <div class="<?php echo e($iconBox); ?>">
                            <svg class="w-6 h-6 text-[#8b4789] dark:text-[#CCBF79]" fill="none" stroke="currentColor"
                                viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.6"
                                    d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
                            </svg>
                        </div>
                        <div class="min-w-0">
                            <h3 class="<?php echo e($title); ?>">الهاتف</h3>
                            <p class="<?php echo e($muted); ?> mt-1" dir="ltr">+964 770 123 4567</p>
                            <p class="<?php echo e($muted); ?>" dir="ltr">+964 780 000 0770</p>
                        </div>
                    </div>
                </div>

                <div class="<?php echo e($cardBase); ?>">
                    <div class="flex items-start gap-4">
                        <div class="<?php echo e($iconBox); ?>">
                            <svg class="w-6 h-6 text-[#8b4789] dark:text-[#CCBF79]" fill="none" stroke="currentColor"
                                viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.6"
                                    d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8" />
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.6"
                                    d="M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                            </svg>
                        </div>
                        <div class="min-w-0">
                            <h3 class="<?php echo e($title); ?>">البريد الإلكتروني</h3>
                            <p class="<?php echo e($muted); ?> mt-1">support@nassaj.iq</p>
                            <p class="<?php echo e($muted); ?>">sales@nassaj.iq</p>
                        </div>
                    </div>
                </div>

                <div class="<?php echo e($cardBase); ?>">
                    <div class="flex items-start gap-4">
                        <div class="<?php echo e($iconBox); ?>">
                            <svg class="w-6 h-6 text-[#8b4789] dark:text-[#CCBF79]" fill="none" stroke="currentColor"
                                viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.6" d="M12 8v4l3 3" />
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.6"
                                    d="M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                        </div>
                        <div class="min-w-0">
                            <h3 class="<?php echo e($title); ?>">ساعات العمل</h3>
                            <p class="<?php echo e($muted); ?> mt-1">السبت - الخميس: 9:00 ص - 10:00 م</p>
                            <p class="<?php echo e($muted); ?>">الجمعة: 2:00 م - 10:00 م</p>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="grid grid-cols-1 lg:grid-cols-12 gap-8 lg:gap-10 items-start">

                
                <div
                    class="lg:col-span-7
                           rounded-[28px] p-7 md:p-8
                           bg-white/80 border border-black/5 shadow-[0_12px_40px_rgba(0,0,0,0.08)]
                           dark:bg-white/[0.04] dark:border-white/10 dark:shadow-[0_20px_60px_rgba(0,0,0,0.35)]">

                    <div class="flex items-center gap-3 mb-7">
                        <span
                            class="inline-flex items-center justify-center w-10 h-10 rounded-2xl
                                   bg-[#CCBF79]/25 dark:bg-[#CCBF79]/10 border border-[#CCBF79]/25 dark:border-[#CCBF79]/15">
                            <svg class="w-5 h-5 text-[#8b4789] dark:text-[#CCBF79]" viewBox="0 0 24 24" fill="none"
                                stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.8" d="M22 2L11 13" />
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.8"
                                    d="M22 2l-7 20-4-9-9-4 20-7z" />
                            </svg>
                        </span>
                        <h2 class="cairo text-xl md:text-2xl font-black text-[#101010] dark:text-white">
                            أرسل لنا رسالة
                        </h2>
                    </div>

                    <form action="#" method="POST" class="space-y-5">
                        <?php echo csrf_field(); ?>

                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-5">
                            <div class="space-y-2">
                                <label for="name" class="block text-sm font-bold text-[#2a2a2a]/80 dark:text-white/70">
                                    الاسم الكامل
                                </label>
                                <input type="text" id="name" name="name" required
                                    class="w-full px-5 py-4 rounded-2xl
                                           bg-[#f1ede2] border border-black/5
                                           text-[#121212] placeholder:text-[#6b6b6b]
                                           outline-none focus:ring-2 focus:ring-[#CCBF79]/60 focus:border-[#CCBF79]/60
                                           dark:bg-white/[0.06] dark:border-white/10 dark:text-white dark:placeholder:text-white/40" />
                            </div>

                            <div class="space-y-2">
                                <label for="email"
                                    class="block text-sm font-bold text-[#2a2a2a]/80 dark:text-white/70">
                                    البريد الإلكتروني
                                </label>
                                <input type="email" id="email" name="email" required
                                    class="w-full px-5 py-4 rounded-2xl
                                           bg-[#f1ede2] border border-black/5
                                           text-[#121212] placeholder:text-[#6b6b6b]
                                           outline-none focus:ring-2 focus:ring-[#CCBF79]/60 focus:border-[#CCBF79]/60
                                           dark:bg-white/[0.06] dark:border-white/10 dark:text-white dark:placeholder:text-white/40" />
                            </div>
                        </div>

                        
                        <div class="space-y-2">
                            <label for="subject" class="block text-sm font-bold text-[#2a2a2a]/80 dark:text-white/70">
                                الموضوع
                            </label>
                            <input type="text" id="subject" name="subject" placeholder="موضوع الرسالة"
                                class="w-full px-5 py-4 rounded-2xl
                                       bg-[#f1ede2] border border-black/5
                                       text-[#121212] placeholder:text-[#6b6b6b]
                                       outline-none focus:ring-2 focus:ring-[#CCBF79]/60 focus:border-[#CCBF79]/60
                                       dark:bg-white/[0.06] dark:border-white/10 dark:text-white dark:placeholder:text-white/40" />
                        </div>

                        
                        <div class="space-y-2">
                            <label for="message" class="block text-sm font-bold text-[#2a2a2a]/80 dark:text-white/70">
                                الرسالة
                            </label>
                            <textarea id="message" name="message" rows="3" required placeholder="اكتب رسالتك هنا..."
                                class="w-full px-5 py-4 rounded-2xl
                                       bg-[#f1ede2] border border-black/5
                                       text-[#121212] placeholder:text-[#6b6b6b]
                                       outline-none focus:ring-2 focus:ring-[#CCBF79]/60 focus:border-[#CCBF79]/60
                                       dark:bg-white/[0.06] dark:border-white/10 dark:text-white dark:placeholder:text-white/40
                                       resize-y min-h-[140px] max-h-[420px]"></textarea>
                        </div>

                        <button type="submit"
                            class="w-full mt-2 py-4 rounded-full font-black text-base
                                   text-[#0d0d0d] bg-[#CCBF79]
                                   hover:brightness-105 active:brightness-95 transition
                                   shadow-[0_12px_30px_rgba(204,191,121,0.35)]
                                   dark:shadow-[0_14px_40px_rgba(0,0,0,0.35)]">
                            إرسال الرسالة
                        </button>
                    </form>
                </div>

                
                <div class="lg:col-span-5">
                    <div class="mb-4 text-right">
                        <span
                            class="inline-flex items-center gap-2 px-4 py-2 rounded-full
                                   bg-white/70 border border-black/5 text-xs font-black text-[#8b4789]
                                   dark:bg-white/[0.04] dark:border-white/10 dark:text-[#CCBF79]">
                            أسئلة متكررة
                        </span>
                    </div>

                    <?php
                        $faqWrap = 'rounded-[22px] overflow-hidden
                            bg-white/80 border border-black/5
                            shadow-[0_10px_30px_rgba(0,0,0,0.07)]
                            dark:bg-white/[0.04] dark:border-white/10 dark:shadow-[0_18px_55px_rgba(0,0,0,0.35)]';
                    ?>

                    <div class="space-y-4">

                        
                        <div class="<?php echo e($faqWrap); ?> faq-item is-open">
                            <button type="button" class="w-full flex items-center justify-between gap-4 p-6 text-right">
                                <span class="font-black text-[#101010] dark:text-white">ما هي طرق الدفع المتاحة؟</span>
                                <svg class="w-5 h-5 text-[#8b4789] dark:text-[#CCBF79] transition-transform"
                                    fill="none" stroke="currentColor" viewBox="0 0 24 24"
                                    style="transform: rotate(180deg);">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M19 9l-7 7-7-7" />
                                </svg>
                            </button>
                            <div class="faq-content px-6 pb-6">
                                <p class="text-sm text-[#4b4b4b] dark:text-white/60 leading-7">
                                    نوفر خيارات دفع متعددة لتسهيل الشراء:
                                    <br>• الدفع نقدًا عند الاستلام داخل المدينة.
                                    <br>• تحويل مصرفي إلى حساباتنا المعتمدة (يتم تأكيد الطلب بعد إرسال وصل التحويل).
                                    <br>• محافظ إلكترونية حسب المتوفر.
                                    <br><span class="font-bold">ملاحظة:</span> قد تختلف الخيارات حسب المحافظة وطريقة الشحن.
                                </p>
                            </div>
                        </div>

                        <div class="<?php echo e($faqWrap); ?> faq-item">
                            <button type="button" class="w-full flex items-center justify-between gap-4 p-6 text-right">
                                <span class="font-black text-[#101010] dark:text-white">كم تستغرق عملية التوصيل؟</span>
                                <svg class="w-5 h-5 text-[#8b4789] dark:text-[#CCBF79] transition-transform"
                                    fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M19 9l-7 7-7-7" />
                                </svg>
                            </button>
                            <div class="faq-content px-6 pb-6 hidden">
                                <p class="text-sm text-[#4b4b4b] dark:text-white/60 leading-7">
                                    مدة التوصيل تعتمد على موقعك وشركة الشحن:
                                    <br>• داخل البصرة: عادةً 1–2 يوم عمل.
                                    <br>• باقي المحافظات: 3–5 أيام عمل.
                                    <br>• في أوقات الضغط/العطل الرسمية قد يحدث تأخير بسيط.
                                    <br>سنرسل لك تحديثات حالة الطلب عند الشحن وعند التسليم.
                                </p>
                            </div>
                        </div>

                        <div class="<?php echo e($faqWrap); ?> faq-item">
                            <button type="button" class="w-full flex items-center justify-between gap-4 p-6 text-right">
                                <span class="font-black text-[#101010] dark:text-white">هل يوجد ضمان على المنتجات؟</span>
                                <svg class="w-5 h-5 text-[#8b4789] dark:text-[#CCBF79] transition-transform"
                                    fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M19 9l-7 7-7-7" />
                                </svg>
                            </button>
                            <div class="faq-content px-6 pb-6 hidden">
                                <p class="text-sm text-[#4b4b4b] dark:text-white/60 leading-7">
                                    نعم، معظم منتجاتنا تشمل ضمانًا حسب نوع المنتج:
                                    <br>• ضمان جودة تصنيع ضد العيوب المصنعية.
                                    <br>• مدة الضمان تختلف (مثلاً سنة إلى ثلاث سنوات) حسب التصنيف.
                                    <br>• لا يشمل الضمان سوء الاستخدام أو التلف الناتج عن عوامل خارجية.
                                    <br>للتفاصيل الدقيقة نرفق سياسة الضمان في صفحة المنتج أو مع الفاتورة.
                                </p>
                            </div>
                        </div>

                        <div class="<?php echo e($faqWrap); ?> faq-item">
                            <button type="button" class="w-full flex items-center justify-between gap-4 p-6 text-right">
                                <span class="font-black text-[#101010] dark:text-white">هل يمكن استبدال أو إرجاع
                                    المنتج؟</span>
                                <svg class="w-5 h-5 text-[#8b4789] dark:text-[#CCBF79] transition-transform"
                                    fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M19 9l-7 7-7-7" />
                                </svg>
                            </button>
                            <div class="faq-content px-6 pb-6 hidden">
                                <p class="text-sm text-[#4b4b4b] dark:text-white/60 leading-7">
                                    نعم، يمكن الاستبدال أو الإرجاع وفق الشروط التالية:
                                    <br>• خلال 7 أيام من الاستلام.
                                    <br>• أن يكون المنتج بحالته الأصلية وغير مستخدم ومع التغليف.
                                    <br>• في حال وجود خطأ في الطلب أو عيب مصنعي نتحمل إجراءات المعالجة حسب الحالة.
                                    <br>تواصل معنا وسنوجّهك بالخطوات بسرعة.
                                </p>
                            </div>
                        </div>

                    </div>
                </div>

                
                <div class="lg:col-span-12 mt-2">
                    <div
                        class="rounded-[26px] overflow-hidden
                               bg-white/80 border border-black/5
                               shadow-[0_12px_40px_rgba(0,0,0,0.08)]
                               dark:bg-white/[0.03] dark:border-white/10 dark:shadow-[0_18px_60px_rgba(0,0,0,0.45)]">
                        <div class="h-[320px] md:h-[360px]">
                            <iframe
                                src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3397.5!2d47.78!3d30.51!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x0!2zMzDCsDMwJzM2LjAiTiA0N8KwNDYnNDguMCJF!5e0!3m2!1sen!2siq!4v1234567890"
                                width="100%" height="100%" style="border:0;" allowfullscreen="" loading="lazy"
                                referrerpolicy="no-referrer-when-downgrade"></iframe>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        // FAQ accordion: first open, others collapsible
        const faqItems = Array.from(document.querySelectorAll('.faq-item'));

        function closeItem(item) {
            item.classList.remove('is-open');
            const content = item.querySelector('.faq-content');
            const icon = item.querySelector('svg');
            if (content) content.classList.add('hidden');
            if (icon) icon.style.transform = '';
        }

        function openItem(item) {
            item.classList.add('is-open');
            const content = item.querySelector('.faq-content');
            const icon = item.querySelector('svg');
            if (content) content.classList.remove('hidden');
            if (icon) icon.style.transform = 'rotate(180deg)';
        }

        // normalize initial state (keep first open if marked)
        faqItems.forEach((item, idx) => {
            const content = item.querySelector('.faq-content');
            const icon = item.querySelector('svg');

            const shouldOpen = item.classList.contains('is-open') || idx === 0;
            if (shouldOpen) {
                if (content) content.classList.remove('hidden');
                if (icon) icon.style.transform = 'rotate(180deg)';
                item.classList.add('is-open');
            } else {
                if (content) content.classList.add('hidden');
                if (icon) icon.style.transform = '';
                item.classList.remove('is-open');
            }
        });

        faqItems.forEach((item) => {
            const btn = item.querySelector('button');
            if (!btn) return;

            btn.addEventListener('click', () => {
                const isOpen = item.classList.contains('is-open');

                // close all first
                faqItems.forEach(closeItem);

                // toggle current
                if (!isOpen) openItem(item);
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\dante\Herd\nassaj\resources\views/contact.blade.php ENDPATH**/ ?>