<?php $__env->startSection('title', 'من نحن - نساج'); ?>

<?php $__env->startSection('content'); ?>
    
    <section
        class="relative overflow-hidden bg-gradient-to-br from-[#442247] via-[#2d1635] to-[#140616] dark:from-[#442247] dark:via-[#2d1635] dark:to-[#140616] py-20 md:py-32">
        
        <div class="absolute inset-0 opacity-20">
            <div class="absolute top-0 right-0 w-96 h-96 bg-nassaj-gold/30 rounded-full blur-3xl"></div>
            <div class="absolute bottom-0 left-0 w-96 h-96 bg-purple-500/20 rounded-full blur-3xl"></div>
        </div>

        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
            <div class="text-center max-w-4xl mx-auto">
                <div
                    class="inline-flex items-center gap-2 px-6 py-3 bg-nassaj-gold/10 border border-nassaj-gold/30 rounded-full mb-8">
                    <svg class="w-5 h-5 text-nassaj-gold" fill="none" stroke="currentColor" stroke-width="2"
                        viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round"
                            d="M9.813 15.904L9 18.75l-.813-2.846a4.5 4.5 0 00-3.09-3.09L2.25 12l2.846-.813a4.5 4.5 0 003.09-3.09L9 5.25l.813 2.846a4.5 4.5 0 003.09 3.09L15.75 12l-2.846.813a4.5 4.5 0 00-3.09 3.09z" />
                    </svg>
                    <span class="text-nassaj-gold font-bold text-sm">قصة نساج</span>
                </div>

                <h1 class="cairo text-5xl md:text-7xl font-black text-white mb-6 leading-tight">
                    حيث تلتقي <span class="text-nassaj-gold">الجودة</span><br>
                    بالراحة والأناقة
                </h1>

                <p class="text-xl text-white/80 leading-relaxed">
                    متجر عراقي متخصص في صناعة وبيع أفخم أنواع الجوارب،<br>
                    نجمع بين الجودة العراقية الأصيلة والتصاميم العصرية
                </p>
            </div>
        </div>
    </section>

    
    <section class="py-20 bg-white dark:bg-[#0a0a0a] transition-colors duration-300">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="about-hero-grid grid grid-cols-1 lg:grid-cols-2 gap-12 lg:gap-16 items-center">
                
                <div>
                    <span
                        class="inline-block px-4 py-2 bg-nassaj-gold/10 text-nassaj-gold rounded-full text-xs font-bold tracking-wider mb-6">
                        قصتنا
                    </span>

                    <h2 class="cairo text-3xl md:text-5xl font-black text-gray-900 dark:text-white mb-6 leading-tight">
                        رحلة <span class="text-nassaj-gold">التميز</span><br>
                        في عالم الجوارب
                    </h2>

                    <p class="text-gray-600 dark:text-gray-400 leading-relaxed mb-6 text-lg">
                        بدأت رحلتنا من شغف حقيقي بتقديم منتجات عالية الجودة تجمع بين الراحة والأناقة. في نساج، نؤمن
                        بأن الجوارب ليست مجرد قطعة ملابس، بل هي تعبير عن الأسلوب والشخصية.
                    </p>

                    <p class="text-gray-600 dark:text-gray-400 leading-relaxed mb-8 text-lg">
                        نحرص على اختيار أفضل الخامات وأحدث التصاميم لنقدم لعملائنا تجربة استثنائية في كل خطوة. من الجوارب
                        الكلاسيكية للاستخدام اليومي إلى التصاميم العصرية والرياضية، نوفر خيارات متنوعة تناسب جميع
                        الأذواق.
                    </p>

                    
                    <div class="about-stats-grid grid grid-cols-3 gap-4">
                        <div
                            class="bg-gray-50 dark:bg-white/5 rounded-2xl p-6 text-center border border-gray-200 dark:border-white/10 transition-colors duration-300">
                            <span class="block text-3xl md:text-4xl font-black text-nassaj-gold mb-2">5000+</span>
                            <span class="text-gray-600 dark:text-gray-400 text-sm font-medium">عميل سعيد</span>
                        </div>
                        <div
                            class="bg-gray-50 dark:bg-white/5 rounded-2xl p-6 text-center border border-gray-200 dark:border-white/10 transition-colors duration-300">
                            <span class="block text-3xl md:text-4xl font-black text-nassaj-gold mb-2">500+</span>
                            <span class="text-gray-600 dark:text-gray-400 text-sm font-medium">منتج متنوع</span>
                        </div>
                        <div
                            class="bg-gray-50 dark:bg-white/5 rounded-2xl p-6 text-center border border-gray-200 dark:border-white/10 transition-colors duration-300">
                            <span class="block text-3xl md:text-4xl font-black text-nassaj-gold mb-2">10+</span>
                            <span class="text-gray-600 dark:text-gray-400 text-sm font-medium">سنوات خبرة</span>
                        </div>
                    </div>
                </div>

                
                <div class="relative">
                    <div class="relative rounded-3xl overflow-hidden shadow-2xl">
                        <div class="aspect-[4/3] relative group">
                            <img src="<?php echo e(asset('images/about/hero-image.jpg')); ?>" 
                                 alt="متجر نساج - جوارب فاخرة"
                                 class="w-full h-full object-cover transition-transform duration-700 group-hover:scale-105"
                                 loading="lazy">
                            
                            <div class="absolute inset-0 bg-gradient-to-br from-transparent via-transparent to-black/10 dark:to-black/30 group-hover:to-black/20 dark:group-hover:to-black/40 transition-all duration-700"></div>
                        </div>
                        
                        <div class="about-hero-badge absolute bottom-6 right-6 bg-nassaj-gold rounded-2xl p-6 shadow-xl max-w-[200px] z-10 transform hover:scale-105 transition-transform duration-300">
                            <span class="block text-4xl font-black text-nassaj-primary mb-1">10+</span>
                            <p class="text-nassaj-primary font-bold text-sm">سنوات من التميز</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    
    <section class="py-20 bg-gray-50 dark:bg-[#111111] transition-colors duration-300">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <span
                    class="inline-block px-4 py-2 bg-nassaj-gold/10 text-nassaj-gold rounded-full text-xs font-bold tracking-wider mb-6">
                    قيمنا
                </span>
                <h2 class="cairo text-3xl md:text-5xl font-black text-gray-900 dark:text-white mb-4">
                    ما يميزنا عن <span class="text-nassaj-gold">الآخرين</span>
                </h2>
                <p class="text-gray-600 dark:text-gray-400 text-lg max-w-2xl mx-auto">
                    نلتزم بمجموعة من القيم التي تجعلنا الخيار الأفضل لعملائنا
                </p>
            </div>

            <div class="about-values-grid grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                
                <div
                    class="bg-white dark:bg-white/5 rounded-3xl p-8 text-center border border-gray-200 dark:border-white/10 group hover:border-nassaj-gold dark:hover:border-nassaj-gold transition-all duration-300 hover:shadow-xl">
                    <div
                        class="w-16 h-16 mx-auto mb-6 rounded-2xl bg-nassaj-gold/10 flex items-center justify-center group-hover:bg-nassaj-gold/20 transition-colors">
                        <svg class="w-8 h-8 text-nassaj-gold" fill="none" stroke="currentColor" stroke-width="2"
                            viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M9 12.75L11.25 15 15 9.75M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                    </div>
                    <h3 class="text-gray-900 dark:text-white font-bold text-xl mb-3">الجودة الفائقة</h3>
                    <p class="text-gray-600 dark:text-gray-400 leading-relaxed">
                        نختار أفضل الخامات لضمان الراحة والمتانة في كل منتج
                    </p>
                </div>

                
                <div
                    class="bg-white dark:bg-white/5 rounded-3xl p-8 text-center border border-gray-200 dark:border-white/10 group hover:border-nassaj-gold dark:hover:border-nassaj-gold transition-all duration-300 hover:shadow-xl">
                    <div
                        class="w-16 h-16 mx-auto mb-6 rounded-2xl bg-nassaj-gold/10 flex items-center justify-center group-hover:bg-nassaj-gold/20 transition-colors">
                        <svg class="w-8 h-8 text-nassaj-gold" fill="none" stroke="currentColor" stroke-width="2"
                            viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M9.53 16.122a3 3 0 00-5.78 1.128 2.25 2.25 0 01-2.4 2.245 4.5 4.5 0 008.4-2.245c0-.399-.078-.78-.22-1.128zm0 0a15.998 15.998 0 003.388-1.62m-5.043-.025a15.994 15.994 0 011.622-3.395m3.42 3.42a15.995 15.995 0 004.764-4.648l3.876-5.814a1.151 1.151 0 00-1.597-1.597L14.146 6.32a15.996 15.996 0 00-4.649 4.763m3.42 3.42a6.776 6.776 0 00-3.42-3.42" />
                        </svg>
                    </div>
                    <h3 class="text-gray-900 dark:text-white font-bold text-xl mb-3">تصاميم عصرية</h3>
                    <p class="text-gray-600 dark:text-gray-400 leading-relaxed">
                        نواكب أحدث صيحات الموضة لنقدم أجمل التصاميم
                    </p>
                </div>

                
                <div
                    class="bg-white dark:bg-white/5 rounded-3xl p-8 text-center border border-gray-200 dark:border-white/10 group hover:border-nassaj-gold dark:hover:border-nassaj-gold transition-all duration-300 hover:shadow-xl">
                    <div
                        class="w-16 h-16 mx-auto mb-6 rounded-2xl bg-nassaj-gold/10 flex items-center justify-center group-hover:bg-nassaj-gold/20 transition-colors">
                        <svg class="w-8 h-8 text-nassaj-gold" fill="none" stroke="currentColor" stroke-width="2"
                            viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M21 7.5l-2.25-1.313M21 7.5v2.25m0-2.25l-2.25 1.313M3 7.5l2.25-1.313M3 7.5l2.25 1.313M3 7.5v2.25m9 3l2.25-1.313M12 12.75l-2.25-1.313M12 12.75V15m0 6.75l2.25-1.313M12 21.75V19.5m0 2.25l-2.25-1.313m0-16.875L12 2.25l2.25 1.313M21 14.25v2.25l-2.25 1.313m-13.5 0L3 16.5v-2.25" />
                        </svg>
                    </div>
                    <h3 class="text-gray-900 dark:text-white font-bold text-xl mb-3">تنوع كبير</h3>
                    <p class="text-gray-600 dark:text-gray-400 leading-relaxed">
                        مجموعة واسعة من المنتجات لتناسب جميع الأذواق
                    </p>
                </div>

                
                <div
                    class="bg-white dark:bg-white/5 rounded-3xl p-8 text-center border border-gray-200 dark:border-white/10 group hover:border-nassaj-gold dark:hover:border-nassaj-gold transition-all duration-300 hover:shadow-xl">
                    <div
                        class="w-16 h-16 mx-auto mb-6 rounded-2xl bg-nassaj-gold/10 flex items-center justify-center group-hover:bg-nassaj-gold/20 transition-colors">
                        <svg class="w-8 h-8 text-nassaj-gold" fill="none" stroke="currentColor" stroke-width="2"
                            viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M15.75 6a3.75 3.75 0 11-7.5 0 3.75 3.75 0 017.5 0zM4.501 20.118a7.5 7.5 0 0114.998 0A17.933 17.933 0 0112 21.75c-2.676 0-5.216-.584-7.499-1.632z" />
                        </svg>
                    </div>
                    <h3 class="text-gray-900 dark:text-white font-bold text-xl mb-3">خدمة مميزة</h3>
                    <p class="text-gray-600 dark:text-gray-400 leading-relaxed">
                        دعم عملاء متميز وتجربة تسوق سلسة
                    </p>
                </div>
            </div>
        </div>
    </section>

    
    <section class="py-20 bg-white dark:bg-[#0a0a0a] transition-colors duration-300">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="about-vision-mission-grid grid grid-cols-1 md:grid-cols-2 gap-12">
                
                <div
                    class="bg-gradient-to-br from-nassaj-gold/5 to-nassaj-gold/10 dark:from-nassaj-gold/10 dark:to-nassaj-gold/5 rounded-3xl p-10 border border-nassaj-gold/20">
                    <div class="w-14 h-14 mb-6 rounded-2xl bg-nassaj-gold/20 flex items-center justify-center">
                        <svg class="w-7 h-7 text-nassaj-gold" fill="none" stroke="currentColor" stroke-width="2"
                            viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M2.036 12.322a1.012 1.012 0 010-.639C3.423 7.51 7.36 4.5 12 4.5c4.638 0 8.573 3.007 9.963 7.178.07.207.07.431 0 .639C20.577 16.49 16.64 19.5 12 19.5c-4.638 0-8.573-3.007-9.963-7.178z" />
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                        </svg>
                    </div>
                    <h3 class="cairo text-2xl md:text-3xl font-black text-gray-900 dark:text-white mb-4">رؤيتنا</h3>
                    <p class="text-gray-600 dark:text-gray-400 leading-relaxed text-lg">
                        أن نكون الخيار الأول للجوارب في العراق والمنطقة، ونشر ثقافة الاهتمام بالتفاصيل والجودة في كل
                        خطوة نخطوها، مع الحفاظ على الهوية العراقية الأصيلة.
                    </p>
                </div>

                
                <div
                    class="bg-gradient-to-br from-purple-500/5 to-purple-500/10 dark:from-purple-500/10 dark:to-purple-500/5 rounded-3xl p-10 border border-purple-500/20">
                    <div class="w-14 h-14 mb-6 rounded-2xl bg-purple-500/20 flex items-center justify-center">
                        <svg class="w-7 h-7 text-purple-500" fill="none" stroke="currentColor" stroke-width="2"
                            viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M15.59 14.37a6 6 0 01-5.84 7.38v-4.8m5.84-2.58a14.98 14.98 0 006.16-12.12A14.98 14.98 0 009.631 8.41m5.96 5.96a14.926 14.926 0 01-5.841 2.58m-.119-8.54a6 6 0 00-7.381 5.84h4.8m2.581-5.84a14.927 14.927 0 00-2.58 5.84m2.699 2.7c-.103.021-.207.041-.311.06a15.09 15.09 0 01-2.448-2.448 14.9 14.9 0 01.06-.312m-2.24 2.39a4.493 4.493 0 00-1.757 4.306 4.493 4.493 0 004.306-1.758M16.5 9a1.5 1.5 0 11-3 0 1.5 1.5 0 013 0z" />
                        </svg>
                    </div>
                    <h3 class="cairo text-2xl md:text-3xl font-black text-gray-900 dark:text-white mb-4">رسالتنا</h3>
                    <p class="text-gray-600 dark:text-gray-400 leading-relaxed text-lg">
                        تقديم منتجات عالية الجودة بأسعار منافسة، وتوفير تجربة تسوق استثنائية لعملائنا، مع الالتزام
                        بالابتكار المستمر والحفاظ على أعلى معايير الجودة والخدمة.
                    </p>
                </div>
            </div>
        </div>
    </section>

    
    <section class="py-20 bg-gray-50 dark:bg-[#111111] transition-colors duration-300">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <span
                    class="inline-block px-4 py-2 bg-nassaj-gold/10 text-nassaj-gold rounded-full text-xs font-bold tracking-wider mb-6">
                    مميزاتنا
                </span>
                <h2 class="cairo text-3xl md:text-5xl font-black text-gray-900 dark:text-white mb-4">
                    لماذا تختار <span class="text-nassaj-gold">نساج؟</span>
                </h2>
            </div>

            <div class="about-features-grid grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                
                <div
                    class="flex items-start gap-4 bg-white dark:bg-white/5 rounded-2xl p-6 border border-gray-200 dark:border-white/10">
                    <div class="w-12 h-12 rounded-xl bg-nassaj-gold/10 flex items-center justify-center shrink-0">
                        <svg class="w-6 h-6 text-nassaj-gold" fill="none" stroke="currentColor" stroke-width="2"
                            viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M8.25 18.75a1.5 1.5 0 01-3 0m3 0a1.5 1.5 0 00-3 0m3 0h6m-9 0H3.375a1.125 1.125 0 01-1.125-1.125V14.25m17.25 4.5a1.5 1.5 0 01-3 0m3 0a1.5 1.5 0 00-3 0m3 0h1.125c.621 0 1.129-.504 1.09-1.124a17.902 17.902 0 00-3.213-9.193 2.056 2.056 0 00-1.58-.86H14.25M16.5 18.75h-2.25m0-11.177v-.958c0-.568-.422-1.048-.987-1.106a48.554 48.554 0 00-10.026 0 1.106 1.106 0 00-.987 1.106v7.635m12-6.677v6.677m0 4.5v-4.5m0 0h-12" />
                        </svg>
                    </div>
                    <div>
                        <h3 class="text-lg font-bold text-gray-900 dark:text-white mb-2">شحن سريع</h3>
                        <p class="text-sm text-gray-600 dark:text-gray-400">توصيل سريع لجميع المحافظات العراقية</p>
                    </div>
                </div>

                
                <div
                    class="flex items-start gap-4 bg-white dark:bg-white/5 rounded-2xl p-6 border border-gray-200 dark:border-white/10">
                    <div class="w-12 h-12 rounded-xl bg-nassaj-gold/10 flex items-center justify-center shrink-0">
                        <svg class="w-6 h-6 text-nassaj-gold" fill="none" stroke="currentColor" stroke-width="2"
                            viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M16.023 9.348h4.992v-.001M2.985 19.644v-4.992m0 0h4.992m-4.993 0l3.181 3.183a8.25 8.25 0 0013.803-3.7M4.031 9.865a8.25 8.25 0 0113.803-3.7l3.181 3.182" />
                        </svg>
                    </div>
                    <div>
                        <h3 class="text-lg font-bold text-gray-900 dark:text-white mb-2">سياسة إرجاع مرنة</h3>
                        <p class="text-sm text-gray-600 dark:text-gray-400">إرجاع مجاني خلال 14 يوم من الشراء</p>
                    </div>
                </div>

                
                <div
                    class="flex items-start gap-4 bg-white dark:bg-white/5 rounded-2xl p-6 border border-gray-200 dark:border-white/10">
                    <div class="w-12 h-12 rounded-xl bg-nassaj-gold/10 flex items-center justify-center shrink-0">
                        <svg class="w-6 h-6 text-nassaj-gold" fill="none" stroke="currentColor" stroke-width="2"
                            viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M2.25 18.75a60.07 60.07 0 0115.797 2.101c.727.198 1.453-.342 1.453-1.096V18.75M3.75 4.5v.75A.75.75 0 013 6h-.75m0 0v-.375c0-.621.504-1.125 1.125-1.125H20.25M2.25 6v9m18-10.5v.75c0 .414.336.75.75.75h.75m-1.5-1.5h.375c.621 0 1.125.504 1.125 1.125v9.75c0 .621-.504 1.125-1.125 1.125h-.375m1.5-1.5H21a.75.75 0 00-.75.75v.75m0 0H3.75m0 0h-.375a1.125 1.125 0 01-1.125-1.125V15m1.5 1.5v-.75A.75.75 0 003 15h-.75M15 10.5a3 3 0 11-6 0 3 3 0 016 0zm3 0h.008v.008H18V10.5zm-12 0h.008v.008H6V10.5z" />
                        </svg>
                    </div>
                    <div>
                        <h3 class="text-lg font-bold text-gray-900 dark:text-white mb-2">دفع آمن</h3>
                        <p class="text-sm text-gray-600 dark:text-gray-400">طرق دفع متعددة وآمنة 100%</p>
                    </div>
                </div>

                
                <div
                    class="flex items-start gap-4 bg-white dark:bg-white/5 rounded-2xl p-6 border border-gray-200 dark:border-white/10">
                    <div class="w-12 h-12 rounded-xl bg-nassaj-gold/10 flex items-center justify-center shrink-0">
                        <svg class="w-6 h-6 text-nassaj-gold" fill="none" stroke="currentColor" stroke-width="2"
                            viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M12 6v12m-3-2.818l.879.659c1.171.879 3.07.879 4.242 0 1.172-.879 1.172-2.303 0-3.182C13.536 12.219 12.768 12 12 12c-.725 0-1.45-.22-2.003-.659-1.106-.879-1.106-2.303 0-3.182s2.9-.879 4.006 0l.415.33M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                    </div>
                    <div>
                        <h3 class="text-lg font-bold text-gray-900 dark:text-white mb-2">أسعار تنافسية</h3>
                        <p class="text-sm text-gray-600 dark:text-gray-400">أفضل الأسعار مع عروض دائمة</p>
                    </div>
                </div>

                
                <div
                    class="flex items-start gap-4 bg-white dark:bg-white/5 rounded-2xl p-6 border border-gray-200 dark:border-white/10">
                    <div class="w-12 h-12 rounded-xl bg-nassaj-gold/10 flex items-center justify-center shrink-0">
                        <svg class="w-6 h-6 text-nassaj-gold" fill="none" stroke="currentColor" stroke-width="2"
                            viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M20.25 8.511c.884.284 1.5 1.128 1.5 2.097v4.286c0 1.136-.847 2.1-1.98 2.193-.34.027-.68.052-1.02.072v3.091l-3-3c-1.354 0-2.694-.055-4.02-.163a2.115 2.115 0 01-.825-.242m9.345-8.334a2.126 2.126 0 00-.476-.095 48.64 48.64 0 00-8.048 0c-1.131.094-1.976 1.057-1.976 2.192v4.286c0 .837.46 1.58 1.155 1.951m9.345-8.334V6.637c0-1.621-1.152-3.026-2.76-3.235A48.455 48.455 0 0011.25 3c-2.115 0-4.198.137-6.24.402-1.608.209-2.76 1.614-2.76 3.235v6.226c0 1.621 1.152 3.026 2.76 3.235.577.075 1.157.14 1.74.194V21l4.155-4.155" />
                        </svg>
                    </div>
                    <div>
                        <h3 class="text-lg font-bold text-gray-900 dark:text-white mb-2">دعم مستمر</h3>
                        <p class="text-sm text-gray-600 dark:text-gray-400">فريق دعم متاح للرد على استفساراتك</p>
                    </div>
                </div>

                
                <div
                    class="flex items-start gap-4 bg-white dark:bg-white/5 rounded-2xl p-6 border border-gray-200 dark:border-white/10">
                    <div class="w-12 h-12 rounded-xl bg-nassaj-gold/10 flex items-center justify-center shrink-0">
                        <svg class="w-6 h-6 text-nassaj-gold" fill="none" stroke="currentColor" stroke-width="2"
                            viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M11.48 3.499a.562.562 0 011.04 0l2.125 5.111a.563.563 0 00.475.345l5.518.442c.499.04.701.663.321.988l-4.204 3.602a.563.563 0 00-.182.557l1.285 5.385a.562.562 0 01-.84.61l-4.725-2.885a.563.563 0 00-.586 0L6.982 20.54a.562.562 0 01-.84-.61l1.285-5.386a.562.562 0 00-.182-.557l-4.204-3.602a.563.563 0 01.321-.988l5.518-.442a.563.563 0 00.475-.345L11.48 3.5z" />
                        </svg>
                    </div>
                    <div>
                        <h3 class="text-lg font-bold text-gray-900 dark:text-white mb-2">ضمان الجودة</h3>
                        <p class="text-sm text-gray-600 dark:text-gray-400">منتجات أصلية بجودة عالية مضمونة</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    
    <section
        class="py-20 bg-gradient-to-br from-[#442247] via-[#2d1635] to-[#140616] dark:from-[#442247] dark:via-[#2d1635] dark:to-[#140616] relative overflow-hidden">
        
        <div class="absolute inset-0 opacity-20">
            <div class="absolute top-0 right-0 w-96 h-96 bg-nassaj-gold/30 rounded-full blur-3xl"></div>
            <div class="absolute bottom-0 left-0 w-96 h-96 bg-purple-500/20 rounded-full blur-3xl"></div>
        </div>

        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
            <div class="max-w-3xl mx-auto text-center">
                <h2 class="cairo text-3xl md:text-5xl font-black text-white mb-6">
                    ابدأ تجربة التسوق <span class="text-nassaj-gold">الآن</span>
                </h2>
                <p class="text-white/80 text-lg md:text-xl leading-relaxed mb-10">
                    اكتشف مجموعتنا الواسعة من الجوارب الفاخرة وابدأ رحلتك نحو الراحة والأناقة
                </p>
                <div class="flex flex-col sm:flex-row gap-4 justify-center">
                    <a href="<?php echo e(route('shop')); ?>"
                        class="inline-flex items-center justify-center gap-2 bg-nassaj-gold text-nassaj-primary px-8 py-4 rounded-full font-black text-lg transition-all duration-300 hover:scale-105 hover:shadow-2xl hover:shadow-nassaj-gold/30">
                        <span>تسوق الآن</span>
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2.5"
                            viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7" />
                        </svg>
                    </a>
                    <a href="<?php echo e(route('contact-us')); ?>"
                        class="inline-flex items-center justify-center gap-2 bg-white/10 backdrop-blur text-white border-2 border-white/30 px-8 py-4 rounded-full font-black text-lg transition-all duration-300 hover:bg-white/20 hover:border-white/50">
                        <span>تواصل معنا</span>
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2.5"
                            viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M21.75 6.75v10.5a2.25 2.25 0 01-2.25 2.25h-15a2.25 2.25 0 01-2.25-2.25V6.75m19.5 0A2.25 2.25 0 0019.5 4.5h-15a2.25 2.25 0 00-2.25 2.25m19.5 0v.243a2.25 2.25 0 01-1.07 1.916l-7.5 4.615a2.25 2.25 0 01-2.36 0L3.32 8.91a2.25 2.25 0 01-1.07-1.916V6.75" />
                        </svg>
                    </a>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\dante\Herd\nassaj\resources\views/about.blade.php ENDPATH**/ ?>