<?php $__env->startSection('title', $model->name . ' - تخصيص المنتج'); ?>
<?php $__env->startSection('page', 'configurator'); ?>

<?php $__env->startPush('styles'); ?>
<style>
/* ═══════════════════════════════════════════════════
   3D PRODUCT CONFIGURATOR — PROFESSIONAL LAYOUT
   ═══════════════════════════════════════════════════ */
body { overflow: hidden !important; height: 100vh !important; }
.cairo { font-family: 'Cairo', sans-serif; }

/* ─── ROOT ─── */
.cfg { display: flex; flex-direction: column; height: 100vh; background: #0a0a0a; color: #fff; }
.cfg-main { display: flex; flex: 1; overflow: hidden; }

/* ─── LEFT TOOLBAR ─── */
.cfg-bar { width: 58px; background: #111; display: flex; flex-direction: column; align-items: center; padding: 8px 0; gap: 2px; z-index: 20; border-right: 1px solid rgba(255,255,255,0.06); flex-shrink: 0; transition: transform 0.3s cubic-bezier(.16,1,.3,1), opacity 0.25s; }
.cfg-bar-btn { width: 46px; height: 52px; border-radius: 10px; display: flex; flex-direction: column; align-items: center; justify-content: center; gap: 2px; cursor: pointer; color: #888; transition: all 0.2s; background: transparent; border: none; text-decoration: none; }
.cfg-bar-btn:hover { color: #ccc; background: rgba(255,255,255,0.05); }
.cfg-bar-btn.active { color: #D4A356; background: rgba(212,163,86,0.12); }
.cfg-bar-btn svg { width: 20px; height: 20px; flex-shrink: 0; }
.cfg-bar-btn span { font-size: 9px; font-weight: 700; line-height: 1; }
.cfg-bar-toggle { position: fixed; top: 20px; left: 20px; width: 48px; height: 48px; border-radius: 50%; background: linear-gradient(135deg, #D4A356, #B0924E); color: #000; border: none; cursor: pointer; box-shadow: 0 4px 20px rgba(0,0,0,0.3); z-index: 100; display: none; align-items: center; justify-content: center; transition: all 0.3s; }
.cfg-bar-toggle:hover { transform: scale(1.1); box-shadow: 0 6px 30px rgba(212,163,86,0.4); }
.cfg-bar-toggle:active { transform: scale(0.95); }
.cfg-bar-toggle.rotate-90 { transform: rotate(90deg); }
.cfg-bar-toggle.rotate-90:hover { transform: rotate(90deg) scale(1.1); }
.cfg-bar-toggle svg { width: 20px; height: 20px; transition: transform 0.3s; }
.cfg-bar-separator { width: 40px; height: 1px; background: rgba(255,255,255,0.06); margin: 4px 0; }

/* ─── TOOL PANEL ─── */
.cfg-panel { width: 290px; background: #141414; flex-shrink: 0; display: flex; flex-direction: column; z-index: 15; border-right: 1px solid rgba(255,255,255,0.06); transition: margin-left 0.35s cubic-bezier(.16,1,.3,1), opacity 0.25s; }
.cfg-panel.collapsed { margin-left: -290px; opacity: 0; pointer-events: none; }
.cfg-panel-head { padding: 14px 16px; border-bottom: 1px solid rgba(255,255,255,0.06); display: flex; align-items: center; justify-content: space-between; flex-shrink: 0; }
.cfg-panel-head h2 { font-size: 14px; font-weight: 800; }
.cfg-panel-body { flex: 1; overflow-y: auto; padding: 16px; scrollbar-width: thin; scrollbar-color: rgba(212,163,86,0.15) transparent; }
.cfg-panel-body::-webkit-scrollbar { width: 3px; }
.cfg-panel-body::-webkit-scrollbar-thumb { background: rgba(212,163,86,0.15); border-radius: 3px; }
.cfg-section { margin-bottom: 20px; }
.cfg-section:last-child { margin-bottom: 0; }
.cfg-label { display: flex; align-items: center; gap: 6px; font-size: 12px; font-weight: 700; color: #ccc; margin-bottom: 10px; }
.cfg-label::before { content: ''; width: 5px; height: 5px; border-radius: 50%; background: #D4A356; flex-shrink: 0; }
.cfg-disabled { opacity: 0.35; pointer-events: none; user-select: none; text-align: center; padding: 40px 16px; }
.cfg-disabled svg { width: 48px; height: 48px; margin: 0 auto 12px; color: #555; }
.cfg-disabled p { font-size: 12px; color: #666; }

/* ─── VIEWPORT ─── */
.cfg-vp { flex: 1; position: relative; background: #1a1a1a; overflow: hidden; }
#cfg-canvas { display: block; width: 100%; height: 100%; outline: none; }
.cfg-vp:not(.placing) #cfg-canvas { cursor: grab; }
.cfg-vp:not(.placing) #cfg-canvas:active { cursor: grabbing; }
.cfg-vp.placing #cfg-canvas { cursor: crosshair; }
.cfg-vp-btn { width: 36px; height: 36px; border-radius: 10px; display: flex; align-items: center; justify-content: center; background: rgba(0,0,0,0.5); backdrop-filter: blur(8px); border: 1px solid rgba(255,255,255,0.08); color: #aaa; cursor: pointer; transition: all 0.2s; }
.cfg-vp-btn:hover { color: #fff; background: rgba(255,255,255,0.1); }
.cfg-vp-btn.active { color: #D4A356; border-color: rgba(212,163,86,0.3); }

/* ─── BADGE (floating above selected part) ─── */
.cfg-badge { position: absolute; z-index: 10; pointer-events: auto; display: flex; align-items: center; gap: 6px; padding: 4px 10px; background: rgba(0,0,0,0.7); backdrop-filter: blur(10px); border: 1px solid rgba(255,255,255,0.1); border-radius: 8px; transform: translate(-50%, -100%); margin-top: -12px; white-space: nowrap; cursor: pointer; transition: opacity 0.2s; }
.cfg-badge .dot { width: 12px; height: 12px; border-radius: 50%; border: 2px solid rgba(255,255,255,0.2); flex-shrink: 0; }

/* ─── RIGHT SIDEBAR (ACTION BAR) ─── */
.cfg-actions { width: 65px; background: #111; border-left: 1px solid rgba(255,255,255,0.06); display: flex; flex-direction: column; align-items: center; padding: 12px 0; gap: 8px; z-index: 20; flex-shrink: 0; }
.cfg-act { width: 52px; height: 52px; border-radius: 12px; display: flex; flex-direction: column; align-items: center; justify-content: center; gap: 3px; font-size: 9px; font-weight: 700; color: #999; background: transparent; border: 1px solid rgba(255,255,255,0.06); cursor: pointer; transition: all 0.2s; text-decoration: none; }
.cfg-act:hover { color: #fff; border-color: rgba(255,255,255,0.15); background: rgba(255,255,255,0.04); transform: scale(1.05); }
.cfg-act svg { width: 20px; height: 20px; flex-shrink: 0; }
.cfg-act-label { font-size: 8px; font-weight: 700; line-height: 1; }
.cfg-divider { width: 40px; height: 1px; background: rgba(255,255,255,0.06); margin: 4px 0; }
.cfg-product-name { width: 100%; padding: 8px; text-align: center; font-size: 10px; font-weight: 800; color: #D4A356; line-height: 1.2; word-break: break-word; }
.cfg-finish { width: 52px; height: 52px; border-radius: 12px; background: linear-gradient(135deg, #D4A356, #B0924E); color: #000; font-size: 10px; font-weight: 900; border: none; cursor: pointer; transition: all 0.2s; display: flex; flex-direction: column; align-items: center; justify-content: center; gap: 2px; }
.cfg-finish:hover { transform: scale(1.08); box-shadow: 0 4px 20px rgba(212,163,86,0.35); }
.cfg-finish svg { width: 20px; height: 20px; }
.cfg-actions-toggle { position: fixed; bottom: 20px; right: 20px; width: 56px; height: 56px; border-radius: 50%; background: linear-gradient(135deg, #D4A356, #B0924E); color: #000; border: none; cursor: pointer; box-shadow: 0 4px 20px rgba(0,0,0,0.3); z-index: 100; display: none; align-items: center; justify-content: center; transition: all 0.3s; }
.cfg-actions-toggle:hover { transform: scale(1.1); box-shadow: 0 6px 30px rgba(212,163,86,0.4); }
.cfg-actions-toggle:active { transform: scale(0.95); }
.cfg-actions-toggle.rotate-90 { transform: rotate(90deg); }
.cfg-actions-toggle.rotate-90:hover { transform: rotate(90deg) scale(1.1); }
.cfg-actions-toggle svg { width: 24px; height: 24px; transition: transform 0.3s; }

/* ─── COLOR SWATCHES ─── */
.cfg-swatch { width: 32px; height: 32px; border-radius: 50%; border: 2px solid rgba(255,255,255,0.1); cursor: pointer; transition: all 0.2s; flex-shrink: 0; }
.cfg-swatch:hover { transform: scale(1.15); border-color: rgba(255,255,255,0.25); }
.cfg-swatch.active { border-color: #D4A356; box-shadow: 0 0 0 3px rgba(212,163,86,0.25); }

/* ─── SHADE ROWS ─── */
.cfg-shades { display: flex; flex-wrap: wrap; gap: 3px; }
.cfg-shade { width: 28px; height: 28px; border-radius: 6px; cursor: pointer; transition: all 0.15s; border: 2px solid transparent; }
.cfg-shade:hover { transform: scale(1.2); z-index: 1; }
.cfg-shade.active { border-color: #fff; box-shadow: 0 0 0 2px #D4A356; }

/* ─── PRESET CARDS ─── */
.cfg-presets { display: grid; grid-template-columns: repeat(2, 1fr); gap: 8px; }
.cfg-preset { border-radius: 10px; background: rgba(255,255,255,0.03); border: 1px solid rgba(255,255,255,0.06); padding: 12px 8px; text-align: center; cursor: pointer; transition: all 0.2s; display: flex; flex-direction: column; align-items: center; gap: 6px; }
.cfg-preset:hover { border-color: rgba(212,163,86,0.3); background: rgba(255,255,255,0.05); }
.cfg-preset.active { border-color: #D4A356; background: rgba(212,163,86,0.08); }
.cfg-preset .icon { font-size: 24px; }
.cfg-preset .name { font-size: 10px; font-weight: 700; color: #aaa; }

/* ─── INPUTS ─── */
.cfg-input { width: 100%; height: 36px; padding: 0 10px; background: rgba(255,255,255,0.04); border: 1px solid rgba(255,255,255,0.08); border-radius: 8px; color: #fff; font-size: 12px; outline: none; transition: border-color 0.2s; }
.cfg-input:focus { border-color: rgba(212,163,86,0.4); }
.cfg-textarea { resize: none; height: auto; padding: 8px 10px; }
.cfg-range { width: 100%; accent-color: #D4A356; }
.cfg-upload { display: block; width: 100%; padding: 16px; border: 2px dashed rgba(255,255,255,0.08); border-radius: 10px; text-align: center; cursor: pointer; transition: all 0.2s; color: #666; font-size: 11px; font-weight: 700; }
.cfg-upload:hover { border-color: rgba(212,163,86,0.3); color: #D4A356; }
.cfg-btn { height: 34px; padding: 0 14px; border-radius: 8px; font-size: 12px; font-weight: 700; cursor: pointer; transition: all 0.2s; border: none; display: inline-flex; align-items: center; justify-content: center; gap: 5px; }
.cfg-btn-gold { background: linear-gradient(135deg, #D4A356, #B0924E); color: #000; }
.cfg-btn-gold:hover { transform: scale(1.03); }
.cfg-btn-danger { background: rgba(239,68,68,0.1); color: #f87171; border: 1px solid rgba(239,68,68,0.15); }
.cfg-btn-danger:hover { background: rgba(239,68,68,0.15); }
.cfg-btn-ghost { background: rgba(255,255,255,0.04); color: #aaa; border: 1px solid rgba(255,255,255,0.06); }
.cfg-btn-ghost:hover { color: #fff; background: rgba(255,255,255,0.08); }

/* ─── LAYER ITEMS ─── */
.cfg-layer { display: flex; align-items: center; gap: 8px; padding: 8px 10px; background: rgba(255,255,255,0.03); border: 1px solid rgba(255,255,255,0.05); border-radius: 8px; margin-bottom: 6px; transition: all 0.15s; }
.cfg-layer .icon { width: 8px; height: 8px; border-radius: 50%; flex-shrink: 0; }
.cfg-layer-active { background: rgba(212,163,86,0.1); border-color: rgba(212,163,86,0.3); }

/* ─── LOADING OVERLAY ─── */
.cfg-loading { position: absolute; inset: 0; z-index: 30; display: flex; align-items: center; justify-content: center; background: #0a0a0a; }
.cfg-progress { transition: width 0.3s ease; }

/* ─── MODAL ─── */
.cfg-modal-bg { position: fixed; inset: 0; z-index: 200; display: flex; align-items: center; justify-content: center; padding: 16px; }
.cfg-modal-bg .overlay { position: absolute; inset: 0; background: rgba(0,0,0,0.7); backdrop-filter: blur(4px); }
.cfg-modal { position: relative; width: 100%; max-width: 380px; background: #1a1a1a; border: 1px solid rgba(255,255,255,0.08); border-radius: 16px; padding: 24px; }

/* ─── TOAST ─── */
.cfg-toast { padding: 8px 16px; background: rgba(0,0,0,0.8); backdrop-filter: blur(10px); border: 1px solid rgba(255,255,255,0.08); border-radius: 10px; display: flex; align-items: center; gap: 8px; animation: cfgToastIn 0.35s cubic-bezier(.16,1,.3,1) forwards; }
@keyframes cfgToastIn { from { opacity:0; transform:translateY(-16px) scale(.95); } to { opacity:1; transform:translateY(0) scale(1); } }

/* ─── PLACEMENT HINT ─── */
.cfg-hint { position: absolute; bottom: 60px; left: 50%; transform: translateX(-50%); z-index: 15; padding: 8px 20px; background: rgba(212,163,86,0.15); border: 1px solid rgba(212,163,86,0.3); border-radius: 10px; color: #D4A356; font-size: 12px; font-weight: 700; backdrop-filter: blur(8px); }

/* ─── DECAL EDIT TOOLBAR ─── */
.cfg-decal-toolbar { position: absolute; bottom: 56px; left: 50%; transform: translateX(-50%); z-index: 15; display: flex; gap: 4px; padding: 5px 8px; background: rgba(20,20,25,0.88); backdrop-filter: blur(14px); border: 1px solid rgba(255,255,255,0.08); border-radius: 12px; box-shadow: 0 8px 24px rgba(0,0,0,0.5); }
.cfg-dt-btn { display: flex; align-items: center; gap: 5px; padding: 6px 12px; border: none; background: rgba(255,255,255,0.04); color: #aaa; border-radius: 8px; cursor: pointer; font-size: 11px; transition: all 0.15s; white-space: nowrap; }
.cfg-dt-btn:hover { background: rgba(255,255,255,0.1); color: #fff; }
.cfg-dt-btn.active { background: rgba(212,163,86,0.2); color: #D4A356; border: 1px solid rgba(212,163,86,0.3); }
.cfg-dt-del { color: #f87171 !important; }
.cfg-dt-del:hover { background: rgba(248,113,113,0.15) !important; }
.cfg-dt-sep { width: 1px; height: 28px; background: rgba(255,255,255,0.08); align-self: center; margin: 0 2px; }

/* ─── RESPONSIVE ─── */
@media (max-width: 768px) {
    .cfg-main { flex-direction: row; position: relative; }
    /* Viewport fills entire screen on mobile */
    .cfg-vp { flex: 1; min-height: 0; }
    /* Toolbar as floating left sidebar on mobile */
    .cfg-bar { position: fixed; left: 0; top: 0; bottom: 0; width: 64px; height: 100vh; padding: 60px 8px 8px; overflow-y: auto; z-index: 90; backdrop-filter: blur(10px); background: rgba(17,17,17,0.98); border-right: 1px solid rgba(255,255,255,0.08); border-radius: 0 16px 16px 0; }
    .cfg-bar.hidden { transform: translateX(-100%); opacity: 0; pointer-events: none; }
    .cfg-bar-toggle { display: flex; }
    .cfg-bar-btn { width: 48px; height: 48px; flex-shrink: 0; }
    .cfg-bar-btn svg { width: 20px; height: 20px; }
    .cfg-bar-btn span { font-size: 8px; }
    /* Panel as overlay drawer sliding up from bottom */
    .cfg-panel { position: fixed; bottom: 0; left: 0; right: 0; width: 100%; height: 55vh; max-height: 420px; border-right: none; border-top: 1px solid rgba(255,255,255,0.1); border-radius: 18px 18px 0 0; z-index: 50; transform: translateY(0); transition: transform 0.35s cubic-bezier(.16,1,.3,1), opacity 0.25s; }
    .cfg-panel.collapsed { transform: translateY(100%); opacity: 0; pointer-events: none; margin-left: 0; }
    .cfg-panel-head { padding: 10px 16px; }
    /* Drawer handle */
    .cfg-panel-head::before { content: ''; display: block; width: 40px; height: 4px; background: rgba(255,255,255,0.15); border-radius: 2px; margin: 0 auto 8px; }
    /* Actions sidebar floating on mobile */
    .cfg-actions { position: fixed; bottom: 90px; right: 0; width: auto; max-width: 65px; height: auto; max-height: calc(100vh - 180px); padding: 8px; border-radius: 16px 0 0 16px; border-left: none; border-top: 1px solid rgba(255,255,255,0.06); border-bottom: 1px solid rgba(255,255,255,0.06); border-right: 1px solid rgba(255,255,255,0.06); backdrop-filter: blur(10px); background: rgba(17,17,17,0.95); overflow-y: auto; transition: transform 0.3s cubic-bezier(.16,1,.3,1), opacity 0.25s; z-index: 90; }
    .cfg-actions.hidden { transform: translateX(100%); opacity: 0; pointer-events: none; }
    .cfg-actions-toggle { display: flex; }
    .cfg-decal-toolbar { bottom: 100px; gap: 2px; padding: 4px 6px; }
    .cfg-dt-btn { padding: 5px 8px; font-size: 10px; }
    .cfg-dt-btn span { display: none; }
    .cfg-hint { bottom: 100px; }
    .cfg-panel-toggle { width: 44px !important; height: 44px !important; }
    .cfg-panel-toggle svg { width: 22px !important; height: 22px !important; }
    .cfg-badge { transform: translate(-50%, -100%) scale(0.9); }
    .cfg-act { width: 48px; height: 48px; }
}
@media (max-width: 480px) {
    .cfg-bar { width: 58px; padding: 56px 6px 6px; }
    .cfg-bar-btn { width: 46px; height: 46px; }
    .cfg-bar-btn svg { width: 18px; height: 18px; }
    .cfg-bar-btn span { font-size: 7px; }
    .cfg-bar-toggle { width: 44px; height: 44px; top: 16px; left: 16px; }
    .cfg-bar-toggle svg { width: 18px; height: 18px; }
    .cfg-actions { padding: 6px; gap: 6px; }
    .cfg-act { width: 44px; height: 44px; font-size: 8px; }
    .cfg-act svg { width: 18px; height: 18px; }
    .cfg-finish { width: 44px; height: 44px; font-size: 9px; }
    .cfg-finish svg { width: 18px; height: 18px; }
    .cfg-actions-toggle { width: 52px; height: 52px; bottom: 16px; right: 16px; }
    .cfg-product-name { font-size: 9px; padding: 6px; }
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

<div x-data="configurator()" x-init="boot()" x-cloak
     class="cfg fixed inset-0 z-100" style="direction:ltr">

    
    <div class="cfg-main">

        
        <aside class="cfg-bar" :class="{'hidden': !barOpen}">
            <template x-for="t in tools" :key="t.id">
                <button class="cfg-bar-btn" :class="{'active': activeTool === t.id}" @click="setTool(t.id)" :title="t.name">
                    <svg fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24" x-html="t.svg"></svg>
                    <span class="cairo" x-text="t.name"></span>
                </button>
            </template>
            
            <div class="cfg-bar-separator"></div>
            
            
            <a href="<?php echo e(route('client.designs')); ?>" class="cfg-bar-btn" title="تصاميمي">
                <svg fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M9.53 16.122a3 3 0 00-5.78 1.128 2.25 2.25 0 01-2.4 2.245 4.5 4.5 0 008.4-2.245c0-.399-.078-.78-.22-1.128zm0 0a15.998 15.998 0 003.388-1.62m-5.043-.025a15.994 15.994 0 011.622-3.395m3.42 3.42a15.995 15.995 0 004.764-4.648l3.876-5.814a1.151 1.151 0 00-1.597-1.597L14.146 6.32a15.996 15.996 0 00-4.649 4.763m3.42 3.42a6.776 6.776 0 00-3.42-3.42"/>
                </svg>
                <span class="cairo">تصاميمي</span>
            </a>
            
            
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(auth()->guard('client')->check()): ?>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(auth('client')->user()->isDesigner()): ?>
                <a href="<?php echo e(route('client.stickers')); ?>" class="cfg-bar-btn" title="ملصقاتي">
                    <svg fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M11.48 3.499a.562.562 0 011.04 0l2.125 5.111a.563.563 0 00.475.345l5.518.442c.499.04.701.663.321.988l-4.204 3.602a.563.563 0 00-.182.557l1.285 5.385a.562.562 0 01-.84.61l-4.725-2.885a.563.563 0 00-.586 0L6.982 20.54a.562.562 0 01-.84-.61l1.285-5.386a.562.562 0 00-.182-.557l-4.204-3.602a.563.563 0 01.321-.988l5.518-.442a.563.563 0 00.475-.345L11.48 3.5z"/>
                    </svg>
                    <span class="cairo">ملصقاتي</span>
                </a>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            
            <div style="flex:1"></div>
            
            <button class="cfg-bar-btn" :class="{'active': canUndo}" :disabled="!canUndo" :style="!canUndo ? 'opacity:0.3' : ''" title="تراجع" @click="undo()">
                <svg fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M9 15L3 9m0 0l6-6M3 9h12a6 6 0 010 12h-3"/></svg>
            </button>
            <button class="cfg-bar-btn" :class="{'active': canRedo}" :disabled="!canRedo" :style="!canRedo ? 'opacity:0.3' : ''" title="إعادة" @click="redo()">
                <svg fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M15 15l6-6m0 0l-6-6m6 6H9a6 6 0 000 12h3"/></svg>
            </button>
        </aside>
        
        
        <button class="cfg-bar-toggle" @click="barOpen = !barOpen" :class="{'rotate-90': barOpen}" x-show="!loading">
            <svg fill="none" stroke="currentColor" stroke-width="2.5" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M3.75 6.75h16.5M3.75 12h16.5m-16.5 5.25h16.5"/>
            </svg>
        </button>

        
        <aside class="cfg-panel" :class="{'collapsed': !panelOpen}" dir="rtl">
            <div class="cfg-panel-head">
                <h2 class="cairo" x-text="currentToolName"></h2>
                <button @click="panelOpen = false" class="cfg-vp-btn" style="width:28px;height:28px;font-size:14px;border:none;">&times;</button>
            </div>
            <div class="cfg-panel-body">

                
                <div x-show="activeTool === 'design'" x-cloak>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($popularDesigns->count() > 0): ?>
                        
                        <div class="cfg-section">
                            <div class="cfg-label cairo" style="font-size: 13px; color: #D4A356; margin-bottom: 12px;">
                                <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M10.788 3.21c.448-1.077 1.976-1.077 2.424 0l2.082 5.007 5.404.433c1.164.093 1.636 1.545.749 2.305l-4.117 3.527 1.257 5.273c.271 1.136-.964 2.033-1.96 1.425L12 18.354 7.373 21.18c-.996.608-2.231-.29-1.96-1.425l1.257-5.273-4.117-3.527c-.887-.76-.415-2.212.749-2.305l5.404-.433 2.082-5.006z" />
                                </svg>
                                الأكثر شهرة
                            </div>
                            <div style="display: flex; flex-direction: column; gap: 8px;">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $popularDesigns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $design): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <button @click="loadPreset(<?php echo e($design->id); ?>)" class="group" style="background: rgba(255,255,255,0.03); border: 1px solid rgba(255,255,255,0.06); border-radius: 12px; padding: 8px; cursor: pointer; transition: all 0.2s; text-align: right;">
                                    <div style="display: flex; align-items: center; gap: 10px;">
                                        <div style="width: 60px; height: 60px; border-radius: 8px; overflow: hidden; flex-shrink: 0; background: #1a1a1a;">
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($design->preview_image_url): ?>
                                            <img src="<?php echo e($design->preview_image_url); ?>" alt="<?php echo e($design->name); ?>" style="width: 100%; height: 100%; object-fit: cover; transition: transform 0.3s;" onmouseover="this.style.transform='scale(1.1)'" onmouseout="this.style.transform='scale(1)'">
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </div>
                                        <div style="flex: 1; min-width: 0;">
                                            <div class="cairo" style="font-size: 12px; font-weight: 700; color: #fff; margin-bottom: 4px; overflow: hidden; text-overflow: ellipsis; white-space: nowrap;">
                                                <?php echo e($design->name); ?>

                                            </div>
                                            <div style="display: flex; align-items: center; gap: 8px; font-size: 10px; color: #999;">
                                                <span style="display: flex; align-items: center; gap: 3px;">
                                                    <svg style="width: 12px; height: 12px;" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" d="M2.036 12.322a1.012 1.012 0 010-.639C3.423 7.51 7.36 4.5 12 4.5c4.638 0 8.573 3.007 9.963 7.178.07.207.07.431 0 .639C20.577 16.49 16.64 19.5 12 19.5c-4.638 0-8.573-3.007-9.963-7.178z" /><path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                                    </svg>
                                                    <?php echo e($design->views_count); ?>

                                                </span>
                                                <span style="display: flex; align-items: center; gap: 3px; color: #D4A356;">
                                                    <svg style="width: 12px; height: 12px;" fill="currentColor" viewBox="0 0 24 24">
                                                        <path d="M21 8.25c0-2.485-2.099-4.5-4.688-4.5-1.935 0-3.597 1.126-4.312 2.733-.715-1.607-2.377-2.733-4.313-2.733C5.1 3.75 3 5.765 3 8.25c0 7.22 9 12 9 12s9-4.78 9-12z" />
                                                    </svg>
                                                    <?php echo e($design->likes_count); ?>

                                                </span>
                                            </div>
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($design->client): ?>
                                            <div style="font-size: 10px; color: #666; margin-top: 2px;"><?php echo e($design->client->name); ?></div>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </div>
                                        <svg style="width: 16px; height: 16px; color: #666; flex-shrink: 0;" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7" />
                                        </svg>
                                    </div>
                                </button>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                    
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($model->publicDesigns->count()): ?>
                    <div class="cfg-section" style="margin-top: <?php echo e($popularDesigns->count() > 0 ? '24px' : '0'); ?>">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($popularDesigns->count() > 0): ?>
                        <div class="cfg-label cairo" style="font-size: 13px; margin-bottom: 12px;">
                            جميع التصاميم
                        </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        <div class="cfg-presets">
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $model->publicDesigns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $design): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <button @click="loadPreset(<?php echo e($design->id); ?>)" class="cfg-preset group" style="padding:0;overflow:hidden;aspect-ratio:1">
                                <img src="<?php echo e($design->preview_image_url); ?>" alt="<?php echo e($design->name); ?>" class="w-full h-full object-cover" style="transition:transform .3s">
                            </button>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                    </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                    <?php if($model->publicDesigns->count() == 0 && $popularDesigns->count() == 0): ?>
                    <div class="cfg-disabled" style="pointer-events:auto;opacity:1">
                        <svg fill="none" stroke="currentColor" stroke-width="1" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M2.25 15.75l5.159-5.159a2.25 2.25 0 013.182 0l5.159 5.159m-1.5-1.5l1.409-1.409a2.25 2.25 0 013.182 0l2.909 2.909M3 21h18a1 1 0 001-1V4a1 1 0 00-1-1H3a1 1 0 00-1 1v16a1 1 0 001 1z"/></svg>
                        <p class="cairo">لا توجد تصاميم جاهزة بعد</p>
                    </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>

                
                <div x-show="activeTool === 'color'" x-cloak>
                    
                    <div class="cfg-section">
                        <label style="display:flex;align-items:center;gap:8px;cursor:pointer;padding:8px 10px;background:rgba(255,255,255,0.03);border:1px solid rgba(255,255,255,0.06);border-radius:10px">
                            <input type="checkbox" x-model="applyToAll" style="accent-color:#D4A356">
                            <span class="cairo" style="font-size:11px;font-weight:700;color:#ccc">تطبيق على كل الأجزاء</span>
                        </label>
                    </div>
                    
                    <div x-show="!selectedPartKey && !applyToAll" class="cfg-disabled">
                        <svg fill="none" stroke="currentColor" stroke-width="1" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M15.042 21.672L13.684 16.6m0 0l-2.51 2.225.569-9.47 5.227 7.917-3.286-.672zM12 2.25V4.5m5.834.166l-1.591 1.591M20.25 10.5H18M7.757 14.743l-1.59 1.59M6 10.5H3.75m4.007-4.243l-1.59-1.59"/></svg>
                        <p class="cairo">اضغط على جزء من المنتج أو فعّل "تطبيق على الكل"</p>
                    </div>
                    
                    <div x-show="selectedPartKey || applyToAll">
                        
                        <div class="cfg-section">
                            <div style="display:flex;align-items:center;gap:8px;padding:8px 12px;background:rgba(255,255,255,0.03);border:1px solid rgba(255,255,255,0.06);border-radius:10px">
                                <span class="cfg-swatch" style="width:24px;height:24px;pointer-events:none" :style="`background:${partColor}`"></span>
                                <span class="cairo" style="font-size:12px;font-weight:700" x-text="selectedPartName"></span>
                                <span style="font-size:10px;color:#666;font-family:monospace;margin-right:auto" x-text="partColor" dir="ltr"></span>
                            </div>
                        </div>
                        
                        <div class="cfg-section">
                            <div class="cfg-label cairo">اللون الأساسي</div>
                            <div style="display:flex;gap:8px;align-items:center">
                                <label style="flex:1;height:36px;border-radius:8px;overflow:hidden;cursor:pointer;position:relative">
                                    <input type="color" x-model="partColor" @input="applyPartColor(partColor)" style="position:absolute;inset:0;width:100%;height:100%;cursor:pointer;opacity:0">
                                    <div style="width:100%;height:100%;border:1px solid rgba(255,255,255,0.08);border-radius:8px" :style="`background:${partColor}`"></div>
                                </label>
                                <input type="text" class="cfg-input" style="width:90px;font-family:monospace;font-size:11px;text-align:center" dir="ltr" x-model="partColor" @change="applyPartColor(partColor)">
                            </div>
                        </div>
                        
                        <div class="cfg-section">
                            <div class="cfg-label cairo">الدرجات</div>
                            <div class="cfg-shades">
                                <template x-for="(s, idx) in shades" :key="'sh_'+idx">
                                    <button class="cfg-shade" :class="{'active': partColor === s}" :style="`background:${s}`" @click="applyPartColor(s)"></button>
                                </template>
                            </div>
                        </div>
                        
                        <div class="cfg-section">
                            <div class="cfg-label cairo">ألوان سريعة</div>
                            <div style="display:flex;flex-wrap:wrap;gap:5px">
                                <template x-for="c in quickColors" :key="c">
                                    <button class="cfg-swatch" :class="{'active': partColor === c}" :style="`background:${c}`" @click="applyPartColor(c)"></button>
                                </template>
                            </div>
                        </div>
                        
                        <div class="cfg-section">
                            <div class="cfg-label cairo">ألوان متكاملة</div>
                            <div style="display:flex;gap:5px">
                                <template x-for="(c, idx) in complementary" :key="'cmp_'+idx">
                                    <button class="cfg-shade" style="width:36px;height:36px" :style="`background:${c}`" @click="applyPartColor(c)"></button>
                                </template>
                            </div>
                        </div>
                    </div>
                </div>

                
                <div x-show="activeTool === 'texture'" x-cloak>
                    <div x-show="!selectedPartKey && !applyToAll" class="cfg-disabled">
                        <svg fill="none" stroke="currentColor" stroke-width="1" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M15.042 21.672L13.684 16.6m0 0l-2.51 2.225.569-9.47 5.227 7.917-3.286-.672zM12 2.25V4.5m5.834.166l-1.591 1.591M20.25 10.5H18M7.757 14.743l-1.59 1.59M6 10.5H3.75m4.007-4.243l-1.59-1.59"/></svg>
                        <p class="cairo">اضغط على جزء أو فعّل "تطبيق على الكل" في تبويب الألوان</p>
                    </div>
                    <div x-show="selectedPartKey || applyToAll">
                        
                        <div class="cfg-section">
                            <div class="cfg-label cairo">الخامات المتاحة</div>
                            <div class="cfg-presets">
                                <template x-for="p in materialPresets" :key="p.id">
                                    <button class="cfg-preset" :class="{'active': activePresetId === p.id}" @click="applyMaterialPreset(p)">
                                        <span class="icon" x-text="p.icon"></span>
                                        <span class="name cairo" x-text="p.name"></span>
                                    </button>
                                </template>
                            </div>
                        </div>
                        
                        <div class="cfg-section">
                            <div class="cfg-label cairo">رفع خامة مخصصة</div>
                            <label class="cfg-upload cairo">
                                <input type="file" @change="uploadTexture($event, 'map')" accept="image/*" style="display:none">
                                📁 Albedo (لون)
                            </label>
                            <label class="cfg-upload cairo" style="margin-top:6px">
                                <input type="file" @change="uploadTexture($event, 'normalMap')" accept="image/*" style="display:none">
                                📁 Normal Map
                            </label>
                            <div x-show="hasPartTexture" style="margin-top:8px">
                                <button class="cfg-btn cfg-btn-danger w-full cairo" @click="removePartTexture()">حذف الخامة</button>
                            </div>
                        </div>
                        
                        <div class="cfg-section" x-show="hasPartTexture">
                            <div class="cfg-label cairo">إعدادات الخامة</div>
                            <div style="display:flex;flex-direction:column;gap:10px">
                                <div>
                                    <div style="display:flex;justify-content:space-between;font-size:10px;color:#888;margin-bottom:4px"><span class="cairo">تكرار أفقي</span><span x-text="uvRepeatX.toFixed(1)"></span></div>
                                    <input type="range" class="cfg-range" x-model.number="uvRepeatX" @input="updateUV()" min="0.1" max="10" step="0.1">
                                </div>
                                <div>
                                    <div style="display:flex;justify-content:space-between;font-size:10px;color:#888;margin-bottom:4px"><span class="cairo">تكرار عمودي</span><span x-text="uvRepeatY.toFixed(1)"></span></div>
                                    <input type="range" class="cfg-range" x-model.number="uvRepeatY" @input="updateUV()" min="0.1" max="10" step="0.1">
                                </div>
                                <div>
                                    <div style="display:flex;justify-content:space-between;font-size:10px;color:#888;margin-bottom:4px"><span class="cairo">الإزاحة أفقي</span><span x-text="uvOffsetX.toFixed(2)"></span></div>
                                    <input type="range" class="cfg-range" x-model.number="uvOffsetX" @input="updateUV()" min="-1" max="1" step="0.01">
                                </div>
                                <div>
                                    <div style="display:flex;justify-content:space-between;font-size:10px;color:#888;margin-bottom:4px"><span class="cairo">الإزاحة عمودي</span><span x-text="uvOffsetY.toFixed(2)"></span></div>
                                    <input type="range" class="cfg-range" x-model.number="uvOffsetY" @input="updateUV()" min="-1" max="1" step="0.01">
                                </div>
                                <div>
                                    <div style="display:flex;justify-content:space-between;font-size:10px;color:#888;margin-bottom:4px"><span class="cairo">الدوران</span><span x-text="(uvRotation * 57.3).toFixed(0) + '°'"></span></div>
                                    <input type="range" class="cfg-range" x-model.number="uvRotation" @input="updateUV()" min="0" max="6.283" step="0.01">
                                </div>
                            </div>
                        </div>
                        
                        <div class="cfg-section">
                            <div class="cfg-label cairo">خصائص السطح</div>
                            <div style="display:flex;flex-direction:column;gap:10px">
                                <div>
                                    <div style="display:flex;justify-content:space-between;font-size:10px;color:#888;margin-bottom:4px"><span class="cairo">الخشونة</span><span x-text="matRoughness.toFixed(2)"></span></div>
                                    <input type="range" class="cfg-range" x-model.number="matRoughness" @input="updateMatParams()" min="0" max="1" step="0.01">
                                </div>
                                <div>
                                    <div style="display:flex;justify-content:space-between;font-size:10px;color:#888;margin-bottom:4px"><span class="cairo">المعدنية</span><span x-text="matMetalness.toFixed(2)"></span></div>
                                    <input type="range" class="cfg-range" x-model.number="matMetalness" @input="updateMatParams()" min="0" max="1" step="0.01">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                
                <div x-show="activeTool === 'text'" x-cloak>
                    <div>
                        <div class="cfg-section">
                            <div class="cfg-label cairo">النص</div>
                            <textarea class="cfg-input cfg-textarea cairo" rows="2" x-model="decalText" placeholder="أدخل النص..." dir="rtl"></textarea>
                        </div>
                        <div class="cfg-section">
                            <div class="cfg-label cairo">حجم الخط</div>
                            <input type="range" class="cfg-range" x-model.number="decalFontSize" min="16" max="120" step="1">
                            <div style="display:flex;justify-content:space-between;font-size:10px;color:#666;margin-top:4px"><span>16</span><span x-text="decalFontSize"></span><span>120</span></div>
                        </div>
                        <div class="cfg-section">
                            <div class="cfg-label cairo">اللون</div>
                            <div style="display:flex;gap:8px;align-items:center">
                                <label style="flex:1;height:32px;border-radius:8px;overflow:hidden;cursor:pointer;position:relative">
                                    <input type="color" x-model="decalTextColor" style="position:absolute;inset:0;width:100%;height:100%;cursor:pointer;opacity:0">
                                    <div style="width:100%;height:100%;border:1px solid rgba(255,255,255,0.08);border-radius:8px" :style="`background:${decalTextColor}`"></div>
                                </label>
                                <span style="font-size:10px;color:#666;font-family:monospace" x-text="decalTextColor" dir="ltr"></span>
                            </div>
                        </div>
                        <div class="cfg-section">
                            <div class="cfg-label cairo">الخط</div>
                            <select class="cfg-input cairo" x-model="decalFont" dir="rtl">
                                <option value="Cairo">Cairo</option>
                                <option value="Tajawal">Tajawal</option>
                                <option value="Arial">Arial</option>
                                <option value="Georgia">Georgia</option>
                            </select>
                        </div>
                        <button class="cfg-btn cfg-btn-gold w-full cairo" style="width:100%;margin-top:12px" @click="startDecalPlacement('text')" :disabled="!decalText">
                            وضع النص على المنتج
                        </button>
                        
                        <div x-show="textDecals.length > 0" style="margin-top:14px;padding-top:10px;border-top:1px solid rgba(255,255,255,0.06)">
                            <div class="cfg-label cairo" style="margin-bottom:6px">النصوص الموضوعة</div>
                            <template x-for="d in textDecals" :key="d.id">
                                <div class="cfg-layer" :class="{'cfg-layer-active': selectedDecalId === d.id}">
                                    <span class="icon" style="background:#D4A356"></span>
                                    <span class="cairo" style="font-size:11px;flex:1;overflow:hidden;text-overflow:ellipsis;white-space:nowrap" x-text="d.content"></span>
                                    <button style="color:#D4A356;font-size:10px;background:none;border:none;cursor:pointer;padding:2px 6px;border-radius:4px" @click="selectDecal(d.id)" title="تعديل الموقع">
                                        <svg width="12" height="12" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M3.75 3.75v4.5m0-4.5h4.5m-4.5 0L9 9M3.75 20.25v-4.5m0 4.5h4.5m-4.5 0L9 15M20.25 3.75h-4.5m4.5 0v4.5m0-4.5L15 9m5.25 11.25h-4.5m4.5 0v-4.5m0 4.5L15 15"/></svg>
                                    </button>
                                    <button style="color:#f87171;font-size:11px;background:none;border:none;cursor:pointer" @click="removeDecal(d.id)">✕</button>
                                </div>
                            </template>
                        </div>
                    </div>
                </div>

                
                <div x-show="activeTool === 'logo'" x-cloak>
                    <div>
                        <div class="cfg-section">
                            <div class="cfg-label cairo">رفع شعار / صورة</div>
                            <label class="cfg-upload cairo">
                                <input type="file" @change="prepareLogoUpload($event)" accept="image/*" style="display:none">
                                📁 اختر صورة (PNG / JPG)
                            </label>
                        </div>
                        <div class="cfg-section" x-show="logoPreview">
                            <div class="cfg-label cairo">معاينة</div>
                            <img :src="logoPreview" style="max-width:100%;max-height:120px;border-radius:8px;border:1px solid rgba(255,255,255,0.06);margin-bottom:8px">
                            <div>
                                <div style="display:flex;justify-content:space-between;font-size:10px;color:#888;margin-bottom:4px"><span class="cairo">الحجم</span><span x-text="logoScale.toFixed(1)"></span></div>
                                <input type="range" class="cfg-range" x-model.number="logoScale" min="0.05" max="1" step="0.01">
                            </div>
                            <button class="cfg-btn cfg-btn-gold w-full cairo" style="width:100%;margin-top:10px" @click="startDecalPlacement('image')">
                                وضع الشعار على المنتج
                            </button>
                        </div>
                        
                        <div x-show="imageDecals.length > 0" style="margin-top:14px;padding-top:10px;border-top:1px solid rgba(255,255,255,0.06)">
                            <div class="cfg-label cairo" style="margin-bottom:6px">الشعارات الموضوعة</div>
                            <template x-for="d in imageDecals" :key="d.id">
                                <div class="cfg-layer" :class="{'cfg-layer-active': selectedDecalId === d.id}">
                                    <span class="icon" style="background:#4ECDC4"></span>
                                    <span class="cairo" style="font-size:11px;flex:1">شعار</span>
                                    <button style="color:#4ECDC4;font-size:10px;background:none;border:none;cursor:pointer;padding:2px 6px;border-radius:4px" @click="selectDecal(d.id)" title="تعديل الموقع">
                                        <svg width="12" height="12" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M3.75 3.75v4.5m0-4.5h4.5m-4.5 0L9 9M3.75 20.25v-4.5m0 4.5h4.5m-4.5 0L9 15M20.25 3.75h-4.5m4.5 0v4.5m0-4.5L15 9m5.25 11.25h-4.5m4.5 0v-4.5m0 4.5L15 15"/></svg>
                                    </button>
                                    <button style="color:#f87171;font-size:11px;background:none;border:none;cursor:pointer" @click="removeDecal(d.id)">✕</button>
                                </div>
                            </template>
                        </div>
                    </div>
                </div>

                
                <div x-show="activeTool === 'stickers'" x-cloak x-init="$watch('activeTool', v => { if (v === 'stickers') loadStickers(); })">
                    
                    <div class="cfg-section">
                        <input type="text" class="cfg-input cairo" x-model="stickerSearch" placeholder="بحث في الملصقات..." dir="rtl" style="margin-bottom:8px">
                        <div style="display:flex;flex-wrap:wrap;gap:4px">
                            <button class="cfg-btn cfg-btn-ghost cairo" style="font-size:10px;padding:3px 8px;height:auto" :class="{'cfg-btn-gold !text-black': !stickerCategory}" @click="stickerCategory = ''">الكل</button>
                            <template x-for="cat in stickerCategories" :key="cat">
                                <button class="cfg-btn cfg-btn-ghost cairo" style="font-size:10px;padding:3px 8px;height:auto" :class="{'cfg-btn-gold !text-black': stickerCategory === cat}" @click="stickerCategory = cat" x-text="cat"></button>
                            </template>
                        </div>
                    </div>
                    
                    <div x-show="stickerLoading" style="text-align:center;padding:30px 0">
                        <div style="width:32px;height:32px;margin:0 auto;border:3px solid rgba(212,163,86,0.15);border-top-color:#D4A356;border-radius:50%;animation:spin 1s linear infinite"></div>
                        <p class="cairo" style="font-size:11px;color:#888;margin-top:8px">جاري تحميل الملصقات...</p>
                    </div>
                    
                    <div x-show="!stickerLoading && filteredStickers.length > 0" style="display:grid;grid-template-columns:repeat(3,1fr);gap:6px">
                        <template x-for="sticker in filteredStickers" :key="sticker.id">
                            <button @click="applyStickerFromLibrary(sticker)" class="group" style="background:rgba(255,255,255,0.03);border:1px solid rgba(255,255,255,0.06);border-radius:10px;padding:8px;cursor:pointer;transition:all 0.2s;display:flex;flex-direction:column;align-items:center;gap:4px" :title="sticker.name"
                                    @mouseenter="$el.style.borderColor='rgba(212,163,86,0.3)';$el.style.background='rgba(255,255,255,0.05)'"
                                    @mouseleave="$el.style.borderColor='rgba(255,255,255,0.06)';$el.style.background='rgba(255,255,255,0.03)'">
                                <img :src="sticker.image_url" :alt="sticker.name" style="width:56px;height:56px;object-fit:contain;border-radius:6px">
                                <span class="cairo" style="font-size:9px;color:#aaa;overflow:hidden;text-overflow:ellipsis;white-space:nowrap;max-width:100%;display:block;text-align:center" x-text="sticker.name"></span>
                            </button>
                        </template>
                    </div>
                    
                    <div x-show="!stickerLoading && filteredStickers.length === 0" class="cfg-disabled" style="pointer-events:auto;opacity:1">
                        <svg fill="none" stroke="currentColor" stroke-width="1" viewBox="0 0 24 24" style="width:48px;height:48px;margin:0 auto 12px;color:#555"><path stroke-linecap="round" stroke-linejoin="round" d="M11.48 3.499a.562.562 0 011.04 0l2.125 5.111a.563.563 0 00.475.345l5.518.442c.499.04.701.663.321.988l-4.204 3.602a.563.563 0 00-.182.557l1.285 5.385a.562.562 0 01-.84.61l-4.725-2.885a.563.563 0 00-.586 0L6.982 20.54a.562.562 0 01-.84-.61l1.285-5.386a.562.562 0 00-.182-.557l-4.204-3.602a.563.563 0 01.321-.988l5.518-.442a.563.563 0 00.475-.345L11.48 3.5z"/></svg>
                        <p class="cairo">لا توجد ملصقات متاحة</p>
                    </div>
                </div>

                
                <div x-show="activeTool === 'layers'" x-cloak>
                    <template x-for="l in layers" :key="l.id">
                        <div class="cfg-layer">
                            <input type="checkbox" x-model="l.enabled" @change="toggleLayer(l.id)" style="accent-color:#D4A356">
                            <span class="icon" :style="`background:${l.color || '#D4A356'}`"></span>
                            <span class="cairo" style="font-size:11px;flex:1;overflow:hidden;text-overflow:ellipsis;white-space:nowrap" x-text="l.name"></span>
                            <button style="color:#f87171;font-size:14px;background:none;border:none;cursor:pointer;line-height:1" @click="removeLayer(l.id)">&times;</button>
                        </div>
                    </template>
                    <div x-show="layers.length === 0" class="cfg-disabled" style="pointer-events:auto;opacity:1">
                        <svg fill="none" stroke="currentColor" stroke-width="1" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M6.429 9.75L2.25 12l4.179 2.25m0-4.5l5.571 3 5.571-3m-11.142 0L2.25 7.5 12 2.25l9.75 5.25-4.179 2.25m0 0L12 12.75 6.43 9.75m11.14 0l4.179 2.25L12 17.25 2.25 12l4.179-2.25m11.142 0l4.179 2.25L12 22.5 2.25 17.25l4.179-2.25"/></svg>
                        <p class="cairo">لا توجد طبقات بعد</p>
                        <p class="cairo" style="font-size:10px;color:#555;margin-top:4px">قم بتغيير لون أو إضافة خامة لإنشاء طبقات</p>
                    </div>
                </div>

                
                <div x-show="activeTool === 'bg'" x-cloak>
                    <div class="cfg-section">
                        <div class="cfg-label cairo">لون الخلفية</div>
                        <div style="display:flex;flex-wrap:wrap;gap:6px">
                            <template x-for="c in bgColors" :key="c">
                                <button class="cfg-swatch" :class="{'active': bgColor === c}" :style="`background:${c}`" @click="setBgColor(c)"></button>
                            </template>
                        </div>
                        <div style="display:flex;gap:8px;align-items:center;margin-top:10px">
                            <label style="flex:1;height:36px;border-radius:8px;overflow:hidden;cursor:pointer;position:relative">
                                <input type="color" x-model="bgColor" @input="setBgColor(bgColor)" style="position:absolute;inset:0;width:100%;height:100%;cursor:pointer;opacity:0">
                                <div style="width:100%;height:100%;border:1px solid rgba(255,255,255,0.08);border-radius:8px" :style="`background:${bgColor}`"></div>
                            </label>
                            <span style="font-size:10px;color:#666;font-family:monospace" x-text="bgColor" dir="ltr"></span>
                        </div>
                    </div>
                </div>
            </div>
        </aside>

        
        <main class="cfg-vp" id="cfg-wrapper" :class="{'placing': placementMode}">
            <canvas id="cfg-canvas"></canvas>

            
            <div class="cfg-loading" x-show="loading" x-transition:leave="transition ease-in duration-300" x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0">
                <div style="text-align:center;width:260px">
                    <div style="width:64px;height:64px;margin:0 auto 20px;border-radius:50%;border:3px solid rgba(212,163,86,0.15);border-top-color:#D4A356;animation:spin 1s linear infinite"></div>
                    <p class="cairo" style="font-weight:800;font-size:16px;margin-bottom:10px">جاري تحميل الموديل</p>
                    <div style="width:100%;height:5px;background:rgba(255,255,255,0.08);border-radius:4px;overflow:hidden">
                        <div class="cfg-progress" style="height:100%;background:linear-gradient(90deg,#D4A356,#B0924E);border-radius:4px" :style="`width:${loadProgress}%`"></div>
                    </div>
                    <p style="color:#666;font-size:12px;margin-top:6px" x-text="`${Math.round(loadProgress)}%`"></p>
                </div>
            </div>

            
            <div class="cfg-badge" x-show="selectedPartKey && !loading && badgeVisible"
                 :style="`left:${badgeX}px;top:${badgeY}px`"
                 @click="setTool('color')">
                <span class="dot" :style="`background:${partColor}`"></span>
                <span class="cairo" style="font-size:11px;font-weight:700" x-text="selectedPartName"></span>
                <span style="font-size:9px;color:#888;font-family:monospace" x-text="partColor" dir="ltr"></span>
            </div>

            
            <div class="cfg-hint cairo" x-show="placementMode" x-transition>
                <span x-text="placementMode === 'text' ? 'اضغط على المنتج لوضع النص' : 'اضغط على المنتج لوضع الشعار'"></span>
                <button style="margin-right:10px;color:#fff;background:none;border:none;cursor:pointer;font-size:11px" @click="cancelPlacement()">إلغاء</button>
            </div>

            
            <div class="cfg-decal-toolbar" x-show="selectedDecalId && !placementMode" x-transition x-cloak dir="rtl">
                <button class="cfg-dt-btn" :class="{'active': transformMode==='translate'}" @click="setTransformMode('translate')" title="نقل">
                    <svg width="15" height="15" fill="none" stroke="currentColor" stroke-width="1.8" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M3.75 3.75v4.5m0-4.5h4.5m-4.5 0L9 9M3.75 20.25v-4.5m0 4.5h4.5m-4.5 0L9 15M20.25 3.75h-4.5m4.5 0v4.5m0-4.5L15 9m5.25 11.25h-4.5m4.5 0v-4.5m0 4.5L15 15"/></svg>
                    <span class="cairo">نقل</span>
                </button>
                <button class="cfg-dt-btn" :class="{'active': transformMode==='rotate'}" @click="setTransformMode('rotate')" title="تدوير">
                    <svg width="15" height="15" fill="none" stroke="currentColor" stroke-width="1.8" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M16.023 9.348h4.992v-.001M2.985 19.644v-4.992m0 0h4.992m-4.993 0l3.181 3.183a8.25 8.25 0 0013.803-3.7M4.031 9.865a8.25 8.25 0 0113.803-3.7l3.181 3.182"/></svg>
                    <span class="cairo">تدوير</span>
                </button>
                <button class="cfg-dt-btn" :class="{'active': transformMode==='scale'}" @click="setTransformMode('scale')" title="تحجيم">
                    <svg width="15" height="15" fill="none" stroke="currentColor" stroke-width="1.8" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M7.5 3.75H4.5m0 0v3m0-3l4 4m8-4h3m0 0v3m0-3l-4 4m-8 8H4.5m0 0v-3m0 3l4-4m8 4h3m0 0v-3m0 3l-4-4"/></svg>
                    <span class="cairo">تحجيم</span>
                </button>
                <div class="cfg-dt-sep"></div>
                <button class="cfg-dt-btn" style="color:#34d399" @click="bakeSelectedDecal()" title="دمج مع السطح">
                    <svg width="15" height="15" fill="none" stroke="currentColor" stroke-width="1.8" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M4.5 12.75l6 6 9-13.5"/></svg>
                    <span class="cairo">تأكيد</span>
                </button>
                <button class="cfg-dt-btn cfg-dt-del" @click="removeSelectedDecal()" title="حذف">
                    <svg width="15" height="15" fill="none" stroke="currentColor" stroke-width="1.8" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M14.74 9l-.346 9m-4.788 0L9.26 9m9.968-3.21c.342.052.682.107 1.022.166m-1.022-.165L18.16 19.673a2.25 2.25 0 01-2.244 2.077H8.084a2.25 2.25 0 01-2.244-2.077L4.772 5.79m14.456 0a48.108 48.108 0 00-3.478-.397m-12 .562c.34-.059.68-.114 1.022-.165m0 0a48.11 48.11 0 013.478-.397m7.5 0v-.916c0-1.18-.91-2.164-2.09-2.201a51.964 51.964 0 00-3.32 0c-1.18.037-2.09 1.022-2.09 2.201v.916m7.5 0a48.667 48.667 0 00-7.5 0"/></svg>
                    <span class="cairo">حذف</span>
                </button>
            </div>

            
            <div style="position:absolute;top:10px;right:10px;display:flex;gap:6px;z-index:10" x-show="!loading" x-transition>
                <button class="cfg-vp-btn" :class="{'active': autoRotate}" @click="toggleAutoRotate()" title="دوران تلقائي">
                    <svg width="16" height="16" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M16.023 9.348h4.992v-.001M2.985 19.644v-4.992m0 0h4.992m-4.993 0l3.181 3.183a8.25 8.25 0 0013.803-3.7M4.031 9.865a8.25 8.25 0 0113.803-3.7l3.181 3.182"/></svg>
                </button>
                <button class="cfg-vp-btn" :class="{'active': wireframe}" @click="toggleWireframe()" title="شبكة">
                    <svg width="16" height="16" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M3.75 6A2.25 2.25 0 016 3.75h2.25A2.25 2.25 0 0110.5 6v2.25a2.25 2.25 0 01-2.25 2.25H6a2.25 2.25 0 01-2.25-2.25V6z"/></svg>
                </button>
                <button class="cfg-vp-btn" @click="resetCamera()" title="إعادة ضبط">
                    <svg width="16" height="16" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M9 9V4.5M9 9H4.5M9 9L3.75 3.75M9 15v4.5M9 15H4.5M9 15l-5.25 5.25M15 9h4.5M15 9V4.5M15 9l5.25-5.25M15 15h4.5M15 15v4.5m0-4.5l5.25 5.25"/></svg>
                </button>
            </div>

            
            <div style="position:absolute;bottom:8px;right:8px;padding:3px 8px;background:rgba(0,0,0,0.5);border-radius:6px;z-index:10" x-show="!loading">
                <span style="font-size:10px;color:#555;font-family:monospace" x-text="`${fps} FPS`"></span>
            </div>

            
            <button class="cfg-vp-btn cfg-panel-toggle" style="position:absolute;top:10px;left:10px;z-index:10" x-show="!panelOpen && !loading" @click="panelOpen = true">
                <svg width="16" height="16" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M3.75 6.75h16.5M3.75 12h16.5m-16.5 5.25h16.5"/></svg>
            </button>
        </main>

        
        <aside class="cfg-actions" :class="{ 'hidden': !actionsOpen }" dir="rtl">
        
        <a href="<?php echo e(url()->previous()); ?>" class="cfg-act cairo" title="رجوع">
            <svg fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M9 15l-6-6m0 0l6-6m-6 6h16"/></svg>
            <span class="cfg-act-label">رجوع</span>
        </a>

        <div class="cfg-divider"></div>

        
        <button class="cfg-act cairo" @click="captureScreenshot()" title="التقاط صورة">
            <svg fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M6.827 6.175A2.31 2.31 0 015.186 7.23c-.38.054-.757.112-1.134.175C2.999 7.58 2.25 8.507 2.25 9.574V18a2.25 2.25 0 002.25 2.25h15A2.25 2.25 0 0021.75 18V9.574c0-1.067-.75-1.994-1.802-2.169a47.865 47.865 0 00-1.134-.175 2.31 2.31 0 01-1.64-1.055l-.822-1.316a2.192 2.192 0 00-1.736-1.039 48.774 48.774 0 00-5.232 0 2.192 2.192 0 00-1.736 1.039l-.821 1.316z"/><path stroke-linecap="round" stroke-linejoin="round" d="M16.5 12.75a4.5 4.5 0 11-9 0 4.5 4.5 0 019 0z"/></svg>
            <span class="cfg-act-label">صورة</span>
        </button>

        
        <button class="cfg-act cairo" @click="openSaveModal()" title="حفظ">
            <svg fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M17 16v2a2 2 0 01-2 2H5a2 2 0 01-2-2v-7a2 2 0 012-2h2m3-4H9a2 2 0 00-2 2v7a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-1m-1 4l-3 3m0 0l-3-3m3 3V3"/></svg>
            <span class="cfg-act-label">حفظ</span>
        </button>

        <div style="flex: 1"></div>

        
        <div class="cfg-product-name cairo" x-text="productName"></div>

        <div class="cfg-divider"></div>

        
        <button class="cfg-finish cairo" @click="openSaveModal()" title="إنهاء التصميم">
            <svg x-show="!saving" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75L11.25 15 15 9.75M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
            <span :class="{'animate-spin': saving}" x-show="saving" style="display:inline-block;width:18px;height:18px;border:2px solid rgba(0,0,0,0.2);border-top-color:#000;border-radius:50%"></span>
            <span class="cfg-act-label" x-text="saving ? 'جاري..' : 'إنهاء'"></span>
        </button>
        </aside>
    </div>

    
    <button class="cfg-actions-toggle" @click="actionsOpen = !actionsOpen" :class="{'rotate-90': actionsOpen}">
        <svg fill="none" stroke="currentColor" stroke-width="2.5" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" d="M12 6.75a.75.75 0 110-1.5.75.75 0 010 1.5zM12 12.75a.75.75 0 110-1.5.75.75 0 010 1.5zM12 18.75a.75.75 0 110-1.5.75.75 0 010 1.5z"/>
        </svg>
    </button>

    
    <div x-show="showSaveModal" x-cloak class="cfg-modal-bg"
         x-transition:enter="transition ease-out duration-200" x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100"
         x-transition:leave="transition ease-in duration-150" x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0">
        <div class="overlay" @click="showSaveModal = false"></div>
        <div class="cfg-modal" dir="rtl" @click.stop
             x-transition:enter="transition ease-out duration-200 delay-75" x-transition:enter-start="opacity-0 scale-95" x-transition:enter-end="opacity-100 scale-100">
            <h3 class="cairo" style="font-size:18px;font-weight:900;margin-bottom:16px">حفظ التصميم</h3>
            <div style="display:flex;flex-direction:column;gap:12px;margin-bottom:16px">
                <div>
                    <label class="cairo" style="font-size:11px;font-weight:700;color:#888;display:block;margin-bottom:4px">اسم التصميم</label>
                    <input type="text" class="cfg-input cairo" x-model="designName" placeholder="تصميمي المميز" dir="rtl">
                </div>
                <label style="display:flex;align-items:center;gap:8px;cursor:pointer">
                    <input type="checkbox" x-model="makePublic" style="accent-color:#D4A356">
                    <span class="cairo" style="font-size:11px;color:#888">جعل التصميم عاماً</span>
                </label>
            </div>
            <div style="display:flex;gap:8px">
                <button class="cfg-btn cfg-btn-ghost cairo" style="flex:1" @click="showSaveModal = false">إلغاء</button>
                <button class="cfg-btn cfg-btn-gold cairo" style="flex:1" @click="confirmSave()">حفظ</button>
            </div>
        </div>
    </div>

    
    <div style="position:fixed;top:16px;left:50%;transform:translateX(-50%);z-index:300;display:flex;flex-direction:column;align-items:center;gap:6px">
        <template x-for="t in toasts" :key="t.id">
            <div class="cfg-toast" :style="t.type==='error' ? 'border-color:rgba(239,68,68,0.2)' : 'border-color:rgba(52,211,153,0.2)'">
                <svg x-show="t.type==='success'" width="14" height="14" fill="none" stroke="#34d399" stroke-width="2.5" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M4.5 12.75l6 6 9-13.5"/></svg>
                <svg x-show="t.type==='error'" width="14" height="14" fill="none" stroke="#f87171" stroke-width="2.5" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"/></svg>
                <span class="cairo" style="font-size:12px;font-weight:700" x-text="t.message"></span>
            </div>
        </template>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<style>@keyframes spin{to{transform:rotate(360deg)}}</style>
<script type="importmap">
{
    "imports": {
        "three": "https://cdn.jsdelivr.net/npm/three@0.160.0/build/three.module.js",
        "three/addons/": "https://cdn.jsdelivr.net/npm/three@0.160.0/examples/jsm/"
    }
}
</script>
<script type="module">
import * as THREE from 'three';
import { OrbitControls } from 'three/addons/controls/OrbitControls.js';
import { GLTFLoader } from 'three/addons/loaders/GLTFLoader.js';
import { RoomEnvironment } from 'three/addons/environments/RoomEnvironment.js';
import { EffectComposer } from 'three/addons/postprocessing/EffectComposer.js';
import { RenderPass } from 'three/addons/postprocessing/RenderPass.js';
import { OutlinePass } from 'three/addons/postprocessing/OutlinePass.js';
import { OutputPass } from 'three/addons/postprocessing/OutputPass.js';
import { TransformControls } from 'three/addons/controls/TransformControls.js';
import { DecalGeometry } from 'three/addons/geometries/DecalGeometry.js';

/* ═══════════════════════════════════════════════════
   THREE.JS STATE  (outside Alpine to avoid Proxy)
   ═══════════════════════════════════════════════════ */
const _3d = {
    scene: null, camera: null, renderer: null, controls: null,
    composer: null, outlinePass: null, transformControls: null,
    raycaster: new THREE.Raycaster(),
    mouse: new THREE.Vector2(),
    model: null, clock: null, animId: null,
    parts: {},            /* { [stable_key]: { mesh, origMat, origColor } } */
    selectedMesh: null,
    decals: [],           /* { id, mesh, type, data } */
    textureCache: {},     /* reuse loaded textures */
};

/* ═══════════════════════════════════════════════════
   COLOR UTILITIES
   ═══════════════════════════════════════════════════ */
const CU = {
    hexToHsl(hex) {
        let r = parseInt(hex.slice(1,3),16)/255, g = parseInt(hex.slice(3,5),16)/255, b = parseInt(hex.slice(5,7),16)/255;
        const max = Math.max(r,g,b), min = Math.min(r,g,b), d = max - min;
        let h = 0, s = 0, l = (max+min)/2;
        if (d > 0) {
            s = l > 0.5 ? d/(2-max-min) : d/(max+min);
            if (max === r) h = ((g-b)/d + (g < b ? 6 : 0)) / 6;
            else if (max === g) h = ((b-r)/d + 2) / 6;
            else h = ((r-g)/d + 4) / 6;
        }
        return { h: h*360, s: s*100, l: l*100 };
    },
    hslToHex(h, s, l) {
        s /= 100; l /= 100;
        const a = s * Math.min(l, 1-l);
        const f = n => { const k = (n + h/30) % 12; return l - a * Math.max(Math.min(k-3, 9-k, 1), -1); };
        return '#' + [f(0),f(8),f(4)].map(x => Math.round(x*255).toString(16).padStart(2,'0')).join('');
    },
    generateShades(hex, steps = 14) {
        const { h, s } = this.hexToHsl(hex);
        const arr = [];
        for (let i = 0; i < steps; i++) {
            const l = 95 - (i * (90 / (steps - 1)));
            arr.push(this.hslToHex(h, s, l));
        }
        return arr;
    },
    getComplementary(hex) {
        const { h, s, l } = this.hexToHsl(hex);
        return [
            this.hslToHex((h + 180) % 360, s, l),
            this.hslToHex((h + 30) % 360, s, l),
            this.hslToHex((h - 30 + 360) % 360, s, l),
            this.hslToHex((h + 120) % 360, s, l),
            this.hslToHex((h + 240) % 360, s, l),
        ];
    }
};

/* ═══════════════════════════════════════════════════
   MATERIAL PRESETS
   ═══════════════════════════════════════════════════ */
const MAT_PRESETS = [
    { id: 'cotton',  name: 'قطن',    icon: '🧵', roughness: 0.85, metalness: 0.0 },
    { id: 'silk',    name: 'حرير',   icon: '✨', roughness: 0.2,  metalness: 0.1 },
    { id: 'linen',   name: 'كتان',   icon: '🪡', roughness: 0.9,  metalness: 0.0 },
    { id: 'nylon',   name: 'نايلون', icon: '🧶', roughness: 0.3,  metalness: 0.15 },
    { id: 'wool',    name: 'صوف',    icon: '🐑', roughness: 0.95, metalness: 0.0 },
    { id: 'velvet',  name: 'مخمل',   icon: '🎀', roughness: 0.7,  metalness: 0.05 },
    { id: 'lycra',   name: 'ليكرا',  icon: '💪', roughness: 0.15, metalness: 0.2 },
    { id: 'leather', name: 'جلد',    icon: '👜', roughness: 0.55, metalness: 0.0 },
];

/* ═══════════════════════════════════════════════════
   ALPINE COMPONENT
   ═══════════════════════════════════════════════════ */
window.configurator = function() {
    return {
        /* ─── UI ─── */
        loading: true, loadProgress: 0, saving: false, showSaveModal: false,
        panelOpen: true, activeTool: 'color', fps: 0,
        wireframe: false, autoRotate: false,
        placementMode: null, /* null | 'text' | 'image' */
        barOpen: window.innerWidth > 768, /* left toolbar toggle for mobile - hidden by default on mobile */
        actionsOpen: true, /* right sidebar toggle for mobile */

        productName: <?php echo json_encode($product->name, 15, 512) ?>,

        /* ─── TOOLS ─── */
        tools: [
            { id:'design',  name:'تصميم',  svg:'<path stroke-linecap="round" stroke-linejoin="round" d="M9.53 16.122a3 3 0 00-5.78 1.128 2.25 2.25 0 01-2.4 2.245 4.5 4.5 0 008.4-2.245c0-.399-.078-.78-.22-1.128zm0 0a15.998 15.998 0 003.388-1.62m-5.043-.025a15.994 15.994 0 011.622-3.395m3.42 3.42a15.995 15.995 0 004.764-4.648l3.876-5.814a1.151 1.151 0 00-1.597-1.597L14.146 6.32a15.996 15.996 0 00-4.649 4.763m3.42 3.42a6.776 6.776 0 00-3.42-3.42"/>' },
            { id:'color',   name:'ألوان',   svg:'<path stroke-linecap="round" stroke-linejoin="round" d="M4.098 19.902a3.75 3.75 0 005.304 0l6.401-6.402M6.75 21A3.75 3.75 0 013 17.25V4.125C3 3.504 3.504 3 4.125 3h5.25c.621 0 1.125.504 1.125 1.125v4.072M6.75 21a3.75 3.75 0 003.75-3.75V8.197M6.75 21h13.125c.621 0 1.125-.504 1.125-1.125v-5.25c0-.621-.504-1.125-1.125-1.125h-4.072M10.5 8.197l2.88-2.88c.438-.439 1.15-.439 1.59 0l3.712 3.713c.44.44.44 1.152 0 1.59l-2.879 2.88M6.75 17.25h.008v.008H6.75v-.008z"/>' },
            { id:'texture', name:'خامات',  svg:'<path stroke-linecap="round" stroke-linejoin="round" d="M3.75 6A2.25 2.25 0 016 3.75h2.25A2.25 2.25 0 0110.5 6v2.25a2.25 2.25 0 01-2.25 2.25H6a2.25 2.25 0 01-2.25-2.25V6zM3.75 15.75A2.25 2.25 0 016 13.5h2.25a2.25 2.25 0 012.25 2.25V18a2.25 2.25 0 01-2.25 2.25H6A2.25 2.25 0 013.75 18v-2.25zM13.5 6a2.25 2.25 0 012.25-2.25H18A2.25 2.25 0 0120.25 6v2.25A2.25 2.25 0 0118 10.5h-2.25a2.25 2.25 0 01-2.25-2.25V6zM13.5 15.75a2.25 2.25 0 012.25-2.25H18a2.25 2.25 0 012.25 2.25V18A2.25 2.25 0 0118 20.25h-2.25A2.25 2.25 0 0113.5 18v-2.25z"/>' },
            { id:'text',    name:'نص',     svg:'<path stroke-linecap="round" stroke-linejoin="round" d="M10.5 21l5.25-11.25L21 21m-9-3h7.5M3 5.621a48.474 48.474 0 016-.371m0 0c1.12 0 2.233.038 3.334.114M9 5.25V3m3.334 2.364V3"/>' },
            { id:'logo',    name:'شعار',   svg:'<path stroke-linecap="round" stroke-linejoin="round" d="M2.25 15.75l5.159-5.159a2.25 2.25 0 013.182 0l5.159 5.159m-1.5-1.5l1.409-1.409a2.25 2.25 0 013.182 0l2.909 2.909M3.75 21h16.5a1.5 1.5 0 001.5-1.5V4.5a1.5 1.5 0 00-1.5-1.5H3.75a1.5 1.5 0 00-1.5 1.5v15a1.5 1.5 0 001.5 1.5zm13.097-13.097a.75.75 0 10-1.06-1.06.75.75 0 001.06 1.06z"/>' },
            { id:'stickers',name:'ملصقات', svg:'<path stroke-linecap="round" stroke-linejoin="round" d="M11.48 3.499a.562.562 0 011.04 0l2.125 5.111a.563.563 0 00.475.345l5.518.442c.499.04.701.663.321.988l-4.204 3.602a.563.563 0 00-.182.557l1.285 5.385a.562.562 0 01-.84.61l-4.725-2.885a.563.563 0 00-.586 0L6.982 20.54a.562.562 0 01-.84-.61l1.285-5.386a.562.562 0 00-.182-.557l-4.204-3.602a.563.563 0 01.321-.988l5.518-.442a.563.563 0 00.475-.345L11.48 3.5z"/>' },
            { id:'layers',  name:'طبقات',  svg:'<path stroke-linecap="round" stroke-linejoin="round" d="M6.429 9.75L2.25 12l4.179 2.25m0-4.5l5.571 3 5.571-3m-11.142 0L2.25 7.5 12 2.25l9.75 5.25-4.179 2.25m0 0L12 12.75 6.43 9.75m11.14 0l4.179 2.25L12 17.25 2.25 12l4.179-2.25"/>' },
            { id:'bg',      name:'خلفية',  svg:'<path stroke-linecap="round" stroke-linejoin="round" d="M4.098 19.902a3.75 3.75 0 005.304 0l6.401-6.402M6.75 21A3.75 3.75 0 013 17.25V4.125C3 3.504 3.504 3 4.125 3h5.25c.621 0 1.125.504 1.125 1.125v4.072M6.75 21a3.75 3.75 0 003.75-3.75V8.197"/>' },
        ],
        get currentToolName() { return this.tools.find(t => t.id === this.activeTool)?.name || ''; },

        /* ─── PART SELECTION ─── */
        selectedPartKey: null, selectedPartName: '', partColor: '#ffffff',
        badgeX: 0, badgeY: 0, badgeVisible: false,
        shades: [], complementary: [],
        applyToAll: true,
        quickColors: ['#ffffff','#000000','#D4A356','#442247','#FF6B6B','#4ECDC4','#FFD93D','#6BCF7F','#1a2332','#B0924E','#FF9F43','#EE5A24','#0abde3','#8395a7'],

        /* ─── MATERIAL / TEXTURE ─── */
        materialPresets: MAT_PRESETS,
        activePresetId: null,
        matRoughness: 0.5, matMetalness: 0,
        hasPartTexture: false,
        uvRepeatX: 1, uvRepeatY: 1, uvOffsetX: 0, uvOffsetY: 0, uvRotation: 0,

        /* ─── TEXT DECALS ─── */
        decalText: '', decalFontSize: 48, decalTextColor: '#D4A356', decalFont: 'Cairo',
        get textDecals() { return _3d.decals.filter(d => d.type === 'text').map(d => ({id: d.id, content: d.data.content})); },

        /* ─── IMAGE DECALS ─── */
        logoPreview: null, logoScale: 0.2, _logoDataUrl: null,
        get imageDecals() { return _3d.decals.filter(d => d.type === 'image').map(d => ({id: d.id})); },

        /* ─── DECAL EDITING ─── */
        selectedDecalId: null,
        transformMode: 'translate', /* 'translate' | 'rotate' | 'scale' */

        /* ─── STICKERS ─── */
        stickerLibrary: [], stickerSearch: '', stickerCategory: '', stickerLoading: false,
        stickerCategories: ['زخارف', 'نصوص', 'شعارات', 'أنماط', 'رموز', 'أخرى'],
        get filteredStickers() {
            let list = this.stickerLibrary;
            if (this.stickerCategory) list = list.filter(s => s.category === this.stickerCategory);
            if (this.stickerSearch) list = list.filter(s => s.name.includes(this.stickerSearch));
            return list;
        },

        /* ─── LAYERS ─── */
        layers: [],

        /* ─── BACKGROUND ─── */
        bgColor: '#1a1a1a',
        bgColors: ['#0a0a0a','#1a1a1a','#2d1635','#442247','#1a2332','#0d1f0d','#2a1a0a','#1a1a2e','#f5f5f0','#ffffff'],

        /* ─── UNDO / REDO ─── */
        undoStack: [], redoStack: [],
        get canUndo() { return this.undoStack.length > 0; },
        get canRedo() { return this.redoStack.length > 0; },

        /* ─── SAVE ─── */
        designName: '', makePublic: false, toasts: [],

        /* ═══════════ BOOT ═══════════ */
        boot() {
            this.$nextTick(() => requestAnimationFrame(() => { this.initScene(); this.loadModel(); }));
        },

        /* ═══════════ SCENE ═══════════ */
        initScene() {
            const wrapper = document.getElementById('cfg-wrapper');
            const canvas = document.getElementById('cfg-canvas');
            const w = wrapper.clientWidth || window.innerWidth;
            const h = wrapper.clientHeight || window.innerHeight;

            _3d.clock = new THREE.Clock();
            _3d.scene = new THREE.Scene();
            _3d.scene.background = new THREE.Color(this.bgColor);

            _3d.camera = new THREE.PerspectiveCamera(45, w / h, 0.1, 1000);
            _3d.camera.position.set(0, 1.2, 4);

            _3d.renderer = new THREE.WebGLRenderer({ canvas, antialias: true, alpha: true, preserveDrawingBuffer: true });
            _3d.renderer.setSize(w, h);
            _3d.renderer.setPixelRatio(Math.min(window.devicePixelRatio, 2));
            _3d.renderer.shadowMap.enabled = true;
            _3d.renderer.shadowMap.type = THREE.PCFSoftShadowMap;
            _3d.renderer.toneMapping = THREE.ACESFilmicToneMapping;
            _3d.renderer.toneMappingExposure = 1.0;
            _3d.renderer.outputColorSpace = THREE.SRGBColorSpace;

            /* PBR environment */
            const pmrem = new THREE.PMREMGenerator(_3d.renderer);
            pmrem.compileEquirectangularShader();
            _3d.scene.environment = pmrem.fromScene(new RoomEnvironment(), 0.04).texture;
            pmrem.dispose();

            /* Lights */
            _3d.scene.add(new THREE.AmbientLight(0xffffff, 0.4));
            _3d.scene.add(new THREE.HemisphereLight(0xffeedd, 0x222244, 0.5));
            const key = new THREE.DirectionalLight(0xffffff, 1.0);
            key.position.set(4, 6, 4); key.castShadow = true;
            key.shadow.mapSize.set(1024, 1024); key.shadow.bias = -0.002;
            _3d.scene.add(key);
            const fill = new THREE.DirectionalLight(0xaabbff, 0.3); fill.position.set(-3, 3, -2); _3d.scene.add(fill);

            /* Ground */
            const ground = new THREE.Mesh(new THREE.PlaneGeometry(20, 20), new THREE.ShadowMaterial({ opacity: 0.15 }));
            ground.rotation.x = -Math.PI / 2; ground.position.y = -0.01; ground.receiveShadow = true; _3d.scene.add(ground);
            const grid = new THREE.GridHelper(10, 20, 0x333333, 0x222222); grid.material.opacity = 0.15; grid.material.transparent = true; _3d.scene.add(grid);

            /* Controls */
            _3d.controls = new OrbitControls(_3d.camera, canvas);
            _3d.controls.enableDamping = true; _3d.controls.dampingFactor = 0.08;
            _3d.controls.autoRotate = false; _3d.controls.autoRotateSpeed = 0.5;
            _3d.controls.minDistance = 1; _3d.controls.maxDistance = 15;
            _3d.controls.maxPolarAngle = Math.PI * 0.85; _3d.controls.target.set(0, 0.5, 0);

            /* TransformControls for decal manipulation */
            _3d.transformControls = new TransformControls(_3d.camera, canvas);
            _3d.transformControls.setSize(0.6);
            _3d.transformControls.addEventListener('dragging-changed', e => {
                _3d.controls.enabled = !e.value;
            });
            _3d.transformControls.visible = false;
            _3d.scene.add(_3d.transformControls);

            /* Post-processing (OutlinePass) */
            _3d.composer = new EffectComposer(_3d.renderer);
            _3d.composer.addPass(new RenderPass(_3d.scene, _3d.camera));
            _3d.outlinePass = new OutlinePass(new THREE.Vector2(w, h), _3d.scene, _3d.camera);
            _3d.outlinePass.edgeStrength = 4; _3d.outlinePass.edgeGlow = 0.3; _3d.outlinePass.edgeThickness = 1.5;
            _3d.outlinePass.pulsePeriod = 0;
            _3d.outlinePass.visibleEdgeColor.set('#D4A356');
            _3d.outlinePass.hiddenEdgeColor.set('#442247');
            _3d.composer.addPass(_3d.outlinePass);
            _3d.composer.addPass(new OutputPass());

            /* Resize */
            const doResize = () => {
                const nw = wrapper.clientWidth || window.innerWidth;
                const nh = wrapper.clientHeight || window.innerHeight;
                if (!nw || !nh) return;
                _3d.camera.aspect = nw / nh; _3d.camera.updateProjectionMatrix();
                _3d.renderer.setSize(nw, nh);
                _3d.composer.setSize(nw, nh);
            };
            if (typeof ResizeObserver !== 'undefined') new ResizeObserver(doResize).observe(wrapper);
            window.addEventListener('resize', doResize);

            /* Click handler for part selection & decal placement */
            let pDown = null, pTime = 0, tcDragging = false;
            _3d.transformControls.addEventListener('dragging-changed', e => { tcDragging = e.value; });
            canvas.addEventListener('pointerdown', e => { if (!tcDragging) { pDown = { x: e.clientX, y: e.clientY }; pTime = Date.now(); } });
            canvas.addEventListener('pointerup', e => {
                if (!pDown || tcDragging) { pDown = null; return; }
                const dx = e.clientX - pDown.x, dy = e.clientY - pDown.y;
                if (Math.sqrt(dx*dx + dy*dy) < 5 && (Date.now() - pTime) < 300) {
                    this.onCanvasClick(e);
                }
                pDown = null;
            });

            /* Keyboard shortcuts */
            window.addEventListener('keydown', e => {
                if (e.key === 'Escape') {
                    if (this.placementMode) this.cancelPlacement();
                    else if (this.selectedDecalId) this.deselectDecal();
                }
                if (e.key === 'Delete' && this.selectedDecalId) this.removeSelectedDecal();
                /* Ctrl+Z / Ctrl+Y for undo/redo */
                if ((e.ctrlKey || e.metaKey) && e.key === 'z' && !e.shiftKey) { e.preventDefault(); this.undo(); }
                if ((e.ctrlKey || e.metaKey) && (e.key === 'y' || (e.key === 'z' && e.shiftKey))) { e.preventDefault(); this.redo(); }
            });

            this.renderLoop();
        },

        /* ═══════════ RENDER LOOP ═══════════ */
        renderLoop() {
            let lastFps = 0, fc = 0;
            const loop = () => {
                _3d.animId = requestAnimationFrame(loop);
                const elapsed = _3d.clock.getElapsedTime();
                fc++;
                if (elapsed - lastFps >= 1) { this.fps = fc; fc = 0; lastFps = elapsed; }
                _3d.controls.update();
                _3d.composer.render();
                /* Update badge position */
                if (_3d.selectedMesh && !this.loading) {
                    if (fc % 3 === 0) {
                        const box = new THREE.Box3().setFromObject(_3d.selectedMesh);
                        const top = new THREE.Vector3(); box.getCenter(top); top.y = box.max.y + 0.15;
                        top.project(_3d.camera);
                        const el = _3d.renderer.domElement;
                        this.badgeX = Math.round((top.x * 0.5 + 0.5) * el.clientWidth);
                        this.badgeY = Math.round((-top.y * 0.5 + 0.5) * el.clientHeight);
                        this.badgeVisible = top.z < 1;
                    }
                }
            };
            loop();
        },

        /* ═══════════ LOAD MODEL ═══════════ */
        loadModel() {
            const url = <?php echo json_encode($model->glb_url, 15, 512) ?>;
            if (!url) { this.loading = false; this.toast('لم يتم العثور على ملف الموديل', 'error'); return; }
            new GLTFLoader().load(url, (gltf) => {
                _3d.model = gltf.scene;
                let idx = 0;
                _3d.model.traverse(ch => {
                    if (ch.isMesh) {
                        ch.castShadow = true; ch.receiveShadow = true;
                        if (ch.material) ch.material = ch.material.clone();
                        const key = ch.name || `part_${idx}`;
                        ch.userData.stable_key = key;
                        _3d.parts[key] = {
                            mesh: ch, name: ch.name || `الجزء ${idx + 1}`,
                            origColor: ch.material.color ? '#' + ch.material.color.getHexString() : '#ffffff',
                            origRoughness: ch.material.roughness ?? 0.5,
                            origMetalness: ch.material.metalness ?? 0,
                        };
                        idx++;
                    }
                });
                /* Auto-center & scale */
                const box = new THREE.Box3().setFromObject(_3d.model);
                const sz = box.getSize(new THREE.Vector3());
                const sc = 2.2 / Math.max(sz.x, sz.y, sz.z);
                _3d.model.scale.setScalar(sc);
                const sb = new THREE.Box3().setFromObject(_3d.model);
                const sc2 = sb.getCenter(new THREE.Vector3());
                _3d.model.position.set(-sc2.x, -sb.min.y, -sc2.z);
                _3d.scene.add(_3d.model);
                const fb = new THREE.Box3().setFromObject(_3d.model);
                _3d.controls.target.copy(fb.getCenter(new THREE.Vector3()));
                _3d.controls.update();
                this.loading = false;
            }, xhr => { if (xhr.total > 0) this.loadProgress = (xhr.loaded / xhr.total) * 100; },
            err => { console.error('GLB error:', err); this.loading = false; this.toast('خطأ في تحميل الموديل', 'error'); });
        },

        /* ═══════════ CANVAS CLICK ═══════════ */
        onCanvasClick(e) {
            const rect = _3d.renderer.domElement.getBoundingClientRect();
            _3d.mouse.x = ((e.clientX - rect.left) / rect.width) * 2 - 1;
            _3d.mouse.y = -((e.clientY - rect.top) / rect.height) * 2 + 1;
            _3d.raycaster.setFromCamera(_3d.mouse, _3d.camera);
            if (!_3d.model) return;

            /* Gather model meshes */
            const modelMeshes = [];
            _3d.model.traverse(c => { if (c.isMesh) modelMeshes.push(c); });

            /* Placement mode — place decal on model surface */
            if (this.placementMode) {
                const hits = _3d.raycaster.intersectObjects(modelMeshes, false);
                if (hits.length > 0) this.placeDecalAt(hits[0]);
                return;
            }

            /* Check if clicking on an existing decal mesh */
            const decalMeshes = _3d.decals.map(d => d.mesh).filter(Boolean);
            if (decalMeshes.length > 0) {
                const decalHits = _3d.raycaster.intersectObjects(decalMeshes, false);
                if (decalHits.length > 0) {
                    const d = _3d.decals.find(x => x.mesh === decalHits[0].object);
                    if (d) { this.selectDecal(d.id); return; }
                }
            }

            /* Check if clicking on model parts */
            const partHits = _3d.raycaster.intersectObjects(modelMeshes, false);
            if (partHits.length > 0) {
                this.deselectDecal();
                this.selectPart(partHits[0].object);
            } else {
                this.deselectDecal();
                this.deselectAll();
            }
        },

        /* ═══════════ PART SELECTION ═══════════ */
        selectPart(mesh) {
            const key = mesh.userData.stable_key;
            if (!key || !_3d.parts[key]) return;
            _3d.selectedMesh = mesh;
            _3d.outlinePass.selectedObjects = [mesh];
            this.selectedPartKey = key;
            this.selectedPartName = _3d.parts[key].name;
            const mat = Array.isArray(mesh.material) ? mesh.material[0] : mesh.material;
            this.partColor = '#' + (mat.color ? mat.color.getHexString() : 'ffffff');
            this.matRoughness = mat.roughness ?? 0.5;
            this.matMetalness = mat.metalness ?? 0;
            this.hasPartTexture = !!mat.map;
            this.shades = CU.generateShades(this.partColor);
            this.complementary = CU.getComplementary(this.partColor);
            /* Auto-open color tab if no tool-related tab is active */
            if (!['color','texture','text','logo'].includes(this.activeTool)) {
                this.activeTool = 'color';
            }
            if (!this.panelOpen) this.panelOpen = true;
        },

        deselectAll() {
            _3d.selectedMesh = null;
            _3d.outlinePass.selectedObjects = [];
            this.selectedPartKey = null;
            this.selectedPartName = '';
            this.badgeVisible = false;
        },

        /* ═══════════ COLOR ═══════════ */
        applyPartColor(hex) {
            this.partColor = hex;
            this.shades = CU.generateShades(hex);
            this.complementary = CU.getComplementary(hex);

            if (this.applyToAll && _3d.model) {
                /* Save undo snapshot for all parts */
                const undoOps = [];
                _3d.model.traverse(c => {
                    if (c.isMesh) {
                        const mat = Array.isArray(c.material) ? c.material[0] : c.material;
                        const prevColor = mat.color ? '#' + mat.color.getHexString() : '#ffffff';
                        undoOps.push({ key: c.userData.stable_key, prevColor });
                        this._applyToMat(c, m => m.color.set(hex));
                    }
                });
                this._pushUndo({ type: 'colorAll', prevState: undoOps, newColor: hex });
                this._addLayer('color', 'all', `لون الكل: ${hex}`, hex);
            } else if (_3d.selectedMesh) {
                const mat = Array.isArray(_3d.selectedMesh.material) ? _3d.selectedMesh.material[0] : _3d.selectedMesh.material;
                const prevColor = mat.color ? '#' + mat.color.getHexString() : '#ffffff';
                this._pushUndo({ type: 'color', key: _3d.selectedMesh.userData.stable_key, prevColor, newColor: hex });
                this._applyToMat(_3d.selectedMesh, m => m.color.set(hex));
                this._addLayer('color', _3d.selectedMesh.userData.stable_key, `لون: ${hex}`, hex);
            }
        },

        /* ═══════════ MATERIAL PRESETS ═══════════ */
        applyMaterialPreset(p) {
            this.activePresetId = p.id;
            this.matRoughness = p.roughness;
            this.matMetalness = p.metalness;

            if (this.applyToAll && _3d.model) {
                const undoOps = [];
                _3d.model.traverse(c => {
                    if (c.isMesh) {
                        const mat = Array.isArray(c.material) ? c.material[0] : c.material;
                        undoOps.push({ key: c.userData.stable_key, prevR: mat.roughness, prevM: mat.metalness });
                        this._applyToMat(c, m => { m.roughness = p.roughness; m.metalness = p.metalness; m.needsUpdate = true; });
                    }
                });
                this._pushUndo({ type: 'presetAll', prevState: undoOps, preset: p });
                this._addLayer('preset', 'all', `خامة الكل: ${p.name}`, '#B0924E');
            } else if (_3d.selectedMesh) {
                const mat = Array.isArray(_3d.selectedMesh.material) ? _3d.selectedMesh.material[0] : _3d.selectedMesh.material;
                this._pushUndo({ type: 'preset', key: _3d.selectedMesh.userData.stable_key, prevR: mat.roughness, prevM: mat.metalness, preset: p });
                this._applyToMat(_3d.selectedMesh, m => { m.roughness = p.roughness; m.metalness = p.metalness; m.needsUpdate = true; });
                this._addLayer('preset', _3d.selectedMesh.userData.stable_key, `خامة: ${p.name}`, '#B0924E');
            }
        },

        updateMatParams() {
            if (this.applyToAll && _3d.model) {
                _3d.model.traverse(c => {
                    if (c.isMesh) this._applyToMat(c, m => { m.roughness = this.matRoughness; m.metalness = this.matMetalness; m.needsUpdate = true; });
                });
            } else if (_3d.selectedMesh) {
                this._applyToMat(_3d.selectedMesh, m => { m.roughness = this.matRoughness; m.metalness = this.matMetalness; m.needsUpdate = true; });
            }
        },

        /* ═══════════ TEXTURE UPLOAD ═══════════ */
        uploadTexture(ev, mapType) {
            const file = ev.target.files[0]; if (!file) return;
            if (!this.applyToAll && !_3d.selectedMesh) return;
            const reader = new FileReader();
            reader.onload = e => {
                new THREE.TextureLoader().load(e.target.result, tex => {
                    tex.wrapS = tex.wrapT = THREE.RepeatWrapping;
                    tex.repeat.set(this.uvRepeatX, this.uvRepeatY);
                    tex.offset.set(this.uvOffsetX, this.uvOffsetY);
                    tex.rotation = this.uvRotation;
                    tex.colorSpace = mapType === 'map' ? THREE.SRGBColorSpace : THREE.LinearSRGBColorSpace;
                    if (this.applyToAll && _3d.model) {
                        _3d.model.traverse(c => { if (c.isMesh) this._applyToMat(c, m => { m[mapType] = tex.clone(); m.needsUpdate = true; }); });
                        this._addLayer('texture', 'all', `خامة الكل: ${mapType}`, '#4ECDC4');
                    } else if (_3d.selectedMesh) {
                        this._applyToMat(_3d.selectedMesh, m => { m[mapType] = tex; m.needsUpdate = true; });
                        this._addLayer('texture', _3d.selectedMesh.userData.stable_key, `خامة: ${mapType}`, '#4ECDC4');
                    }
                    this.hasPartTexture = true;
                });
            };
            reader.readAsDataURL(file);
            ev.target.value = '';
        },

        removePartTexture() {
            if (this.applyToAll && _3d.model) {
                _3d.model.traverse(c => { if (c.isMesh) this._applyToMat(c, m => {
                    if (m.map) { m.map.dispose(); m.map = null; }
                    if (m.normalMap) { m.normalMap.dispose(); m.normalMap = null; }
                    m.needsUpdate = true;
                }); });
            } else if (_3d.selectedMesh) {
                this._applyToMat(_3d.selectedMesh, m => {
                    if (m.map) { m.map.dispose(); m.map = null; }
                    if (m.normalMap) { m.normalMap.dispose(); m.normalMap = null; }
                    m.needsUpdate = true;
                });
            }
            this.hasPartTexture = false;
        },

        updateUV() {
            if (!_3d.selectedMesh) return;
            this._applyToMat(_3d.selectedMesh, m => {
                ['map','normalMap','roughnessMap','metalnessMap'].forEach(k => {
                    if (m[k]) {
                        m[k].repeat.set(this.uvRepeatX, this.uvRepeatY);
                        m[k].offset.set(this.uvOffsetX, this.uvOffsetY);
                        m[k].rotation = this.uvRotation;
                        m[k].needsUpdate = true;
                    }
                });
            });
        },

        /* ═══════════ DECAL PLACEMENT ═══════════ */
        startDecalPlacement(type) {
            this.deselectDecal();
            this.placementMode = type;
        },
        cancelPlacement() { this.placementMode = null; },

        /**
         * Place a decal as a floating plane mesh (not DecalGeometry).
         * This allows direct move/rotate/scale with TransformControls.
         */
        placeDecalAt(hit) {
            const position = hit.point.clone();
            const normal = hit.face.normal.clone().transformDirection(hit.object.matrixWorld);
            const offset = normal.clone().multiplyScalar(0.005);

            let texture, planeW, planeH, decalData;

            if (this.placementMode === 'text') {
                /* ── Text decal canvas (with proper RTL support) ── */
                const cvs = document.createElement('canvas');
                cvs.width = 1024; cvs.height = 512;
                const ctx = cvs.getContext('2d');

                /* Clear with transparent bg */
                ctx.clearRect(0, 0, cvs.width, cvs.height);

                /* Set font first so measureText works */
                const fontStr = `bold ${this.decalFontSize * 2}px "${this.decalFont}", "Cairo", "Tajawal", sans-serif`;
                ctx.font = fontStr;

                /* Arabic / RTL fix: use direction + textAlign */
                const isRTL = /[\u0600-\u06FF\u0750-\u077F\u08A0-\u08FF\uFB50-\uFDFF\uFE70-\uFEFF]/.test(this.decalText);
                ctx.direction = isRTL ? 'rtl' : 'ltr';
                ctx.textAlign = 'center';
                ctx.textBaseline = 'middle';

                ctx.fillStyle = this.decalTextColor;
                ctx.fillText(this.decalText, cvs.width / 2, cvs.height / 2);

                texture = new THREE.CanvasTexture(cvs);
                texture.colorSpace = THREE.SRGBColorSpace;

                const measuredW = ctx.measureText(this.decalText).width;
                const aspect = Math.max(measuredW / (this.decalFontSize * 2), 1);
                planeW = 0.25 * aspect;
                planeH = 0.25 / aspect * 0.8;

                decalData = { content: this.decalText, fontSize: this.decalFontSize, color: this.decalTextColor, font: this.decalFont };
            } else {
                /* ── Image decal ── */
                texture = new THREE.TextureLoader().load(this._logoDataUrl);
                texture.colorSpace = THREE.SRGBColorSpace;
                planeW = this.logoScale;
                planeH = this.logoScale;
                decalData = { scale: this.logoScale, dataUrl: this._logoDataUrl };
            }

            try {
                /* Create a plane mesh */
                const geo = new THREE.PlaneGeometry(planeW, planeH);
                const mat = new THREE.MeshBasicMaterial({
                    map: texture, transparent: true, side: THREE.DoubleSide,
                    depthTest: true, depthWrite: false,
                    polygonOffset: true, polygonOffsetFactor: -4,
                });
                const mesh = new THREE.Mesh(geo, mat);

                /* Position slightly above the surface */
                mesh.position.copy(position.clone().add(offset));

                /* Orient the plane to face along the surface normal.
                   lookAt(position + normal) makes the plane's +Z face outward → front face visible from outside. */
                const up = new THREE.Vector3(0, 1, 0);
                if (Math.abs(normal.dot(up)) > 0.99) up.set(0, 0, 1);
                const lookTarget = mesh.position.clone().add(normal);
                mesh.lookAt(lookTarget);

                _3d.scene.add(mesh);

                const id = 'dcl_' + Date.now();
                _3d.decals.push({ id, mesh, type: this.placementMode, data: decalData, partKey: hit.object.userData.stable_key || null });
                this._addLayer('decal', id, this.placementMode === 'text' ? `نص: ${this.decalText}` : 'شعار', this.placementMode === 'text' ? '#D4A356' : '#4ECDC4');
                this.toast(this.placementMode === 'text' ? 'تم وضع النص — اسحب للتحريك' : 'تم وضع الشعار — اسحب للتحريك', 'success');

                /* Auto-select the new decal for immediate editing */
                this.placementMode = null;
                this.selectDecal(id);
            } catch (err) {
                console.error('Decal error:', err);
                this.toast('حدث خطأ أثناء وضع العنصر', 'error');
                this.placementMode = null;
            }
        },

        /* ═══════════ DECAL SELECTION & EDITING ═══════════ */
        selectDecal(id) {
            const d = _3d.decals.find(x => x.id === id);
            if (!d) return;
            this.selectedDecalId = id;
            _3d.outlinePass.selectedObjects = [d.mesh];
            _3d.transformControls.attach(d.mesh);
            _3d.transformControls.setMode(this.transformMode);
            _3d.transformControls.visible = true;
            /* Deselect any part */
            _3d.selectedMesh = null;
            this.selectedPartKey = null;
            this.selectedPartName = '';
            this.badgeVisible = false;
        },

        deselectDecal() {
            if (!this.selectedDecalId) return;
            this.selectedDecalId = null;
            _3d.outlinePass.selectedObjects = [];
            _3d.transformControls.detach();
            _3d.transformControls.visible = false;
        },

        setTransformMode(mode) {
            this.transformMode = mode;
            if (_3d.transformControls) _3d.transformControls.setMode(mode);
        },

        removeSelectedDecal() {
            if (!this.selectedDecalId) return;
            this.removeDecal(this.selectedDecalId);
            this.deselectDecal();
        },

        removeDecal(id) {
            if (this.selectedDecalId === id) this.deselectDecal();
            const idx = _3d.decals.findIndex(d => d.id === id);
            if (idx >= 0) {
                _3d.scene.remove(_3d.decals[idx].mesh);
                _3d.decals[idx].mesh.geometry.dispose();
                if (_3d.decals[idx].mesh.material.map) _3d.decals[idx].mesh.material.map.dispose();
                _3d.decals[idx].mesh.material.dispose();
                _3d.decals.splice(idx, 1);
            }
            this.layers = this.layers.filter(l => l.refId !== id);
        },

        /**
         * Bake a plane-based decal onto the model surface using DecalGeometry.
         * Called after the user confirms placement ("تأكيد" button in the toolbar).
         */
        bakeSelectedDecal() {
            if (!this.selectedDecalId) return;
            const d = _3d.decals.find(x => x.id === this.selectedDecalId);
            if (!d || !d.mesh) return;

            /* Find the closest mesh on the model beneath the decal */
            const decalPos = d.mesh.position.clone();
            const decalDir = new THREE.Vector3(0, 0, -1).applyQuaternion(d.mesh.quaternion);
            const rc = new THREE.Raycaster(decalPos.clone().add(decalDir.clone().multiplyScalar(0.5)), decalDir.clone().negate());
            const modelMeshes = [];
            if (_3d.model) _3d.model.traverse(c => { if (c.isMesh) modelMeshes.push(c); });
            const hits = rc.intersectObjects(modelMeshes, false);

            if (hits.length === 0) {
                this.toast('لا يمكن دمج العنصر — لم يُعثر على سطح', 'error');
                return;
            }

            const hit = hits[0];
            const normal = hit.face.normal.clone().transformDirection(hit.object.matrixWorld);
            const quat = new THREE.Quaternion().setFromUnitVectors(new THREE.Vector3(0, 0, 1), normal);
            const orientation = new THREE.Euler().setFromQuaternion(quat);

            /* Use the decal's scale to determine size */
            const ws = d.mesh.scale;
            const geo = d.mesh.geometry;
            geo.computeBoundingBox();
            const bb = geo.boundingBox;
            const baseW = (bb.max.x - bb.min.x) * ws.x;
            const baseH = (bb.max.y - bb.min.y) * ws.y;
            const size = new THREE.Vector3(baseW, baseH, 0.2);

            try {
                const decalGeo = new DecalGeometry(hit.object, hit.point, orientation, size);
                const bakedMat = new THREE.MeshBasicMaterial({
                    map: d.mesh.material.map, transparent: true, side: THREE.DoubleSide,
                    depthTest: true, depthWrite: false,
                    polygonOffset: true, polygonOffsetFactor: -4,
                });
                const bakedMesh = new THREE.Mesh(decalGeo, bakedMat);
                _3d.scene.add(bakedMesh);

                /* Remove old plane mesh and replace with baked mesh */
                _3d.scene.remove(d.mesh);
                d.mesh.geometry.dispose();
                /* Don't dispose the texture - it's shared with the baked mesh */
                d.mesh = bakedMesh;
                d.baked = true;

                this.deselectDecal();
                this.toast('تم دمج العنصر مع السطح بنجاح', 'success');
            } catch (err) {
                console.error('Bake error:', err);
                this.toast('خطأ في دمج العنصر', 'error');
            }
        },

        prepareLogoUpload(ev) {
            const file = ev.target.files[0]; if (!file) return;
            const reader = new FileReader();
            reader.onload = e => { this.logoPreview = e.target.result; this._logoDataUrl = e.target.result; };
            reader.readAsDataURL(file);
            ev.target.value = '';
        },

        /* ═══════════ LAYERS ═══════════ */
        _addLayer(type, refId, name, color) {
            const id = 'L_' + Date.now() + '_' + Math.random().toString(36).slice(2,6);
            this.layers.push({ id, type, refId, name, color, enabled: true });
        },
        toggleLayer(id) {
            const l = this.layers.find(x => x.id === id); if (!l) return;
            if (l.type === 'decal') {
                const d = _3d.decals.find(x => x.id === l.refId);
                if (d) d.mesh.visible = l.enabled;
            }
        },
        removeLayer(id) {
            const l = this.layers.find(x => x.id === id); if (!l) return;
            if (l.type === 'decal') this.removeDecal(l.refId);
            this.layers = this.layers.filter(x => x.id !== id);
        },

        /* ═══════════ STICKER LIBRARY ═══════════ */
        async loadStickers() {
            if (this.stickerLibrary.length > 0) return;
            this.stickerLoading = true;
            try {
                const resp = await fetch('<?php echo e(route("stickers.approved")); ?>');
                const data = await resp.json();
                if (data.success) this.stickerLibrary = data.stickers;
            } catch (e) { console.error('Sticker load error:', e); }
            this.stickerLoading = false;
        },

        applyStickerFromLibrary(sticker) {
            if (!sticker.image_url) { this.toast('صورة الملصق غير متوفرة', 'error'); return; }
            /* Load the sticker image and enter placement mode */
            this.logoPreview = sticker.image_url;
            this._logoDataUrl = sticker.image_url;
            this._stickerRefId = sticker.id;
            this.logoScale = 0.2;
            this.startDecalPlacement('image');
            this.toast('اضغط على المنتج لوضع الملصق', 'success');
            /* Track usage */
            fetch(`/stickers/${sticker.id}/track`, { method: 'POST', headers: { 'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>' } }).catch(() => {});
        },

        /* ═══════════ BACKGROUND ═══════════ */
        setBgColor(c) { this.bgColor = c; if (_3d.scene) _3d.scene.background = new THREE.Color(c); },

        /* ═══════════ VIEW CONTROLS ═══════════ */
        toggleWireframe() {
            this.wireframe = !this.wireframe;
            if (!_3d.model) return;
            _3d.model.traverse(c => { if (c.isMesh) this._applyToMat(c, m => m.wireframe = this.wireframe); });
        },
        toggleAutoRotate() { this.autoRotate = !this.autoRotate; if (_3d.controls) _3d.controls.autoRotate = this.autoRotate; },
        resetCamera() { if (!_3d.camera) return; _3d.camera.position.set(0, 1.2, 4); _3d.controls.target.set(0, 0.5, 0); _3d.controls.update(); },
        captureScreenshot() {
            if (!_3d.renderer) return;
            _3d.renderer.render(_3d.scene, _3d.camera);
            const url = _3d.renderer.domElement.toDataURL('image/png');
            const a = document.createElement('a'); a.download = `design-${Date.now()}.png`; a.href = url; a.click();
            this.toast('تم التقاط الصورة بنجاح', 'success');
        },

        /* ═══════════ SAVE ═══════════ */
        openSaveModal() {
            <?php if(auth()->guard('client')->guest()): ?>
                window.location.href = '<?php echo e(route("client.login")); ?>';
                return;
            <?php endif; ?>
            this.showSaveModal = true;
        },

        async confirmSave() {
            this.saving = true; this.showSaveModal = false;
            try {
                /* Render a clean frame for screenshot */
                _3d.renderer.render(_3d.scene, _3d.camera);
                /* Scale down to reasonable size for upload (prevents post_max_size errors) */
                const src = _3d.renderer.domElement;
                const tmpCvs = document.createElement('canvas');
                tmpCvs.width = 800;
                tmpCvs.height = Math.round(800 * src.height / Math.max(src.width, 1));
                tmpCvs.getContext('2d').drawImage(src, 0, 0, tmpCvs.width, tmpCvs.height);
                const screenshot = tmpCvs.toDataURL('image/jpeg', 0.85);

                const resp = await fetch('<?php echo e(route("configurator.save", $model)); ?>', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json', 'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>' },
                    body: JSON.stringify({
                        name: this.designName || 'تصميمي',
                        configuration: this.getDesignJSON(),
                        preview_image: screenshot,
                        is_public: this.makePublic
                    })
                });

                if (resp.status === 419) {
                    this.toast('انتهت الجلسة، يرجى تحديث الصفحة', 'error');
                    this.saving = false;
                    return;
                }
                if (!resp.ok) {
                    let errMsg = `خطأ ${resp.status}`;
                    try { const errData = await resp.json(); errMsg = errData.message || errMsg; } catch (_) {}
                    console.error('Save error:', resp.status);
                    this.toast(errMsg, 'error');
                    this.saving = false;
                    return;
                }

                const data = await resp.json();
                if (data.success) { this.toast('تم حفظ التصميم بنجاح', 'success'); this.designName = ''; this.makePublic = false; }
                else this.toast(data.message || 'حدث خطأ أثناء الحفظ', 'error');
            } catch (e) { console.error('Save exception:', e); this.toast('خطأ في الاتصال بالخادم', 'error'); }
            this.saving = false;
        },

        /* ═══════════ DESIGN JSON ═══════════ */
        getDesignJSON() {
            const partOverrides = [];
            Object.entries(_3d.parts).forEach(([key, p]) => {
                const mat = Array.isArray(p.mesh.material) ? p.mesh.material[0] : p.mesh.material;
                const curColor = '#' + mat.color.getHexString();
                if (curColor !== p.origColor || mat.roughness !== p.origRoughness || mat.metalness !== p.origMetalness) {
                    partOverrides.push({ part_key: key, base_color: curColor, material_params: { roughness: mat.roughness, metalness: mat.metalness } });
                }
            });
            const decalLayers = _3d.decals.map(d => ({
                id: d.id, type: d.type, data: d.data, partKey: d.partKey || null,
                transform: {
                    position: d.mesh.position.toArray(),
                    rotation: d.mesh.rotation.toArray().slice(0, 3),
                    scale: d.mesh.scale.toArray(),
                }
            }));
            return {
                version: '1.0',
                background: { color: this.bgColor },
                part_overrides: partOverrides,
                decal_layers: decalLayers,
                camera: { position: _3d.camera?.position.toArray(), target: _3d.controls?.target.toArray() }
            };
        },

        async loadPreset(id) {
            try {
                const resp = await fetch(`/configurator/design/${id}`);
                const data = await resp.json();
                if (!data.success || !data.design) return;
                const cfg = data.design.configuration;
                if (cfg.background?.color) this.setBgColor(cfg.background.color);
                if (cfg.backgroundColor) this.setBgColor(cfg.backgroundColor);
                if (cfg.part_overrides) {
                    cfg.part_overrides.forEach(o => {
                        const p = _3d.parts[o.part_key]; if (!p) return;
                        if (o.base_color) this._applyToMat(p.mesh, m => m.color.set(o.base_color));
                        if (o.material_params) this._applyToMat(p.mesh, m => { m.roughness = o.material_params.roughness ?? m.roughness; m.metalness = o.material_params.metalness ?? m.metalness; });
                    });
                }
                /* Legacy support */
                if (cfg.modelColor && !cfg.part_overrides) {
                    _3d.model?.traverse(c => { if (c.isMesh) this._applyToMat(c, m => m.color.set(cfg.modelColor)); });
                }
                this.toast('تم تحميل التصميم بنجاح', 'success');
            } catch (e) { console.error(e); this.toast('حدث خطأ أثناء التحميل', 'error'); }
        },

        /* ═══════════ UNDO / REDO ═══════════ */
        _pushUndo(action) {
            this.undoStack.push(action);
            if (this.undoStack.length > 30) this.undoStack.shift(); /* Limit stack */
            this.redoStack = []; /* Clear redo on new action */
        },

        undo() {
            if (this.undoStack.length === 0) return;
            const action = this.undoStack.pop();
            this.redoStack.push(action);
            this._applyUndoRedoAction(action, true);
        },

        redo() {
            if (this.redoStack.length === 0) return;
            const action = this.redoStack.pop();
            this.undoStack.push(action);
            this._applyUndoRedoAction(action, false);
        },

        _applyUndoRedoAction(action, isUndo) {
            if (action.type === 'color') {
                const p = _3d.parts[action.key];
                if (p) {
                    const color = isUndo ? action.prevColor : action.newColor;
                    this._applyToMat(p.mesh, m => m.color.set(color));
                    if (_3d.selectedMesh === p.mesh) {
                        this.partColor = color;
                        this.shades = CU.generateShades(color);
                        this.complementary = CU.getComplementary(color);
                    }
                }
            } else if (action.type === 'colorAll') {
                if (isUndo) {
                    action.prevState.forEach(s => {
                        const p = _3d.parts[s.key];
                        if (p) this._applyToMat(p.mesh, m => m.color.set(s.prevColor));
                    });
                } else {
                    if (_3d.model) _3d.model.traverse(c => { if (c.isMesh) this._applyToMat(c, m => m.color.set(action.newColor)); });
                }
                this.partColor = isUndo ? (action.prevState[0]?.prevColor || '#ffffff') : action.newColor;
                this.shades = CU.generateShades(this.partColor);
                this.complementary = CU.getComplementary(this.partColor);
            } else if (action.type === 'preset') {
                const p = _3d.parts[action.key];
                if (p) {
                    if (isUndo) {
                        this._applyToMat(p.mesh, m => { m.roughness = action.prevR; m.metalness = action.prevM; m.needsUpdate = true; });
                    } else {
                        this._applyToMat(p.mesh, m => { m.roughness = action.preset.roughness; m.metalness = action.preset.metalness; m.needsUpdate = true; });
                    }
                }
            } else if (action.type === 'presetAll') {
                if (isUndo) {
                    action.prevState.forEach(s => {
                        const p = _3d.parts[s.key];
                        if (p) this._applyToMat(p.mesh, m => { m.roughness = s.prevR; m.metalness = s.prevM; m.needsUpdate = true; });
                    });
                } else if (_3d.model) {
                    _3d.model.traverse(c => {
                        if (c.isMesh) this._applyToMat(c, m => { m.roughness = action.preset.roughness; m.metalness = action.preset.metalness; m.needsUpdate = true; });
                    });
                }
            }
            this.toast(isUndo ? 'تم التراجع' : 'تم الإعادة', 'success');
        },

        /* ═══════════ HELPERS ═══════════ */
        setTool(id) { this.activeTool = id; if (!this.panelOpen) this.panelOpen = true; },
        _applyToMat(mesh, fn) {
            if (Array.isArray(mesh.material)) mesh.material.forEach(fn);
            else fn(mesh.material);
        },
        toast(message, type = 'success') {
            const id = Date.now();
            this.toasts.push({ id, message, type });
            setTimeout(() => { this.toasts = this.toasts.filter(t => t.id !== id); }, 3000);
        }
    };
};
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\dante\Herd\nassaj\resources\views/configurator/show.blade.php ENDPATH**/ ?>