<div x-data="compareDrawer(<?php echo \Illuminate\Support\Js::from($items->toArray())->toHtml() ?>)" x-on:compare-open.window="open = true"
    x-on:compare-add-instant.window="addItemInstant($event.detail)" @keydown.escape.window="if(open) open = false">
    
    <div x-show="open" x-cloak class="fixed inset-0 z-[9999]">
        
        <div x-show="open" x-transition:enter="transition ease-out duration-100" x-transition:enter-start="opacity-0"
            x-transition:enter-end="opacity-100" x-transition:leave="transition ease-in duration-75"
            x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0" @click="open = false"
            class="absolute inset-0 bg-black/60 backdrop-blur-sm"></div>

        
        <div x-show="open" x-transition:enter="transition ease-out duration-100"
            x-transition:enter-start="translate-x-full" x-transition:enter-end="translate-x-0"
            x-transition:leave="transition ease-in duration-75" x-transition:leave-start="translate-x-0"
            x-transition:leave-end="translate-x-full"
            class="absolute left-0 top-0 h-full w-full max-w-md bg-[#0a0a0a] border-r border-white/10 flex flex-col shadow-2xl">
            
            <div class="p-6 border-b border-white/10">
                <div class="flex items-center justify-between">
                    <h2 class="cairo text-2xl font-bold text-white flex items-center gap-2">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z" />
                        </svg>
                        المقارنة (<span x-text="localItems.length"></span>/4)
                    </h2>
                    <button @click="open = false" class="p-2 hover:bg-white/5 rounded-full transition-colors">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                    </button>
                </div>
            </div>

            
            <div class="flex-1 overflow-y-auto p-6">
                <template x-if="localItems.length === 0">
                    <div class="text-center py-12 text-gray-400">
                        <svg class="w-24 h-24 mx-auto mb-4 opacity-50" fill="none" stroke="currentColor"
                            viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z" />
                        </svg>
                        <p class="text-lg">قائمة المقارنة فارغة</p>
                        <p class="text-sm mt-2">أضف منتجات للمقارنة بينها</p>
                    </div>
                </template>

                <template x-if="localItems.length > 0">
                    <div class="space-y-4">
                        <template x-for="(item, index) in localItems" :key="item.id">
                            <div class="flex gap-4 bg-white/5 rounded-xl p-4 border border-white/10">
                                
                                <div class="w-20 h-20 flex-shrink-0 rounded-lg overflow-hidden bg-white/10">
                                    <template x-if="item.image">
                                        <img :src="item.image" :alt="item.name"
                                            class="w-full h-full object-cover">
                                    </template>
                                    <template x-if="!item.image">
                                        <div class="w-full h-full flex items-center justify-center text-gray-500">
                                            <svg class="w-8 h-8" fill="none" stroke="currentColor"
                                                viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                            </svg>
                                        </div>
                                    </template>
                                </div>

                                
                                <div class="flex-1 min-w-0">
                                    <span class="font-bold text-white line-clamp-2" x-text="item.name"></span>
                                    <p class="text-[#D4A356] font-bold mt-2" x-text="formatPrice(item.price)"></p>

                                    <div class="flex items-center gap-2 mt-3">
                                        <button @click="addToCart(item)"
                                            class="flex-1 bg-gradient-to-r from-[#D4A356] to-[#F5D799] text-black py-2 rounded-lg font-bold text-sm hover:shadow-lg transition-all">
                                            أضف للسلة
                                        </button>
                                        <button @click="removeItem(index)"
                                            class="p-2 text-red-400 hover:bg-red-500/20 rounded-lg transition-colors">
                                            <svg class="w-5 h-5" fill="none" stroke="currentColor"
                                                viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M6 18L18 6M6 6l12 12" />
                                            </svg>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </template>

                        
                        <button @click="clearAll()"
                            class="w-full mt-4 text-red-400 hover:text-red-300 text-sm transition-colors">
                            تفريغ المقارنة
                        </button>
                    </div>
                </template>
            </div>

            
            <template x-if="localItems.length >= 2">
                <div class="p-6 border-t border-white/10">
                    <button @click="open = false"
                        class="w-full bg-gradient-to-r from-[#D4A356] to-[#F5D799] text-black py-4 rounded-full font-bold text-lg text-center hover:shadow-2xl transition-all hover:scale-[1.02]">
                        مقارنة المنتجات (<span x-text="localItems.length"></span>)
                    </button>
                </div>
            </template>

            <template x-if="localItems.length === 1">
                <div class="p-6 border-t border-white/10">
                    <p class="text-center text-gray-400 text-sm">أضف منتج آخر على الأقل للمقارنة</p>
                </div>
            </template>
        </div>
    </div>
</div>

<script>
    function compareDrawer(initialItems = []) {
        return {
            open: false,
            localItems: initialItems,
            maxItems: 4,

            formatPrice(val) {
                return new Intl.NumberFormat('en-US').format(val) + ' د.ع';
            },

            addItemInstant(detail) {
                // Check max limit
                if (this.localItems.length >= this.maxItems) {
                    return;
                }

                // Check if item already exists (use product_id for server items, id for client items)
                const existingIndex = this.localItems.findIndex(item => (item.product_id || item.id) === detail.id);

                if (existingIndex < 0) {
                    // Add new item
                    this.localItems.push({
                        id: detail.id,
                        product_id: detail.id,
                        name: detail.name,
                        price: detail.price,
                        image: detail.image || null
                    });
                }

                // Open drawer immediately after adding
                this.open = true;

                // Sync with server in background
                Livewire.dispatch('compare:toggle', {
                    productId: detail.id
                });
            },

            removeItem(index) {
                const item = this.localItems[index];
                this.localItems.splice(index, 1);
                Livewire.dispatch('compare:toggle', {
                    productId: item.product_id || item.id
                });
            },

            addToCart(item) {
                window.dispatchEvent(new CustomEvent('cart-add-instant', {
                    detail: {
                        id: item.product_id || item.id,
                        name: item.name,
                        price: item.price,
                        image: item.image
                    }
                }));
            },

            clearAll() {
                this.localItems = [];
                Livewire.dispatch('compare:clear');
            }
        };
    }
</script>
<?php /**PATH C:\Users\dante\Herd\nassaj\resources\views/livewire/store/compare-manager.blade.php ENDPATH**/ ?>