<?php $__env->startSection('title', 'نساج - الرئيسية'); ?>
<?php $__env->startSection('content'); ?>
    
    <section class="relative overflow-hidden bg-gray-100 dark:bg-[#0a0a0a]">
        <div class="site-container py-6 md:py-10">
            
            <div class="grid grid-cols-1 md:grid-cols-12 gap-4 md:gap-5 auto-rows-fr">

                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($categories->count() > 0): ?>
                    
                    
                    <?php $mainCat = $categories->first(); ?>
                    <?php
                        $mainProduct = $mainCat
                            ->products()
                            ->active()
                            ->whereHas(
                                'media',
                                fn($q) => $q->where('collection_name', \App\Models\Product::MEDIA_COLLECTION_THUMBNAIL),
                            )
                            ->first();
                        $mainImage = $mainProduct?->thumbnail_url;
                    ?>

                    <div
                        class="md:col-span-6 md:row-span-2 group relative rounded-3xl overflow-hidden bg-[#2a2a2a] min-h-[400px] md:min-h-[600px]">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($mainImage): ?>
                            <img src="<?php echo e($mainImage); ?>" alt="<?php echo e($mainCat->name); ?>"
                                class="absolute inset-0 w-full h-full object-cover transition-transform duration-700 group-hover:scale-105"
                                loading="eager">
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        <div class="absolute inset-0 bg-gradient-to-t from-black/80 via-black/30 to-black/10"></div>

                        
                        <div class="absolute bottom-8 right-8 z-10 max-w-md">
                            <h2 class="cairo text-white text-3xl md:text-5xl font-black mb-3 leading-tight">
                                <?php echo e($mainCat->name); ?>

                            </h2>
                            <p class="text-white/80 text-base md:text-lg mb-4 leading-relaxed">
                                <?php echo e($mainCat->description ?? 'اكتشف مجموعتنا المميزة'); ?>

                            </p>
                            <a href="<?php echo e(route('category.show', $mainCat->slug)); ?>"
                                class="inline-flex items-center gap-2 bg-white text-black px-6 py-3 rounded-full font-bold text-sm hover:bg-nassaj-gold hover:text-white transition-all duration-300 group/btn">
                                <span>تسوق الآن</span>
                                <svg class="w-4 h-4 transition-transform group-hover/btn:-translate-x-1" fill="none"
                                    stroke="currentColor" stroke-width="2.5" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5L8.25 12l7.5-7.5" />
                                </svg>
                            </a>
                        </div>

                        
                        <div class="absolute top-6 right-6 z-10">
                            <span
                                class="bg-nassaj-gold/90 backdrop-blur-sm text-black px-4 py-2 rounded-full text-xs font-bold">
                                منتجاتنا المميزة
                            </span>
                        </div>
                    </div>

                    
                    
                    <?php if($categories->count() > 1): ?>
                        <?php $cat2 = $categories->skip(1)->first(); ?>
                        <?php
                            $cat2Product = $cat2
                                ->products()
                                ->active()
                                ->whereHas(
                                    'media',
                                    fn($q) => $q->where(
                                        'collection_name',
                                        \App\Models\Product::MEDIA_COLLECTION_THUMBNAIL,
                                    ),
                                )
                                ->first();
                            $cat2Image = $cat2Product?->thumbnail_url;
                        ?>

                        <div
                            class="md:col-span-3 group relative rounded-3xl overflow-hidden bg-gradient-to-br from-pink-400 to-red-500 min-h-[280px] md:min-h-0">
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($cat2Image): ?>
                                <img src="<?php echo e($cat2Image); ?>" alt="<?php echo e($cat2->name); ?>"
                                    class="absolute inset-0 w-full h-full object-cover transition-transform duration-700 group-hover:scale-105"
                                    loading="eager">
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            <div class="absolute inset-0 bg-gradient-to-t from-black/60 via-black/20 to-transparent"></div>

                            <div class="absolute bottom-6 right-6 z-10">
                                <h3 class="cairo text-white text-xl md:text-2xl font-black mb-2"><?php echo e($cat2->name); ?></h3>
                                <a href="<?php echo e(route('category.show', $cat2->slug)); ?>"
                                    class="inline-flex items-center gap-1.5 text-white text-sm font-bold hover:text-nassaj-gold transition-colors group/link">
                                    <span class="border-b border-white/60 group-hover/link:border-nassaj-gold pb-0.5">
                                        تسوق الآن
                                    </span>
                                    <svg class="w-4 h-4 transition-transform group-hover/link:-translate-x-1" fill="none"
                                        stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round"
                                            d="M15.75 19.5L8.25 12l7.5-7.5" />
                                    </svg>
                                </a>
                            </div>
                        </div>
                    <?php endif; ?>

                    
                    <?php if($categories->count() > 2): ?>
                        <?php $cat3 = $categories->skip(2)->first(); ?>
                        <?php
                            $cat3Product = $cat3
                                ->products()
                                ->active()
                                ->whereHas(
                                    'media',
                                    fn($q) => $q->where(
                                        'collection_name',
                                        \App\Models\Product::MEDIA_COLLECTION_THUMBNAIL,
                                    ),
                                )
                                ->first();
                            $cat3Image = $cat3Product?->thumbnail_url;
                        ?>

                        <div
                            class="md:col-span-3 group relative rounded-3xl overflow-hidden bg-gradient-to-br from-gray-300 to-gray-400 min-h-[280px] md:min-h-0">
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($cat3Image): ?>
                                <img src="<?php echo e($cat3Image); ?>" alt="<?php echo e($cat3->name); ?>"
                                    class="absolute inset-0 w-full h-full object-cover transition-transform duration-700 group-hover:scale-105"
                                    loading="eager">
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            <div class="absolute inset-0 bg-gradient-to-t from-black/60 via-black/20 to-transparent"></div>

                            <div class="absolute bottom-6 right-6 z-10">
                                <h3 class="cairo text-white text-xl md:text-2xl font-black mb-2"><?php echo e($cat3->name); ?></h3>
                                <a href="<?php echo e(route('category.show', $cat3->slug)); ?>"
                                    class="inline-flex items-center gap-1.5 text-white text-sm font-bold hover:text-nassaj-gold transition-colors group/link">
                                    <span class="border-b border-white/60 group-hover/link:border-nassaj-gold pb-0.5">
                                        انقر هنا
                                    </span>
                                    <svg class="w-4 h-4 transition-transform group-hover/link:-translate-x-1" fill="none"
                                        stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round"
                                            d="M15.75 19.5L8.25 12l7.5-7.5" />
                                    </svg>
                                </a>
                            </div>
                        </div>
                    <?php endif; ?>

                    
                    <?php if($categories->count() > 3): ?>
                        <?php $cat4 = $categories->skip(3)->first(); ?>
                        <?php
                            $cat4Product = $cat4
                                ->products()
                                ->active()
                                ->whereHas(
                                    'media',
                                    fn($q) => $q->where(
                                        'collection_name',
                                        \App\Models\Product::MEDIA_COLLECTION_THUMBNAIL,
                                    ),
                                )
                                ->first();
                            $cat4Image = $cat4Product?->thumbnail_url;
                        ?>

                        <div
                            class="md:col-span-6 group relative rounded-3xl overflow-hidden bg-gradient-to-br from-gray-700 to-gray-900 min-h-[280px] md:min-h-0">
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($cat4Image): ?>
                                <img src="<?php echo e($cat4Image); ?>" alt="<?php echo e($cat4->name); ?>"
                                    class="absolute inset-0 w-full h-full object-cover transition-transform duration-700 group-hover:scale-105"
                                    loading="eager">
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            <div class="absolute inset-0 bg-gradient-to-t from-black/70 via-black/20 to-transparent"></div>

                            <div class="absolute bottom-6 right-6 z-10">
                                <h3 class="cairo text-white text-xl md:text-2xl font-black mb-2"><?php echo e($cat4->name); ?></h3>
                                <a href="<?php echo e(route('category.show', $cat4->slug)); ?>"
                                    class="inline-flex items-center gap-1.5 text-white text-sm font-bold hover:text-nassaj-gold transition-colors group/link">
                                    <span class="border-b border-white/60 group-hover/link:border-nassaj-gold pb-0.5">
                                        تسوق الآن
                                    </span>
                                    <svg class="w-4 h-4 transition-transform group-hover/link:-translate-x-1" fill="none"
                                        stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round"
                                            d="M15.75 19.5L8.25 12l7.5-7.5" />
                                    </svg>
                                </a>
                            </div>
                        </div>
                    <?php else: ?>
                        
                        
                        <div class="md:col-span-6 group relative rounded-3xl overflow-hidden min-h-[280px] md:min-h-0">

                            
                            <div class="absolute inset-0 bg-gradient-to-br from-[#442247] via-[#2d1635] to-[#140616]"></div>

                            
                            <div
                                class="absolute inset-0 opacity-30
                                bg-[radial-gradient(circle_at_80%_20%,rgba(204,191,121,0.35),transparent_60%)]">
                            </div>

                            
                            <div
                                class="absolute inset-0 opacity-5
                                bg-[radial-gradient(circle_at_50%_50%,rgba(255,255,255,0.08),transparent_70%)]
                                ">
                            </div>

                            
                            <div class="absolute -left-10 bottom-0 opacity-5 select-none pointer-events-none">
                                <span class="text-[140px] font-black text-white tracking-wider">
                                    NASSAJ
                                </span>
                            </div>

                            
                            <div class="absolute bottom-8 right-8 z-10 max-w-sm">
                                <h3 class="cairo text-white text-2xl md:text-3xl font-black mb-3 leading-tight">
                                    تصفح الكل
                                </h3>

                                <p class="text-white/70 text-sm md:text-base mb-5 leading-relaxed">
                                    اكتشف جميع منتجاتنا المميزة بأحدث التصاميم والخامات الفاخرة.
                                </p>

                                <a href="<?php echo e(route('shop')); ?>"
                                    class="inline-flex items-center gap-2 bg-nassaj-gold text-black px-6 py-3 rounded-full font-bold text-sm
                  hover:bg-nassaj-gold-light transition-all duration-300 group/btn">

                                    <span>اذهب للمتجر</span>

                                    <svg class="w-4 h-4 transition-transform group-hover/btn:-translate-x-1" fill="none"
                                        stroke="currentColor" stroke-width="2.5" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round"
                                            d="M15.75 19.5L8.25 12l7.5-7.5" />
                                    </svg>
                                </a>
                            </div>

                            
                            <div class="absolute inset-0 rounded-3xl border border-white/10"></div>

                        </div>

                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                <?php else: ?>
                    
                    <div
                        class="md:col-span-12 group relative rounded-3xl overflow-hidden bg-gradient-to-br from-nassaj-primary/40 to-black/60 min-h-[400px]">
                        <div class="absolute bottom-8 right-8 z-10">
                            <h2 class="cairo text-white text-3xl md:text-4xl font-black mb-3">منتجاتنا</h2>
                            <a href="<?php echo e(route('shop')); ?>"
                                class="inline-flex items-center gap-2 bg-nassaj-gold text-black px-6 py-3 rounded-full font-bold text-sm hover:bg-nassaj-gold-light transition-colors">
                                <span>تسوق الآن</span>
                            </a>
                        </div>
                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>
        </div>
    </section>

    
    <section class="py-6 bg-gray-50 dark:bg-[#111111]">
        <div class="site-container">
            <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                
                <div
                    class="flex items-center gap-3 p-4 rounded-2xl bg-white dark:bg-white/5 border border-gray-100 dark:border-white/5">
                    <div
                        class="w-11 h-11 rounded-xl bg-nassaj-gold/10 dark:bg-nassaj-gold/15 flex items-center justify-center shrink-0">
                        <svg class="w-5 h-5 text-nassaj-gold" fill="none" stroke="currentColor" stroke-width="1.5"
                            viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M8.25 18.75a1.5 1.5 0 01-3 0m3 0a1.5 1.5 0 00-3 0m3 0h6m-9 0H3.375a1.125 1.125 0 01-1.125-1.125V14.25m17.25 4.5a1.5 1.5 0 01-3 0m3 0a1.5 1.5 0 00-3 0m3 0h1.125c.621 0 1.129-.504 1.09-1.124a17.902 17.902 0 00-3.213-9.193 2.056 2.056 0 00-1.58-.86H14.25M16.5 18.75h-2.25m0-11.177v-.958c0-.568-.422-1.048-.987-1.106a48.554 48.554 0 00-10.026 0 1.106 1.106 0 00-.987 1.106v7.635m12-6.677v6.677m0 4.5v-4.5m0 0h-12" />
                        </svg>
                    </div>
                    <div>
                        <p class="text-sm font-black text-gray-900 dark:text-white">شحن مجاني</p>
                        <p class="text-xs text-gray-500 dark:text-gray-400">فوق 100,000 د.ع</p>
                    </div>
                </div>

                
                <div
                    class="flex items-center gap-3 p-4 rounded-2xl bg-white dark:bg-white/5 border border-gray-100 dark:border-white/5">
                    <div
                        class="w-11 h-11 rounded-xl bg-nassaj-gold/10 dark:bg-nassaj-gold/15 flex items-center justify-center shrink-0">
                        <svg class="w-5 h-5 text-nassaj-gold" fill="none" stroke="currentColor" stroke-width="1.5"
                            viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M9 12.75L11.25 15 15 9.75m-3-7.036A11.959 11.959 0 013.598 6 11.99 11.99 0 003 9.749c0 5.592 3.824 10.29 9 11.623 5.176-1.332 9-6.03 9-11.622 0-1.31-.21-2.571-.598-3.751h-.152c-3.196 0-6.1-1.248-8.25-3.285z" />
                        </svg>
                    </div>
                    <div>
                        <p class="text-sm font-black text-gray-900 dark:text-white">ضمان الجودة</p>
                        <p class="text-xs text-gray-500 dark:text-gray-400">منتجات أصلية 100%</p>
                    </div>
                </div>

                
                <div
                    class="flex items-center gap-3 p-4 rounded-2xl bg-white dark:bg-white/5 border border-gray-100 dark:border-white/5">
                    <div
                        class="w-11 h-11 rounded-xl bg-nassaj-gold/10 dark:bg-nassaj-gold/15 flex items-center justify-center shrink-0">
                        <svg class="w-5 h-5 text-nassaj-gold" fill="none" stroke="currentColor" stroke-width="1.5"
                            viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M16.023 9.348h4.992v-.001M2.985 19.644v-4.992m0 0h4.992m-4.993 0l3.181 3.183a8.25 8.25 0 0013.803-3.7M4.031 9.865a8.25 8.25 0 0113.803-3.7l3.181 3.182" />
                        </svg>
                    </div>
                    <div>
                        <p class="text-sm font-black text-gray-900 dark:text-white">إرجاع سهل</p>
                        <p class="text-xs text-gray-500 dark:text-gray-400">خلال 14 يوم</p>
                    </div>
                </div>

                
                <div
                    class="flex items-center gap-3 p-4 rounded-2xl bg-white dark:bg-white/5 border border-gray-100 dark:border-white/5">
                    <div
                        class="w-11 h-11 rounded-xl bg-nassaj-gold/10 dark:bg-nassaj-gold/15 flex items-center justify-center shrink-0">
                        <svg class="w-5 h-5 text-nassaj-gold" fill="none" stroke="currentColor" stroke-width="1.5"
                            viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M20.25 8.511c.884.284 1.5 1.128 1.5 2.097v4.286c0 1.136-.847 2.1-1.98 2.193-.34.027-.68.052-1.02.072v3.091l-3-3c-1.354 0-2.694-.055-4.02-.163a2.115 2.115 0 01-.825-.242m9.345-8.334a2.126 2.126 0 00-.476-.095 48.64 48.64 0 00-8.048 0c-1.131.094-1.976 1.057-1.976 2.192v4.286c0 .837.46 1.58 1.155 1.951m9.345-8.334V6.637c0-1.621-1.152-3.026-2.76-3.235A48.455 48.455 0 0011.25 3c-2.115 0-4.198.137-6.24.402-1.608.209-2.76 1.614-2.76 3.235v6.226c0 1.621 1.152 3.026 2.76 3.235.577.075 1.157.14 1.74.194V21l4.155-4.155" />
                        </svg>
                    </div>
                    <div>
                        <p class="text-sm font-black text-gray-900 dark:text-white">دعم فني</p>
                        <p class="text-xs text-gray-500 dark:text-gray-400">على مدار الساعة</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    
    <section id="categories" class="py-16 bg-gray-50 dark:bg-[#0a0a0a]">
        <div class="site-container">
            
            <div class="text-center mb-12">
                <span
                    class="inline-block px-4 py-2 bg-nassaj-gold/10 text-nassaj-gold rounded-full text-sm font-bold mb-4">
                    التصنيفات
                </span>
                <h2 class="cairo text-3xl md:text-4xl font-black text-gray-900 dark:text-white mb-4">
                    تسوق حسب الفئة
                </h2>
                <p class="text-gray-600 dark:text-gray-400 text-lg max-w-2xl mx-auto">
                    اكتشف مجموعتنا الواسعة من المنتجات المصنفة خصيصاً لراحتك
                </p>
            </div>

            
            <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-4 md:gap-6">
                
                <a href="<?php echo e(route('shop')); ?>"
                    class="group relative overflow-hidden rounded-2xl transition-all duration-300 hover:shadow-xl hover:-translate-y-1">
                    <div
                        class="relative aspect-square bg-gradient-to-br from-nassaj-gold via-yellow-500 to-orange-400 p-6 flex flex-col items-center justify-center">
                        
                        <div class="absolute inset-0 opacity-10">
                            <div class="absolute top-0 right-0 w-24 h-24 bg-white rounded-full -mr-12 -mt-12"></div>
                            <div class="absolute bottom-0 left-0 w-20 h-20 bg-white rounded-full -ml-10 -mb-10"></div>
                        </div>

                        
                        <div
                            class="relative z-10 w-14 h-14 bg-white/20 backdrop-blur-sm rounded-xl flex items-center justify-center mb-4 group-hover:scale-110 transition-transform duration-300">
                            <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V6zM4 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2zM14 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z" />
                            </svg>
                        </div>

                        
                        <h3 class="relative z-10 cairo text-white text-lg font-black mb-1">جميع المنتجات</h3>
                        <p class="relative z-10 text-white/90 text-sm">استكشف الكل</p>
                    </div>
                </a>

                
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $gradients = [
                            'from-pink-500 to-pink-600',
                            'from-purple-500 to-purple-600',
                            'from-blue-500 to-blue-600',
                            'from-green-500 to-green-600',
                            'from-indigo-500 to-indigo-600',
                            'from-red-500 to-red-600',
                            'from-teal-500 to-teal-600',
                            'from-orange-500 to-orange-600',
                        ];
                        $gradient = $gradients[$index % count($gradients)];
                    ?>

                    <a href="<?php echo e(route('category.show', $category->slug)); ?>" data-category-id="<?php echo e($category->id); ?>"
                        data-category-name="<?php echo e($category->name); ?>"
                        class="group relative overflow-hidden rounded-2xl transition-all duration-300 hover:shadow-xl hover:-translate-y-1">
                        <div
                            class="relative aspect-square bg-gradient-to-br <?php echo e($gradient); ?> p-6 flex flex-col items-center justify-center">
                            
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($category->image ?? false): ?>
                                <img src="<?php echo e($category->image); ?>" alt="<?php echo e($category->name); ?>"
                                    class="absolute inset-0 w-full h-full object-cover opacity-20 group-hover:opacity-30 transition-opacity duration-300">
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                            
                            <div class="absolute inset-0 bg-gradient-to-t from-black/30 to-transparent"></div>

                            
                            <div
                                class="relative z-10 w-14 h-14 bg-white/20 backdrop-blur-sm rounded-xl flex items-center justify-center mb-3 group-hover:scale-110 group-hover:bg-white/30 transition-all duration-300">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($category->icon ?? false): ?>
                                    <img src="<?php echo e($category->icon); ?>" alt="<?php echo e($category->name); ?>" class="w-7 h-7">
                                <?php else: ?>
                                    <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z" />
                                    </svg>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>

                            
                            <h3 class="relative z-10 cairo text-white text-base font-bold text-center mb-1 leading-tight">
                                <?php echo e($category->name); ?>

                            </h3>
                            <p class="relative z-10 text-white/90 text-xs font-medium">
                                <?php echo e($category->products_count ?? 0); ?> منتج
                            </p>
                        </div>
                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>
        </div>
    </section>
    
    <section class="py-20 bg-gray-50 dark:bg-[#0a0a0a]">
        <div class="site-container">
            <div class="flex items-center justify-between mb-8">
                <div>
                    <h2 class="cairo text-3xl md:text-4xl font-black text-gray-900 dark:text-white mb-2">
                        <span id="productsTitle">تشكيلتنا</span> <span class="text-nassaj-gold">المميزة</span>
                    </h2>
                    <p class="text-gray-500 dark:text-gray-400">
                        <span id="categoryLabel">أفضل المنتجات المختارة بعناية</span>
                    </p>
                </div>
                <div class="flex gap-3">
                    <button id="resetFilter"
                        class="text-nassaj-gold bg-nassaj-gold/10 px-6 py-3 rounded-full font-bold text-sm hover:bg-nassaj-gold/20 transition-all duration-300 items-center gap-2 hidden">
                        عرض الكل
                    </button>
                    <a href="<?php echo e(route('shop')); ?>"
                        class="hidden md:flex items-center gap-2 text-nassaj-gold hover:text-nassaj-gold-light transition-colors font-semibold">
                        <span>عرض الكل</span>
                        <svg class="h-5 w-5" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                            stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                        </svg>
                    </a>
                </div>
            </div>

            <div id="productsLoader" class="hidden text-center py-12">
                <div
                    class="inline-block w-12 h-12 border-4 border-[#D4A356] border-t-transparent rounded-full animate-spin">
                </div>
                <p class="text-gray-400 mt-4">جاري تحميل المنتجات...</p>
            </div>

            <div class="relative product-carousel-wrapper">
                
                <div id="latestProducts" class="swiper latest-products-swiper">
                    <div class="swiper-wrapper">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $latestProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="swiper-slide">
                                <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('products.product-card', ['productId' => $product->id]);

$key = 'card-'.e($product->id).'';

$key ??= \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::generateKey('lw-2735829809-0', 'card-'.e($product->id).'');

$__html = app('livewire')->mount($__name, $__params, $key);

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="swiper-slide">
                                <div class="text-center py-12">
                                    <p class="text-gray-400 text-lg">لا توجد منتجات متاحة حالياً</p>
                                </div>
                            </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                </div>

                
                <div class="swiper-pagination latest-pagination flex justify-center items-center gap-2 mt-8"></div>
            </div>
        </div>
    </section>

    
    <section class="py-20 bg-white dark:bg-[#111111]">
        <div class="site-container">
            <div class="flex items-center justify-between mb-8">
                <div>
                    <h2 class="cairo text-3xl md:text-4xl font-black text-gray-900 dark:text-white mb-2">
                        <span class="text-nassaj-gold">الأكثر</span> مبيعاً
                    </h2>
                    <p class="text-gray-500 dark:text-gray-400">المنتجات الأكثر طلباً</p>
                </div>
                <a href="<?php echo e(route('shop')); ?>?sort=bestsellers"
                    class="hidden md:flex items-center gap-2 text-nassaj-gold hover:text-nassaj-gold-light transition-colors font-semibold">
                    <span>عرض الكل</span>
                    <svg class="h-5 w-5" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                    </svg>
                </a>
            </div>

            <div class="relative product-carousel-wrapper">
                
                <div class="swiper best-selling-swiper">
                    <div class="swiper-wrapper">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $bestSellingProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="swiper-slide">
                                <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('products.product-card', ['productId' => $product->id]);

$key = 'best-'.e($product->id).'';

$key ??= \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::generateKey('lw-2735829809-1', 'best-'.e($product->id).'');

$__html = app('livewire')->mount($__name, $__params, $key);

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="swiper-slide">
                                <div class="text-center py-12">
                                    <p class="text-gray-400 text-lg">لا توجد منتجات حالياً</p>
                                </div>
                            </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                </div>

                
                <div class="swiper-pagination best-pagination flex justify-center items-center gap-2 mt-8"></div>
            </div>
        </div>
    </section>

    
    <section class="py-20 bg-gray-50 dark:bg-[#0a0a0a]">
        <div class="site-container">
            <div class="flex items-center justify-between mb-8">
                <div>
                    <h2 class="cairo text-3xl md:text-4xl font-black text-gray-900 dark:text-white mb-2">
                        وصل <span class="text-nassaj-gold">حديثاً</span>
                    </h2>
                    <p class="text-gray-500 dark:text-gray-400">أحدث إضافاتنا</p>
                </div>
                <a href="<?php echo e(route('shop')); ?>?sort=newest"
                    class="hidden md:flex items-center gap-2 text-nassaj-gold hover:text-nassaj-gold-light transition-colors font-semibold">
                    <span>عرض الكل</span>
                    <svg class="h-5 w-5" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                    </svg>
                </a>
            </div>

            <div class="relative product-carousel-wrapper">
                
                <div class="swiper featured-products-swiper">
                    <div class="swiper-wrapper">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $featuredProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="swiper-slide">
                                <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('products.product-card', ['productId' => $product->id]);

$key = 'featured-'.e($product->id).'';

$key ??= \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::generateKey('lw-2735829809-2', 'featured-'.e($product->id).'');

$__html = app('livewire')->mount($__name, $__params, $key);

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="swiper-slide">
                                <div class="text-center py-12">
                                    <p class="text-gray-400 text-lg">لا توجد عروض حالياً</p>
                                </div>
                            </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                </div>

                
                <div class="swiper-pagination featured-pagination flex justify-center items-center gap-2 mt-8"></div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
    
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />

    <style>
        /* ============================================
                                                                                                                                   HOME PAGE CAROUSEL STYLES ONLY
                                                                                                                                   Scoped to prevent affecting other components
                                                                                                                                   ============================================ */

        /* Prevent horizontal overflow on mobile */
        @media (max-width: 768px) {
            body {
                overflow-x: hidden;
            }

            .swiper {
                overflow: hidden !important;
            }

            .swiper-wrapper {
                max-width: 100vw !important;
            }
        }

        /* Custom Pagination - Only for home page carousels */
        .latest-pagination,
        .best-pagination,
        .featured-pagination,
        .testimonials-pagination {
            position: relative !important;
            text-align: center;
            display: flex !important;
            justify-content: center;
            align-items: center;
            gap: 12px;
        }

        .latest-pagination .swiper-pagination-bullet,
        .best-pagination .swiper-pagination-bullet,
        .featured-pagination .swiper-pagination-bullet,
        .testimonials-pagination .swiper-pagination-bullet {
            background: transparent !important;
            border: 2px solid rgba(255, 255, 255, 0.3) !important;
            opacity: 1 !important;
            width: 12px !important;
            height: 12px !important;
            border-radius: 50% !important;
            transition: all 0.3s ease !important;
            margin: 0 !important;
            cursor: pointer;
        }

        .latest-pagination .swiper-pagination-bullet:hover,
        .best-pagination .swiper-pagination-bullet:hover,
        .featured-pagination .swiper-pagination-bullet:hover,
        .testimonials-pagination .swiper-pagination-bullet:hover {
            border-color: rgba(255, 255, 255, 0.6) !important;
        }

        .latest-pagination .swiper-pagination-bullet-active,
        .best-pagination .swiper-pagination-bullet-active,
        .featured-pagination .swiper-pagination-bullet-active,
        .testimonials-pagination .swiper-pagination-bullet-active {
            background: #CCBF79 !important;
            border-color: #CCBF79 !important;
        }

        /* Carousel Navigation Buttons - NASSAJ Colors */
        .carousel-nav-btn {
            transition: all 0.3s ease;
            opacity: 1 !important;
            background: linear-gradient(135deg, #442247, #CCBF79) !important;
            border-color: #CCBF79 !important;
            transform: translateY(-50%);
        }

        .carousel-nav-btn svg {
            color: #fff !important;
        }

        .carousel-nav-btn:hover {
            background: linear-gradient(135deg, #CCBF79, #d9ce93) !important;
            border-color: #CCBF79 !important;
            transform: translateY(-50%) scale(1.1);
            box-shadow: 0 10px 30px rgba(204, 191, 121, 0.5);
        }

        .carousel-nav-btn:disabled,
        .carousel-nav-btn.swiper-button-disabled {
            opacity: 0.3 !important;
            cursor: not-allowed !important;
            background: #1a1a1a !important;
            border-color: rgba(255, 255, 255, 0.2) !important;
        }

        .carousel-nav-btn.swiper-button-disabled svg {
            color: #fff !important;
        }

        .carousel-nav-btn.swiper-button-disabled:hover {
            transform: translateY(-50%) scale(1);
            box-shadow: none;
        }

        /* Show buttons only on mobile */
        .carousel-nav-btn {
            display: none !important;
        }

        .carousel-nav-btn-cats {
            display: none !important;
        }

        /* Product Carousel Wrapper - Add padding only on mobile for buttons */
        .product-carousel-wrapper {
            padding-left: 0;
            padding-right: 0;
        }

        @media (max-width: 768px) {
            .product-carousel-wrapper {
                padding-left: 1.5rem;
                padding-right: 1.5rem;
            }
        }

        /* Swiper Slide Styles - Scoped to home page carousels */
        .latest-products-swiper .swiper-slide,
        .best-selling-swiper .swiper-slide,
        .featured-products-swiper .swiper-slide,
        .testimonials-swiper .swiper-slide {
            height: auto;
        }

        .latest-products-swiper .swiper-slide>div,
        .best-selling-swiper .swiper-slide>div,
        .featured-products-swiper .swiper-slide>div,
        .testimonials-swiper .swiper-slide>div {
            height: 100%;
        }

        /* Ensure product cards maintain consistent height in carousel */
        .latest-products-swiper .product-card-v3,
        .best-selling-swiper .product-card-v3,
        .featured-products-swiper .product-card-v3 {
            height: 100%;
            display: flex;
            flex-direction: column;
        }

        .latest-products-swiper .product-card-v3>a,
        .best-selling-swiper .product-card-v3>a,
        .featured-products-swiper .product-card-v3>a {
            flex: 1;
            display: flex;
            flex-direction: column;
        }

        /* Fix for RTL pagination */
        .latest-pagination,
        .best-pagination,
        .featured-pagination,
        .testimonials-pagination,
        .categories-pagination {
            direction: ltr;
        }

        /* Categories Carousel Navigation */
        .carousel-nav-btn-cats {
            transition: all 0.3s ease;
            opacity: 1 !important;
            background: linear-gradient(135deg, #442247, #CCBF79) !important;
            border-color: #CCBF79 !important;
        }

        .carousel-nav-btn-cats svg {
            color: #fff !important;
        }

        .carousel-nav-btn-cats:hover {
            background: linear-gradient(135deg, #CCBF79, #d9ce93) !important;
            transform: translateY(-50%) scale(1.1);
            box-shadow: 0 10px 30px rgba(204, 191, 121, 0.5);
        }

        /* Categories Carousel Wrapper */
        .categories-carousel-wrapper {
            position: relative;
        }

        @media (max-width: 768px) {
            .categories-carousel-wrapper {
                padding-left: 2rem;
                padding-right: 2rem;
            }
        }

        @media (min-width: 769px) {
            .categories-swiper {
                overflow: visible !important;
            }

            .categories-swiper .swiper-wrapper {
                display: grid !important;
                grid-template-columns: repeat(auto-fill, minmax(160px, 1fr));
                gap: 1rem;
            }

            .categories-swiper .swiper-slide {
                width: auto !important;
                height: auto !important;
            }
        }
    </style>

    <style>
        /* Active state styling */
        .category-card.active .absolute.inset-0.border-4 {
            @apply scale-100;
        }

        /* Smooth transitions */
        .category-card {
            @apply transform-gpu;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
    
    <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>

    <script>
        let currentCategory = null;
        let selectedCategoryName = '';

        // Initialize category click listeners when DOM is ready
        document.addEventListener('DOMContentLoaded', function() {
            initializeCategoryListeners();
            initializeResetButton();
        });

        function initializeCategoryListeners() {
            const categoryCards = document.querySelectorAll('.category-card');
            console.log('Initializing category listeners for', categoryCards.length, 'categories');

            categoryCards.forEach(card => {
                card.addEventListener('click', function(event) {
                    event.preventDefault();
                    event.stopPropagation();

                    const categoryId = parseInt(this.getAttribute('data-category-id'));
                    const categoryName = this.getAttribute('data-category-name');
                    console.log('Category clicked:', categoryId, categoryName);

                    filterByCategory(categoryId);
                });
            });
        }

        function initializeResetButton() {
            const resetBtn = document.getElementById('resetFilter');
            if (resetBtn) {
                resetBtn.addEventListener('click', function(event) {
                    event.preventDefault();
                    event.stopPropagation();
                    resetCategoryFilter();
                });
            }
        }

        function filterByCategory(categoryId) {
            console.log('Filtering by category:', categoryId);

            currentCategory = categoryId;

            // Get category name from clicked element
            const categoryCard = document.querySelector(`[data-category-id="${categoryId}"]`);
            selectedCategoryName = categoryCard ? categoryCard.querySelector('h3').textContent : '';

            console.log('Selected category name:', selectedCategoryName);

            // Update UI
            updateCategoryHighlight(categoryId);
            updateProductsTitle(selectedCategoryName);
            showResetButton();

            // Fetch products
            fetchProductsByCategory(categoryId);

            // Scroll to products section
            document.getElementById('latestProducts').scrollIntoView({
                behavior: 'smooth',
                block: 'start'
            });
        }

        function resetCategoryFilter() {
            currentCategory = null;
            selectedCategoryName = '';

            // Update UI
            updateCategoryHighlight(null);
            resetProductsTitle();
            hideResetButton();

            // Reload page to show all products
            window.location.reload();
        }

        function updateCategoryHighlight(categoryId) {
            // Remove active class from all categories
            document.querySelectorAll('.category-card').forEach(card => {
                card.classList.remove('ring-2', 'ring-[#D4A356]', 'bg-[#D4A356]/5');
            });

            // Add active class to selected category
            if (categoryId) {
                const selectedCard = document.querySelector(`[data-category-id="${categoryId}"]`);
                if (selectedCard) {
                    selectedCard.classList.add('ring-2', 'ring-[#D4A356]', 'bg-[#D4A356]/5');
                }
            }
        }

        function updateProductsTitle(categoryName) {
            document.getElementById('categoryLabel').textContent = categoryName;
            document.getElementById('productsTitle').textContent = 'منتجات';
        }

        function resetProductsTitle() {
            document.getElementById('categoryLabel').textContent = 'جديد';
            document.getElementById('productsTitle').textContent = 'أحدث';
        }

        function showResetButton() {
            document.getElementById('resetFilter').classList.remove('hidden');
            document.getElementById('resetFilter').classList.add('flex');
        }

        function hideResetButton() {
            document.getElementById('resetFilter').classList.add('hidden');
            document.getElementById('resetFilter').classList.remove('flex');
        }

        function showLoader() {
            document.getElementById('productsLoader').classList.remove('hidden');
            document.getElementById('latestProducts').style.opacity = '0.3';
        }

        function hideLoader() {
            document.getElementById('productsLoader').classList.add('hidden');
            document.getElementById('latestProducts').style.opacity = '1';
        }

        async function fetchProductsByCategory(categoryId) {
            showLoader();

            try {
                const response = await fetch(`<?php echo e(route('api.store.products')); ?>?category=${categoryId}&per_page=8`);
                const data = await response.json();

                if (data.success && data.products) {
                    renderProducts(data.products);
                } else {
                    showError('حدث خطأ في تحميل المنتجات');
                }
            } catch (error) {
                console.error('Error fetching products:', error);
                showError('حدث خطأ في الاتصال بالخادم');
            } finally {
                hideLoader();
            }
        }

        function renderProducts(products) {
            const container = document.getElementById('latestProducts');
            const swiperWrapper = container.querySelector('.swiper-wrapper');

            if (!swiperWrapper) {
                console.error('Swiper wrapper not found');
                return;
            }

            if (products.length === 0) {
                swiperWrapper.innerHTML = `
                <div class="swiper-slide">
                    <div class="text-center py-12">
                        <svg class="w-20 h-20 mx-auto text-gray-600 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M20 13V6a2 2 0 00-2-2H6a2 2 0 00-2 2v7m16 0v5a2 2 0 01-2 2H6a2 2 0 01-2-2v-5m16 0h-2.586a1 1 0 00-.707.293l-2.414 2.414a1 1 0 01-.707.293h-3.172a1 1 0 01-.707-.293l-2.414-2.414A1 1 0 006.586 13H4" />
                        </svg>
                        <p class="text-gray-400 text-lg">لا توجد منتجات في هذا التصنيف</p>
                    </div>
                </div>
            `;
                return;
            }

            swiperWrapper.innerHTML = products.map((product, index) => `
            <div class="swiper-slide">` + `
            <div class="product-card-v3 group" x-data="{
                addToCart() {
                    window.dispatchEvent(new CustomEvent('cart-add-instant', {
                        detail: {
                            id: ${product.id},
                            name: '${product.name.replace(/'/g, "\\'")}',
                            price: ${product.price},
                            image: '${product.image || ''}'
                        }
                    }));
                },
                addToWishlist() {
                    window.dispatchEvent(new CustomEvent('wishlist-add-instant', {
                        detail: {
                            id: ${product.id},
                            name: '${product.name.replace(/'/g, "\\'")}',
                            price: ${product.price},
                            image: '${product.image || ''}'
                        }
                    }));
                },
                addToCompare() {
                    window.dispatchEvent(new CustomEvent('compare-add-instant', {
                        detail: {
                            id: ${product.id},
                            name: '${product.name.replace(/'/g, "\\'")}',
                            price: ${product.price},
                            image: '${product.image || ''}'
                        }
                    }));
                },
                quickView() {
                    window.dispatchEvent(new CustomEvent('quickview-open', { detail: { productId: ${product.id} } }));
                }
            }">
                <a href="/shop/product/${product.slug}" class="block">
                    <div class="relative overflow-hidden rounded-3xl bg-[#1a1a1a]">
                        ${index < 2 ? '<span class="absolute top-4 right-4 z-10 px-3 py-1.5 rounded-full text-xs font-bold bg-[#D4A356] text-black">جديد</span>' : ''}

                        <div class="aspect-[3/4] overflow-hidden relative bg-[#1a1a1a]">
                            ${product.image
                                ? `<img src="${product.image}" alt="${product.name}" loading="lazy" class="w-full h-full object-cover transition-all duration-500 group-hover:scale-105">`
                                : `<div class="w-full h-full flex items-center justify-center text-gray-600">
                                                                                                                                                            <svg class="w-20 h-20" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                                                                                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                                                                                                                                            </svg>
                                                                                                                                                        </div>`
                            }
                        </div>

                        <div class="absolute bottom-4 left-1/2 -translate-x-1/2 flex items-center gap-3 opacity-0 translate-y-4 group-hover:opacity-100 group-hover:translate-y-0 transition-all duration-300">
                            <div class="relative group/btn">
                                <span class="absolute -top-10 left-1/2 -translate-x-1/2 bg-[#1a1a1a] border border-white/20 text-white text-xs px-3 py-1.5 rounded-lg whitespace-nowrap opacity-0 group-hover/btn:opacity-100 transition-opacity pointer-events-none z-10">مقارنة</span>
                                <button @click.prevent="addToCompare()" class="w-11 h-11 rounded-full border-2 border-white/30 bg-black/50 backdrop-blur text-white flex items-center justify-center transition-all hover:bg-[#D4A356] hover:border-[#D4A356] hover:text-black hover:scale-110">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M3 13.125C3 12.504 3.504 12 4.125 12h2.25c.621 0 1.125.504 1.125 1.125v6.75C7.5 20.496 6.996 21 6.375 21h-2.25A1.125 1.125 0 013 19.875v-6.75zM9.75 8.625c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125v11.25c0 .621-.504 1.125-1.125 1.125h-2.25a1.125 1.125 0 01-1.125-1.125V8.625zM16.5 4.125c0-.621.504-1.125 1.125-1.125h2.25C20.496 3 21 3.504 21 4.125v15.75c0 .621-.504 1.125-1.125 1.125h-2.25a1.125 1.125 0 01-1.125-1.125V4.125z" /></svg>
                                </button>
                            </div>
                            <div class="relative group/btn">
                                <span class="absolute -top-10 left-1/2 -translate-x-1/2 bg-[#1a1a1a] border border-white/20 text-white text-xs px-3 py-1.5 rounded-lg whitespace-nowrap opacity-0 group-hover/btn:opacity-100 transition-opacity pointer-events-none z-10">المفضلة</span>
                                <button @click.prevent="addToWishlist()" class="w-11 h-11 rounded-full border-2 border-white/30 bg-black/50 backdrop-blur text-white flex items-center justify-center transition-all hover:bg-[#D4A356] hover:border-[#D4A356] hover:text-black hover:scale-110">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M21 8.25c0-2.485-2.099-4.5-4.688-4.5-1.935 0-3.597 1.126-4.312 2.733-.715-1.607-2.377-2.733-4.313-2.733C5.1 3.75 3 5.765 3 8.25c0 7.22 9 12 9 12s9-4.78 9-12z" /></svg>
                                </button>
                            </div>
                            <div class="relative group/btn">
                                <span class="absolute -top-10 left-1/2 -translate-x-1/2 bg-[#1a1a1a] border border-white/20 text-white text-xs px-3 py-1.5 rounded-lg whitespace-nowrap opacity-0 group-hover/btn:opacity-100 transition-opacity pointer-events-none z-10">عرض سريع</span>
                                <button @click.prevent="quickView()" class="w-11 h-11 rounded-full border-2 border-white/30 bg-black/50 backdrop-blur text-white flex items-center justify-center transition-all hover:bg-[#D4A356] hover:border-[#D4A356] hover:text-black hover:scale-110">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M2.036 12.322a1.012 1.012 0 010-.639C3.423 7.51 7.36 4.5 12 4.5c4.638 0 8.573 3.007 9.963 7.178.07.207.07.431 0 .639C20.577 16.49 16.64 19.5 12 19.5c-4.638 0-8.573-3.007-9.963-7.178z" /><path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" /></svg>
                                </button>
                            </div>
                        </div>
                    </div>

                    <div class="pt-4 pb-2 text-center">
                        <h3 class="text-white font-bold text-base mb-2 line-clamp-1 group-hover:text-[#D4A356] transition-colors">${product.name}</h3>
                        <div class="flex items-center justify-center gap-2 mb-4">
                            <span class="text-[#D4A356] font-black text-lg">${formatPrice(product.price)} د.ع</span>
                        </div>
                    </div>
                </a>

                <button @click="addToCart()" class="w-full gold-gradient text-black py-3.5 rounded-full font-black text-sm transition-all duration-300 hover:scale-[1.02] hover:shadow-lg hover:shadow-[#D4A356]/20">
                    ${product.in_stock ? 'إضافة إلى السلة' : 'غير متوفر'}
                </button>
            </div>
            </div>
        `).join('');

            // Reinitialize Swiper after updating content
            if (window.latestProductsSwiper) {
                window.latestProductsSwiper.update();
                window.latestProductsSwiper.slideTo(0);
            }
        }

        function formatPrice(price) {
            return new Intl.NumberFormat('en-US').format(price);
        }

        function showError(message) {
            const container = document.getElementById('latestProducts');
            container.innerHTML = `
            <div class="col-span-full text-center py-12">
                <svg class="w-20 h-20 mx-auto text-red-500 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                </svg>
                <p class="text-gray-400 text-lg">${message}</p>
            </div>
        `;
        }

        // Initialize All Carousels
        document.addEventListener('DOMContentLoaded', function() {
            // Latest Products Carousel (store in global variable for updates)
            window.latestProductsSwiper = new Swiper('.latest-products-swiper', {
                slidesPerView: 1,
                spaceBetween: 16,
                loop: false,
                centeredSlides: true,
                autoplay: {
                    delay: 5000,
                    disableOnInteraction: false,
                    pauseOnMouseEnter: true,
                },
                pagination: {
                    el: '.latest-pagination',
                    clickable: true,
                },
                navigation: {
                    nextEl: '.latest-next',
                    prevEl: '.latest-prev',
                },
                breakpoints: {
                    640: {
                        slidesPerView: 2,
                        spaceBetween: 16,
                        centeredSlides: false,
                    },
                    768: {
                        slidesPerView: 3,
                        spaceBetween: 20,
                        centeredSlides: false,
                    },
                    1024: {
                        slidesPerView: 4,
                        spaceBetween: 24,
                        centeredSlides: false,
                    },
                },
            });

            // Best Selling Products Carousel
            const bestSellingSwiper = new Swiper('.best-selling-swiper', {
                slidesPerView: 1,
                spaceBetween: 16,
                loop: false,
                centeredSlides: true,
                autoplay: {
                    delay: 5000,
                    disableOnInteraction: false,
                    pauseOnMouseEnter: true,
                },
                pagination: {
                    el: '.best-pagination',
                    clickable: true,
                },
                navigation: {
                    nextEl: '.best-next',
                    prevEl: '.best-prev',
                },
                breakpoints: {
                    640: {
                        slidesPerView: 2,
                        spaceBetween: 16,
                        centeredSlides: false,
                    },
                    768: {
                        slidesPerView: 3,
                        spaceBetween: 20,
                        centeredSlides: false,
                    },
                    1024: {
                        slidesPerView: 4,
                        spaceBetween: 24,
                        centeredSlides: false,
                    },
                },
            });

            // Featured Products Carousel
            const featuredSwiper = new Swiper('.featured-products-swiper', {
                slidesPerView: 1,
                spaceBetween: 16,
                loop: false,
                centeredSlides: true,
                autoplay: {
                    delay: 5000,
                    disableOnInteraction: false,
                    pauseOnMouseEnter: true,
                },
                pagination: {
                    el: '.featured-pagination',
                    clickable: true,
                },
                navigation: {
                    nextEl: '.featured-next',
                    prevEl: '.featured-prev',
                },
                breakpoints: {
                    640: {
                        slidesPerView: 2,
                        spaceBetween: 16,
                        centeredSlides: false,
                    },
                    768: {
                        slidesPerView: 3,
                        spaceBetween: 20,
                        centeredSlides: false,
                    },
                    1024: {
                        slidesPerView: 4,
                        spaceBetween: 24,
                        centeredSlides: false,
                    },
                },
            });

            // Categories are now regular grid - no swiper needed

        });
    </script>

    
    <script>
        function filterByCategory(categoryId) {
            // Remove active class from all cards
            document.querySelectorAll('.category-card').forEach(card => {
                card.classList.remove('active');
                const border = card.querySelector('.absolute.inset-0.border-4');
                if (border) {
                    border.classList.remove('scale-100');
                    border.classList.add('scale-0');
                }
            });

            // Add active class to clicked card
            const activeCard = categoryId === 'all' ?
                document.querySelector('[data-category-id="all"]') :
                document.querySelector(`[data-category-id="${categoryId}"]`);

            if (activeCard) {
                activeCard.classList.add('active');
                const border = activeCard.querySelector('.absolute.inset-0.border-4');
                if (border) {
                    border.classList.remove('scale-0');
                    border.classList.add('scale-100');
                }
            }

            // Your filter logic here
            console.log('Filtering by category:', categoryId);
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\dante\Herd\nassaj\resources\views/home.blade.php ENDPATH**/ ?>