<?php $__env->startSection('title', 'تم الطلب بنجاح - ديفرنت'); ?>

<?php $__env->startSection('content'); ?>
    <section class="min-h-screen py-12 bg-[#0a0a0a]">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            
            <div class="text-center mb-10">
                <div class="w-24 h-24 mx-auto mb-6 rounded-full bg-emerald-500/10 flex items-center justify-center">
                    <svg class="w-12 h-12 text-emerald-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                    </svg>
                </div>

                <h1 class="cairo text-3xl md:text-4xl font-black text-white mb-4">
                    شكراً لك! <span class="text-[#D4A356]">تم استلام طلبك</span>
                </h1>

                <p class="text-gray-400 text-lg">
                    سنتواصل معك قريباً لتأكيد الطلب وموعد التوصيل
                </p>
            </div>

            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($order): ?>
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-10">
                    
                    <div class="bg-[#111111] rounded-2xl border border-white/10 p-6">
                        <div class="flex items-center justify-between mb-6">
                            <h2 class="text-white font-black text-lg">تفاصيل الطلب</h2>
                            <span class="px-3 py-1 rounded-full bg-amber-500/10 text-amber-500 text-xs font-bold">
                                <?php echo e($order->status->label()); ?>

                            </span>
                        </div>

                        <div class="space-y-4">
                            <div class="flex justify-between items-center pb-4 border-b border-white/10">
                                <span class="text-gray-400">رقم الطلب</span>
                                <span class="text-[#D4A356] font-black text-lg"><?php echo e($order->order_number); ?></span>
                            </div>

                            <div class="flex justify-between items-center">
                                <span class="text-gray-400">تاريخ الطلب</span>
                                <span class="text-white font-bold"><?php echo e($order->created_at->format('Y/m/d - h:i A')); ?></span>
                            </div>

                            <div class="flex justify-between items-center">
                                <span class="text-gray-400">طريقة الدفع</span>
                                <span class="text-white font-bold">
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php switch($order->payment_method):
                                        case ('cod'): ?>
                                            الدفع عند الاستلام
                                        <?php break; ?>

                                        <?php case ('card'): ?>
                                            بطاقة ائتمان
                                        <?php break; ?>

                                        <?php case ('zaincash'): ?>
                                            زين كاش
                                        <?php break; ?>
                                    <?php endswitch; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </span>
                            </div>

                            <div class="flex justify-between items-center">
                                <span class="text-gray-400">عدد المنتجات</span>
                                <span class="text-white font-bold"><?php echo e($order->items->sum('quantity')); ?> منتج</span>
                            </div>
                        </div>

                        
                        <div class="mt-6 pt-6 border-t border-white/10">
                            <h3 class="text-white font-bold text-sm mb-4">المنتجات</h3>
                            <div class="space-y-3 max-h-48 overflow-y-auto">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="flex items-center gap-3 p-2 bg-white/5 rounded-lg">
                                        <div
                                            class="w-12 h-12 rounded-lg bg-[#1a1a1a] flex items-center justify-center shrink-0 overflow-hidden">
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($item->product?->thumbnail_thumb_url): ?>
                                                <img src="<?php echo e($item->product->thumbnail_thumb_url); ?>"
                                                    alt="<?php echo e($item->product_name); ?>" class="w-full h-full object-cover">
                                            <?php else: ?>
                                                <svg class="w-5 h-5 text-gray-600" fill="none" stroke="currentColor"
                                                    viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1"
                                                        d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                                </svg>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </div>
                                        <div class="flex-1 min-w-0">
                                            <p class="text-white text-sm font-bold line-clamp-1"><?php echo e($item->product_name); ?>

                                            </p>
                                            <p class="text-gray-500 text-xs">x<?php echo e($item->quantity); ?></p>
                                        </div>
                                        <span
                                            class="text-[#D4A356] font-bold text-sm shrink-0"><?php echo e(number_format($item->line_total)); ?>

                                            د.ع</span>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        </div>

                        
                        <div class="mt-6 pt-6 border-t border-white/10 space-y-3">
                            <div class="flex justify-between items-center text-sm">
                                <span class="text-gray-400">المجموع الفرعي</span>
                                <span class="text-white"><?php echo e(number_format($order->subtotal)); ?> د.ع</span>
                            </div>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($order->discount_total > 0): ?>
                                <div class="flex justify-between items-center text-sm">
                                    <span class="text-emerald-400">الخصم</span>
                                    <span class="text-emerald-400">-<?php echo e(number_format($order->discount_total)); ?> د.ع</span>
                                </div>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            <div class="flex justify-between items-center text-sm">
                                <span class="text-gray-400">الشحن</span>
                                <span
                                    class="text-white"><?php echo e($order->shipping_fee > 0 ? number_format($order->shipping_fee) . ' د.ع' : 'مجاني'); ?></span>
                            </div>
                            <div class="flex justify-between items-center pt-3 border-t border-white/10">
                                <span class="text-white font-bold">الإجمالي</span>
                                <span class="text-[#D4A356] font-black text-xl"><?php echo e(number_format($order->grand_total)); ?>

                                    د.ع</span>
                            </div>
                        </div>
                    </div>

                    
                    <div class="space-y-6">
                        <div class="bg-[#111111] rounded-2xl border border-white/10 p-6">
                            <h2 class="text-white font-black text-lg mb-4">عنوان التوصيل</h2>
                            <div class="space-y-3">
                                <div class="flex items-center gap-3">
                                    <svg class="w-5 h-5 text-[#D4A356] shrink-0" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                            d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                                    </svg>
                                    <span class="text-white"><?php echo e($order->shippingAddress?->name); ?></span>
                                </div>
                                <div class="flex items-center gap-3">
                                    <svg class="w-5 h-5 text-[#D4A356] shrink-0" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                            d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
                                    </svg>
                                    <span
                                        class="text-white direction-ltr text-right"><?php echo e($order->shippingAddress?->phone); ?></span>
                                </div>
                                <div class="flex items-start gap-3">
                                    <svg class="w-5 h-5 text-[#D4A356] shrink-0 mt-0.5" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                            d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z" />
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                            d="M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
                                    </svg>
                                    <span class="text-white"><?php echo e($order->shippingAddress?->city?->name); ?> -
                                        <?php echo e($order->shippingAddress?->address); ?></span>
                                </div>
                            </div>
                        </div>

                        
                        <div class="bg-[#111111] rounded-2xl border border-white/10 p-6">
                            <h2 class="text-white font-black text-lg mb-4">الخطوات التالية</h2>
                            <div class="space-y-4">
                                <div class="flex items-center gap-4">
                                    <div
                                        class="w-10 h-10 rounded-full bg-[#D4A356]/10 flex items-center justify-center shrink-0">
                                        <span class="text-[#D4A356] font-bold">1</span>
                                    </div>
                                    <div>
                                        <h3 class="text-white font-bold text-sm">تأكيد الطلب</h3>
                                        <p class="text-gray-500 text-xs">سنتصل بك خلال 24 ساعة</p>
                                    </div>
                                </div>
                                <div class="flex items-center gap-4">
                                    <div
                                        class="w-10 h-10 rounded-full bg-white/5 flex items-center justify-center shrink-0">
                                        <span class="text-gray-400 font-bold">2</span>
                                    </div>
                                    <div>
                                        <h3 class="text-white font-bold text-sm">تجهيز الطلب</h3>
                                        <p class="text-gray-500 text-xs">سيتم تجهيز طلبك للشحن</p>
                                    </div>
                                </div>
                                <div class="flex items-center gap-4">
                                    <div
                                        class="w-10 h-10 rounded-full bg-white/5 flex items-center justify-center shrink-0">
                                        <span class="text-gray-400 font-bold">3</span>
                                    </div>
                                    <div>
                                        <h3 class="text-white font-bold text-sm">التوصيل</h3>
                                        <p class="text-gray-500 text-xs">سيصلك الطلب باسرع وقت</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(auth()->guard('client')->check()): ?>
                    <a href="<?php echo e(route('client.orders')); ?>"
                        class="bg-gradient-to-r from-[#D4A356] to-[#442247] text-black px-8 py-4 rounded-xl font-black text-center hover:shadow-lg hover:shadow-[#D4A356]/20 transition-all">
                        تتبع طلباتك
                    </a>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                <a href="<?php echo e(route('shop')); ?>"
                    class="bg-white/5 border border-white/10 text-white px-8 py-4 rounded-xl font-bold text-center hover:bg-white/10 transition-colors">
                    متابعة التسوق
                </a>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\dante\Herd\nassaj\resources\views/store/checkout-success.blade.php ENDPATH**/ ?>