<?php $__env->startSection('title', $product->name . ' - نساج'); ?>
<?php $__env->startSection('page', 'product'); ?>

<?php $__env->startSection('hero_title', $product->name); ?>
<?php $__env->startSection('hero_breadcrumbs'); ?>
    <span class="text-white/30 mx-0.5">›</span>
    <a href="<?php echo e(route('shop')); ?>" class="text-nassaj-gold hover:text-nassaj-gold-light transition-colors">المتجر</a>
    <span class="text-white/30 mx-0.5">›</span>
    <span class="text-white/60"><?php echo e($product->name); ?></span>
<?php $__env->stopSection(); ?>

<?php
    // Get product images
    $thumbnail = $product->thumbnail_url;
    $gallery = $product->gallery_urls ?? [];
    $allImages = array_filter(array_merge([$thumbnail], $gallery));

    // Get variants
    $variants = $product->variants;
    $defaultVariant = $variants->firstWhere('is_default', true) ?? $variants->first();

    // Calculate price
    $basePrice = 0;
    if ($defaultVariant) {
        $priceRow = \App\Models\ProductPrice::where('product_id', $product->id)
            ->where('product_variant_id', $defaultVariant->id)
            ->first();

        if ($priceRow) {
            $basePrice = (int) ($priceRow->retail_price ?? 0);
        }

        if ($basePrice <= 0 && $defaultVariant->cost) {
            $margin = $priceRow->retail_margin ?? 20;
            $basePrice = (int) round($defaultVariant->cost * (1 + $margin / 100));
        }
    }

    // Check stock
    $totalStock = $variants->sum(fn($v) => $v->stockBalances->sum('quantity') ?? 0);
    $inStock = $totalStock > 0;

    // Get unique colors and sizes from variants
    $colors = [];
    $sizes = [];
    $colorAttributeName = '';
    $sizeAttributeName = '';

    foreach ($variants as $v) {
        foreach ($v->attributeValues as $av) {
            $attrName = strtolower($av->attribute->name ?? '');
            if (in_array($attrName, ['color', 'لون', 'اللون'])) {
                if (!$colorAttributeName) {
                    $colorAttributeName = $av->attribute->display_name ?? ($av->attribute->name ?? 'اللون');
                }
                $colors[$av->id] = [
                    'id' => $av->id,
                    'name' => $av->display_value ?? $av->value,
                    'color_code' => $av->color_code ?? '#808080',
                ];
            } elseif (in_array($attrName, ['size', 'مقاس', 'الحجم', 'حجم'])) {
                if (!$sizeAttributeName) {
                    $sizeAttributeName = $av->attribute->display_name ?? ($av->attribute->name ?? 'المقاس');
                }
                $sizes[$av->id] = [
                    'id' => $av->id,
                    'name' => $av->display_value ?? $av->value,
                ];
            }
        }
    }
    $colors = array_values($colors);
    $sizes = array_values($sizes);
?>

<?php $__env->startSection('content'); ?>
    
    <div class="bg-white dark:bg-[#0a0a0a] border-b border-gray-200 dark:border-white/5">
        <div class="site-container py-4">
            <nav class="flex items-center gap-2 text-sm">
                <a href="<?php echo e(route('home')); ?>"
                    class="text-gray-600 dark:text-gray-400 hover:text-nassaj-gold transition-colors">الرئيسية</a>
                <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                </svg>
                <a href="<?php echo e(route('shop')); ?>"
                    class="text-gray-600 dark:text-gray-400 hover:text-nassaj-gold transition-colors">المتجر</a>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($product->category): ?>
                    <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                    </svg>
                    <a href="<?php echo e(route('category.show', $product->category->slug)); ?>"
                        class="text-gray-600 dark:text-gray-400 hover:text-nassaj-gold transition-colors"><?php echo e($product->category->name); ?></a>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                </svg>
                <span class="text-nassaj-gold font-bold"><?php echo e($product->name); ?></span>
            </nav>
        </div>
    </div>

    
    <section class="py-12 bg-white dark:bg-[#0a0a0a]" x-data="{
        activeImage: 0,
        selectedColor: <?php echo e(count($colors) > 0 ? $colors[0]['id'] : 'null'); ?>,
        selectedSize: <?php echo e(count($sizes) > 0 ? $sizes[0]['id'] : 'null'); ?>,
        selectedColorName: '<?php echo e(count($colors) > 0 ? $colors[0]['name'] : ''); ?>',
        selectedSizeName: '<?php echo e(count($sizes) > 0 ? $sizes[0]['name'] : ''); ?>',
        qty: 1,
        price: <?php echo e($basePrice); ?>,
        activeTab: 'specs',
        formatPrice(num) {
            return num.toLocaleString('en-US');
        }
    }">
        <div class="site-container">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-10 lg:gap-16">
                
                <div class="space-y-4">
                    
                    <div
                        class="relative aspect-square rounded-2xl overflow-hidden bg-gray-50 dark:bg-[#0f0f0f] border border-gray-200 dark:border-white/5">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($allImages) > 0): ?>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $allImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <img x-show="activeImage === <?php echo e($index); ?>"
                                    x-transition:enter="transition ease-out duration-300"
                                    x-transition:enter-start="opacity-0 scale-95"
                                    x-transition:enter-end="opacity-100 scale-100" src="<?php echo e($image); ?>"
                                    alt="<?php echo e($product->name); ?>" class="w-full h-full object-cover">
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        <?php else: ?>
                            <div class="w-full h-full flex items-center justify-center text-gray-300 dark:text-gray-700">
                                <svg class="w-24 h-24" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1"
                                        d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                </svg>
                            </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                        
                        <div class="absolute top-3 right-3 flex flex-col gap-2 z-10">
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($product->is_new): ?>
                                <span
                                    class="px-3 py-1.5 rounded-lg text-xs font-bold bg-emerald-500 text-white shadow-lg">جديد</span>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($basePrice > 0): ?>
                                <span class="px-3 py-1.5 rounded-lg text-xs font-bold bg-red-500 text-white shadow-lg">خصم
                                    15%</span>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                    </div>

                    
                    <?php if(count($allImages) > 1): ?>
                        <div class="flex gap-3 overflow-x-auto hide-scrollbar pb-2">
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $allImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <button @click="activeImage = <?php echo e($index); ?>"
                                    class="shrink-0 w-20 h-20 rounded-xl overflow-hidden border-2 transition-all duration-200"
                                    :class="activeImage === <?php echo e($index); ?> ? 'border-nassaj-gold scale-105 shadow-lg' :
                                        'border-gray-200 dark:border-white/10 hover:border-nassaj-gold/50'">
                                    <img src="<?php echo e($image); ?>" alt="صورة <?php echo e($index + 1); ?>"
                                        class="w-full h-full object-cover">
                                </button>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>

                
                <div class="space-y-6">
                    
                    <div>
                        <div class="flex items-center gap-3 mb-3">
                            <span
                                class="px-3 py-1 rounded-full text-xs font-bold <?php echo e($inStock ? 'bg-emerald-500/20 text-emerald-400' : 'bg-red-500/20 text-red-400'); ?>">
                                <?php echo e($inStock ? 'متوفر' : 'غير متوفر'); ?>

                            </span>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($defaultVariant?->sku): ?>
                                <span class="text-gray-500 text-sm">SKU: <?php echo e($defaultVariant->sku); ?></span>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>

                        <h1 class="cairo text-3xl md:text-4xl font-black text-white mb-3">
                            <?php echo e($product->name); ?>

                        </h1>

                        
                        <div class="flex items-center gap-4 flex-wrap">
                            
                            <div class="flex items-center gap-2">
                                <div class="flex items-center gap-0.5">
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php for($i = 1; $i <= 5; $i++): ?>
                                        <svg class="w-5 h-5 <?php echo e($i <= 4 ? 'text-[#D4A356]' : 'text-gray-600'); ?>"
                                            fill="currentColor" viewBox="0 0 20 20">
                                            <path
                                                d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                                        </svg>
                                    <?php endfor; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </div>
                                <span class="text-white font-bold">4.8</span>
                                <span class="text-gray-500 text-sm">(124 تقييم)</span>
                            </div>
                            <span class="text-gray-600">|</span>
                            <span class="text-gray-400 text-sm">
                                <span class="text-[#D4A356] font-bold">350</span> تم بيعه
                            </span>
                        </div>

                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($product->brand): ?>
                            <p class="text-gray-400 text-sm mt-2">الماركة: <span
                                    class="text-[#D4A356]"><?php echo e($product->brand->name); ?></span></p>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>

                    
                    <div class="p-6 rounded-2xl glass border border-white/5">
                        <div class="flex items-baseline gap-4 flex-wrap">
                            <span class="cairo text-4xl font-black text-[#D4A356]"><?php echo e(number_format($basePrice)); ?>

                                د.ع</span>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($basePrice > 0): ?>
                                <span
                                    class="text-gray-500 text-xl line-through"><?php echo e(number_format((int) ($basePrice * 1.15))); ?>

                                    د.ع</span>
                                <span class="px-3 py-1 rounded-full text-sm font-bold bg-red-500/20 text-red-400">
                                    وفر 15%
                                </span>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                        <p class="text-emerald-400 text-sm mt-2 flex items-center gap-2">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                            </svg>
                            شحن مجاني للطلبات فوق 100,000 د.ع
                        </p>
                    </div>

                    
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($product->description): ?>
                        <div>
                            <p class="text-gray-400 leading-relaxed"><?php echo e($product->description); ?></p>
                        </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                    
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($colors) > 0): ?>
                        <div>
                            <h3 class="text-white font-bold text-sm mb-4 flex items-center gap-2">
                                <?php echo e($colorAttributeName); ?>:
                                <span class="text-[#D4A356]" x-text="selectedColorName"></span>
                            </h3>
                            <div class="flex items-center gap-3">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $colors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <button
                                        @click="selectedColor = <?php echo e($color['id']); ?>; selectedColorName = '<?php echo e($color['name']); ?>'"
                                        class="w-10 h-10 rounded-full border-2 transition-all duration-200 relative"
                                        :class="selectedColor === <?php echo e($color['id']); ?> ?
                                            'border-[#D4A356] scale-110 ring-2 ring-[#D4A356]/30' :
                                            'border-transparent hover:scale-105'"
                                        style="background-color: <?php echo e($color['color_code']); ?>"
                                        title="<?php echo e($color['name']); ?>">
                                        <span x-show="selectedColor === <?php echo e($color['id']); ?>"
                                            class="absolute inset-0 flex items-center justify-center text-white">
                                            <svg class="w-5 h-5 drop-shadow-lg" fill="none" stroke="currentColor"
                                                viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3"
                                                    d="M5 13l4 4L19 7" />
                                            </svg>
                                        </span>
                                    </button>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                    
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($sizes) > 0): ?>
                        <div>
                            <h3 class="text-white font-bold text-sm mb-4 flex items-center gap-2">
                                <?php echo e($sizeAttributeName); ?>:
                                <span class="text-[#D4A356]" x-text="selectedSizeName"></span>
                                <a href="#" class="text-[#D4A356] text-xs underline mr-auto">دليل المقاسات</a>
                            </h3>
                            <div class="flex flex-wrap gap-3">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $sizes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $size): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <button
                                        @click="selectedSize = <?php echo e($size['id']); ?>; selectedSizeName = '<?php echo e($size['name']); ?>'"
                                        class="min-w-[48px] h-12 px-4 rounded-xl border-2 font-bold text-sm transition-all duration-200"
                                        :class="selectedSize === <?php echo e($size['id']); ?> ?
                                            'border-[#D4A356] bg-[#D4A356] text-black' :
                                            'border-white/20 text-white hover:border-[#D4A356]/50'">
                                        <?php echo e($size['name']); ?>

                                    </button>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                    
                    <div class="space-y-5">
                        
                        <div class="flex items-center justify-between">
                            
                            <div
                                class="flex items-center bg-gradient-to-r from-[#1a1a1a] to-[#151515] rounded-2xl border-2 border-white/10 shadow-lg">
                                <button @click="qty = Math.max(qty - 1, 1)"
                                    class="w-16 h-16 flex items-center justify-center text-white text-2xl font-bold rounded-l-2xl">
                                    <span>−</span>
                                </button>
                                <div class="px-8 min-w-[100px] text-center">
                                    <span class="cairo text-2xl font-black text-white" x-text="qty"></span>
                                </div>
                                <button @click="qty = Math.min(qty + 1, 99)"
                                    class="w-16 h-16 flex items-center justify-center text-white text-2xl font-bold rounded-r-2xl">
                                    <span>+</span>
                                </button>
                            </div>

                            
                            <div class="flex items-center gap-2">
                                
                                <button
                                    @click="window.dispatchEvent(new CustomEvent('wishlist-add-instant', {
                                        detail: {
                                            id: <?php echo e($product->id); ?>,
                                            name: '<?php echo e(addslashes($product->name)); ?>',
                                            price: <?php echo e($basePrice); ?>,
                                            image: '<?php echo e($thumbnail ?? ''); ?>'
                                        }
                                    }))"
                                    class="w-14 h-14 rounded-xl bg-gradient-to-br from-[#1a1a1a] to-[#0d0d0d] border-2 border-white/10 hover:border-red-500/50 hover:bg-red-500/10 text-white hover:text-red-500 flex items-center justify-center transition-all shadow-lg group">
                                    <svg class="w-6 h-6 group-hover:scale-110 transition-transform" fill="none"
                                        stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z" />
                                    </svg>
                                </button>

                                
                                <button
                                    @click="window.dispatchEvent(new CustomEvent('compare-add-instant', {
                                        detail: {
                                            id: <?php echo e($product->id); ?>,
                                            name: '<?php echo e(addslashes($product->name)); ?>',
                                            price: <?php echo e($basePrice); ?>,
                                            image: '<?php echo e($thumbnail ?? ''); ?>'
                                        }
                                    }))"
                                    class="w-14 h-14 rounded-xl bg-gradient-to-br from-[#1a1a1a] to-[#0d0d0d] border-2 border-white/10 hover:border-blue-500/50 hover:bg-blue-500/10 text-white hover:text-blue-500 flex items-center justify-center transition-all shadow-lg group">
                                    <svg class="w-6 h-6 group-hover:scale-110 transition-transform" fill="none"
                                        stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z" />
                                    </svg>
                                </button>

                                
                                <button
                                    onclick="navigator.share ? navigator.share({title: '<?php echo e($product->name); ?>', url: window.location.href}) : navigator.clipboard.writeText(window.location.href)"
                                    class="w-14 h-14 rounded-xl bg-gradient-to-br from-[#1a1a1a] to-[#0d0d0d] border-2 border-white/10 hover:border-green-500/50 hover:bg-green-500/10 text-white hover:text-green-500 flex items-center justify-center transition-all shadow-lg group">
                                    <svg class="w-6 h-6 group-hover:scale-110 transition-transform" fill="none"
                                        stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M8.684 13.342C8.886 12.938 9 12.482 9 12c0-.482-.114-.938-.316-1.342m0 2.684a3 3 0 110-2.684m0 2.684l6.632 3.316m-6.632-6l6.632-3.316m0 0a3 3 0 105.367-2.684 3 3 0 00-5.367 2.684zm0 9.316a3 3 0 105.368 2.684 3 3 0 00-5.368-2.684z" />
                                    </svg>
                                </button>
                            </div>
                        </div>
                        
                        <div class="flex gap-3">
                            
                            <button
                                @click="window.dispatchEvent(new CustomEvent('cart-add-instant', {
                                    detail: {
                                        id: <?php echo e($product->id); ?>,
                                        name: '<?php echo e(addslashes($product->name)); ?>',
                                        price: <?php echo e($basePrice); ?>,
                                        image: '<?php echo e($thumbnail ?? ''); ?>',
                                        quantity: qty
                                    }
                                }))"
                                class="flex-1 bg-gradient-to-r from-[#D4A356] via-[#442247] to-[#D4A356] text-black py-4 rounded-2xl font-black text-base flex items-center justify-center gap-3 hover:shadow-2xl hover:shadow-[#D4A356]/40 transition-all hover:scale-[1.02] active:scale-[0.98] border-2 border-[#D4A356]/20 relative overflow-hidden group">
                                <div
                                    class="absolute inset-0 bg-gradient-to-r from-transparent via-white/10 to-transparent translate-x-[-100%] group-hover:translate-x-[100%] transition-transform duration-700">
                                </div>
                                <svg class="w-5 h-5 relative z-10" fill="none" stroke="currentColor"
                                    stroke-width="2.5" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round"
                                        d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z" />
                                </svg>
                                <span class="relative z-10">أضف للسلة</span>
                                <span class="relative z-10 text-black/40 mx-1">|</span>
                                <span class="cairo relative z-10 font-black"
                                    x-text="formatPrice(qty * price) + ' د.ع'"></span>
                            </button>

                            
                            <a href="<?php echo e(route('checkout.index')); ?>"
                                class="flex-1 bg-white/5 backdrop-blur-xl text-white py-4 rounded-2xl font-bold text-base flex items-center justify-center hover:bg-white/10 transition-all duration-300 border-2 border-[#D4A356]/30 hover:border-[#D4A356]/60 hover:shadow-xl hover:shadow-[#D4A356]/20 group relative overflow-hidden">
                                <div
                                    class="absolute inset-0 bg-gradient-to-r from-[#D4A356]/0 via-[#D4A356]/10 to-[#D4A356]/0 translate-y-[100%] group-hover:translate-y-0 transition-transform duration-300">
                                </div>
                                <span class="relative z-10">اشتري الآن</span>
                            </a>
                        </div>
                    </div>

                    
                    <div class="grid grid-cols-2 gap-3">
                        <div
                            class="flex items-center gap-3 p-5 rounded-2xl bg-gradient-to-br from-[#1a1a1a] to-[#0d0d0d] border border-white/10 hover:border-[#D4A356]/30 transition-all group">
                            <div
                                class="w-12 h-12 rounded-xl bg-gradient-to-br from-[#D4A356]/20 to-[#D4A356]/10 flex items-center justify-center group-hover:scale-110 transition-transform">
                                <svg class="w-6 h-6 text-[#D4A356]" fill="none" stroke="currentColor"
                                    stroke-width="2" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round"
                                        d="M5 8h14M5 8a2 2 0 110-4h14a2 2 0 110 4M5 8v10a2 2 0 002 2h10a2 2 0 002-2V8m-9 4h4" />
                                </svg>
                            </div>
                            <div>
                                <span class="text-white font-bold text-sm block">شحن سريع</span>
                                <span class="text-gray-500 text-xs">2-3 أيام عمل</span>
                            </div>
                        </div>
                        <div
                            class="flex items-center gap-3 p-5 rounded-2xl bg-gradient-to-br from-[#1a1a1a] to-[#0d0d0d] border border-white/10 hover:border-emerald-500/30 transition-all group">
                            <div
                                class="w-12 h-12 rounded-xl bg-gradient-to-br from-emerald-500/20 to-emerald-500/10 flex items-center justify-center group-hover:scale-110 transition-transform">
                                <svg class="w-6 h-6 text-emerald-400" fill="none" stroke="currentColor"
                                    stroke-width="2" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round"
                                        d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
                                </svg>
                            </div>
                            <div>
                                <span class="text-white font-bold text-sm block">ضمان سنة</span>
                                <span class="text-gray-500 text-xs">ضمان المصنع</span>
                            </div>
                        </div>
                        <div
                            class="flex items-center gap-3 p-5 rounded-2xl bg-gradient-to-br from-[#1a1a1a] to-[#0d0d0d] border border-white/10 hover:border-blue-500/30 transition-all group">
                            <div
                                class="w-12 h-12 rounded-xl bg-gradient-to-br from-blue-500/20 to-blue-500/10 flex items-center justify-center group-hover:scale-110 transition-transform">
                                <svg class="w-6 h-6 text-blue-400" fill="none" stroke="currentColor" stroke-width="2"
                                    viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round"
                                        d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15" />
                                </svg>
                            </div>
                            <div>
                                <span class="text-white font-bold text-sm block">إرجاع مجاني</span>
                                <span class="text-gray-500 text-xs">خلال 14 يوم</span>
                            </div>
                        </div>
                        <div
                            class="flex items-center gap-3 p-5 rounded-2xl bg-gradient-to-br from-[#1a1a1a] to-[#0d0d0d] border border-white/10 hover:border-purple-500/30 transition-all group">
                            <div
                                class="w-12 h-12 rounded-xl bg-gradient-to-br from-purple-500/20 to-purple-500/10 flex items-center justify-center group-hover:scale-110 transition-transform">
                                <svg class="w-6 h-6 text-purple-400" fill="none" stroke="currentColor"
                                    stroke-width="2" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round"
                                        d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z" />
                                </svg>
                            </div>
                            <div>
                                <span class="text-white font-bold text-sm block">دفع آمن</span>
                                <span class="text-gray-500 text-xs">بطاقات ائتمان</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="mt-16">
                
                <div class="flex items-center gap-1 border-b border-white/10 overflow-x-auto hide-scrollbar">
                    <button @click="activeTab = 'specs'"
                        class="px-6 py-4 font-bold text-sm whitespace-nowrap transition-all border-b-2 -mb-px"
                        :class="activeTab === 'specs' ? 'text-[#D4A356] border-[#D4A356]' :
                            'text-gray-400 border-transparent hover:text-white'">
                        المواصفات
                    </button>
                    <button @click="activeTab = 'details'"
                        class="px-6 py-4 font-bold text-sm whitespace-nowrap transition-all border-b-2 -mb-px"
                        :class="activeTab === 'details' ? 'text-[#D4A356] border-[#D4A356]' :
                            'text-gray-400 border-transparent hover:text-white'">
                        التفاصيل
                    </button>
                    <button @click="activeTab = 'reviews'"
                        class="px-6 py-4 font-bold text-sm whitespace-nowrap transition-all border-b-2 -mb-px"
                        :class="activeTab === 'reviews' ? 'text-[#D4A356] border-[#D4A356]' :
                            'text-gray-400 border-transparent hover:text-white'">
                        التقييمات (124)
                    </button>
                    <button @click="activeTab = 'shipping'"
                        class="px-6 py-4 font-bold text-sm whitespace-nowrap transition-all border-b-2 -mb-px"
                        :class="activeTab === 'shipping' ? 'text-[#D4A356] border-[#D4A356]' :
                            'text-gray-400 border-transparent hover:text-white'">
                        الشحن والإرجاع
                    </button>
                </div>

                
                <div class="py-8">
                    
                    <div x-show="activeTab === 'specs'" x-transition:enter="transition ease-out duration-200"
                        x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div class="flex items-center justify-between p-4 rounded-xl glass">
                                <span class="text-gray-400">الماركة</span>
                                <span class="text-white font-bold"><?php echo e($product->brand?->name ?? 'نساج'); ?></span>
                            </div>
                            <div class="flex items-center justify-between p-4 rounded-xl glass">
                                <span class="text-gray-400">الفئة</span>
                                <span class="text-white font-bold"><?php echo e($product->category?->name ?? 'عام'); ?></span>
                            </div>
                            <div class="flex items-center justify-between p-4 rounded-xl glass">
                                <span class="text-gray-400">الخامة</span>
                                <span class="text-white font-bold">قطن 100%</span>
                            </div>
                            <div class="flex items-center justify-between p-4 rounded-xl glass">
                                <span class="text-gray-400">بلد المنشأ</span>
                                <span class="text-white font-bold">تركيا</span>
                            </div>
                            <div class="flex items-center justify-between p-4 rounded-xl glass">
                                <span class="text-gray-400">نوع القماش</span>
                                <span class="text-white font-bold">قطن مصري</span>
                            </div>
                            <div class="flex items-center justify-between p-4 rounded-xl glass">
                                <span class="text-gray-400">موسم</span>
                                <span class="text-white font-bold">كل المواسم</span>
                            </div>
                        </div>
                    </div>

                    
                    <div x-show="activeTab === 'details'" x-cloak x-transition:enter="transition ease-out duration-200"
                        x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100">
                        <div class="prose prose-invert max-w-none">
                            <p class="text-gray-400 leading-relaxed mb-4">
                                <?php echo e($product->description ?? 'منتج عالي الجودة من نساج، مصنوع من أجود الخامات لضمان الراحة والأناقة. تصميم عصري يناسب جميع المناسبات.'); ?>

                            </p>
                            <h4 class="text-white font-bold mt-6 mb-3">مميزات المنتج:</h4>
                            <ul class="space-y-2">
                                <li class="text-gray-400 flex items-center gap-2">
                                    <svg class="w-5 h-5 text-[#D4A356]" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M5 13l4 4L19 7" />
                                    </svg>
                                    خامة عالية الجودة
                                </li>
                                <li class="text-gray-400 flex items-center gap-2">
                                    <svg class="w-5 h-5 text-[#D4A356]" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M5 13l4 4L19 7" />
                                    </svg>
                                    تصميم عصري وأنيق
                                </li>
                                <li class="text-gray-400 flex items-center gap-2">
                                    <svg class="w-5 h-5 text-[#D4A356]" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M5 13l4 4L19 7" />
                                    </svg>
                                    مناسب لجميع المناسبات
                                </li>
                                <li class="text-gray-400 flex items-center gap-2">
                                    <svg class="w-5 h-5 text-[#D4A356]" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M5 13l4 4L19 7" />
                                    </svg>
                                    سهل الغسيل والعناية
                                </li>
                            </ul>
                        </div>
                    </div>

                    
                    <div x-show="activeTab === 'reviews'" x-cloak x-transition:enter="transition ease-out duration-200"
                        x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100">
                        
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-8 mb-8">
                            <div class="text-center p-6 rounded-2xl glass">
                                <div class="text-5xl font-black text-[#D4A356] mb-2">4.8</div>
                                <div class="flex items-center justify-center gap-1 mb-2">
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php for($i = 1; $i <= 5; $i++): ?>
                                        <svg class="w-5 h-5 <?php echo e($i <= 5 ? 'text-[#D4A356]' : 'text-gray-600'); ?>"
                                            fill="currentColor" viewBox="0 0 20 20">
                                            <path
                                                d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                                        </svg>
                                    <?php endfor; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </div>
                                <p class="text-gray-400 text-sm">من 124 تقييم</p>
                            </div>

                            <div class="col-span-2 space-y-3">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = [['stars' => 5, 'count' => 89, 'percent' => 72], ['stars' => 4, 'count' => 25, 'percent' => 20], ['stars' => 3, 'count' => 7, 'percent' => 6], ['stars' => 2, 'count' => 2, 'percent' => 1], ['stars' => 1, 'count' => 1, 'percent' => 1]]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rating): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="flex items-center gap-3">
                                        <span class="text-white text-sm w-20"><?php echo e($rating['stars']); ?> نجوم</span>
                                        <div class="flex-1 h-2 bg-white/10 rounded-full overflow-hidden">
                                            <div class="h-full bg-[#D4A356] rounded-full"
                                                style="width: <?php echo e($rating['percent']); ?>%"></div>
                                        </div>
                                        <span class="text-gray-400 text-sm w-12"><?php echo e($rating['percent']); ?>%</span>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        </div>

                        
                        <div class="space-y-6">
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = [['name' => 'أحمد محمد', 'date' => 'منذ 3 أيام', 'rating' => 5, 'comment' => 'منتج ممتاز جداً، الخامة عالية الجودة والتوصيل سريع. أنصح به بشدة!'], ['name' => 'سارة علي', 'date' => 'منذ أسبوع', 'rating' => 4, 'comment' => 'جودة جيدة والمقاس مناسب. التغليف كان ممتاز.'], ['name' => 'محمد خالد', 'date' => 'منذ أسبوعين', 'rating' => 5, 'comment' => 'أفضل شراء قمت به هذا الشهر. سأشتري المزيد بالتأكيد!']]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="p-6 rounded-2xl glass">
                                    <div class="flex items-start justify-between mb-4">
                                        <div class="flex items-center gap-3">
                                            <div
                                                class="w-12 h-12 rounded-full bg-[#D4A356]/20 flex items-center justify-center text-[#D4A356] font-bold">
                                                <?php echo e(mb_substr($review['name'], 0, 1)); ?>

                                            </div>
                                            <div>
                                                <h4 class="text-white font-bold"><?php echo e($review['name']); ?></h4>
                                                <p class="text-gray-500 text-sm"><?php echo e($review['date']); ?></p>
                                            </div>
                                        </div>
                                        <div class="flex items-center gap-0.5">
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php for($i = 1; $i <= 5; $i++): ?>
                                                <svg class="w-4 h-4 <?php echo e($i <= $review['rating'] ? 'text-[#D4A356]' : 'text-gray-600'); ?>"
                                                    fill="currentColor" viewBox="0 0 20 20">
                                                    <path
                                                        d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                                                </svg>
                                            <?php endfor; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </div>
                                    </div>
                                    <p class="text-gray-400"><?php echo e($review['comment']); ?></p>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>

                        
                        <div class="text-center mt-8">
                            <button
                                class="px-8 py-3 rounded-full glass text-white font-bold hover:bg-white/10 transition-colors">
                                عرض المزيد من التقييمات
                            </button>
                        </div>
                    </div>

                    
                    <div x-show="activeTab === 'shipping'" x-cloak x-transition:enter="transition ease-out duration-200"
                        x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                            
                            <div class="space-y-6">
                                <h3 class="text-white font-bold text-xl mb-4">معلومات الشحن</h3>
                                <div class="space-y-4">
                                    <div class="flex items-start gap-4 p-4 rounded-xl glass">
                                        <div
                                            class="w-10 h-10 rounded-full bg-[#D4A356]/15 flex items-center justify-center shrink-0">
                                            <svg class="w-5 h-5 text-[#D4A356]" fill="none" stroke="currentColor"
                                                viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z" />
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
                                            </svg>
                                        </div>
                                        <div>
                                            <h4 class="text-white font-bold mb-1">التوصيل داخل بغداد</h4>
                                            <p class="text-gray-400 text-sm">1-2 أيام عمل - 5,000 د.ع</p>
                                        </div>
                                    </div>
                                    <div class="flex items-start gap-4 p-4 rounded-xl glass">
                                        <div
                                            class="w-10 h-10 rounded-full bg-[#D4A356]/15 flex items-center justify-center shrink-0">
                                            <svg class="w-5 h-5 text-[#D4A356]" fill="none" stroke="currentColor"
                                                viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M3.055 11H5a2 2 0 012 2v1a2 2 0 002 2 2 2 0 012 2v2.945M8 3.935V5.5A2.5 2.5 0 0010.5 8h.5a2 2 0 012 2 2 2 0 104 0 2 2 0 012-2h1.064M15 20.488V18a2 2 0 012-2h3.064M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                            </svg>
                                        </div>
                                        <div>
                                            <h4 class="text-white font-bold mb-1">التوصيل للمحافظات</h4>
                                            <p class="text-gray-400 text-sm">2-4 أيام عمل - 7,000 د.ع</p>
                                        </div>
                                    </div>
                                    <div class="flex items-start gap-4 p-4 rounded-xl glass">
                                        <div
                                            class="w-10 h-10 rounded-full bg-emerald-500/15 flex items-center justify-center shrink-0">
                                            <svg class="w-5 h-5 text-emerald-400" fill="none" stroke="currentColor"
                                                viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M5 13l4 4L19 7" />
                                            </svg>
                                        </div>
                                        <div>
                                            <h4 class="text-white font-bold mb-1">شحن مجاني</h4>
                                            <p class="text-gray-400 text-sm">للطلبات فوق 100,000 د.ع</p>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            
                            <div class="space-y-6">
                                <h3 class="text-white font-bold text-xl mb-4">سياسة الإرجاع</h3>
                                <div class="space-y-4">
                                    <div class="flex items-start gap-4 p-4 rounded-xl glass">
                                        <div
                                            class="w-10 h-10 rounded-full bg-[#D4A356]/15 flex items-center justify-center shrink-0">
                                            <svg class="w-5 h-5 text-[#D4A356]" fill="none" stroke="currentColor"
                                                viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15" />
                                            </svg>
                                        </div>
                                        <div>
                                            <h4 class="text-white font-bold mb-1">إرجاع مجاني</h4>
                                            <p class="text-gray-400 text-sm">خلال 14 يوم من الاستلام</p>
                                        </div>
                                    </div>
                                    <div class="flex items-start gap-4 p-4 rounded-xl glass">
                                        <div
                                            class="w-10 h-10 rounded-full bg-[#D4A356]/15 flex items-center justify-center shrink-0">
                                            <svg class="w-5 h-5 text-[#D4A356]" fill="none" stroke="currentColor"
                                                viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                            </svg>
                                        </div>
                                        <div>
                                            <h4 class="text-white font-bold mb-1">شروط الإرجاع</h4>
                                            <p class="text-gray-400 text-sm">المنتج بحالته الأصلية مع جميع الملحقات</p>
                                        </div>
                                    </div>
                                    <div class="flex items-start gap-4 p-4 rounded-xl glass">
                                        <div
                                            class="w-10 h-10 rounded-full bg-[#D4A356]/15 flex items-center justify-center shrink-0">
                                            <svg class="w-5 h-5 text-[#D4A356]" fill="none" stroke="currentColor"
                                                viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                            </svg>
                                        </div>
                                        <div>
                                            <h4 class="text-white font-bold mb-1">استرداد المبلغ</h4>
                                            <p class="text-gray-400 text-sm">خلال 3-5 أيام عمل بعد الموافقة</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($relatedProducts->isNotEmpty()): ?>
        <section class="py-16 bg-[#0a0a0a] border-t border-white/5">
            <div class="site-container">
                <div class="flex items-center justify-between mb-10">
                    <div>
                        <span
                            class="inline-block px-4 py-1.5 rounded-full glass text-xs font-bold text-[#D4A356] tracking-wider mb-3">
                            قد يعجبك أيضاً
                        </span>
                        <h2 class="cairo text-2xl md:text-3xl font-black text-white">
                            منتجات <span class="text-[#D4A356]">مشابهة</span>
                        </h2>
                    </div>
                    <a href="<?php echo e(route('shop', ['category' => $product->category_id])); ?>"
                        class="hidden sm:flex items-center gap-2 text-[#D4A356] font-bold text-sm hover:underline">
                        عرض الكل
                        <svg class="w-4 h-4 rotate-180" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M14 5l7 7m0 0l-7 7m7-7H3" />
                        </svg>
                    </a>
                </div>

                <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-4 md:gap-6">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $relatedProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $related): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('products.product-card', ['productId' => $related->id]);

$key = 'related-'.e($related->id).'';

$key ??= \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::generateKey('lw-3723755197-0', 'related-'.e($related->id).'');

$__html = app('livewire')->mount($__name, $__params, $key);

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>
            </div>
        </section>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\dante\Herd\nassaj\resources\views/store/product.blade.php ENDPATH**/ ?>