<div x-data="cartDrawer()" x-on:cart-open.window="open = true"
    x-on:cart-add-instant.window="addItemInstant($event.detail)" @keydown.escape.window="if(open) open = false">
    
    <style>
        .cart-scroll::-webkit-scrollbar {
            width: 6px;
        }

        .cart-scroll::-webkit-scrollbar-track {
            background: rgba(255, 255, 255, 0.05);
            border-radius: 3px;
        }

        .cart-scroll::-webkit-scrollbar-thumb {
            background: linear-gradient(180deg, #D4A356, #F5D799);
            border-radius: 3px;
        }

        .cart-scroll::-webkit-scrollbar-thumb:hover {
            background: linear-gradient(180deg, #F5D799, #D4A356);
        }

        /* Firefox */
        .cart-scroll {
            scrollbar-width: thin;
            scrollbar-color: #D4A356 rgba(255, 255, 255, 0.05);
        }
    </style>

    
    <div x-show="open" x-cloak class="fixed inset-0 z-[9999]">
        
        <div x-show="open" x-transition:enter="transition ease-out duration-100" x-transition:enter-start="opacity-0"
            x-transition:enter-end="opacity-100" x-transition:leave="transition ease-in duration-75"
            x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0" @click="open = false"
            class="absolute inset-0 bg-black/60 backdrop-blur-sm"></div>

        
        <div x-show="open" x-transition:enter="transition ease-out duration-100"
            x-transition:enter-start="translate-x-full" x-transition:enter-end="translate-x-0"
            x-transition:leave="transition ease-in duration-75" x-transition:leave-start="translate-x-0"
            x-transition:leave-end="translate-x-full"
            class="absolute left-0 top-0 h-full w-full max-w-md bg-[#0a0a0a] border-r border-[#D4A356]/20 flex flex-col shadow-2xl">
            
            <div class="p-6 border-b border-[#D4A356]/20 shrink-0 bg-gradient-to-l from-[#D4A356]/5 to-transparent">
                <div class="flex items-center justify-between">
                    <h2 class="cairo text-2xl font-bold text-white flex items-center gap-3">
                        <div
                            class="w-10 h-10 rounded-full bg-gradient-to-br from-[#D4A356] to-[#F5D799] flex items-center justify-center">
                            <svg class="w-5 h-5 text-black" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z" />
                            </svg>
                        </div>
                        <span>سلة التسوق <span class="text-[#D4A356]">(<?php echo e($count); ?>)</span></span>
                    </h2>
                    <button @click="open = false"
                        class="p-2 hover:bg-white/5 rounded-full transition-colors border border-white/10 hover:border-[#D4A356]/30">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                    </button>
                </div>
            </div>

            
            <div class="flex-1 overflow-y-auto min-h-0 cart-scroll">
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($items->isEmpty()): ?>
                    <div class="text-center py-16 text-gray-400 h-full flex flex-col items-center justify-center">
                        <div
                            class="w-24 h-24 rounded-full bg-white/5 flex items-center justify-center mb-6 border border-[#D4A356]/20">
                            <svg class="w-12 h-12 text-[#D4A356]/50" fill="none" stroke="currentColor"
                                viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                    d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z" />
                            </svg>
                        </div>
                        <p class="text-lg font-bold">سلة التسوق فارغة</p>
                        <p class="text-sm text-gray-500 mt-2">ابدأ التسوق الآن!</p>
                    </div>
                <?php else: ?>
                    <div class="p-4 space-y-3">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div wire:key="cart-item-<?php echo e($item['id']); ?>" x-data="{ qty: <?php echo e($item['quantity']); ?>, price: <?php echo e($item['unit_price']); ?> }"
                                class="relative bg-white/[0.03] rounded-xl p-4 border border-white/5 hover:border-[#D4A356]/30 transition-all group shadow-lg hover:shadow-[#D4A356]/5">

                                
                                <button @click="$wire.removeItem(<?php echo e($item['id']); ?>)"
                                    class="absolute top-3 left-3 w-7 h-7 flex items-center justify-center rounded-full bg-red-500/10 text-red-400/70 hover:bg-red-500/20 hover:text-red-400 transition-all opacity-0 group-hover:opacity-100">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                                    </svg>
                                </button>

                                <div class="flex gap-4">
                                    
                                    <div
                                        class="w-20 h-20 flex-shrink-0 rounded-xl overflow-hidden border-2 border-[#D4A356]/30 shadow-lg shadow-black/30 group-hover:border-[#D4A356]/50 transition-all">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($item['image']): ?>
                                            <img src="<?php echo e($item['image']); ?>" alt="<?php echo e($item['name']); ?>"
                                                class="w-full h-full object-cover">
                                        <?php else: ?>
                                            <div
                                                class="w-full h-full flex items-center justify-center bg-gradient-to-br from-white/5 to-white/[0.02] text-[#D4A356]/50">
                                                <svg class="w-8 h-8" fill="none" stroke="currentColor"
                                                    viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        stroke-width="1.5"
                                                        d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                                </svg>
                                            </div>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>

                                    
                                    <div class="flex-1 min-w-0 flex flex-col justify-between">
                                        <div>
                                            
                                            <a href="<?php echo e(route('shop.product', $item['slug'])); ?>"
                                                class="font-bold text-white hover:text-[#D4A356] transition-colors line-clamp-2 text-sm leading-tight">
                                                <?php echo e($item['name']); ?>

                                            </a>
                                            
                                            <p class="text-[11px] text-gray-500 mt-1 font-mono">
                                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($item['variant_name']): ?>
                                                    <?php echo e($item['variant_name']); ?>

                                                <?php else: ?>
                                                    SKU-<?php echo e(str_pad($item['id'], 4, '0', STR_PAD_LEFT)); ?>

                                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                            </p>
                                        </div>
                                        
                                        <p class="text-[#D4A356] font-black text-lg mt-2">
                                            <?php echo e($this->formatPrice($item['unit_price'])); ?>

                                        </p>
                                    </div>
                                </div>

                                
                                <div class="flex items-center justify-end mt-3 pt-3 border-t border-white/5">
                                    <div
                                        class="flex items-center bg-black/60 rounded-lg border border-white/10 overflow-hidden shadow-inner">
                                        <button
                                            @click="if(qty > 1) { qty--; $wire.updateQuantity(<?php echo e($item['id']); ?>, qty) }"
                                            class="w-9 h-9 flex items-center justify-center hover:bg-[#D4A356]/20 text-white/70 hover:text-[#D4A356] transition-all text-lg font-bold border-l border-white/10">
                                            −
                                        </button>
                                        <span class="w-10 text-center font-bold text-white text-base"
                                            x-text="qty"></span>
                                        <button @click="qty++; $wire.updateQuantity(<?php echo e($item['id']); ?>, qty)"
                                            class="w-9 h-9 flex items-center justify-center hover:bg-[#D4A356]/20 text-white/70 hover:text-[#D4A356] transition-all text-lg font-bold border-r border-white/10">
                                            +
                                        </button>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>

            
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($items->isNotEmpty()): ?>
                <div class="p-4 border-t border-[#D4A356]/20 shrink-0 bg-gradient-to-t from-black/50 to-transparent">
                    
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($availableCoupons->isNotEmpty()): ?>
                        <div class="mb-4 bg-white/5 rounded-xl p-3 border border-[#D4A356]/10">
                            <div class="flex items-center gap-2 mb-2">
                                <svg class="w-4 h-4 text-[#D4A356]" fill="none" stroke="currentColor"
                                    viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z" />
                                </svg>
                                <span class="text-white font-bold text-xs">كوبونات متاحة</span>
                            </div>
                            <div class="flex flex-wrap gap-2">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $availableCoupons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coupon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="flex items-center gap-2 px-2.5 py-1.5 bg-[#D4A356]/10 rounded-lg border border-[#D4A356]/20 cursor-pointer hover:bg-[#D4A356]/20 transition-colors group"
                                        onclick="navigator.clipboard.writeText('<?php echo e($coupon['code']); ?>'); this.querySelector('.copy-text').textContent = 'تم النسخ!'; setTimeout(() => this.querySelector('.copy-text').textContent = '<?php echo e($coupon['code']); ?>', 1500)">
                                        <span
                                            class="text-[#D4A356] font-bold text-xs copy-text"><?php echo e($coupon['code']); ?></span>
                                        <span class="text-gray-400 text-[10px]"><?php echo e($coupon['description']); ?></span>
                                        <svg class="w-3 h-3 text-gray-500 group-hover:text-[#D4A356] transition-colors"
                                            fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z" />
                                        </svg>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                    
                    <div class="mb-4 bg-white/5 rounded-xl p-3 border border-[#D4A356]/10">
                        <div class="flex items-center justify-between text-sm mb-2">
                            <span class="text-gray-300 font-bold">التوصيل المجاني</span>
                            <span class="text-gray-400 text-xs">حد: <span
                                    class="font-black text-[#D4A356]"><?php echo e(number_format($freeShippingThreshold, 0, '.', ',')); ?></span>
                                د.ع</span>
                        </div>
                        <div class="h-2 bg-white/10 rounded-full overflow-hidden">
                            <div class="h-full bg-gradient-to-r from-[#D4A356] to-[#F5D799] transition-all duration-300"
                                style="width: <?php echo e($shippingProgress); ?>%"></div>
                        </div>
                        <div class="mt-2 text-xs">
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($shippingProgress >= 100): ?>
                                <span class="text-green-400">🎉 لقد حصلت على التوصيل المجاني!</span>
                            <?php else: ?>
                                <span class="text-gray-400">أضف <span
                                        class="text-[#D4A356] font-bold"><?php echo e($this->formatPrice($remainingForFreeShipping)); ?></span>
                                    للتوصيل المجاني</span>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                    </div>

                    
                    <div class="space-y-2 mb-4">
                        <div class="flex items-center justify-between text-gray-400 text-sm">
                            <span>المجموع الفرعي</span>
                            <span class="text-white font-bold"><?php echo e($this->formatPrice($subtotal)); ?></span>
                        </div>
                        <div class="flex items-center justify-between text-gray-400 text-sm">
                            <span>الشحن</span>
                            <span
                                class="text-white font-bold"><?php echo e($shipping > 0 ? $this->formatPrice($shipping) : 'مجاني'); ?></span>
                        </div>
                        <div
                            class="flex items-center justify-between text-lg font-bold pt-2 border-t border-[#D4A356]/20">
                            <span>الإجمالي</span>
                            <span class="text-[#D4A356]"><?php echo e($this->formatPrice($total)); ?></span>
                        </div>
                    </div>

                    
                    <div class="space-y-3">
                        <div class="flex gap-3">
                            <a href="<?php echo e(route('checkout.index')); ?>"
                                class="flex-1 bg-gradient-to-r from-[#D4A356] to-[#442247] text-black py-3.5 rounded-xl font-bold text-center hover:shadow-lg hover:shadow-[#D4A356]/20 transition-all">
                                إتمام الطلب
                            </a>
                            <a href="<?php echo e(route('cart.index')); ?>"
                                class="flex-1 bg-white/5 text-white py-3.5 rounded-xl font-bold text-center border border-[#D4A356]/30 hover:bg-white/10 hover:border-[#D4A356]/50 transition-all">
                                عرض السلة
                            </a>
                        </div>
                        <button @click="open = false"
                            class="w-full text-center text-gray-400 hover:text-[#D4A356] transition-colors text-sm font-bold">
                            أو متابعة التسوق
                        </button>
                    </div>
                </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>
    </div>
</div>

<script>
    function cartDrawer() {
        return {
            open: false,

            addItemInstant(detail) {
                // Open drawer immediately
                this.open = true;

                // Dispatch to Livewire to add the item
                Livewire.dispatch('cart:add', {
                    id: detail.id,
                    qty: detail.quantity || 1,
                    variantId: detail.variantId || null
                });
            }
        };
    }
</script>
<?php /**PATH C:\Users\dante\Herd\nassaj\resources\views/livewire/store/cart-manager.blade.php ENDPATH**/ ?>