<div class="product-card group" x-data="{
    addToCart() {
        window.dispatchEvent(new CustomEvent('cart-add-instant', {
            detail: {
                id: <?php echo e($product->id); ?>,
                name: '<?php echo e(addslashes($product->name)); ?>',
                price: <?php echo e($price['current']); ?>,
                image: '<?php echo e($mainImg ?? ''); ?>'
            }
        }));
    },
    addToWishlist() {
        window.dispatchEvent(new CustomEvent('wishlist-add-instant', {
            detail: {
                id: <?php echo e($product->id); ?>,
                name: '<?php echo e(addslashes($product->name)); ?>',
                price: <?php echo e($price['current']); ?>,
                image: '<?php echo e($mainImg ?? ''); ?>'
            }
        }));
    },
    addToCompare() {
        window.dispatchEvent(new CustomEvent('compare-add-instant', {
            detail: {
                id: <?php echo e($product->id); ?>,
                name: '<?php echo e(addslashes($product->name)); ?>',
                price: <?php echo e($price['current']); ?>,
                image: '<?php echo e($mainImg ?? ''); ?>'
            }
        }));
    },
    quickView() {
        window.dispatchEvent(new CustomEvent('quickview-open', { detail: { productId: <?php echo e($product->id); ?> } }));
    },
    shareProduct() {
        const url = '<?php echo e(url()->current()); ?>/shop/product/<?php echo e($product->slug); ?>';
        if (navigator.share) {
            navigator.share({ 
                title: '<?php echo e(addslashes($product->name)); ?>',
                url: url 
            });
        } else {
            navigator.clipboard.writeText(url);
            alert('تم نسخ الرابط!');
        }
    }
}">
    <div class="relative overflow-hidden rounded-2xl bg-white dark:bg-[#1a1a1a] border border-gray-200 dark:border-white/10 hover:shadow-2xl transition-all duration-300 flex flex-col h-full">
        
        
        <a href="<?php echo e(route('shop.product', $product->slug)); ?>" class="block relative">
            
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($badge): ?>
                <span class="absolute top-3 right-3 z-10 px-3 py-1.5 rounded-full text-xs font-bold
                    <?php echo e($badgeType === 'sale' ? 'bg-red-500 text-white' : 'bg-purple-600 text-white'); ?>">
                    <?php echo e($badge); ?>

                </span>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            
            <div class="aspect-square overflow-hidden relative bg-gray-50 dark:bg-[#0f0f0f]">
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($mainImg): ?>
                    <img src="<?php echo e($mainImg); ?>" alt="<?php echo e($product->name); ?>" loading="lazy"
                        class="w-full h-full object-cover">
                <?php else: ?>
                    <div class="w-full h-full flex items-center justify-center">
                        <svg class="w-20 h-20 text-gray-300 dark:text-gray-700" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1"
                                d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z" />
                        </svg>
                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>

            
            <div class="absolute bottom-4 left-1/2 -translate-x-1/2 flex items-center gap-2 z-10">
                
                <button @click.prevent="quickView()"
                    class="w-12 h-12 rounded-full bg-white dark:bg-gray-800 shadow-lg flex items-center justify-center transition-all duration-200 hover:scale-110 hover:bg-nassaj-gold"
                    title="عرض سريع">
                    <svg class="w-5 h-5 text-gray-700 dark:text-white" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M2.036 12.322a1.012 1.012 0 010-.639C3.423 7.51 7.36 4.5 12 4.5c4.638 0 8.573 3.007 9.963 7.178.07.207.07.431 0 .639C20.577 16.49 16.64 19.5 12 19.5c-4.638 0-8.573-3.007-9.963-7.178z" />
                        <path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                    </svg>
                </button>

                
                <button @click.prevent="addToCompare()"
                    class="w-12 h-12 rounded-full bg-white dark:bg-gray-800 shadow-lg flex items-center justify-center transition-all duration-200 hover:scale-110 hover:bg-nassaj-gold"
                    title="مقارنة">
                    <svg class="w-5 h-5 text-gray-700 dark:text-white" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M3 13.125C3 12.504 3.504 12 4.125 12h2.25c.621 0 1.125.504 1.125 1.125v6.75C7.5 20.496 6.996 21 6.375 21h-2.25A1.125 1.125 0 013 19.875v-6.75zM9.75 8.625c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125v11.25c0 .621-.504 1.125-1.125 1.125h-2.25a1.125 1.125 0 01-1.125-1.125V8.625zM16.5 4.125c0-.621.504-1.125 1.125-1.125h2.25C20.496 3 21 3.504 21 4.125v15.75c0 .621-.504 1.125-1.125 1.125h-2.25a1.125 1.125 0 01-1.125-1.125V4.125z" />
                    </svg>
                </button>

                
                <button @click.prevent="addToWishlist()"
                    class="w-12 h-12 rounded-full bg-white dark:bg-gray-800 shadow-lg flex items-center justify-center transition-all duration-200 hover:scale-110 hover:bg-nassaj-gold"
                    title="المفضلة">
                    <svg class="w-5 h-5 text-gray-700 dark:text-white" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M21 8.25c0-2.485-2.099-4.5-4.688-4.5-1.935 0-3.597 1.126-4.312 2.733-.715-1.607-2.377-2.733-4.313-2.733C5.1 3.75 3 5.765 3 8.25c0 7.22 9 12 9 12s9-4.78 9-12z" />
                    </svg>
                </button>
            </div>
        </a>

        
        <div class="p-4 flex flex-col flex-1">
            
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($product->brand): ?>
                <p class="text-gray-500 dark:text-gray-400 text-xs mb-2"><?php echo e($product->brand->name); ?></p>
            <?php elseif($product->category): ?>
                <p class="text-gray-500 dark:text-gray-400 text-xs mb-2"><?php echo e($product->category->name); ?></p>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            
            <a href="<?php echo e(route('shop.product', $product->slug)); ?>" class="mb-2">
                <h3 class="text-gray-900 dark:text-white font-bold text-base leading-tight line-clamp-2 hover:text-nassaj-gold transition-colors cairo">
                    <?php echo e($product->name); ?>

                </h3>
            </a>

            
            <div class="flex items-center gap-1 mb-3">
                <?php
                    $rating = 4.8; // يمكن استبدالها بالتقييم الفعلي
                ?>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php for($i = 1; $i <= 5; $i++): ?>
                    <svg class="w-4 h-4 <?php echo e($i <= $rating ? 'text-yellow-400' : 'text-gray-300 dark:text-gray-600'); ?>" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                    </svg>
                <?php endfor; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                <span class="text-gray-600 dark:text-gray-400 text-xs mr-1">(<?php echo e($rating); ?>)</span>
            </div>

            
            <div class="flex-1"></div>

            
            <div class="mb-4">
                <div class="flex items-baseline gap-2">
                    <span class="text-nassaj-gold font-black text-xl cairo"><?php echo e($this->formatIQD($price['current'])); ?></span>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($price['old'] > 0): ?>
                        <span class="text-gray-400 dark:text-gray-500 text-sm line-through"><?php echo e($this->formatIQD($price['old'])); ?></span>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>
            </div>

            
            <button @click="addToCart()"
                class="w-full bg-nassaj-gold hover:bg-nassaj-gold-dark text-nassaj-primary py-3 rounded-xl font-bold text-base transition-all duration-300 hover:shadow-lg flex items-center justify-center gap-2">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2.5" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M2.25 3h1.386c.51 0 .955.343 1.087.835l.383 1.437M7.5 14.25a3 3 0 00-3 3h15.75m-12.75-3h11.218c1.121-2.3 2.1-4.684 2.924-7.138a60.114 60.114 0 00-16.536-1.84M7.5 14.25L5.106 5.272M6 20.25a.75.75 0 11-1.5 0 .75.75 0 011.5 0zm12.75 0a.75.75 0 11-1.5 0 .75.75 0 011.5 0z" />
                </svg>
                <span>أضف للسلة</span>
            </button>
        </div>
    </div>
</div>
<?php /**PATH C:\Users\dante\Herd\nassaj\resources\views/livewire/products/product-card.blade.php ENDPATH**/ ?>