<?php $__env->startSection('title', 'العروض الخاصة - نساج'); ?>
<?php $__env->startSection('page', 'offers'); ?>

<?php $__env->startSection('content'); ?>
    
    <section class="relative overflow-hidden bg-gradient-to-br from-[#442247] via-[#2d1635] to-[#140616]">
        <div class="site-container py-20">
            
            <div class="absolute inset-0 opacity-30">
                <div class="absolute top-0 right-0 w-96 h-96 bg-nassaj-gold/20 rounded-full blur-3xl"></div>
                <div class="absolute bottom-0 left-0 w-96 h-96 bg-purple-500/20 rounded-full blur-3xl"></div>
            </div>

            <div class="relative z-10 text-center">
                
                <div class="inline-flex items-center gap-2 px-6 py-3 bg-nassaj-gold/10 border border-nassaj-gold/30 rounded-full mb-6">
                    <svg class="w-5 h-5 text-nassaj-gold" fill="none" stroke="currentColor" stroke-width="2"
                        viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round"
                            d="M9.568 3H5.25A2.25 2.25 0 003 5.25v4.318c0 .597.237 1.17.659 1.591l9.581 9.581c.699.699 1.78.872 2.607.33a18.095 18.095 0 005.223-5.223c.542-.827.369-1.908-.33-2.607L11.16 3.66A2.25 2.25 0 009.568 3z" />
                        <path stroke-linecap="round" stroke-linejoin="round" d="M6 6h.008v.008H6V6z" />
                    </svg>
                    <span class="text-nassaj-gold font-bold text-sm">عروض حصرية</span>
                </div>

                
                <h1 class="cairo text-5xl md:text-7xl font-black text-white mb-6 leading-tight">
                    العروض <span class="text-nassaj-gold">الخاصة</span>
                </h1>

                <p class="text-xl text-white/80 max-w-2xl mx-auto mb-8 leading-relaxed">
                    اكتشف أفضل العروض والخصومات على منتجاتنا المميزة
                </p>

                
                <div class="flex items-center justify-center gap-8 text-white">
                    <div>
                        <div class="text-3xl font-black text-nassaj-gold"><?php echo e($products->total()); ?></div>
                        <div class="text-sm text-white/60">منتج بعرض خاص</div>
                    </div>
                    <div class="w-px h-12 bg-white/20"></div>
                    <div>
                        <div class="text-3xl font-black text-nassaj-gold"><?php echo e($categories->count()); ?></div>
                        <div class="text-sm text-white/60">تصنيف</div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    
    <section class="py-12 bg-white dark:bg-[#0a0a0a] min-h-screen">
        <div class="site-container">
            
            <div class="mb-8 flex flex-col md:flex-row gap-4 items-start md:items-center justify-between">
                
                <div class="flex flex-wrap gap-3 items-center">
                    
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($categories->count() > 0): ?>
                        <div class="relative" x-data="{ open: false }">
                            <button @click="open = !open" @click.away="open = false"
                                class="flex items-center gap-2 px-4 py-2.5 bg-white dark:bg-white/5 border border-gray-200 dark:border-white/10 rounded-xl text-sm font-medium text-gray-700 dark:text-white hover:border-nassaj-gold dark:hover:border-nassaj-gold transition-colors">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" stroke-width="2"
                                    viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round"
                                        d="M3.75 6.75h16.5M3.75 12h16.5m-16.5 5.25h16.5" />
                                </svg>
                                <span>التصنيفات</span>
                                <svg class="w-4 h-4 transition-transform" :class="{ 'rotate-180': open }" fill="none"
                                    stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M19 9l-7 7-7-7" />
                                </svg>
                            </button>

                            <div x-show="open" x-transition
                                class="absolute top-full left-0 mt-2 w-56 bg-white dark:bg-[#1a1a1a] border border-gray-200 dark:border-white/10 rounded-2xl shadow-xl z-50 py-2">
                                <a href="<?php echo e(route('offers')); ?>"
                                    class="block px-4 py-2.5 text-sm text-gray-700 dark:text-white hover:bg-gray-50 dark:hover:bg-white/5 transition-colors <?php echo e(!request('category') ? 'text-nassaj-gold font-bold' : ''); ?>">
                                    جميع التصنيفات
                                </a>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <a href="<?php echo e(route('offers', ['category' => $category->id])); ?>"
                                        class="flex items-center justify-between px-4 py-2.5 text-sm text-gray-700 dark:text-white hover:bg-gray-50 dark:hover:bg-white/5 transition-colors <?php echo e(request('category') == $category->id ? 'text-nassaj-gold font-bold bg-nassaj-gold/5' : ''); ?>">
                                        <span><?php echo e($category->name); ?></span>
                                        <span
                                            class="text-xs text-gray-400 dark:text-gray-500"><?php echo e($category->products_count); ?></span>
                                    </a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                    
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($brands->count() > 0): ?>
                        <div class="relative" x-data="{ open: false }">
                            <button @click="open = !open" @click.away="open = false"
                                class="flex items-center gap-2 px-4 py-2.5 bg-white dark:bg-white/5 border border-gray-200 dark:border-white/10 rounded-xl text-sm font-medium text-gray-700 dark:text-white hover:border-nassaj-gold dark:hover:border-nassaj-gold transition-colors">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" stroke-width="2"
                                    viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round"
                                        d="M9.568 3H5.25A2.25 2.25 0 003 5.25v4.318c0 .597.237 1.17.659 1.591l9.581 9.581c.699.699 1.78.872 2.607.33a18.095 18.095 0 005.223-5.223c.542-.827.369-1.908-.33-2.607L11.16 3.66A2.25 2.25 0 009.568 3z" />
                                </svg>
                                <span>الماركات</span>
                                <svg class="w-4 h-4 transition-transform" :class="{ 'rotate-180': open }" fill="none"
                                    stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M19 9l-7 7-7-7" />
                                </svg>
                            </button>

                            <div x-show="open" x-transition
                                class="absolute top-full left-0 mt-2 w-56 bg-white dark:bg-[#1a1a1a] border border-gray-200 dark:border-white/10 rounded-2xl shadow-xl z-50 py-2">
                                <a href="<?php echo e(route('offers')); ?>"
                                    class="block px-4 py-2.5 text-sm text-gray-700 dark:text-white hover:bg-gray-50 dark:hover:bg-white/5 transition-colors <?php echo e(!request('brand') ? 'text-nassaj-gold font-bold' : ''); ?>">
                                    جميع الماركات
                                </a>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <a href="<?php echo e(route('offers', ['brand' => $brand->id])); ?>"
                                        class="flex items-center justify-between px-4 py-2.5 text-sm text-gray-700 dark:text-white hover:bg-gray-50 dark:hover:bg-white/5 transition-colors <?php echo e(request('brand') == $brand->id ? 'text-nassaj-gold font-bold bg-nassaj-gold/5' : ''); ?>">
                                        <span><?php echo e($brand->name); ?></span>
                                        <span
                                            class="text-xs text-gray-400 dark:text-gray-500"><?php echo e($brand->products_count); ?></span>
                                    </a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>

                
                <div class="flex items-center gap-3">
                    <label class="text-sm text-gray-600 dark:text-gray-400">ترتيب حسب:</label>
                    <select onchange="window.location.href = this.value"
                        class="px-4 py-2.5 bg-white dark:bg-white/5 border border-gray-200 dark:border-white/10 rounded-xl text-sm font-medium text-gray-700 dark:text-white focus:ring-2 focus:ring-nassaj-gold focus:border-transparent transition-all">
                        <option value="<?php echo e(route('offers', array_merge(request()->except('sort'), ['sort' => 'newest']))); ?>"
                            <?php echo e(request('sort', 'newest') == 'newest' ? 'selected' : ''); ?>>
                            الأحدث
                        </option>
                        <option
                            value="<?php echo e(route('offers', array_merge(request()->except('sort'), ['sort' => 'discount_high']))); ?>"
                            <?php echo e(request('sort') == 'discount_high' ? 'selected' : ''); ?>>
                            الخصم الأعلى
                        </option>
                        <option
                            value="<?php echo e(route('offers', array_merge(request()->except('sort'), ['sort' => 'price_asc']))); ?>"
                            <?php echo e(request('sort') == 'price_asc' ? 'selected' : ''); ?>>
                            السعر: من الأقل للأعلى
                        </option>
                        <option
                            value="<?php echo e(route('offers', array_merge(request()->except('sort'), ['sort' => 'price_desc']))); ?>"
                            <?php echo e(request('sort') == 'price_desc' ? 'selected' : ''); ?>>
                            السعر: من الأعلى للأقل
                        </option>
                        <option
                            value="<?php echo e(route('offers', array_merge(request()->except('sort'), ['sort' => 'name_asc']))); ?>"
                            <?php echo e(request('sort') == 'name_asc' ? 'selected' : ''); ?>>
                            الاسم: أ-ي
                        </option>
                        <option
                            value="<?php echo e(route('offers', array_merge(request()->except('sort'), ['sort' => 'name_desc']))); ?>"
                            <?php echo e(request('sort') == 'name_desc' ? 'selected' : ''); ?>>
                            الاسم: ي-أ
                        </option>
                    </select>
                </div>
            </div>

            
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($products->count() > 0): ?>
                <div class="grid grid-cols-2 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-4 md:gap-6 mb-12">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('products.product-card', ['productId' => $product->id]);

$key = 'offer-'.e($product->id).'';

$key ??= \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::generateKey('lw-499596511-0', 'offer-'.e($product->id).'');

$__html = app('livewire')->mount($__name, $__params, $key);

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>

                
                <div class="mt-12">
                    <?php echo e($products->links()); ?>

                </div>
            <?php else: ?>
                
                <div class="text-center py-20">
                    <div
                        class="w-24 h-24 mx-auto mb-6 rounded-full bg-gray-100 dark:bg-white/5 flex items-center justify-center">
                        <svg class="w-12 h-12 text-gray-400 dark:text-gray-600" fill="none" stroke="currentColor"
                            stroke-width="1.5" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M9.568 3H5.25A2.25 2.25 0 003 5.25v4.318c0 .597.237 1.17.659 1.591l9.581 9.581c.699.699 1.78.872 2.607.33a18.095 18.095 0 005.223-5.223c.542-.827.369-1.908-.33-2.607L11.16 3.66A2.25 2.25 0 009.568 3z" />
                            <path stroke-linecap="round" stroke-linejoin="round" d="M6 6h.008v.008H6V6z" />
                        </svg>
                    </div>
                    <h3 class="cairo text-2xl font-bold text-gray-900 dark:text-white mb-2">
                        لا توجد عروض حالياً
                    </h3>
                    <p class="text-gray-600 dark:text-gray-400 mb-8">
                        تابعنا للحصول على آخر العروض والخصومات
                    </p>
                    <a href="<?php echo e(route('shop')); ?>"
                        class="inline-flex items-center gap-2 px-8 py-4 bg-nassaj-gold text-black rounded-full font-bold hover:bg-nassaj-gold-light transition-all duration-300 hover:scale-105">
                        <span>تصفح المتجر</span>
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7" />
                        </svg>
                    </a>
                </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>
    </section>

    
    <section class="py-12 bg-gray-50 dark:bg-[#111111]">
        <div class="site-container">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                
                <div class="flex items-start gap-4 p-6 rounded-2xl bg-white dark:bg-white/5">
                    <div
                        class="w-12 h-12 rounded-xl bg-nassaj-gold/10 flex items-center justify-center text-nassaj-gold shrink-0">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M9 12.75L11.25 15 15 9.75M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                    </div>
                    <div>
                        <h3 class="text-lg font-bold text-gray-900 dark:text-white mb-2">ضمان الجودة</h3>
                        <p class="text-sm text-gray-600 dark:text-gray-400">جميع المنتجات أصلية 100%</p>
                    </div>
                </div>

                
                <div class="flex items-start gap-4 p-6 rounded-2xl bg-white dark:bg-white/5">
                    <div
                        class="w-12 h-12 rounded-xl bg-nassaj-gold/10 flex items-center justify-center text-nassaj-gold shrink-0">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M8.25 18.75a1.5 1.5 0 01-3 0m3 0a1.5 1.5 0 00-3 0m3 0h6m-9 0H3.375a1.125 1.125 0 01-1.125-1.125V14.25m17.25 4.5a1.5 1.5 0 01-3 0m3 0a1.5 1.5 0 00-3 0m3 0h1.125c.621 0 1.129-.504 1.09-1.124a17.902 17.902 0 00-3.213-9.193 2.056 2.056 0 00-1.58-.86H14.25M16.5 18.75h-2.25m0-11.177v-.958c0-.568-.422-1.048-.987-1.106a48.554 48.554 0 00-10.026 0 1.106 1.106 0 00-.987 1.106v7.635m12-6.677v6.677m0 4.5v-4.5m0 0h-12" />
                        </svg>
                    </div>
                    <div>
                        <h3 class="text-lg font-bold text-gray-900 dark:text-white mb-2">شحن سريع</h3>
                        <p class="text-sm text-gray-600 dark:text-gray-400">توصيل سريع لجميع المحافظات</p>
                    </div>
                </div>

                
                <div class="flex items-start gap-4 p-6 rounded-2xl bg-white dark:bg-white/5">
                    <div
                        class="w-12 h-12 rounded-xl bg-nassaj-gold/10 flex items-center justify-center text-nassaj-gold shrink-0">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M16.023 9.348h4.992v-.001M2.985 19.644v-4.992m0 0h4.992m-4.993 0l3.181 3.183a8.25 8.25 0 0013.803-3.7M4.031 9.865a8.25 8.25 0 0113.803-3.7l3.181 3.182" />
                        </svg>
                    </div>
                    <div>
                        <h3 class="text-lg font-bold text-gray-900 dark:text-white mb-2">إرجاع مجاني</h3>
                        <p class="text-sm text-gray-600 dark:text-gray-400">خلال 14 يوم من الاستلام</p>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\dante\Herd\nassaj\resources\views/offers.blade.php ENDPATH**/ ?>