<!DOCTYPE html>
<html lang="ar" dir="rtl" class="scroll-smooth">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="نساج - متجر إلكتروني للمنتجات الفاخرة">
    <title>نساج - الرئيسية</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>

<body class="bg-gradient-to-b from-[#1a0a1e] via-[#2d1635] to-[#1a0a1e] text-white antialiased min-h-screen">

    <!-- Header -->
    <x-nassaj.header />
    <!-- Hero Section -->
    <section class="relative overflow-hidden py-16 md:py-24" dir="rtl">
        <div class="absolute inset-0 bg-gradient-to-br from-nassaj-purple/20 via-transparent to-nassaj-gold/10"></div>
        <div class="site-container relative z-10">
            <div class="max-w-3xl mx-auto text-center space-y-8">
                <div
                    class="inline-block px-6 py-2 rounded-full bg-nassaj-gold/20 border border-nassaj-gold/40 backdrop-blur-sm">
                    <span class="text-nassaj-gold font-semibold">✨ مجموعة جديدة</span>
                </div>
                <h1 class="text-5xl md:text-7xl font-black leading-tight">
                    <span class="block text-white">جوائز فاخرة</span>
                    <span class="block gradient-text">بأقل عراقية</span>
                </h1>
                <p class="text-xl md:text-2xl text-gray-300 leading-relaxed max-w-2xl mx-auto">
                    اكتشف مجموعتنا الحصرية من المنتجات الفاخرة بأسعار لا تقاوم
                </p>
                <div class="flex flex-col sm:flex-row items-center justify-center gap-4">
                    <x-nassaj.button href="/shop" size="lg" class="w-full sm:w-auto text-lg px-8">
                        تسوق الآن
                        <svg class="h-5 w-5" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                            stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                        </svg>
                    </x-nassaj.button>
                    <x-nassaj.button href="/categories" variant="secondary" size="lg"
                        class="w-full sm:w-auto text-lg px-8">
                        استكشف الأقسام
                    </x-nassaj.button>
                </div>
            </div>
        </div>

        <!-- Decorative Elements -->
        <div class="absolute top-20 right-10 w-32 h-32 bg-nassaj-gold/10 rounded-full blur-3xl"></div>
        <div class="absolute bottom-20 left-10 w-40 h-40 bg-nassaj-purple/20 rounded-full blur-3xl"></div>
    </section>

    <!-- Categories Section -->
    <section class="py-8 border-y border-nassaj-gold/20" dir="rtl">
        <div class="site-container">
            <div class="flex overflow-x-auto gap-4 pb-2 scrollbar-hide">
                @foreach (['جميع المنتجات', 'حقائب يد', 'أحذية', 'ملابس', 'إكسسوارات', 'مجوهرات'] as $category)
                    <button
                        class="flex-shrink-0 px-6 py-3 rounded-xl bg-white/5 hover:bg-nassaj-gold/20 border border-white/10 hover:border-nassaj-gold/40 transition-all duration-300 whitespace-nowrap font-semibold">
                        {{ $category }}
                    </button>
                @endforeach
            </div>
        </div>
    </section>

    <!-- Featured Collection -->
    <section class="py-12 md:py-20" dir="rtl">
        <div class="site-container">
            <div class="flex items-center justify-between mb-8">
                <div>
                    <h2 class="text-3xl md:text-4xl font-black text-white mb-2">تشكيلتنا المميزة</h2>
                    <p class="text-gray-400">أفضل المنتجات المختارة بعناية</p>
                </div>
                <a href="/shop"
                    class="hidden md:flex items-center gap-2 text-nassaj-gold hover:text-nassaj-gold-light transition-colors font-semibold">
                    <span>عرض الكل</span>
                    <svg class="h-5 w-5" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                    </svg>
                </a>
            </div>

            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
                @php
                    $featuredProducts = [
                        [
                            'name' => 'حقيبة يد جلدية فاخرة',
                            'price' => 250000,
                            'old' => 350000,
                            'badge' => 'تخفيض',
                            'type' => 'sale',
                            'image' => 'bag-orange.jpg',
                        ],
                        [
                            'name' => 'حذاء رياضي أحمر',
                            'price' => 180000,
                            'badge' => 'جديد',
                            'type' => 'new',
                            'image' => 'shoe-red.jpg',
                        ],
                        [
                            'name' => 'معطف شتوي أنيق',
                            'price' => 320000,
                            'old' => 420000,
                            'badge' => 'تخفيض',
                            'type' => 'sale',
                            'image' => 'coat-gray.jpg',
                        ],
                        [
                            'name' => 'جوارب ملونة عصرية',
                            'price' => 45000,
                            'badge' => 'وصل حديثاً',
                            'type' => 'hot',
                            'image' => 'socks-pattern.jpg',
                        ],
                    ];
                @endphp

                @foreach ($featuredProducts as $product)
                    <x-nassaj.product-card-dark :image="'https://via.placeholder.com/400x400/442247/CCBF79?text=' . urlencode($product['name'])" :name="$product['name']" :price="$product['price']" :old-price="$product['old'] ?? null"
                        :badge="['text' => $product['badge'], 'type' => $product['type']]" :rating="rand(40, 50) / 10" />
                @endforeach
            </div>

            <div class="text-center mt-8 md:hidden">
                <a href="/shop"
                    class="inline-flex items-center gap-2 text-nassaj-gold hover:text-nassaj-gold-light transition-colors font-semibold">
                    <span>عرض جميع المنتجات</span>
                    <svg class="h-5 w-5" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                    </svg>
                </a>
            </div>
        </div>
    </section>

    <!-- Best Sellers -->
    <section class="py-12 md:py-20 bg-black/20" dir="rtl">
        <div class="site-container">
            <div class="flex items-center justify-between mb-8">
                <div>
                    <h2 class="text-3xl md:text-4xl font-black text-white mb-2">الأكثر مبيعاً</h2>
                    <p class="text-gray-400">المنتجات الأكثر طلباً</p>
                </div>
                <a href="/shop?sort=bestsellers"
                    class="hidden md:flex items-center gap-2 text-nassaj-gold hover:text-nassaj-gold-light transition-colors font-semibold">
                    <span>عرض الكل</span>
                    <svg class="h-5 w-5" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                    </svg>
                </a>
            </div>

            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
                @php
                    $bestSellers = [
                        [
                            'name' => 'حقيبة يد كلاسيكية',
                            'price' => 280000,
                            'old' => 380000,
                            'badge' => 'أفضل مبيع',
                            'type' => 'hot',
                        ],
                        ['name' => 'حذاء جلدي أخضر', 'price' => 220000, 'badge' => 'مميز', 'type' => 'new'],
                        [
                            'name' => 'حذاء رياضي بنفسجي',
                            'price' => 195000,
                            'old' => 245000,
                            'badge' => 'تخفيض',
                            'type' => 'sale',
                        ],
                        ['name' => 'حذاء رياضي أحمر كلاسيك', 'price' => 185000, 'badge' => 'شائع', 'type' => 'hot'],
                    ];
                @endphp

                @foreach ($bestSellers as $product)
                    <x-nassaj.product-card-dark :image="'https://via.placeholder.com/400x400/442247/CCBF79?text=' . urlencode($product['name'])" :name="$product['name']" :price="$product['price']" :old-price="$product['old'] ?? null"
                        :badge="['text' => $product['badge'], 'type' => $product['type']]" :rating="rand(42, 50) / 10" />
                @endforeach
            </div>
        </div>
    </section>

    <!-- New Arrivals -->
    <section class="py-12 md:py-20" dir="rtl">
        <div class="site-container">
            <div class="flex items-center justify-between mb-8">
                <div>
                    <h2 class="text-3xl md:text-4xl font-black text-white mb-2">وصل حديثاً</h2>
                    <p class="text-gray-400">أحدث إضافاتنا</p>
                </div>
                <a href="/shop?sort=newest"
                    class="hidden md:flex items-center gap-2 text-nassaj-gold hover:text-nassaj-gold-light transition-colors font-semibold">
                    <span>عرض الكل</span>
                    <svg class="h-5 w-5" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                    </svg>
                </a>
            </div>

            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
                @php
                    $newArrivals = [
                        ['name' => 'حذاء رياضي متعدد الألوان', 'price' => 175000, 'badge' => 'جديد', 'type' => 'new'],
                        [
                            'name' => 'حذاء جلدي كلاسيكي',
                            'price' => 240000,
                            'old' => 290000,
                            'badge' => 'وصل حديثاً',
                            'type' => 'hot',
                        ],
                        ['name' => 'حذاء رياضي أحمر مميز', 'price' => 190000, 'badge' => 'جديد', 'type' => 'new'],
                        [
                            'name' => 'معطف بني أنيق',
                            'price' => 310000,
                            'old' => 390000,
                            'badge' => 'تخفيض',
                            'type' => 'sale',
                        ],
                    ];
                @endphp

                @foreach ($newArrivals as $product)
                    <x-nassaj.product-card-dark :image="'https://via.placeholder.com/400x400/442247/CCBF79?text=' . urlencode($product['name'])" :name="$product['name']" :price="$product['price']"
                        :old-price="$product['old'] ?? null" :badge="['text' => $product['badge'], 'type' => $product['type']]" :rating="rand(38, 50) / 10" />
                @endforeach
            </div>
        </div>
    </section>

    <!-- Special Offers -->
    <section class="py-12 md:py-20 bg-black/20" dir="rtl">
        <div class="site-container">
            <div class="flex items-center justify-between mb-8">
                <div>
                    <h2 class="text-3xl md:text-4xl font-black text-white mb-2">عروض مميزة</h2>
                    <p class="text-gray-400">خصومات حصرية</p>
                </div>
                <a href="/shop?filter=sale"
                    class="hidden md:flex items-center gap-2 text-nassaj-gold hover:text-nassaj-gold-light transition-colors font-semibold">
                    <span>عرض الكل</span>
                    <svg class="h-5 w-5" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                    </svg>
                </a>
            </div>

            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
                @php
                    $specialOffers = [
                        [
                            'name' => 'حقيبة يد جلدية فاخرة',
                            'price' => 260000,
                            'old' => 360000,
                            'badge' => 'خصم 28%',
                            'type' => 'sale',
                        ],
                        [
                            'name' => 'جوارب ملونة مميزة',
                            'price' => 48000,
                            'old' => 68000,
                            'badge' => 'خصم 30%',
                            'type' => 'sale',
                        ],
                        [
                            'name' => 'معطف شتوي بني',
                            'price' => 295000,
                            'old' => 395000,
                            'badge' => 'خصم 25%',
                            'type' => 'sale',
                        ],
                        [
                            'name' => 'جوارب عصرية بألوان زاهية',
                            'price' => 42000,
                            'old' => 62000,
                            'badge' => 'خصم 32%',
                            'type' => 'sale',
                        ],
                    ];
                @endphp

                @foreach ($specialOffers as $product)
                    <x-nassaj.product-card-dark :image="'https://via.placeholder.com/400x400/442247/CCBF79?text=' . urlencode($product['name'])" :name="$product['name']" :price="$product['price']"
                        :old-price="$product['old']" :badge="['text' => $product['badge'], 'type' => $product['type']]" :rating="rand(40, 50) / 10" />
                @endforeach
            </div>
        </div>
    </section>

    <!-- Newsletter Section -->
    <section class="py-16 bg-gradient-to-r from-nassaj-purple via-nassaj-purple-dark to-nassaj-purple" dir="rtl">
        <div class="site-container">
            <div class="max-w-2xl mx-auto text-center space-y-6">
                <h2 class="text-3xl md:text-4xl font-black text-white">اشترك في نشرتنا البريدية</h2>
                <p class="text-lg text-gray-300">احصل على آخر العروض والتحديثات مباشرة في بريدك</p>
                <div class="flex flex-col sm:flex-row gap-3 max-w-md mx-auto">
                    <input type="email" placeholder="أدخل بريدك الإلكتروني"
                        class="flex-1 px-6 py-4 rounded-xl bg-white/10 border border-white/20 text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-nassaj-gold focus:border-transparent">
                    <x-nassaj.button size="lg" class="sm:w-auto">
                        اشتراك
                    </x-nassaj.button>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <x-nassaj.footer />

    <!-- Toast Container -->
    <x-nassaj.toast />

    <!-- Mobile Bottom Nav -->
    <x-nassaj.mobile-bottom-nav />

    <!-- JavaScript -->
    <script src="{{ asset('js/nassaj-ui.js') }}"></script>
</body>

</html>
