@extends('layouts.master')

@section('title', $category->name . ' - نساج')
@section('page', 'category')

@section('content')
    {{-- Category Banner --}}
    <x-store-banner 
        :title="$category->name"
        :subtitle="'استكشف منتجات ' . $category->name . ' مع تشكيلة واسعة من الخيارات'"
        type="category"
    />

    {{-- Breadcrumbs --}}
    <div class="bg-gray-50 dark:bg-[#0f0f0f] border-b border-gray-200 dark:border-white/5">
        <div class="site-container py-4">
            <nav class="flex items-center gap-2 text-sm">
                <a href="{{ route('home') }}" class="text-gray-600 dark:text-gray-400 hover:text-nassaj-gold transition-colors">الرئيسية</a>
                <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                </svg>
                <a href="{{ route('shop') }}" class="text-gray-600 dark:text-gray-400 hover:text-nassaj-gold transition-colors">المتجر</a>
                @foreach($breadcrumbs as $crumb)
                    <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                    </svg>
                    @if($loop->last)
                        <span class="text-nassaj-gold font-bold">{{ $crumb->name }}</span>
                    @else
                        <a href="{{ route('category.show', $crumb->slug) }}" class="text-gray-600 dark:text-gray-400 hover:text-nassaj-gold transition-colors">{{ $crumb->name }}</a>
                    @endif
                @endforeach
            </nav>
        </div>
    </div>

    {{-- Subcategories Section --}}
    @if($subcategories->isNotEmpty())
        <section class="py-12 bg-white dark:bg-[#0a0a0a]">
            <div class="site-container">
                <div class="text-center mb-10">
                    <span class="inline-block px-4 py-2 bg-nassaj-gold/10 text-nassaj-gold rounded-full text-sm font-bold mb-4">
                        التصنيفات الفرعية
                    </span>
                    <h2 class="cairo text-2xl md:text-3xl font-black text-gray-900 dark:text-white">
                        تصنيفات <span class="text-nassaj-gold">{{ $category->name }}</span>
                    </h2>
                </div>

                <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-4 md:gap-6">
                    @foreach($subcategories as $subcategory)
                        <a href="{{ route('category.show', $subcategory->slug) }}" 
                           class="group relative overflow-hidden rounded-2xl bg-white dark:bg-[#111111] border border-gray-200 dark:border-white/5 p-6 text-center hover:shadow-xl hover:-translate-y-1 transition-all duration-300">
                            <div class="w-14 h-14 mx-auto mb-3 rounded-xl bg-nassaj-gold/10 flex items-center justify-center group-hover:bg-nassaj-gold/20 transition-colors">
                                <svg class="w-7 h-7 text-nassaj-gold" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4" />
                                </svg>
                            </div>
                            <h3 class="text-gray-900 dark:text-white font-bold text-sm mb-1 group-hover:text-nassaj-gold transition-colors">{{ $subcategory->name }}</h3>
                            <p class="text-gray-500 dark:text-gray-400 text-xs">{{ $subcategory->products_count }} منتج</p>
                        </a>
                    @endforeach
                </div>
            </div>
        </section>
    @endif

    {{-- Products Section --}}
    <section class="py-12 bg-gray-50 dark:bg-[#0f0f0f]">
        <div class="site-container">
            <div class="text-center mb-10">
                <span class="inline-block px-4 py-2 bg-nassaj-gold/10 text-nassaj-gold rounded-full text-sm font-bold mb-4">
                    المنتجات
                </span>
                <h2 class="cairo text-2xl md:text-3xl font-black text-gray-900 dark:text-white">
                    منتجات <span class="text-nassaj-gold">{{ $category->name }}</span>
                </h2>
            </div>

            {{-- Livewire Product Grid with category pre-selected --}}
            <livewire:store.product-grid :category-id="$category->id" />
        </div>
    </section>
@endsection

