<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>فاتورة طلب - {{ $order->order_number }}</title>
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        :root {
            --primary: {{ $css_vars['--primary'] ?? '#006837' }};
            --primary-400: {{ $css_vars['--primary-400'] ?? '#1F7A52' }};
            --primary-700: {{ $css_vars['--primary-700'] ?? '#00512B' }};
            --text: {{ $css_vars['--text'] ?? '#0A3326' }};
            --text-muted: {{ $css_vars['--text-muted'] ?? '#7E8B86' }};
            --surface: {{ $css_vars['--surface'] ?? '#FFFFFF' }};
            --surface-field: {{ $css_vars['--surface-field'] ?? '#E9ECEF' }};
            --surface-pill: {{ $css_vars['--surface-pill'] ?? '#F3F5F4' }};
            --border: {{ $css_vars['--border'] ?? '#DDE6E1' }};
        }

        body {
            font-family: 'Cairo', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: white;
            color: var(--text);
            padding: 20mm;
            font-size: 11pt;
        }

        .invoice-container {
            max-width: 210mm;
            margin: 0 auto;
            background: white;
        }

        /* Header */
        .invoice-header {
            display: flex;
            justify-content: space-between;
            align-items: start;
            padding: 20px;
            background: linear-gradient(135deg, var(--surface-field), var(--surface));
            border-bottom: 3px solid var(--primary);
            margin-bottom: 30px;
        }

        .header-right {
            text-align: right;
        }

        .logo {
            width: 80px;
            height: 80px;
            object-fit: contain;
            margin-bottom: 10px;
        }

        .branch-name {
            font-size: 20pt;
            font-weight: 900;
            color: var(--primary);
            margin-bottom: 5px;
        }

        .branch-info {
            font-size: 9pt;
            color: var(--text-muted);
            line-height: 1.6;
        }

        .header-left {
            text-align: left;
        }

        .invoice-title {
            font-size: 22pt;
            font-weight: 900;
            color: var(--primary);
            margin-bottom: 10px;
        }

        .invoice-meta {
            font-size: 10pt;
            color: var(--text-muted);
            line-height: 1.8;
        }

        .status-badge {
            display: inline-block;
            padding: 6px 16px;
            border-radius: 20px;
            font-size: 9pt;
            font-weight: 700;
            margin-top: 10px;
        }

        .status-pending { background: #f3f4f6; color: #4b5563; }
        .status-confirmed { background: #dbeafe; color: #1e40af; }
        .status-processing { background: #fef3c7; color: #92400e; }
        .status-shipped { background: #dbeafe; color: #1e40af; }
        .status-delivered { background: #d1fae5; color: #065f46; }
        .status-completed { background: #d1fae5; color: #065f46; }
        .status-canceled { background: #fee2e2; color: #991b1b; }

        /* Client Info */
        .client-section {
            background: var(--surface-field);
            padding: 15px 20px;
            border-radius: 10px;
            margin-bottom: 30px;
        }

        .client-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 20px;
        }

        .client-field {
            display: flex;
            gap: 8px;
            font-size: 10pt;
        }

        .client-label {
            font-weight: 900;
            color: var(--text);
        }

        .client-value {
            font-weight: 700;
            color: var(--text-muted);
        }

        /* Items Table */
        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
        }

        .items-table thead {
            background: var(--primary);
            color: white;
        }

        .items-table th {
            padding: 12px;
            text-align: center;
            font-size: 10pt;
            font-weight: 700;
        }

        .items-table tbody tr {
            border-bottom: 1px solid var(--border);
        }

        .items-table tbody tr:nth-child(even) {
            background: var(--surface-field);
        }

        .items-table td {
            padding: 10px 12px;
            text-align: center;
            font-size: 9pt;
        }

        .items-table td.text-right {
            text-align: right;
        }

        .items-table td.text-left {
            text-align: left;
        }

        .items-table td.product-name {
            font-weight: 700;
            color: var(--text);
        }

        .items-table td.variant-name {
            font-size: 8pt;
            color: var(--text-muted);
        }

        /* Totals */
        .totals-section {
            display: flex;
            justify-content: flex-end;
            margin-bottom: 30px;
        }

        .totals-box {
            width: 350px;
            border: 2px solid var(--border);
            border-radius: 10px;
            overflow: hidden;
        }

        .total-row {
            display: flex;
            justify-content: space-between;
            padding: 12px 20px;
            border-bottom: 1px solid var(--border);
        }

        .total-row:last-child {
            border-bottom: none;
        }

        .total-label {
            font-weight: 700;
            color: var(--text);
        }

        .total-value {
            font-weight: 700;
            color: var(--text-muted);
        }

        .total-row.grand {
            background: var(--primary);
            color: white;
            font-size: 14pt;
            font-weight: 900;
        }

        .total-row.grand .total-label,
        .total-row.grand .total-value {
            color: white;
        }

        .total-row.discount .total-value {
            color: #dc2626;
        }

        /* Shipping Section */
        .shipping-section {
            background: var(--surface-field);
            padding: 15px 20px;
            border-radius: 10px;
            margin-bottom: 30px;
        }

        .shipping-title {
            font-size: 12pt;
            font-weight: 700;
            color: var(--primary);
            margin-bottom: 10px;
        }

        .shipping-info {
            font-size: 10pt;
            color: var(--text-muted);
            line-height: 1.8;
        }

        /* Notes */
        .notes-section {
            background: #fffbeb;
            border-right: 4px solid #f59e0b;
            padding: 15px 20px;
            border-radius: 5px;
            margin-bottom: 30px;
        }

        .notes-title {
            font-size: 11pt;
            font-weight: 700;
            color: #92400e;
            margin-bottom: 10px;
        }

        .notes-text {
            font-size: 9pt;
            color: #78350f;
            line-height: 1.6;
        }

        /* Footer */
        .invoice-footer {
            text-align: center;
            padding-top: 20px;
            border-top: 2px solid var(--border);
            font-size: 9pt;
            color: var(--text-muted);
        }

        /* Print Styles */
        @media print {
            body {
                padding: 0;
            }

            .no-print {
                display: none !important;
            }

            @page {
                margin: 15mm;
                size: A4;
            }
        }

        .action-buttons {
            position: fixed;
            top: 20px;
            left: 20px;
            display: flex;
            gap: 10px;
            z-index: 1000;
        }

        .print-button, .back-button {
            background: var(--primary);
            color: white;
            border: none;
            padding: 12px 24px;
            border-radius: 8px;
            font-size: 11pt;
            font-weight: 700;
            cursor: pointer;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            transition: all 0.3s ease;
        }

        .print-button:hover, .back-button:hover {
            background: var(--primary-700);
            transform: translateY(-2px);
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15);
        }

        .back-button svg {
            width: 20px;
            height: 20px;
        }
    </style>
</head>
<body>
    <div class="action-buttons no-print">
        <a href="{{ route('filament.admin.resources.orders.index') }}" class="back-button">
            <svg fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/>
            </svg>
            العودة إلى الطلبات
        </a>
        <button class="print-button" onclick="window.print()">
            🖨️ طباعة
        </button>
    </div>

    <div class="invoice-container">
        <!-- Header -->
        <div class="invoice-header">
            <div class="header-right">
                @if($settings && $settings->logo_light_url)
                    <img src="{{ $settings->logo_light_url }}" alt="Logo" class="logo">
                @endif
                <div class="branch-name">{{ $branch->name ?? 'الفرع' }}</div>
                <div class="branch-info">
                    @if($settings && $settings->address)
                        {{ $settings->address }}<br>
                    @endif
                    @if($settings && isset($settings->phones['main']))
                        📞 {{ $settings->phones['main'] }}<br>
                    @endif
                </div>
            </div>

            <div class="header-left">
                <div class="invoice-title">فاتورة طلب</div>
                <div class="invoice-meta">
                    <strong>رقم الطلب:</strong> {{ $order->order_number }}<br>
                    <strong>التاريخ:</strong> {{ $order->created_at->format('Y-m-d') }}<br>
                    <strong>الوقت:</strong> {{ $order->created_at->format('h:i A') }}
                </div>
                <div class="status-badge status-{{ $order->status->value }}">
                    {{ $order->status->label() }}
                </div>
            </div>
        </div>

        <!-- Client Info -->
        <div class="client-section">
            <div class="client-grid">
                <div class="client-field">
                    <span class="client-label">العميل:</span>
                    <span class="client-value">{{ $client->name }}</span>
                </div>
                @if($client->phone)
                <div class="client-field">
                    <span class="client-label">الهاتف:</span>
                    <span class="client-value">{{ $client->phone }}</span>
                </div>
                @endif
                @if($client->email)
                <div class="client-field">
                    <span class="client-label">البريد:</span>
                    <span class="client-value">{{ $client->email }}</span>
                </div>
                @endif
            </div>
        </div>

        <!-- Shipping Info -->
        @if($order->shipping_method || $order->shippingAddress)
        <div class="shipping-section">
            <div class="shipping-title">🚚 معلومات الشحن</div>
            <div class="shipping-info">
                @if($order->shipping_method)
                    <strong>طريقة الشحن:</strong> {{ $order->shipping_method->label() }}<br>
                @endif
                @if($order->shippingCompany)
                    <strong>شركة الشحن:</strong> {{ $order->shippingCompany->name }}<br>
                @endif
                @if($order->shippingAddress)
                    <strong>عنوان التوصيل:</strong> {{ $order->shippingAddress->full_address }}
                @endif
            </div>
        </div>
        @endif

        <!-- Items Table -->
        <table class="items-table">
            <thead>
                <tr>
                    <th>#</th>
                    <th>المنتج</th>
                    <th>الباركود</th>
                    <th>الكمية</th>
                    <th>السعر</th>
                    <th>الخصم</th>
                    <th>الإجمالي</th>
                </tr>
            </thead>
            <tbody>
                @foreach($items as $index => $item)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td class="text-right">
                        <div class="product-name">{{ $item->product_name }}</div>
                        @if($item->variant_name)
                        <div class="variant-name">{{ $item->variant_name }}</div>
                        @endif
                    </td>
                    <td>{{ $item->sku ?? '-' }}</td>
                    <td>{{ $item->quantity }}</td>
                    <td>{{ number_format($item->unit_price, 0, '', ',') }}</td>
                    <td class="text-left">
                        @if($item->discount_amount > 0)
                            <span style="color: #dc2626;">-{{ number_format($item->discount_amount, 0, '', ',') }}</span>
                        @else
                            -
                        @endif
                    </td>
                    <td class="text-left" style="font-weight: 700;">
                        {{ number_format($item->line_total, 0, '', ',') }} د.ع
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>

        <!-- Totals -->
        <div class="totals-section">
            <div class="totals-box">
                <div class="total-row">
                    <span class="total-label">المجموع الفرعي:</span>
                    <span class="total-value">{{ number_format($order->subtotal, 0, '', ',') }} د.ع</span>
                </div>
                
                @if($order->discount_total > 0)
                <div class="total-row discount">
                    <span class="total-label">الخصم:</span>
                    <span class="total-value">-{{ number_format($order->discount_total, 0, '', ',') }} د.ع</span>
                </div>
                @endif

                @if($order->shipping_fee > 0)
                <div class="total-row">
                    <span class="total-label">رسوم الشحن:</span>
                    <span class="total-value">{{ number_format($order->shipping_fee, 0, '', ',') }} د.ع</span>
                </div>
                @endif

                @if($order->cod_fee > 0)
                <div class="total-row">
                    <span class="total-label">رسوم الدفع عند الاستلام:</span>
                    <span class="total-value">{{ number_format($order->cod_fee, 0, '', ',') }} د.ع</span>
                </div>
                @endif

                <div class="total-row grand">
                    <span class="total-label">الإجمالي النهائي:</span>
                    <span class="total-value">{{ number_format($order->grand_total, 0, '', ',') }} د.ع</span>
                </div>

                @if($order->paid_amount > 0)
                <div class="total-row" style="background: #dcfce7;">
                    <span class="total-label">المدفوع:</span>
                    <span class="total-value" style="color: #16a34a;">{{ number_format($order->paid_amount, 0, '', ',') }} د.ع</span>
                </div>
                <div class="total-row" style="background: #fef3c7;">
                    <span class="total-label">المتبقي:</span>
                    <span class="total-value" style="color: #92400e;">{{ number_format($order->remaining_amount, 0, '', ',') }} د.ع</span>
                </div>
                @endif
            </div>
        </div>

        <!-- Customer Notes -->
        @if($order->customer_notes)
        <div class="notes-section">
            <div class="notes-title">📝 ملاحظات العميل</div>
            <div class="notes-text">{{ $order->customer_notes }}</div>
        </div>
        @endif

        <!-- Internal Notes -->
        @if($order->internal_notes)
        <div class="notes-section" style="background: #f3f4f6; border-right-color: #6b7280;">
            <div class="notes-title" style="color: #374151;">🔒 ملاحظات داخلية</div>
            <div class="notes-text" style="color: #4b5563;">{{ $order->internal_notes }}</div>
        </div>
        @endif

        <!-- Footer -->
        <div class="invoice-footer">
            <p>شكراً لتعاملكم معنا</p>
            <p style="font-size: 8pt; margin-top: 10px;">
                تم الطباعة بتاريخ: {{ now()->format('Y-m-d h:i A') }}
            </p>
        </div>
    </div>

    <script>
        // Auto print on load (optional)
        // window.onload = function() { window.print(); };
    </script>
</body>
</html>
