{{-- Search Modal --}}
<div x-data="{ isOpen: false }" 
     @search-open.window="isOpen = true; $nextTick(() => $refs.searchInput.focus())"
     @keydown.escape.window="isOpen = false; $wire.search = ''"
     class="relative z-[100]">
    
    {{-- Modal Overlay --}}
    <div x-show="isOpen" 
         x-cloak
         x-transition:enter="transition ease-out duration-200"
         x-transition:enter-start="opacity-0"
         x-transition:enter-end="opacity-100"
         x-transition:leave="transition ease-in duration-150"
         x-transition:leave-start="opacity-100"
         x-transition:leave-end="opacity-0"
         @click="isOpen = false; $wire.search = ''"
         class="fixed inset-0 bg-black/70 backdrop-blur-sm"
         style="display: none;">
    </div>

    {{-- Modal Content --}}
    <div x-show="isOpen"
         x-cloak
         x-transition:enter="transition ease-out duration-200"
         x-transition:enter-start="opacity-0 scale-95 -translate-y-4"
         x-transition:enter-end="opacity-100 scale-100 translate-y-0"
         x-transition:leave="transition ease-in duration-150"
         x-transition:leave-start="opacity-100 scale-100 translate-y-0"
         x-transition:leave-end="opacity-0 scale-95 -translate-y-4"
         class="fixed inset-x-4 top-24 mx-auto max-w-3xl z-[101]"
         style="display: none;"
         @click.outside="isOpen = false; $wire.search = ''">
        
        <div class="bg-[#111111] rounded-3xl border border-white/10 shadow-2xl overflow-hidden">
            {{-- Search Input --}}
            <div class="p-6 border-b border-white/10">
                <div class="relative">
                    <div class="absolute inset-y-0 right-0 flex items-center pr-4 pointer-events-none">
                        <svg class="w-6 h-6 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-5.197-5.197m0 0A7.5 7.5 0 105.196 5.196a7.5 7.5 0 0010.607 10.607z" />
                        </svg>
                    </div>
                    <input 
                        wire:model.live.debounce.300ms="search"
                        x-ref="searchInput"
                        type="text" 
                        placeholder="ابحث عن منتج... (مثال: ثريا، لمبة، إضاءة)"
                        class="w-full pr-14 pl-4 py-4 rounded-2xl bg-white/5 border border-white/10 focus:border-[#D4A356] focus:ring-2 focus:ring-[#D4A356]/20 outline-none transition-all text-white placeholder-gray-500 text-lg"
                        autocomplete="off">
                    
                    {{-- Clear Button --}}
                    @if(strlen($search) > 0)
                        <button 
                            wire:click="$set('search', '')"
                            class="absolute inset-y-0 left-0 flex items-center pl-4 text-gray-500 hover:text-white transition-colors">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                            </svg>
                        </button>
                    @endif
                </div>
                
                {{-- Search Hint --}}
                @if(strlen($search) < 2 && strlen($search) > 0)
                    <p class="text-gray-500 text-sm mt-3">أدخل حرفين على الأقل للبحث</p>
                @endif
            </div>

            {{-- Search Results --}}
            <div class="max-h-[60vh] overflow-y-auto">
                {{-- Loading State --}}
                <div wire:loading class="p-8 text-center">
                    <div class="flex items-center justify-center gap-3 text-gray-400">
                        <svg class="w-6 h-6 animate-spin" fill="none" viewBox="0 0 24 24">
                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                        </svg>
                        <span class="font-bold">جاري البحث...</span>
                    </div>
                </div>

                {{-- Results --}}
                <div wire:loading.remove>
                    @if(strlen($search) >= 2)
                        @if($this->searchResults->isEmpty())
                            {{-- Empty State --}}
                            <div class="p-12 text-center">
                                <div class="w-20 h-20 mx-auto mb-4 rounded-full bg-[#D4A356]/10 flex items-center justify-center">
                                    <svg class="w-10 h-10 text-[#D4A356]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M21 21l-5.197-5.197m0 0A7.5 7.5 0 105.196 5.196a7.5 7.5 0 0010.607 10.607z" />
                                    </svg>
                                </div>
                                <h3 class="text-white font-bold text-lg mb-2">لا توجد نتائج</h3>
                                <p class="text-gray-400 text-sm">جرب البحث بكلمات أخرى</p>
                            </div>
                        @else
                            {{-- Product Results --}}
                            <div class="p-3">
                                <p class="text-gray-400 text-sm px-3 mb-3">وجدنا {{ $this->searchResults->count() }} منتجات</p>
                                
                                <div class="space-y-2">
                                    @foreach($this->searchResults as $result)
                                        <a href="{{ route('shop.product', $result['slug']) }}" 
                                           @click="isOpen = false; $wire.search = ''"
                                           class="flex items-center gap-4 p-4 rounded-2xl hover:bg-white/5 transition-all group">
                                            {{-- Product Image --}}
                                            <div class="w-20 h-20 rounded-xl bg-[#1a1a1a] overflow-hidden shrink-0">
                                                @if($result['image'])
                                                    <img src="{{ $result['image'] }}" alt="{{ $result['name'] }}" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-300">
                                                @else
                                                    <div class="w-full h-full flex items-center justify-center text-gray-600">
                                                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                                        </svg>
                                                    </div>
                                                @endif
                                            </div>

                                            {{-- Product Info --}}
                                            <div class="flex-1 min-w-0">
                                                <h3 class="text-white font-bold mb-1 group-hover:text-[#D4A356] transition-colors line-clamp-1">
                                                    {{ $result['name'] }}
                                                </h3>
                                                <div class="flex items-center gap-2 text-sm mb-2">
                                                    @if($result['category'])
                                                        <span class="text-gray-500">{{ $result['category'] }}</span>
                                                    @endif
                                                    @if($result['brand'])
                                                        <span class="text-gray-600">•</span>
                                                        <span class="text-gray-500">{{ $result['brand'] }}</span>
                                                    @endif
                                                </div>
                                                <div class="flex items-center gap-3">
                                                    <span class="text-[#D4A356] font-black text-lg">{{ number_format($result['price']) }} د.ع</span>
                                                    <span class="px-2 py-0.5 rounded-full text-xs font-bold {{ $result['in_stock'] ? 'bg-emerald-500/20 text-emerald-400' : 'bg-red-500/20 text-red-400' }}">
                                                        {{ $result['in_stock'] ? 'متوفر' : 'نفذت الكمية' }}
                                                    </span>
                                                </div>
                                            </div>

                                            {{-- Arrow Icon --}}
                                            <div class="text-gray-600 group-hover:text-[#D4A356] transition-colors">
                                                <svg class="w-6 h-6 rotate-180" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3" />
                                                </svg>
                                            </div>
                                        </a>
                                    @endforeach
                                </div>

                                {{-- View All Results --}}
                                @if($this->searchResults->count() >= 8)
                                    <div class="mt-4 pt-4 border-t border-white/5 text-center">
                                        <a href="{{ route('shop', ['q' => $search]) }}" 
                                           @click="isOpen = false"
                                           class="inline-flex items-center gap-2 px-6 py-3 rounded-full bg-white/5 text-white font-bold hover:bg-white/10 transition-all">
                                            عرض جميع النتائج
                                            <svg class="w-5 h-5 rotate-180" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3" />
                                            </svg>
                                        </a>
                                    </div>
                                @endif
                            </div>
                        @endif
                    @else
                        {{-- Initial State --}}
                        <div class="p-12 text-center">
                            <div class="w-20 h-20 mx-auto mb-4 rounded-full bg-[#D4A356]/10 flex items-center justify-center">
                                <svg class="w-10 h-10 text-[#D4A356]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M21 21l-5.197-5.197m0 0A7.5 7.5 0 105.196 5.196a7.5 7.5 0 0010.607 10.607z" />
                                </svg>
                            </div>
                            <h3 class="text-white font-bold text-lg mb-2">ابحث عن منتج</h3>
                            <p class="text-gray-400 text-sm">أدخل اسم المنتج أو وصفه للبحث</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
