<div x-data="{
    view: '{{ $viewMode }}',
    cols: {{ $gridColumns }},
    filtersOpen: false
}" x-init="$wire.set('gridColumns', cols)">
    {{-- Toolbar --}}
    <div class="w-full bg-white dark:bg-[#1a1a1a] rounded-xl border border-gray-200 dark:border-white/10 px-4 py-3 mb-6">
        <div class="flex flex-wrap items-center justify-between gap-4">
            {{-- Filter Toggle & Sort --}}
            <div class="flex items-center gap-3">
                {{-- Filter Toggle Button --}}
                <button @click="filtersOpen = true"
                    class="flex items-center gap-2 px-4 py-2 rounded-lg border border-gray-200 dark:border-white/10 bg-gray-50 dark:bg-[#0f0f0f] hover:border-nassaj-gold hover:bg-nassaj-gold/5 text-gray-900 dark:text-white font-bold text-sm transition-all">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M3 4a1 1 0 011-1h16a1 1 0 011 1v2.586a1 1 0 01-.293.707l-6.414 6.414a1 1 0 00-.293.707V17l-4 4v-6.586a1 1 0 00-.293-.707L3.293 7.293A1 1 0 013 6.586V4z" />
                    </svg>
                    <span>الفلاتر</span>
                    @if ($hasFilters)
                        <span class="w-2 h-2 rounded-full bg-nassaj-gold"></span>
                    @endif
                </button>

                {{-- Sort Dropdown --}}
                <div class="flex items-center gap-2">
                    <select wire:model.live="sort"
                        class="bg-gray-50 dark:bg-[#0f0f0f] border border-gray-200 dark:border-white/10 text-gray-900 dark:text-white text-sm font-bold cursor-pointer focus:outline-none focus:ring-2 focus:ring-nassaj-gold px-4 py-2 rounded-lg">
                        <option value="newest">الترتيب الافتراضي</option>
                        <option value="price_asc">السعر: الأقل</option>
                        <option value="price_desc">السعر: الأعلى</option>
                        <option value="name_asc">الاسم: أ-ي</option>
                        <option value="name_desc">الاسم: ي-أ</option>
                    </select>
                </div>
            </div>

            {{-- View Controls --}}
            <div class="flex items-center gap-2">
                {{-- Grid View Buttons --}}
                <div
                    class="hidden sm:flex items-center gap-1 border border-gray-200 dark:border-white/10 rounded-lg p-1">
                    {{-- 2 Columns --}}
                    <button @click="view = 'grid'; cols = 2; $wire.set('gridColumns', 2)"
                        class="p-2 rounded transition-all"
                        :class="view === 'grid' && cols === 2 ? 'bg-nassaj-gold text-nassaj-primary' :
                            'text-gray-600 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-[#0f0f0f]'"
                        title="2 أعمدة">
                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                            <rect x="2" y="4" width="7" height="12" rx="1" />
                            <rect x="11" y="4" width="7" height="12" rx="1" />
                        </svg>
                    </button>

                    {{-- 3 Columns --}}
                    <button @click="view = 'grid'; cols = 3; $wire.set('gridColumns', 3)"
                        class="p-2 rounded transition-all"
                        :class="view === 'grid' && cols === 3 ? 'bg-nassaj-gold text-nassaj-primary' :
                            'text-gray-600 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-[#0f0f0f]'"
                        title="3 أعمدة">
                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                            <rect x="1" y="4" width="5" height="12" rx="1" />
                            <rect x="7.5" y="4" width="5" height="12" rx="1" />
                            <rect x="14" y="4" width="5" height="12" rx="1" />
                        </svg>
                    </button>

                    {{-- 4 Columns --}}
                    <button @click="view = 'grid'; cols = 4; $wire.set('gridColumns', 4)"
                        class="p-2 rounded transition-all"
                        :class="view === 'grid' && cols === 4 ? 'bg-nassaj-gold text-nassaj-primary' :
                            'text-gray-600 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-[#0f0f0f]'"
                        title="4 أعمدة">
                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                            <rect x="1" y="4" width="4" height="12" rx="0.5" />
                            <rect x="6" y="4" width="4" height="12" rx="0.5" />
                            <rect x="11" y="4" width="4" height="12" rx="0.5" />
                            <rect x="16" y="4" width="3" height="12" rx="0.5" />
                        </svg>
                    </button>
                </div>

                {{-- Results Count --}}
                <span class="text-gray-600 dark:text-gray-400 text-sm">
                    عرض <span class="font-bold text-gray-900 dark:text-white">{{ $products->count() }}</span> منتج
                </span>
            </div>
        </div>
    </div>

    {{-- Active Filters --}}
    @if ($hasFilters)
        <div class="flex flex-wrap gap-2 mb-6">
            @if ($selectedCategory)
                <span
                    class="inline-flex items-center gap-2 bg-nassaj-gold/20 text-nassaj-gold px-3 py-1.5 rounded-lg text-sm font-bold">
                    {{ $selectedCategory->name }}
                    <button wire:click="$set('categoryId', null)" class="hover:text-nassaj-gold-dark">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M6 18L18 6M6 6l12 12" />
                        </svg>
                    </button>
                </span>
            @endif
            @if ($selectedBrand)
                <span
                    class="inline-flex items-center gap-2 bg-nassaj-gold/20 text-nassaj-gold px-3 py-1.5 rounded-lg text-sm font-bold">
                    {{ $selectedBrand->name }}
                    <button wire:click="$set('brandId', null)" class="hover:text-nassaj-gold-dark">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M6 18L18 6M6 6l12 12" />
                        </svg>
                    </button>
                </span>
            @endif
        </div>
    @endif

    {{-- Products Grid --}}
    <div class="grid gap-4 md:gap-6"
        :class="{
            'grid-cols-2': view === 'grid' && cols === 2,
            'grid-cols-2 sm:grid-cols-3': view === 'grid' && cols === 3,
            'grid-cols-2 sm:grid-cols-3 lg:grid-cols-4': view === 'grid' && cols === 4
        }">
        @forelse($products as $product)
            <livewire:products.product-card :product-id="$product->id" wire:key="card-{{ $product->id }}" />
        @empty
            <div class="col-span-full text-center py-12">
                <div
                    class="inline-block p-8 bg-gray-100 dark:bg-[#1a1a1a] rounded-2xl border border-gray-200 dark:border-white/10">
                    <svg class="w-16 h-16 mx-auto mb-4 text-gray-400" fill="none" stroke="currentColor"
                        viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1"
                            d="M20 13V6a2 2 0 00-2-2H6a2 2 0 00-2 2v7m16 0v5a2 2 0 01-2 2H6a2 2 0 01-2-2v-5m16 0h-2.586a1 1 0 00-.707.293l-2.414 2.414a1 1 0 01-.707.293h-3.172a1 1 0 01-.707-.293l-2.414-2.414A1 1 0 006.586 13H4" />
                    </svg>
                    <p class="text-gray-600 dark:text-gray-400 font-bold">لا توجد منتجات</p>
                </div>
            </div>
        @endforelse
    </div>

    {{-- Pagination --}}
    @if ($products->hasPages())
        <div class="mt-8">
            {{ $products->links() }}
        </div>
    @endif

    {{-- Filter Drawer (Toggle) --}}
    <div x-show="filtersOpen" x-cloak @keydown.escape.window="filtersOpen = false" class="fixed inset-0 z-50">
        {{-- Backdrop --}}
        <div x-show="filtersOpen" x-transition:enter="transition ease-out duration-300"
            x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100"
            x-transition:leave="transition ease-in duration-200" x-transition:leave-start="opacity-100"
            x-transition:leave-end="opacity-0" @click="filtersOpen = false"
            class="absolute inset-0 bg-black/50 backdrop-blur-sm"></div>

        {{-- Drawer Panel (slides from right in RTL) --}}
        <div x-show="filtersOpen" x-transition:enter="transition ease-out duration-300 transform"
            x-transition:enter-start="translate-x-full" x-transition:enter-end="translate-x-0"
            x-transition:leave="transition ease-in duration-200 transform" x-transition:leave-start="translate-x-0"
            x-transition:leave-end="translate-x-full"
            class="absolute right-0 top-0 h-full w-[85vw] max-w-[380px] flex flex-col shadow-[-8px_0_30px_rgba(0,0,0,0.15)] dark:shadow-[-8px_0_40px_rgba(0,0,0,0.5)]
                   bg-gradient-to-b from-white via-white to-gray-50 dark:from-[#0d0d0d] dark:via-[#0d0d0d] dark:to-[#080808]">
            {{-- Header --}}
            <div class="relative px-6 pt-6 pb-5">
                {{-- Decorative accent --}}
                <div
                    class="absolute top-0 right-0 w-32 h-32 rounded-full bg-nassaj-gold/5 dark:bg-nassaj-gold/10 blur-3xl -translate-y-1/2 translate-x-1/2 pointer-events-none">
                </div>

                <div class="relative flex items-center justify-between">
                    <div class="flex items-center gap-3">
                        <div
                            class="w-10 h-10 rounded-xl bg-nassaj-gold/15 dark:bg-nassaj-gold/10 border border-nassaj-gold/20 dark:border-nassaj-gold/15 flex items-center justify-center">
                            <svg class="w-5 h-5 text-nassaj-gold" fill="none" stroke="currentColor"
                                viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M3 4a1 1 0 011-1h16a1 1 0 011 1v2.586a1 1 0 01-.293.707l-6.414 6.414a1 1 0 00-.293.707V17l-4 4v-6.586a1 1 0 00-.293-.707L3.293 7.293A1 1 0 013 6.586V4z" />
                            </svg>
                        </div>
                        <div>
                            <h3 class="text-gray-900 dark:text-white font-black text-lg cairo">الفلاتر</h3>
                            @if ($hasFilters)
                                <span class="text-nassaj-gold text-xs font-bold">فلاتر نشطة</span>
                            @endif
                        </div>
                    </div>
                    <button @click="filtersOpen = false"
                        class="w-9 h-9 flex items-center justify-center rounded-xl bg-gray-100 dark:bg-white/5 hover:bg-gray-200 dark:hover:bg-white/10 transition-colors">
                        <svg class="w-4 h-4 text-gray-500 dark:text-gray-400" fill="none" stroke="currentColor"
                            viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5"
                                d="M6 18L18 6M6 6l12 12" />
                        </svg>
                    </button>
                </div>
            </div>

            {{-- Divider --}}
            <div class="h-px bg-gradient-to-l from-transparent via-nassaj-gold/20 to-transparent"></div>

            {{-- Filters Content --}}
            <div class="flex-1 overflow-y-auto px-6 py-5 space-y-7">
                {{-- Categories Filter --}}
                <div>
                    <h4 class="text-gray-900 dark:text-white font-bold text-sm mb-3 flex items-center gap-2">
                        <span class="w-1.5 h-1.5 rounded-full bg-nassaj-gold"></span>
                        الفئات
                    </h4>
                    <div class="space-y-1 max-h-52 overflow-y-auto">
                        @foreach ($categories as $cat)
                            <label
                                class="flex items-center gap-3 cursor-pointer group py-2 px-3 rounded-xl hover:bg-nassaj-gold/5 dark:hover:bg-nassaj-gold/5 transition-all duration-200">
                                <input type="radio" wire:model.live="categoryId" value="{{ $cat->id }}"
                                    class="w-4 h-4 text-nassaj-gold focus:ring-nassaj-gold/50 border-gray-300 dark:border-gray-600">
                                <span
                                    class="text-gray-700 dark:text-gray-300 text-sm group-hover:text-nassaj-gold transition-colors flex-1 font-medium">
                                    {{ $cat->name }}
                                </span>
                                <span
                                    class="text-gray-400 dark:text-gray-500 text-xs bg-gray-100 dark:bg-white/5 px-2 py-0.5 rounded-full">{{ $cat->products_count }}</span>
                            </label>
                        @endforeach
                    </div>
                </div>

                {{-- Price Range --}}
                <div>
                    <h4 class="text-gray-900 dark:text-white font-bold text-sm mb-3 flex items-center gap-2">
                        <span class="w-1.5 h-1.5 rounded-full bg-nassaj-gold"></span>
                        السعر
                    </h4>
                    <div class="flex items-center gap-3">
                        <input type="number" placeholder="50,000"
                            class="flex-1 px-3 py-2.5 rounded-xl border border-gray-200 dark:border-white/10 bg-gray-50 dark:bg-white/5 text-gray-900 dark:text-white text-sm text-center font-medium focus:outline-none focus:ring-2 focus:ring-nassaj-gold/30 focus:border-nassaj-gold/30 transition-all">
                        <span class="text-gray-300 dark:text-gray-600 font-bold text-lg">—</span>
                        <input type="number" placeholder="0"
                            class="flex-1 px-3 py-2.5 rounded-xl border border-gray-200 dark:border-white/10 bg-gray-50 dark:bg-white/5 text-gray-900 dark:text-white text-sm text-center font-medium focus:outline-none focus:ring-2 focus:ring-nassaj-gold/30 focus:border-nassaj-gold/30 transition-all">
                    </div>
                </div>

                {{-- Colors Filter --}}
                <div>
                    <h4 class="text-gray-900 dark:text-white font-bold text-sm mb-3 flex items-center gap-2">
                        <span class="w-1.5 h-1.5 rounded-full bg-nassaj-gold"></span>
                        الألوان
                    </h4>
                    <div class="flex flex-wrap gap-3">
                        @foreach ([['color' => '#8B4513', 'name' => 'بني'], ['color' => '#FF0000', 'name' => 'أحمر'], ['color' => '#0000FF', 'name' => 'أزرق'], ['color' => '#008000', 'name' => 'أخضر'], ['color' => '#FFA500', 'name' => 'برتقالي'], ['color' => '#FFD700', 'name' => 'ذهبي'], ['color' => '#FFC0CB', 'name' => 'وردي'], ['color' => '#FFFFFF', 'name' => 'أبيض'], ['color' => '#000000', 'name' => 'أسود']] as $colorItem)
                            <button
                                class="w-9 h-9 rounded-full border-2 border-gray-200 dark:border-gray-600 hover:scale-110 hover:border-nassaj-gold hover:shadow-md transition-all duration-200"
                                style="background-color: {{ $colorItem['color'] }}"
                                title="{{ $colorItem['name'] }}"></button>
                        @endforeach
                    </div>
                </div>

                {{-- Size Filter --}}
                <div>
                    <h4 class="text-gray-900 dark:text-white font-bold text-sm mb-3 flex items-center gap-2">
                        <span class="w-1.5 h-1.5 rounded-full bg-nassaj-gold"></span>
                        المقاسات
                    </h4>
                    <div class="space-y-1">
                        @foreach (['S (36-38)', 'M (39-41)', 'L (42-44)', 'XL (45-67)'] as $size)
                            <label
                                class="flex items-center gap-3 cursor-pointer py-2 px-3 rounded-xl hover:bg-nassaj-gold/5 dark:hover:bg-nassaj-gold/5 transition-all duration-200">
                                <input type="checkbox"
                                    class="w-4 h-4 text-nassaj-gold focus:ring-nassaj-gold/50 border-gray-300 dark:border-gray-600 rounded">
                                <span
                                    class="text-gray-700 dark:text-gray-300 text-sm font-medium">{{ $size }}</span>
                            </label>
                        @endforeach
                    </div>
                </div>

                {{-- Brands Filter --}}
                @if ($brands->isNotEmpty())
                    <div>
                        <h4 class="text-gray-900 dark:text-white font-bold text-sm mb-3 flex items-center gap-2">
                            <span class="w-1.5 h-1.5 rounded-full bg-nassaj-gold"></span>
                            البراندات
                        </h4>
                        <div class="space-y-1 max-h-52 overflow-y-auto">
                            @foreach ($brands as $brand)
                                <label
                                    class="flex items-center gap-3 cursor-pointer group py-2 px-3 rounded-xl hover:bg-nassaj-gold/5 dark:hover:bg-nassaj-gold/5 transition-all duration-200">
                                    <input type="radio" wire:model.live="brandId" value="{{ $brand->id }}"
                                        class="w-4 h-4 text-nassaj-gold focus:ring-nassaj-gold/50 border-gray-300 dark:border-gray-600">
                                    <span
                                        class="text-gray-700 dark:text-gray-300 text-sm group-hover:text-nassaj-gold transition-colors flex-1 font-medium">
                                        {{ $brand->name }}
                                    </span>
                                    <span
                                        class="text-gray-400 dark:text-gray-500 text-xs bg-gray-100 dark:bg-white/5 px-2 py-0.5 rounded-full">{{ $brand->products_count }}</span>
                                </label>
                            @endforeach
                        </div>
                    </div>
                @endif
            </div>

            {{-- Footer --}}
            <div class="h-px bg-gradient-to-l from-transparent via-nassaj-gold/20 to-transparent"></div>
            <div class="p-6 flex gap-3">
                <button @click="filtersOpen = false"
                    class="flex-1 py-3.5 rounded-xl bg-nassaj-gold hover:bg-nassaj-gold-dark text-nassaj-primary font-black transition-all duration-200 hover:shadow-lg hover:shadow-nassaj-gold/20 flex items-center justify-center gap-2">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M5 13l4 4L19 7" />
                    </svg>
                    تطبيق
                </button>
                <button wire:click="clearFilters"
                    class="flex-1 py-3.5 rounded-xl border border-gray-200 dark:border-white/10 text-gray-700 dark:text-gray-300 font-bold hover:bg-gray-50 dark:hover:bg-white/5 transition-all duration-200 flex items-center justify-center gap-2">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15" />
                    </svg>
                    إعادة ضبط
                </button>
            </div>
        </div>
    </div>
</div>
