<div class="flex items-center gap-2">
    {{-- Cart --}}
    <button
        @click="$dispatch('cart-open')"
        class="relative p-2 text-gray-400 hover:text-nassaj-gold transition-all duration-200"
    >
        <svg class="w-6 h-6" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round"
                d="M2.25 3h1.386c.51 0 .955.343 1.087.835l.383 1.437M7.5 14.25a3 3 0 00-3 3h15.75m-12.75-3h11.218c1.121-2.3 2.1-4.684 2.924-7.138a60.114 60.114 0 00-16.536-1.84M7.5 14.25L5.106 5.272M6 20.25a.75.75 0 11-1.5 0 .75.75 0 011.5 0zm12.75 0a.75.75 0 11-1.5 0 .75.75 0 011.5 0z" />
        </svg>
        @if($cartCount > 0)
            <span class="absolute -top-1 -right-1 bg-nassaj-gold text-nassaj-primary text-xs font-black rounded-full min-w-[18px] h-[18px] flex items-center justify-center px-1">
                {{ $cartCount > 99 ? '99+' : $cartCount }}
            </span>
        @endif
    </button>

    {{-- Compare --}}
    <button
        @click="$dispatch('compare-open')"
        class="hidden sm:flex relative p-2 text-gray-400 hover:text-nassaj-gold transition-all duration-200"
    >
        <svg class="w-6 h-6" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round"
                d="M3 13.125C3 12.504 3.504 12 4.125 12h2.25c.621 0 1.125.504 1.125 1.125v6.75C7.5 20.496 6.996 21 6.375 21h-2.25A1.125 1.125 0 013 19.875v-6.75zM9.75 8.625c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125v11.25c0 .621-.504 1.125-1.125 1.125h-2.25a1.125 1.125 0 01-1.125-1.125V8.625zM16.5 4.125c0-.621.504-1.125 1.125-1.125h2.25C20.496 3 21 3.504 21 4.125v15.75c0 .621-.504 1.125-1.125 1.125h-2.25a1.125 1.125 0 01-1.125-1.125V4.125z" />
        </svg>
        @if($compareCount > 0)
            <span class="absolute -top-1 -right-1 bg-blue-500 text-white text-xs font-black rounded-full min-w-[18px] h-[18px] flex items-center justify-center px-1">
                {{ $compareCount }}
            </span>
        @endif
    </button>

    {{-- Wishlist --}}
    <button
        @click="$dispatch('wishlist-open')"
        class="relative p-2 text-gray-400 hover:text-nassaj-gold transition-all duration-200"
    >
        <svg class="w-6 h-6" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round"
                d="M21 8.25c0-2.485-2.099-4.5-4.688-4.5-1.935 0-3.597 1.126-4.312 2.733-.715-1.607-2.377-2.733-4.313-2.733C5.1 3.75 3 5.765 3 8.25c0 7.22 9 12 9 12s9-4.78 9-12z" />
        </svg>
        @if($wishlistCount > 0)
            <span class="absolute -top-1 -right-1 bg-red-500 text-white text-xs font-black rounded-full min-w-[18px] h-[18px] flex items-center justify-center px-1">
                {{ $wishlistCount > 99 ? '99+' : $wishlistCount }}
            </span>
        @endif
    </button>
</div>
