<div class="min-h-screen bg-[#f8f5ef] dark:bg-[#0a0a0a]">

    {{-- Google model-viewer for 3D GLB --}}
    <script type="module" src="https://cdn.jsdelivr.net/npm/@google/model-viewer@3.5.0/dist/model-viewer.min.js"></script>

    {{-- Hero Section --}}
    <section class="relative overflow-hidden border-b border-[#442247]/10 dark:border-white/10"
        style="background: linear-gradient(135deg, #f8f5ef 0%, #f0ebdc 30%, #ede6d3 50%, #f0ebdc 70%, #f8f5ef 100%);">
        <div class="absolute inset-0"
            style="background: radial-gradient(ellipse 700px 450px at 75% 50%, rgba(176,162,98,.12), transparent 65%),
                                radial-gradient(ellipse 500px 350px at 20% 70%, rgba(68,34,71,.06), transparent 60%);">
        </div>
        <div class="relative site-container py-14 md:py-20">
            <div class="text-center">
                <h1 class="cairo text-4xl md:text-5xl font-black text-[#442247] dark:text-white mb-4">
                    مكتبة <span class="gradient-text">التصاميم</span>
                </h1>
                <p class="text-[#442247]/60 dark:text-gray-400 text-base md:text-lg mb-8 max-w-xl mx-auto">
                    اختر موديلاً وابدأ بإنشاء تصميمك الخاص
                </p>

                {{-- Real-time Search --}}
                <div class="max-w-lg mx-auto relative">
                    <input type="text"
                        wire:model.live.debounce.300ms="search"
                        placeholder="ابحث عن موديل..."
                        class="w-full px-5 py-3.5 pr-12 bg-white dark:bg-white/5 border border-[#B0A262]/30 dark:border-white/10 rounded-2xl text-[#442247] dark:text-white placeholder-[#442247]/40 dark:placeholder-gray-500 focus:border-[#B0A262] focus:ring-2 focus:ring-[#B0A262]/20 outline-none transition-all shadow-md text-sm">
                    <div class="absolute right-4 top-1/2 -translate-y-1/2">
                        <svg wire:loading.remove wire:target="search" class="w-5 h-5 text-[#B0A262]" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M21 21l-5.197-5.197m0 0A7.5 7.5 0 105.196 5.196a7.5 7.5 0 0010.607 10.607z" />
                        </svg>
                        <svg wire:loading wire:target="search" class="w-5 h-5 text-[#B0A262] animate-spin" fill="none" viewBox="0 0 24 24">
                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4z"></path>
                        </svg>
                    </div>
                </div>
            </div>
        </div>
    </section>

    {{-- Top 6 Popular Designs --}}
    @if($popularDesigns->count() > 0 && !$search)
    <section class="py-10 border-b border-[#442247]/10 dark:border-white/10 bg-white/60 dark:bg-[#111]">
        <div class="site-container">
            <div class="flex items-center justify-between mb-6">
                <h2 class="cairo text-xl md:text-2xl font-black text-[#442247] dark:text-white flex items-center gap-2">
                    <svg class="w-6 h-6 text-[#B0A262]" fill="currentColor" viewBox="0 0 24 24">
                        <path d="M10.788 3.21c.448-1.077 1.976-1.077 2.424 0l2.082 5.007 5.404.433c1.164.093 1.636 1.545.749 2.305l-4.117 3.527 1.257 5.273c.271 1.136-.964 2.033-1.96 1.425L12 18.354 7.373 21.18c-.996.608-2.231-.29-1.96-1.425l1.257-5.273-4.117-3.527c-.887-.76-.415-2.212.749-2.305l5.404-.433 2.082-5.006z" />
                    </svg>
                    التصاميم الأكثر طلباً
                </h2>
            </div>
            <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 gap-5">
                @foreach($popularDesigns as $design)
                <a href="{{ route('designs.show', $design) }}" class="group block rounded-2xl overflow-hidden bg-white dark:bg-white/5 border border-[#442247]/10 dark:border-white/10 hover:border-[#B0A262] hover:shadow-xl transition-all duration-300">
                    <div class="aspect-square relative overflow-hidden bg-gradient-to-br from-gray-100 to-gray-50 dark:from-gray-800 dark:to-gray-900">
                        @if($design->preview_image_url)
                            <img src="{{ $design->preview_image_url }}" alt="{{ $design->name }}" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500">
                        @endif
                        <div class="absolute top-3 left-3 bg-[#B0A262]/90 text-white text-xs font-bold px-2.5 py-1 rounded-full">#{{ $loop->iteration }}</div>
                    </div>
                    <div class="p-3.5">
                        <p class="cairo text-sm font-bold text-[#442247] dark:text-white truncate group-hover:text-[#B0A262] transition-colors">{{ $design->name }}</p>
                        <div class="flex items-center gap-3 mt-1.5">
                            <span class="text-xs text-gray-500 dark:text-gray-400 flex items-center gap-1">
                                <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M2.036 12.322a1.012 1.012 0 010-.639C3.423 7.51 7.36 4.5 12 4.5c4.638 0 8.573 3.007 9.963 7.178.07.207.07.431 0 .639C20.577 16.49 16.64 19.5 12 19.5c-4.638 0-8.573-3.007-9.963-7.178z" /><path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" /></svg>
                                {{ $design->views_count }}
                            </span>
                            <span class="text-xs text-red-400 flex items-center gap-1">
                                <svg class="w-3.5 h-3.5" fill="currentColor" viewBox="0 0 24 24"><path d="M21 8.25c0-2.485-2.099-4.5-4.688-4.5-1.935 0-3.597 1.126-4.312 2.733-.715-1.607-2.377-2.733-4.313-2.733C5.1 3.75 3 5.765 3 8.25c0 7.22 9 12 9 12s9-4.78 9-12z" /></svg>
                                {{ $design->likes_count }}
                            </span>
                        </div>
                    </div>
                </a>
                @endforeach
            </div>
        </div>
    </section>
    @endif

    {{-- Main Content: 3D Models --}}
    <section class="py-10 bg-[#f8f5ef] dark:bg-[#0a0a0a]">
        <div class="site-container">

            {{-- Toolbar --}}
            <div class="flex flex-col sm:flex-row items-start sm:items-center justify-between gap-4 mb-8">
                <h2 class="cairo text-xl md:text-2xl font-black text-[#442247] dark:text-white">
                    الموديلات <span class="text-[#B0A262]">ثلاثية الأبعاد</span>
                </h2>

                <div class="flex items-center gap-3 flex-wrap">
                    {{-- Sort --}}
                    <select wire:model.live="sortBy" class="px-3 py-2 text-sm bg-white dark:bg-white/5 border border-[#442247]/15 dark:border-white/10 rounded-xl text-[#442247] dark:text-white font-bold focus:border-[#B0A262] focus:ring-1 focus:ring-[#B0A262]/20 outline-none select-dark">
                        <option value="popular">الأكثر شهرة</option>
                        <option value="newest">الأحدث</option>
                        <option value="featured">المميزة</option>
                    </select>

                    {{-- View Toggle --}}
                    <div class="flex items-center bg-white dark:bg-white/5 rounded-xl border border-[#442247]/15 dark:border-white/10 p-0.5">
                        <button wire:click="setViewMode('grid')" class="p-2 rounded-lg transition-all {{ $viewMode === 'grid' ? 'bg-[#B0A262] text-white shadow-sm' : 'text-gray-500 dark:text-gray-400 hover:text-[#442247]' }}">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M3.75 6A2.25 2.25 0 016 3.75h2.25A2.25 2.25 0 0110.5 6v2.25a2.25 2.25 0 01-2.25 2.25H6a2.25 2.25 0 01-2.25-2.25V6zM3.75 15.75A2.25 2.25 0 016 13.5h2.25a2.25 2.25 0 012.25 2.25V18a2.25 2.25 0 01-2.25 2.25H6A2.25 2.25 0 013.75 18v-2.25zM13.5 6a2.25 2.25 0 012.25-2.25H18A2.25 2.25 0 0120.25 6v2.25A2.25 2.25 0 0118 10.5h-2.25a2.25 2.25 0 01-2.25-2.25V6zM13.5 15.75a2.25 2.25 0 012.25-2.25H18a2.25 2.25 0 012.25 2.25V18A2.25 2.25 0 0118 20.25h-2.25A2.25 2.25 0 0113.5 18v-2.25z" /></svg>
                        </button>
                        <button wire:click="setViewMode('list')" class="p-2 rounded-lg transition-all {{ $viewMode === 'list' ? 'bg-[#B0A262] text-white shadow-sm' : 'text-gray-500 dark:text-gray-400 hover:text-[#442247]' }}">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M3.75 12h16.5m-16.5 3.75h16.5M3.75 19.5h16.5M5.625 4.5h12.75a1.875 1.875 0 010 3.75H5.625a1.875 1.875 0 010-3.75z" /></svg>
                        </button>
                    </div>

                    {{-- Columns (grid only) --}}
                    @if($viewMode === 'grid')
                    <div class="flex items-center bg-white dark:bg-white/5 rounded-xl border border-[#442247]/15 dark:border-white/10 p-0.5">
                        @foreach([2, 3] as $col)
                        <button wire:click="setColumns({{ $col }})" class="w-8 h-8 rounded-lg flex items-center justify-center text-xs font-black transition-all {{ $gridColumns === $col ? 'bg-[#B0A262] text-white shadow-sm' : 'text-gray-500 dark:text-gray-400 hover:text-[#442247]' }}">
                            {{ $col }}
                        </button>
                        @endforeach
                    </div>
                    @endif

                    {{-- Filter Toggle --}}
                    <button wire:click="$toggle('showFilters')" class="p-2 rounded-xl bg-white dark:bg-white/5 border border-[#442247]/15 dark:border-white/10 hover:border-[#B0A262] text-[#442247] dark:text-white transition-all relative">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M12 3c2.755 0 5.455.232 8.083.678.533.09.917.556.917 1.096v1.044a2.25 2.25 0 01-.659 1.591l-5.432 5.432a2.25 2.25 0 00-.659 1.591v2.927a2.25 2.25 0 01-1.244 2.013L9.75 21v-6.568a2.25 2.25 0 00-.659-1.591L3.659 7.409A2.25 2.25 0 013 5.818V4.774c0-.54.384-1.006.917-1.096A48.32 48.32 0 0112 3z" /></svg>
                        @if($search) <span class="absolute -top-1 -left-1 w-2.5 h-2.5 bg-[#B0A262] rounded-full"></span> @endif
                    </button>

                    <span class="text-xs text-[#442247]/50 dark:text-gray-400 font-bold">{{ $models->total() }} موديل</span>
                </div>
            </div>

            {{-- Filters Panel --}}
            @if($showFilters)
            <div class="mb-6 bg-white dark:bg-[#111] rounded-2xl p-4 border border-[#442247]/10 dark:border-white/10 shadow-md flex flex-wrap items-center gap-3">
                <button wire:click="$set('sortBy', 'popular')" class="px-4 py-2 rounded-xl text-sm font-bold transition-all {{ $sortBy === 'popular' ? 'bg-[#B0A262] text-white' : 'bg-[#442247]/5 dark:bg-white/5 text-[#442247] dark:text-gray-300 hover:bg-[#442247]/10' }}">الأكثر شهرة</button>
                <button wire:click="$set('sortBy', 'newest')" class="px-4 py-2 rounded-xl text-sm font-bold transition-all {{ $sortBy === 'newest' ? 'bg-[#B0A262] text-white' : 'bg-[#442247]/5 dark:bg-white/5 text-[#442247] dark:text-gray-300 hover:bg-[#442247]/10' }}">الأحدث</button>
                <button wire:click="$set('sortBy', 'featured')" class="px-4 py-2 rounded-xl text-sm font-bold transition-all {{ $sortBy === 'featured' ? 'bg-[#B0A262] text-white' : 'bg-[#442247]/5 dark:bg-white/5 text-[#442247] dark:text-gray-300 hover:bg-[#442247]/10' }}">المميزة</button>
                @if($search)
                <button wire:click="clearFilters" class="px-4 py-2 rounded-xl text-sm font-bold bg-red-50 dark:bg-red-500/10 text-red-600 dark:text-red-400 hover:bg-red-100 transition-all">مسح البحث</button>
                @endif
            </div>
            @endif

            {{-- Loading --}}
            <div wire:loading.flex wire:target="search,sortBy,setViewMode,setColumns" class="justify-center py-12">
                <div class="flex items-center gap-3 bg-white dark:bg-[#111] px-5 py-3 rounded-full shadow-lg border border-[#442247]/10 dark:border-white/10">
                    <svg class="w-5 h-5 text-[#B0A262] animate-spin" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4z"></path></svg>
                    <span class="text-sm font-bold text-[#442247] dark:text-white">جاري التحميل...</span>
                </div>
            </div>

            {{-- Models Grid --}}
            <div wire:loading.remove wire:target="search,sortBy,setViewMode,setColumns">
                @if($models->isEmpty())
                    <div class="text-center py-20 bg-white dark:bg-[#111] rounded-3xl border border-[#442247]/10 dark:border-white/10">
                        <svg class="w-20 h-20 mx-auto text-[#442247]/20 dark:text-gray-600 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1" d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9.003 9.003 0 008.354-5.646z" /></svg>
                        <h3 class="cairo text-xl font-black text-[#442247] dark:text-white mb-2">لا توجد نتائج</h3>
                        <p class="text-[#442247]/50 dark:text-gray-400 text-sm">جرب تغيير معايير البحث</p>
                    </div>
                @else
                    @if($viewMode === 'grid')
                    <div class="grid grid-cols-1 {{ $gridColumns === 3 ? 'md:grid-cols-3' : 'md:grid-cols-2' }} gap-6">
                        @foreach($models as $model)
                        <div class="group rounded-3xl overflow-hidden bg-white dark:bg-[#111] border-2 border-[#B0A262]/20 dark:border-white/10 hover:border-[#B0A262] hover:shadow-2xl transition-all duration-300" wire:key="model-{{ $model->id }}">
                            {{-- 3D Viewer --}}
                            <div class="relative aspect-square bg-gradient-to-br from-[#1a0a1e] to-[#0a0a0a] overflow-hidden">
                                @if($model->glb_url)
                                <model-viewer
                                    src="{{ $model->glb_url }}"
                                    alt="{{ $model->name }}"
                                    auto-rotate
                                    camera-controls
                                    interaction-prompt="none"
                                    shadow-intensity="1"
                                    exposure="1"
                                    camera-orbit="45deg 55deg auto"
                                    style="width: 100%; height: 100%; --poster-color: transparent;"
                                    loading="lazy"
                                ></model-viewer>
                                @elseif($model->preview_image_url)
                                <img src="{{ $model->preview_image_url }}" alt="{{ $model->name }}" class="w-full h-full object-cover">
                                @else
                                <div class="w-full h-full flex items-center justify-center">
                                    <svg class="w-20 h-20 text-[#B0A262]/20" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1" d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9.003 9.003 0 008.354-5.646z" /></svg>
                                </div>
                                @endif

                                {{-- Featured Badge --}}
                                @if($model->is_featured)
                                <div class="absolute top-4 left-4 bg-[#442247] text-white px-3 py-1.5 rounded-full text-xs font-black flex items-center gap-1.5 shadow-lg z-10">
                                    <svg class="w-3.5 h-3.5 text-[#B0A262]" fill="currentColor" viewBox="0 0 24 24"><path d="M10.788 3.21c.448-1.077 1.976-1.077 2.424 0l2.082 5.007 5.404.433c1.164.093 1.636 1.545.749 2.305l-4.117 3.527 1.257 5.273c.271 1.136-.964 2.033-1.96 1.425L12 18.354 7.373 21.18c-.996.608-2.231-.29-1.96-1.425l1.257-5.273-4.117-3.527c-.887-.76-.415-2.212.749-2.305l5.404-.433 2.082-5.006z" /></svg>
                                    موصى به
                                </div>
                                @endif

                                {{-- Designs count badge --}}
                                <div class="absolute bottom-4 right-4 bg-black/50 backdrop-blur-sm text-white px-3 py-1.5 rounded-full text-xs font-bold flex items-center gap-1.5 z-10">
                                    <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M9.53 16.122a3 3 0 00-5.78 1.128 2.25 2.25 0 01-2.4 2.245 4.5 4.5 0 008.4-2.245c0-.399-.078-.78-.22-1.128zm0 0a15.998 15.998 0 003.388-1.62m-5.043-.025a15.994 15.994 0 011.622-3.395m3.42 3.42a15.995 15.995 0 004.764-4.648l3.876-5.814a1.151 1.151 0 00-1.597-1.597L14.146 6.32a15.996 15.996 0 00-4.649 4.763m3.42 3.42a6.776 6.776 0 00-3.42-3.42" /></svg>
                                    {{ $model->designs_count }} تصميم
                                </div>
                            </div>

                            {{-- Content --}}
                            <div class="p-5 bg-gradient-to-b from-white to-[#faf8f2] dark:from-[#111] dark:to-[#0d0d0d]">
                                <div class="flex items-start gap-2 mb-2">
                                    <h3 class="cairo text-lg font-black text-[#442247] dark:text-white group-hover:text-[#B0A262] transition-colors flex-1">
                                        {{ $model->name }}
                                    </h3>
                                    {{-- 3D Badge --}}
                                    <span class="shrink-0 w-7 h-7 rounded-full bg-[#442247]/10 dark:bg-[#B0A262]/10 flex items-center justify-center" title="موديل ثلاثي الأبعاد">
                                        <svg class="w-4 h-4 text-[#442247] dark:text-[#B0A262]" viewBox="0 0 24 24" fill="currentColor"><path d="M12 2L2 7l10 5 10-5-10-5zM2 17l10 5 10-5M2 12l10 5 10-5"/></svg>
                                    </span>
                                </div>

                                @if($model->description)
                                <p class="text-sm text-[#442247]/60 dark:text-gray-400 mb-3 line-clamp-2">
                                    {{ $model->description }}
                                </p>
                                @endif

                                {{-- Feature Badges --}}
                                @php
                                    $options = $model->available_options ?? [];
                                    $features = [];
                                    if(in_array('color', array_keys($options))) $features[] = ['icon' => '🎨', 'label' => 'ألوان مخصصة'];
                                    if(in_array('text', array_keys($options))) $features[] = ['icon' => 'A', 'label' => 'إضافة نصوص'];
                                    if(in_array('image', array_keys($options)) || in_array('sticker', array_keys($options))) $features[] = ['icon' => '🖼', 'label' => 'رفع صور'];
                                    if(in_array('material', array_keys($options)) || in_array('texture', array_keys($options))) {
                                        $count = count($options['texture'] ?? $options['material'] ?? []);
                                        $features[] = ['icon' => '🧶', 'label' => ($count > 0 ? $count : '') . ' خامات'];
                                    }
                                    if(count($features) === 0) {
                                        $features[] = ['icon' => '🎨', 'label' => 'تخصيص الألوان'];
                                        $features[] = ['icon' => '👁', 'label' => 'عرض 360°'];
                                        $features[] = ['icon' => '✂', 'label' => 'تخصيص كامل'];
                                    }
                                @endphp
                                <div class="flex flex-wrap gap-1.5 mb-4">
                                    @foreach($features as $feat)
                                    <span class="inline-flex items-center gap-1 px-2.5 py-1 rounded-lg bg-[#442247]/5 dark:bg-white/5 border border-[#442247]/10 dark:border-white/10 text-[10px] font-bold text-[#442247]/70 dark:text-gray-300">
                                        <span>{{ $feat['icon'] }}</span> {{ $feat['label'] }}
                                    </span>
                                    @endforeach
                                </div>

                                {{-- Actions --}}
                                <div class="flex gap-3">
                                    <a href="{{ route('configurator.show', $model) }}"
                                       class="flex-1 py-3 rounded-xl gold-gradient text-[#442247] font-black text-center text-sm flex items-center justify-center gap-2 hover:scale-[1.02] transition-transform shadow-md">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" stroke-width="2.5" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M9.594 3.94c.09-.542.56-.94 1.11-.94h2.593c.55 0 1.02.398 1.11.94l.213 1.281c.063.374.313.686.645.87.074.04.147.083.22.127.324.196.72.257 1.075.124l1.217-.456a1.125 1.125 0 011.37.49l1.296 2.247a1.125 1.125 0 01-.26 1.431l-1.003.827c-.293.24-.438.613-.431.992a6.759 6.759 0 010 .255c-.007.378.138.75.43.99l1.005.828c.424.35.534.954.26 1.43l-1.298 2.247a1.125 1.125 0 01-1.369.491l-1.217-.456c-.355-.133-.75-.072-1.076.124a6.57 6.57 0 01-.22.128c-.331.183-.581.495-.644.869l-.213 1.28c-.09.543-.56.941-1.11.941h-2.594c-.55 0-1.02-.398-1.11-.94l-.213-1.281c-.062-.374-.312-.686-.644-.87a6.52 6.52 0 01-.22-.127c-.325-.196-.72-.257-1.076-.124l-1.217.456a1.125 1.125 0 01-1.369-.49l-1.297-2.247a1.125 1.125 0 01.26-1.431l1.004-.827c.292-.24.437-.613.43-.992a6.932 6.932 0 010-.255c.007-.378-.138-.75-.43-.99l-1.004-.828a1.125 1.125 0 01-.26-1.43l1.297-2.247a1.125 1.125 0 011.37-.491l1.216.456c.356.133.751.072 1.076-.124.072-.044.146-.087.22-.128.332-.183.582-.495.644-.869l.214-1.281z" /><path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" /></svg>
                                        تخصيص الآن
                                    </a>
                                    @if($model->glb_url)
                                    <button onclick="window.open('{{ route('configurator.show', $model) }}', '_blank')" class="px-4 py-3 rounded-xl bg-white dark:bg-white/5 border border-[#442247]/15 dark:border-white/10 hover:border-[#B0A262] text-[#442247] dark:text-white font-bold text-sm transition-all flex items-center gap-2">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M2.036 12.322a1.012 1.012 0 010-.639C3.423 7.51 7.36 4.5 12 4.5c4.638 0 8.573 3.007 9.963 7.178.07.207.07.431 0 .639C20.577 16.49 16.64 19.5 12 19.5c-4.638 0-8.573-3.007-9.963-7.178z" /><path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" /></svg>
                                        معاينة
                                    </button>
                                    @endif
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                    @else
                    {{-- List View --}}
                    <div class="space-y-4">
                        @foreach($models as $model)
                        <div class="group bg-white dark:bg-[#111] rounded-2xl overflow-hidden border-2 border-[#B0A262]/20 dark:border-white/10 hover:border-[#B0A262] transition-all duration-300 hover:shadow-xl" wire:key="model-list-{{ $model->id }}">
                            <div class="flex flex-col md:flex-row">
                                {{-- 3D Viewer --}}
                                <div class="relative w-full md:w-64 h-56 md:h-auto bg-gradient-to-br from-[#1a0a1e] to-[#0a0a0a] flex-shrink-0">
                                    @if($model->glb_url)
                                    <model-viewer
                                        src="{{ $model->glb_url }}"
                                        alt="{{ $model->name }}"
                                        auto-rotate
                                        camera-controls
                                        interaction-prompt="none"
                                        shadow-intensity="1"
                                        camera-orbit="45deg 55deg auto"
                                        style="width: 100%; height: 100%; --poster-color: transparent;"
                                        loading="lazy"
                                    ></model-viewer>
                                    @elseif($model->preview_image_url)
                                    <img src="{{ $model->preview_image_url }}" alt="{{ $model->name }}" class="w-full h-full object-cover">
                                    @endif
                                    @if($model->is_featured)
                                    <div class="absolute top-3 left-3 bg-[#442247] text-white px-3 py-1 rounded-full text-xs font-black flex items-center gap-1.5 z-10">
                                        <svg class="w-3 h-3 text-[#B0A262]" fill="currentColor" viewBox="0 0 24 24"><path d="M10.788 3.21c.448-1.077 1.976-1.077 2.424 0l2.082 5.007 5.404.433c1.164.093 1.636 1.545.749 2.305l-4.117 3.527 1.257 5.273c.271 1.136-.964 2.033-1.96 1.425L12 18.354 7.373 21.18c-.996.608-2.231-.29-1.96-1.425l1.257-5.273-4.117-3.527c-.887-.76-.415-2.212.749-2.305l5.404-.433 2.082-5.006z" /></svg>
                                        موصى به
                                    </div>
                                    @endif
                                </div>
                                {{-- Content --}}
                                <div class="flex-1 p-5 flex flex-col justify-between">
                                    <div>
                                        <div class="flex items-start gap-2 mb-2">
                                            <h3 class="cairo text-xl font-black text-[#442247] dark:text-white group-hover:text-[#B0A262] transition-colors flex-1">{{ $model->name }}</h3>
                                            <span class="shrink-0 bg-[#442247]/10 dark:bg-[#B0A262]/10 text-[#442247] dark:text-[#B0A262] px-2.5 py-1 rounded-lg text-xs font-bold">{{ $model->designs_count }} تصميم</span>
                                        </div>
                                        @if($model->description)
                                        <p class="text-sm text-[#442247]/60 dark:text-gray-400 mb-3 line-clamp-2">{{ $model->description }}</p>
                                        @endif
                                        @php
                                            $options = $model->available_options ?? [];
                                            $features = [];
                                            if(in_array('color', array_keys($options))) $features[] = ['icon' => '🎨', 'label' => 'ألوان مخصصة'];
                                            if(in_array('text', array_keys($options))) $features[] = ['icon' => 'A', 'label' => 'إضافة نصوص'];
                                            if(in_array('image', array_keys($options)) || in_array('sticker', array_keys($options))) $features[] = ['icon' => '🖼', 'label' => 'رفع صور'];
                                            if(count($features) === 0) {
                                                $features[] = ['icon' => '🎨', 'label' => 'تخصيص الألوان'];
                                                $features[] = ['icon' => '👁', 'label' => 'عرض 360°'];
                                                $features[] = ['icon' => '✂', 'label' => 'تخصيص كامل'];
                                            }
                                        @endphp
                                        <div class="flex flex-wrap gap-1.5 mb-4">
                                            @foreach($features as $feat)
                                            <span class="inline-flex items-center gap-1 px-2.5 py-1 rounded-lg bg-[#442247]/5 dark:bg-white/5 border border-[#442247]/10 dark:border-white/10 text-[10px] font-bold text-[#442247]/70 dark:text-gray-300">
                                                <span>{{ $feat['icon'] }}</span> {{ $feat['label'] }}
                                            </span>
                                            @endforeach
                                        </div>
                                    </div>
                                    <div class="flex gap-3">
                                        <a href="{{ route('configurator.show', $model) }}" class="px-6 py-3 rounded-xl gold-gradient text-[#442247] font-black text-sm flex items-center gap-2 hover:scale-[1.02] transition-transform shadow-md">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" stroke-width="2.5" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M9.594 3.94c.09-.542.56-.94 1.11-.94h2.593c.55 0 1.02.398 1.11.94l.213 1.281c.063.374.313.686.645.87.074.04.147.083.22.127.324.196.72.257 1.075.124l1.217-.456a1.125 1.125 0 011.37.49l1.296 2.247a1.125 1.125 0 01-.26 1.431l-1.003.827c-.293.24-.438.613-.431.992a6.759 6.759 0 010 .255c-.007.378.138.75.43.99l1.005.828c.424.35.534.954.26 1.43l-1.298 2.247a1.125 1.125 0 01-1.369.491l-1.217-.456c-.355-.133-.75-.072-1.076.124a6.57 6.57 0 01-.22.128c-.331.183-.581.495-.644.869l-.213 1.28c-.09.543-.56.941-1.11.941h-2.594c-.55 0-1.02-.398-1.11-.94l-.213-1.281c-.062-.374-.312-.686-.644-.87a6.52 6.52 0 01-.22-.127c-.325-.196-.72-.257-1.076-.124l-1.217.456a1.125 1.125 0 01-1.369-.49l-1.297-2.247a1.125 1.125 0 01.26-1.431l1.004-.827c.292-.24.437-.613.43-.992a6.932 6.932 0 010-.255c.007-.378-.138-.75-.43-.99l-1.004-.828a1.125 1.125 0 01-.26-1.43l1.297-2.247a1.125 1.125 0 011.37-.491l1.216.456c.356.133.751.072 1.076-.124.072-.044.146-.087.22-.128.332-.183.582-.495.644-.869l.214-1.281z" /><path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" /></svg>
                                            تخصيص الآن
                                        </a>
                                        <button onclick="window.open('{{ route('configurator.show', $model) }}', '_blank')" class="px-4 py-3 rounded-xl bg-white dark:bg-white/5 border border-[#442247]/15 dark:border-white/10 hover:border-[#B0A262] text-[#442247] dark:text-white font-bold text-sm transition-all flex items-center gap-2">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" d="M2.036 12.322a1.012 1.012 0 010-.639C3.423 7.51 7.36 4.5 12 4.5c4.638 0 8.573 3.007 9.963 7.178.07.207.07.431 0 .639C20.577 16.49 16.64 19.5 12 19.5c-4.638 0-8.573-3.007-9.963-7.178z" /><path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" /></svg>
                                            معاينة
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                    @endif

                    {{-- Pagination --}}
                    @if($models->hasPages())
                    <div class="mt-10">
                        {{ $models->links() }}
                    </div>
                    @endif
                @endif
            </div>
        </div>
    </section>
</div>
