<div class="glass rounded-3xl p-8 border border-white/10">
    <div class="text-center mb-8">
        <h2 class="cairo text-3xl font-black mb-2">إعادة تعيين كلمة المرور</h2>
        <p class="text-gray-400">أدخل الرمز وكلمة المرور الجديدة</p>
    </div>

    @if (session()->has('success'))
        <div class="mb-4 p-4 rounded-2xl bg-emerald-500/10 border border-emerald-500/20 text-emerald-200">
            {{ session('success') }}
        </div>
    @endif

    <form wire:submit.prevent="resetPassword" class="space-y-4">
        <div>
            <label class="block text-sm text-gray-300 mb-2">رقم الهاتف</label>
            <input wire:model.defer="phone" type="text" inputmode="numeric" autocomplete="tel"
                   class="w-full px-4 py-3 rounded-2xl bg-white/5 border border-white/10 focus:border-[var(--primary-gold)] outline-none">
            @error('phone') <div class="text-sm text-red-300 mt-2">{{ $message }}</div> @enderror
        </div>

        <div>
            <label class="block text-sm text-gray-300 mb-2">الرمز</label>
            <input wire:model.defer="token" type="text" autocomplete="one-time-code"
                   class="w-full px-4 py-3 rounded-2xl bg-white/5 border border-white/10 focus:border-[var(--primary-gold)] outline-none">
            @error('token') <div class="text-sm text-red-300 mt-2">{{ $message }}</div> @enderror
        </div>

        <div>
            <label class="block text-sm text-gray-300 mb-2">كلمة المرور الجديدة</label>
            <input wire:model.defer="password" type="password" autocomplete="new-password"
                   class="w-full px-4 py-3 rounded-2xl bg-white/5 border border-white/10 focus:border-[var(--primary-gold)] outline-none">
            @error('password') <div class="text-sm text-red-300 mt-2">{{ $message }}</div> @enderror
        </div>

        <div>
            <label class="block text-sm text-gray-300 mb-2">تأكيد كلمة المرور</label>
            <input wire:model.defer="password_confirmation" type="password" autocomplete="new-password"
                   class="w-full px-4 py-3 rounded-2xl bg-white/5 border border-white/10 focus:border-[var(--primary-gold)] outline-none">
        </div>

        <button type="submit"
                class="w-full gold-gradient text-black px-6 py-3 rounded-2xl font-bold hover:scale-[1.02] transition">
            حفظ كلمة المرور
        </button>
    </form>
</div>
