<div x-data="{ clientType: @entangle('client_type') }">
    <form wire:submit.prevent="register" class="space-y-5">
        {{-- Account Type --}}
        <div>
            <p class="text-center text-gray-300 text-sm font-bold mb-3">نوع الحساب</p>
            <div class="flex gap-3">
                <div @click="clientType = 'company'"
                    class="flex-1 flex flex-col items-center justify-center gap-2 px-4 py-4 rounded-xl border transition-all cursor-pointer"
                    :class="clientType === 'company' ? 'border-[#D4A356] bg-[#D4A356]/10' : 'border-white/10 hover:bg-white/5'">
                    <svg class="w-6 h-6 transition-colors"
                        :class="clientType === 'company' ? 'text-[#D4A356]' : 'text-gray-400'" fill="none"
                        stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                            d="M3.75 21h16.5M4.5 3h15M5.25 3v18m13.5-18v18M9 6.75h1.5m-1.5 3h1.5m-1.5 3h1.5m3-6H15m-1.5 3H15m-1.5 3H15M9 21v-3.375c0-.621.504-1.125 1.125-1.125h3.75c.621 0 1.125.504 1.125 1.125V21" />
                    </svg>
                    <span class="text-sm font-bold transition-colors"
                        :class="clientType === 'company' ? 'text-[#D4A356]' : 'text-white'">حساب جملة</span>
                </div>

                <div @click="clientType = 'personal'"
                    class="flex-1 flex flex-col items-center justify-center gap-2 px-4 py-4 rounded-xl border transition-all cursor-pointer"
                    :class="clientType === 'personal' ? 'border-[#D4A356] bg-[#D4A356]/10' : 'border-white/10 hover:bg-white/5'">
                    <svg class="w-6 h-6 transition-colors"
                        :class="clientType === 'personal' ? 'text-[#D4A356]' : 'text-gray-400'" fill="none"
                        stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                            d="M15.75 6a3.75 3.75 0 11-7.5 0 3.75 3.75 0 017.5 0zM4.501 20.118a7.5 7.5 0 0114.998 0A17.933 17.933 0 0112 21.75c-2.676 0-5.216-.584-7.499-1.632z" />
                    </svg>
                    <span class="text-sm font-bold transition-colors"
                        :class="clientType === 'personal' ? 'text-[#D4A356]' : 'text-white'">حساب مفرد</span>
                </div>

                <div @click="clientType = 'designer'"
                    class="flex-1 flex flex-col items-center justify-center gap-2 px-4 py-4 rounded-xl border transition-all cursor-pointer"
                    :class="clientType === 'designer' ? 'border-[#D4A356] bg-[#D4A356]/10' : 'border-white/10 hover:bg-white/5'">
                    <svg class="w-6 h-6 transition-colors"
                        :class="clientType === 'designer' ? 'text-[#D4A356]' : 'text-gray-400'" fill="none"
                        stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                            d="M9.53 16.122a3 3 0 00-5.78 1.128 2.25 2.25 0 01-2.4 2.245 4.5 4.5 0 008.4-2.245c0-.399-.078-.78-.22-1.128zm0 0a15.998 15.998 0 003.388-1.62m-5.043-.025a15.994 15.994 0 011.622-3.395m3.42 3.42a15.995 15.995 0 004.764-4.648l3.876-5.814a1.151 1.151 0 00-1.597-1.597L14.146 6.32a15.996 15.996 0 00-4.649 4.763m3.42 3.42a6.776 6.776 0 00-3.42-3.42" />
                    </svg>
                    <span class="text-sm font-bold transition-colors"
                        :class="clientType === 'designer' ? 'text-[#D4A356]' : 'text-white'">مصمم</span>
                </div>
            </div>
        </div>

        {{-- Company Name (if company) --}}
        <div x-show="clientType === 'company'" x-collapse>
            <div class="relative">
                <input wire:model.defer="company" type="text" autocomplete="organization"
                    class="w-full pr-12 pl-4 py-4 rounded-xl bg-white/5 border border-white/10 focus:border-[#D4A356] focus:ring-2 focus:ring-[#D4A356]/20 outline-none transition-all text-white placeholder-gray-500"
                    placeholder="اسم الشركة">
                <div class="absolute inset-y-0 right-0 flex items-center pr-4 pointer-events-none">
                    <svg class="w-5 h-5 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                            d="M3.75 21h16.5M4.5 3h15M5.25 3v18m13.5-18v18M9 6.75h1.5m-1.5 3h1.5m-1.5 3h1.5m3-6H15m-1.5 3H15m-1.5 3H15M9 21v-3.375c0-.621.504-1.125 1.125-1.125h3.75c.621 0 1.125.504 1.125 1.125V21" />
                    </svg>
                </div>
            </div>
            @error('company')
                <p class="mt-2 text-sm text-red-400">{{ $message }}</p>
            @enderror
        </div>

        {{-- Name --}}
        <div>
            <div class="relative">
                <input wire:model.defer="name" type="text" autocomplete="name"
                    class="w-full pr-12 pl-4 py-4 rounded-xl bg-white/5 border border-white/10 focus:border-[#D4A356] focus:ring-2 focus:ring-[#D4A356]/20 outline-none transition-all text-white placeholder-gray-500"
                    placeholder="الاسم الكامل">
                <div class="absolute inset-y-0 right-0 flex items-center pr-4 pointer-events-none">
                    <svg class="w-5 h-5 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                            d="M15.75 6a3.75 3.75 0 11-7.5 0 3.75 3.75 0 017.5 0zM4.501 20.118a7.5 7.5 0 0114.998 0A17.933 17.933 0 0112 21.75c-2.676 0-5.216-.584-7.499-1.632z" />
                    </svg>
                </div>
            </div>
            @error('name')
                <p class="mt-2 text-sm text-red-400">{{ $message }}</p>
            @enderror
        </div>

        {{-- Phone --}}
        <div>
            <div class="relative">
                <input wire:model.defer="phone" type="text" inputmode="numeric" autocomplete="tel" maxlength="11"
                    class="w-full pr-12 pl-4 py-4 rounded-xl bg-white/5 border border-white/10 focus:border-[#D4A356] focus:ring-2 focus:ring-[#D4A356]/20 outline-none transition-all text-white placeholder-gray-500"
                    placeholder="رقم الهاتف">
                <div class="absolute inset-y-0 right-0 flex items-center pr-4 pointer-events-none">
                    <svg class="w-5 h-5 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                            d="M2.25 6.75c0 8.284 6.716 15 15 15h2.25a2.25 2.25 0 002.25-2.25v-1.372c0-.516-.351-.966-.852-1.091l-4.423-1.106c-.44-.11-.902.055-1.173.417l-.97 1.293c-.282.376-.769.542-1.21.38a12.035 12.035 0 01-7.143-7.143c-.162-.441.004-.928.38-1.21l1.293-.97c.363-.271.527-.734.417-1.173L6.963 3.102a1.125 1.125 0 00-1.091-.852H4.5A2.25 2.25 0 002.25 4.5v2.25z" />
                    </svg>
                </div>
            </div>
            @error('phone')
                <p class="mt-2 text-sm text-red-400">{{ $message }}</p>
            @enderror
        </div>

        {{-- Password with Strength Bar --}}
        <div x-data="{
            show: false,
            pwd: '',
            init() {
                this.$watch('pwd', value => {
                    $wire.set('password', value, false);
                });
            },
            get strength() {
                let score = 0;
                if (this.pwd.length >= 6) score++;
                if (this.pwd.length >= 8) score++;
                if (/[A-Z]/.test(this.pwd)) score++;
                if (/[0-9]/.test(this.pwd)) score++;
                if (/[^A-Za-z0-9]/.test(this.pwd)) score++;
                return score;
            },
            get strengthBarColor() {
                if (this.pwd.length === 0) return 'bg-transparent';
                if (this.strength <= 2) return 'bg-gradient-to-l from-red-500 to-red-400';
                if (this.strength <= 3) return 'bg-gradient-to-l from-yellow-500 to-[#D4A356]';
                return 'bg-gradient-to-l from-green-500 to-green-400';
            },
            get strengthPercent() {
                if (this.pwd.length === 0) return 0;
                return (this.strength / 5) * 100;
            }
        }">
            <div class="relative">
                <input x-model="pwd" :type="show ? 'text' : 'password'" autocomplete="new-password"
                    class="w-full pr-12 pl-12 py-4 rounded-xl bg-white/5 border border-white/10 focus:border-[#D4A356] focus:ring-2 focus:ring-[#D4A356]/20 outline-none transition-all text-white placeholder-gray-500"
                    placeholder="كلمة المرور">
                <div class="absolute inset-y-0 right-0 flex items-center pr-4 pointer-events-none">
                    <svg class="w-5 h-5 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                            d="M16.5 10.5V6.75a4.5 4.5 0 10-9 0v3.75m-.75 11.25h10.5a2.25 2.25 0 002.25-2.25v-6.75a2.25 2.25 0 00-2.25-2.25H6.75a2.25 2.25 0 00-2.25 2.25v6.75a2.25 2.25 0 002.25 2.25z" />
                    </svg>
                </div>
                <button type="button" tabindex="-1" @click="show = !show"
                    class="absolute inset-y-0 left-0 flex items-center pl-4 text-gray-500 hover:text-white transition-colors">
                    <svg x-show="!show" class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                            d="M2.036 12.322a1.012 1.012 0 010-.639C3.423 7.51 7.36 4.5 12 4.5c4.638 0 8.573 3.007 9.963 7.178.07.207.07.431 0 .639C20.577 16.49 16.64 19.5 12 19.5c-4.638 0-8.573-3.007-9.963-7.178z" />
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                            d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                    </svg>
                    <svg x-show="show" x-cloak class="w-5 h-5" fill="none" stroke="currentColor"
                        viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                            d="M3.98 8.223A10.477 10.477 0 001.934 12C3.226 16.338 7.244 19.5 12 19.5c.993 0 1.953-.138 2.863-.395M6.228 6.228A10.45 10.45 0 0112 4.5c4.756 0 8.773 3.162 10.065 7.498a10.523 10.523 0 01-4.293 5.774M6.228 6.228L3 3m3.228 3.228l3.65 3.65m7.894 7.894L21 21m-3.228-3.228l-3.65-3.65m0 0a3 3 0 10-4.243-4.243m4.242 4.242L9.88 9.88" />
                    </svg>
                </button>
            </div>
            {{-- Password Strength Bar --}}
            <div class="h-1.5 mt-2 bg-white/10 rounded-full overflow-hidden">
                <div class="h-full transition-all duration-300 rounded-full" :class="strengthBarColor"
                    :style="'width: ' + strengthPercent + '%'"></div>
            </div>
            @error('password')
                <p class="mt-2 text-sm text-red-400">{{ $message }}</p>
            @enderror
        </div>

        {{-- Confirm Password --}}
        <div x-data="{ show: false }">
            <div class="relative">
                <input wire:model.defer="password_confirmation" :type="show ? 'text' : 'password'"
                    autocomplete="new-password"
                    class="w-full pr-12 pl-12 py-4 rounded-xl bg-white/5 border border-white/10 focus:border-[#D4A356] focus:ring-2 focus:ring-[#D4A356]/20 outline-none transition-all text-white placeholder-gray-500"
                    placeholder="تأكيد كلمة المرور">
                <div class="absolute inset-y-0 right-0 flex items-center pr-4 pointer-events-none">
                    <svg class="w-5 h-5 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                            d="M16.5 10.5V6.75a4.5 4.5 0 10-9 0v3.75m-.75 11.25h10.5a2.25 2.25 0 002.25-2.25v-6.75a2.25 2.25 0 00-2.25-2.25H6.75a2.25 2.25 0 00-2.25 2.25v6.75a2.25 2.25 0 002.25 2.25z" />
                    </svg>
                </div>
                <button type="button" tabindex="-1" @click="show = !show"
                    class="absolute inset-y-0 left-0 flex items-center pl-4 text-gray-500 hover:text-white transition-colors">
                    <svg x-show="!show" class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                            d="M2.036 12.322a1.012 1.012 0 010-.639C3.423 7.51 7.36 4.5 12 4.5c4.638 0 8.573 3.007 9.963 7.178.07.207.07.431 0 .639C20.577 16.49 16.64 19.5 12 19.5c-4.638 0-8.573-3.007-9.963-7.178z" />
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                            d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                    </svg>
                    <svg x-show="show" x-cloak class="w-5 h-5" fill="none" stroke="currentColor"
                        viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                            d="M3.98 8.223A10.477 10.477 0 001.934 12C3.226 16.338 7.244 19.5 12 19.5c.993 0 1.953-.138 2.863-.395M6.228 6.228A10.45 10.45 0 0112 4.5c4.756 0 8.773 3.162 10.065 7.498a10.523 10.523 0 01-4.293 5.774M6.228 6.228L3 3m3.228 3.228l3.65 3.65m7.894 7.894L21 21m-3.228-3.228l-3.65-3.65m0 0a3 3 0 10-4.243-4.243m4.242 4.242L9.88 9.88" />
                    </svg>
                </button>
            </div>
        </div>

        {{-- Terms --}}
        <label class="flex items-start gap-3 cursor-pointer group">
            <div class="relative mt-0.5">
                <input wire:model="terms" type="checkbox" class="sr-only peer" tabindex="-1">
                <div
                    class="w-5 h-5 rounded border-2 border-white/20 peer-checked:border-[#D4A356] peer-checked:bg-[#D4A356] transition-all">
                </div>
                <svg class="w-3 h-3 absolute top-1 right-1 text-black opacity-0 peer-checked:opacity-100 transition-opacity"
                    fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M5 13l4 4L19 7" />
                </svg>
            </div>
            <span class="text-sm text-gray-400 group-hover:text-gray-300 transition-colors">
                أوافق على <a href="#" class="text-[#D4A356] hover:underline" tabindex="-1">الشروط والأحكام</a>
                و <a href="#" class="text-[#D4A356] hover:underline" tabindex="-1">سياسة الخصوصية</a>
            </span>
        </label>
        @error('terms')
            <p class="text-sm text-red-400">{{ $message }}</p>
        @enderror

        {{-- Newsletter --}}
        <label class="flex items-start gap-3 cursor-pointer group">
            <div class="relative mt-0.5">
                <input wire:model="newsletter" type="checkbox" class="sr-only peer" tabindex="-1">
                <div
                    class="w-5 h-5 rounded border-2 border-white/20 peer-checked:border-[#D4A356] peer-checked:bg-[#D4A356] transition-all">
                </div>
                <svg class="w-3 h-3 absolute top-1 right-1 text-black opacity-0 peer-checked:opacity-100 transition-opacity"
                    fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M5 13l4 4L19 7" />
                </svg>
            </div>
            <span class="text-sm text-gray-400 group-hover:text-gray-300 transition-colors">
                أرغب في تلقي العروض والأخبار عبر البريد الإلكتروني
            </span>
        </label>

        {{-- Submit --}}
        <button type="submit"
            class="w-full bg-gradient-to-r from-[#D4A356] to-[#442247] text-black py-4 rounded-xl font-black text-lg hover:shadow-lg hover:shadow-[#D4A356]/20 hover:scale-[1.02] transition-all flex items-center justify-center gap-3"
            wire:loading.attr="disabled" wire:loading.class="opacity-70 cursor-not-allowed">
            <span wire:loading.remove>إنشاء الحساب</span>
            <span wire:loading class="flex items-center gap-2">
                <svg class="w-5 h-5 animate-spin" fill="none" viewBox="0 0 24 24">
                    <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor"
                        stroke-width="4"></circle>
                    <path class="opacity-75" fill="currentColor"
                        d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z">
                    </path>
                </svg>
                جاري التسجيل...
            </span>
        </button>
    </form>
</div>
