{{-- Cart Overlay --}}
<div class="drawer-overlay" id="cartOverlay" onclick="closeCart()"></div>

{{-- Cart Drawer --}}
<div class="drawer drawer-right" id="cartDrawer">
    <div class="p-6 border-b border-white/10">
        <div class="flex items-center justify-between">
            <h2 class="cairo text-2xl font-bold text-white flex items-center gap-2">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z" />
                </svg>
                سلة التسوق (<span id="cartItemsCount">0</span>)
            </h2>
            <button onclick="closeCart()" class="p-2 hover:bg-white/5 rounded-full transition-colors">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                </svg>
            </button>
        </div>
    </div>

    <div class="p-6 flex-1" id="cartItems">
        <div class="text-center py-12 text-gray-400">
            <svg class="w-24 h-24 mx-auto mb-4 opacity-50" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z" />
            </svg>
            <p class="text-lg">سلة التسوق فارغة</p>
        </div>
    </div>

    <div class="p-6 border-t border-white/10 mt-auto">
        {{-- Free Shipping Progress --}}
        <div id="shippingProgress" class="mb-6 shipping-progress glass rounded-2xl p-4 border border-white/10">
            <div class="flex items-center justify-between text-sm mb-3">
                <span class="text-gray-300 font-bold">التوصيل المجاني</span>
                <span class="text-gray-400">حد الطلب: <span class="font-black threshold">100,000</span> د.ع</span>
            </div>
            <div class="progress-track">
                <div class="progress-fill" id="shippingProgressFill" style="width:0%"></div>
            </div>
            <div class="mt-3 text-sm" id="shippingProgressText"></div>
        </div>

        <div class="space-y-4 mb-6">
            <div class="flex items-center justify-between text-gray-400">
                <span>المجموع الفرعي</span>
                <span id="subtotal">0 د.ع</span>
            </div>
            <div class="flex items-center justify-between text-gray-400">
                <span>الشحن</span>
                <span id="shippingFee">0 د.ع</span>
            </div>
            <div class="flex items-center justify-between text-xl font-bold">
                <span>الإجمالي</span>
                <span class="text-[#D4A356]" id="total">0 د.ع</span>
            </div>
        </div>
        <button class="w-full gold-gradient text-black py-4 rounded-full font-bold text-lg hover:shadow-2xl transition-all duration-300 hover:scale-105">
            إتمام الطلب
        </button>
        <button onclick="closeCart()" class="w-full mt-3 glass text-white py-4 rounded-full font-bold text-lg border-2 border-[#D4A356] hover:scale-105 transition-all duration-300">
            متابعة التسوق
        </button>
    </div>
</div>
