@section('hero_description', 'وصف الصفحة')

@section('hero_breadcrumbs')
    <i class="fas fa-chevron-left hb-sep"></i>
    <span class="hb-current">اسم الصفحة</span>
@endsection

@hasSection('hero_title')

    <section class="page-hero">
        <div class="page-hero-bg"></div>

        <div class="page-hero-inner site-container">
            <div class="page-hero-text">
                {{-- Breadcrumbs --}}
                <div class="hero-breadcrumb">
                    <a href="{{ route('home') }}">
                        <i class="fas fa-home"></i>
                        <span>الرئيسية</span>
                    </a>

                    {{-- If the page provides custom breadcrumbs, use it. Otherwise default to current title --}}
                    @hasSection('hero_breadcrumbs')
                        @yield('hero_breadcrumbs')
                    @else
                        <i class="fas fa-chevron-left hb-sep"></i>
                        <span class="hb-current">@yield('hero_title')</span>
                    @endif
                </div>

                {{-- Title --}}
                <h1 class="cairo hero-heading">
                    @hasSection('hero_icon')
                        {{-- Support emoji OR icon HTML --}}
                        <span class="hero-emoji">@yield('hero_icon')</span>
                    @endif
                    @yield('hero_title')
                </h1>

                {{-- Description --}}
                @hasSection('hero_description')
                    <p>@yield('hero_description')</p>
                @endif
            </div>

            {{-- Animated Socks Illustration --}}
            <div class="page-hero-illustration" aria-hidden="true">
                <div class="socks-illustration">
                    <svg viewBox="0 0 200 200" fill="none" xmlns="http://www.w3.org/2000/svg">
                        {{-- Left Sock --}}
                        <g class="sock-left">
                            {{-- Sock body --}}
                            <path d="M50 40 L50 90 C50 100 55 105 60 105 L75 105 L75 120 C75 130 70 140 75 145 C80 150 90 148 95 140 L100 110 L100 40 Z"
                                  fill="var(--sock-primary)" stroke="var(--sock-stroke)" stroke-width="2" opacity="0.9"/>
                            
                            {{-- Sock stripes --}}
                            <rect x="50" y="50" width="50" height="4" fill="var(--sock-accent)" opacity="0.8" class="stripe-1"/>
                            <rect x="50" y="60" width="50" height="4" fill="var(--sock-accent)" opacity="0.8" class="stripe-2"/>
                            <rect x="50" y="70" width="50" height="4" fill="var(--sock-accent)" opacity="0.8" class="stripe-3"/>
                            
                            {{-- Pattern dots --}}
                            <circle cx="65" cy="85" r="3" fill="var(--sock-accent)" opacity="0.6" class="dot-1"/>
                            <circle cx="75" cy="85" r="3" fill="var(--sock-accent)" opacity="0.6" class="dot-2"/>
                            <circle cx="85" cy="85" r="3" fill="var(--sock-accent)" opacity="0.6" class="dot-3"/>
                        </g>

                        {{-- Right Sock --}}
                        <g class="sock-right">
                            {{-- Sock body --}}
                            <path d="M150 45 L150 95 C150 105 145 110 140 110 L125 110 L125 125 C125 135 130 145 125 150 C120 155 110 153 105 145 L100 115 L100 45 Z"
                                  fill="var(--sock-secondary)" stroke="var(--sock-stroke)" stroke-width="2" opacity="0.9"/>
                            
                            {{-- Sock stripes --}}
                            <rect x="100" y="55" width="50" height="4" fill="var(--sock-accent-2)" opacity="0.8" class="stripe-4"/>
                            <rect x="100" y="65" width="50" height="4" fill="var(--sock-accent-2)" opacity="0.8" class="stripe-5"/>
                            <rect x="100" y="75" width="50" height="4" fill="var(--sock-accent-2)" opacity="0.8" class="stripe-6"/>
                            
                            {{-- Pattern zigzag --}}
                            <path d="M105 90 L115 95 L125 90 L135 95 L145 90" stroke="var(--sock-accent-2)" 
                                  stroke-width="2" fill="none" opacity="0.6" class="zigzag"/>
                        </g>

                        {{-- Decorative elements --}}
                        <g class="sparkles">
                            <circle cx="45" cy="35" r="2" fill="var(--sparkle-color)" opacity="0.4" class="sparkle-1"/>
                            <circle cx="155" cy="40" r="2" fill="var(--sparkle-color)" opacity="0.4" class="sparkle-2"/>
                            <circle cx="100" cy="30" r="2.5" fill="var(--sparkle-color)" opacity="0.5" class="sparkle-3"/>
                            <circle cx="55" cy="160" r="2" fill="var(--sparkle-color)" opacity="0.3" class="sparkle-4"/>
                            <circle cx="145" cy="165" r="2" fill="var(--sparkle-color)" opacity="0.3" class="sparkle-5"/>
                        </g>

                        {{-- Brand thread/yarn effect --}}
                        <g class="yarn-thread">
                            <path d="M30 100 Q50 95 70 100 T110 100" stroke="var(--sock-accent)" 
                                  stroke-width="1.5" fill="none" opacity="0.3" stroke-dasharray="4,4" class="thread-1"/>
                            <path d="M170 105 Q150 100 130 105 T90 105" stroke="var(--sock-accent-2)" 
                                  stroke-width="1.5" fill="none" opacity="0.3" stroke-dasharray="4,4" class="thread-2"/>
                        </g>
                    </svg>
                </div>
            </div>
        </div>
    </section>
@endif
