{{-- Main Navigation Header --}}
<header
    class="sticky top-0 z-50 bg-white dark:bg-[#111111] border-b border-nassaj-primary/8 dark:border-white/5 transition-colors duration-300 shadow-sm dark:shadow-none">
    <div class="site-container">
        <div class="flex items-center justify-between h-16 lg:h-18 gap-4">
            {{-- Logo (Right side in RTL) --}}
            <a href="{{ route('home') }}" class="shrink-0 flex items-center gap-3 overflow-hidden logo">

                {{-- Dark Mode --}}
                <img src="{{ asset('images/logo/dark.png') }}" alt="نساج"
                    class="hidden dark:block h-7 sm:h-8 lg:h-12 w-auto max-w-[140px] object-contain">

                {{-- Light Mode --}}
                <img src="{{ asset('images/logo/light.png') }}" alt="نساج"
                    class="block dark:hidden h-7 sm:h-8 lg:h-12 w-auto max-w-[140px] object-contain">
            </a>


            {{-- Navigation Links with Icons (Center) --}}
            <nav class="hidden lg:flex items-center gap-1">
                <a href="{{ route('home') }}"
                    class="flex items-center gap-2 px-4 py-2 rounded-xl text-sm font-bold transition-all duration-200
                    {{ request()->routeIs('home') ? 'bg-nassaj-gold/15 text-nassaj-gold dark:text-nassaj-gold text-nassaj-primary' : 'text-nassaj-text-secondary dark:text-gray-300 hover:text-nassaj-gold dark:hover:text-nassaj-gold hover:bg-nassaj-primary/5 dark:hover:bg-white/5' }}">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round"
                            d="M2.25 12l8.954-8.955c.44-.439 1.152-.439 1.591 0L21.75 12M4.5 9.75v10.125c0 .621.504 1.125 1.125 1.125H9.75v-4.875c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125V21h4.125c.621 0 1.125-.504 1.125-1.125V9.75M8.25 21h8.25" />
                    </svg>
                    الرئيسية
                </a>

                <a href="{{ route('shop') }}"
                    class="flex items-center gap-2 px-4 py-2 rounded-xl text-sm font-bold transition-all duration-200
                    {{ request()->routeIs('shop') || request()->routeIs('store.*') ? 'bg-nassaj-gold/15 text-nassaj-gold dark:text-nassaj-gold text-nassaj-primary' : 'text-nassaj-text-secondary dark:text-gray-300 hover:text-nassaj-gold dark:hover:text-nassaj-gold hover:bg-nassaj-primary/5 dark:hover:bg-white/5' }}">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round"
                            d="M13.5 21v-7.5a.75.75 0 01.75-.75h3a.75.75 0 01.75.75V21m-4.5 0H2.36m11.14 0H18m0 0h3.64m-1.39 0V9.349m-16.5 11.65V9.35m0 0a3.001 3.001 0 003.75-.615A2.993 2.993 0 009.75 9.75c.896 0 1.7-.393 2.25-1.016a2.993 2.993 0 002.25 1.016c.896 0 1.7-.393 2.25-1.016a3.001 3.001 0 003.75.614m-16.5 0a3.004 3.004 0 01-.621-4.72L4.318 3.44A1.5 1.5 0 015.378 3h13.243a1.5 1.5 0 011.06.44l1.19 1.189a3 3 0 01-.621 4.72m-13.5 8.65h3.75a.75.75 0 00.75-.75V13.5a.75.75 0 00-.75-.75H6.75a.75.75 0 00-.75.75v3.15c0 .415.336.75.75.75z" />
                    </svg>
                    المتجر
                </a>

                <a href="{{ route('designs.index') }}"
                    class="flex items-center gap-2 px-4 py-2 rounded-xl text-sm font-bold transition-all duration-200
                    {{ request()->routeIs('designs*') || request()->routeIs('configurator*') ? 'bg-nassaj-gold/15 text-nassaj-gold dark:text-nassaj-gold text-nassaj-primary' : 'text-nassaj-text-secondary dark:text-gray-300 hover:text-nassaj-gold dark:hover:text-nassaj-gold hover:bg-nassaj-primary/5 dark:hover:bg-white/5' }}">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round"
                            d="M9.53 16.122a3 3 0 00-5.78 1.128 2.25 2.25 0 01-2.4 2.245 4.5 4.5 0 008.4-2.245c0-.399-.078-.78-.22-1.128zm0 0a15.998 15.998 0 003.388-1.62m-5.043-.025a15.994 15.994 0 011.622-3.395m3.42 3.42a15.995 15.995 0 004.764-4.648l3.876-5.814a1.151 1.151 0 00-1.597-1.597L14.146 6.32a15.996 15.996 0 00-4.649 4.763m3.42 3.42a6.776 6.776 0 00-3.42-3.42" />
                    </svg>
                    مكتبة التصاميم
                </a>

                <a href="{{ route('offers') }}"
                    class="flex items-center gap-2 px-4 py-2 rounded-xl text-sm font-bold transition-all duration-200
                    {{ request()->routeIs('offers') ? 'bg-nassaj-gold/15 text-nassaj-gold dark:text-nassaj-gold text-nassaj-primary' : 'text-nassaj-text-secondary dark:text-gray-300 hover:text-nassaj-gold dark:hover:text-nassaj-gold hover:bg-nassaj-primary/5 dark:hover:bg-white/5' }}">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round"
                            d="M9.568 3H5.25A2.25 2.25 0 003 5.25v4.318c0 .597.237 1.17.659 1.591l9.581 9.581c.699.699 1.78.872 2.607.33a18.095 18.095 0 005.223-5.223c.542-.827.369-1.908-.33-2.607L11.16 3.66A2.25 2.25 0 009.568 3z" />
                        <path stroke-linecap="round" stroke-linejoin="round" d="M6 6h.008v.008H6V6z" />
                    </svg>
                    العروض
                </a>

                <a href="{{ route('about-us') }}"
                    class="flex items-center gap-2 px-4 py-2 rounded-xl text-sm font-bold transition-all duration-200
                    {{ request()->routeIs('about-us') ? 'bg-nassaj-gold/15 text-nassaj-gold dark:text-nassaj-gold text-nassaj-primary' : 'text-nassaj-text-secondary dark:text-gray-300 hover:text-nassaj-gold dark:hover:text-nassaj-gold hover:bg-nassaj-primary/5 dark:hover:bg-white/5' }}">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round"
                            d="M9.813 15.904L9 18.75l-.813-2.846a4.5 4.5 0 00-3.09-3.09L2.25 12l2.846-.813a4.5 4.5 0 003.09-3.09L9 5.25l.813 2.846a4.5 4.5 0 003.09 3.09L15.75 12l-2.846.813a4.5 4.5 0 00-3.09 3.09zM18.259 8.715L18 9.75l-.259-1.035a3.375 3.375 0 00-2.455-2.456L14.25 6l1.036-.259a3.375 3.375 0 002.455-2.456L18 2.25l.259 1.035a3.375 3.375 0 002.455 2.456L21.75 6l-1.036.259a3.375 3.375 0 00-2.455 2.456zM16.894 20.567L16.5 21.75l-.394-1.183a2.25 2.25 0 00-1.423-1.423L13.5 18.75l1.183-.394a2.25 2.25 0 001.423-1.423l.394-1.183.394 1.183a2.25 2.25 0 001.423 1.423l1.183.394-1.183.394a2.25 2.25 0 00-1.423 1.423z" />
                    </svg>
                    من نحن
                </a>

                <a href="{{ route('contact-us') }}"
                    class="flex items-center gap-2 px-4 py-2 rounded-xl text-sm font-bold transition-all duration-200
                    {{ request()->routeIs('contact-us') ? 'bg-nassaj-gold/15 text-nassaj-gold dark:text-nassaj-gold text-nassaj-primary' : 'text-nassaj-text-secondary dark:text-gray-300 hover:text-nassaj-gold dark:hover:text-nassaj-gold hover:bg-nassaj-primary/5 dark:hover:bg-white/5' }}">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round"
                            d="M21.75 6.75v10.5a2.25 2.25 0 01-2.25 2.25h-15a2.25 2.25 0 01-2.25-2.25V6.75m19.5 0A2.25 2.25 0 0019.5 4.5h-15a2.25 2.25 0 00-2.25 2.25m19.5 0v.243a2.25 2.25 0 01-1.07 1.916l-7.5 4.615a2.25 2.25 0 01-2.36 0L3.32 8.91a2.25 2.25 0 01-1.07-1.916V6.75" />
                    </svg>
                    اتصل بنا
                </a>
            </nav>

            {{-- Search form: click/focus opens search modal --}}
            <div class="hidden lg:flex items-center flex-1 max-w-md">
                <div class="relative w-full" onclick="window.dispatchEvent(new CustomEvent('search-open'))">
                    <label for="navbarSearchInput" class="sr-only">بحث</label>
                    <input id="navbarSearchInput" type="text" readonly placeholder="ابحث عن جوارب، فئات، ألوان..."
                        class="w-full pl-12 pr-4 py-2.5 rounded-full bg-nassaj-primary/5 dark:bg-white/5 border border-nassaj-primary/10 dark:border-white/10 text-nassaj-text-primary dark:text-gray-300 placeholder:text-nassaj-text-muted dark:placeholder:text-gray-500 text-sm font-medium cursor-pointer hover:border-nassaj-gold/30 focus:border-nassaj-gold/30 focus:outline-none transition-colors">
                    <span
                        class="absolute left-1 top-1/2 -translate-y-1/2 w-9 h-9 rounded-full bg-nassaj-gold flex items-center justify-center pointer-events-none"
                        aria-hidden="true">
                        <svg class="w-4 h-4 text-nassaj-primary" fill="none" stroke="currentColor" stroke-width="2.5"
                            viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M21 21l-5.197-5.197m0 0A7.5 7.5 0 105.196 5.196a7.5 7.5 0 0010.607 10.607z" />
                        </svg>
                    </span>
                </div>
            </div>

            {{-- Actions (Left side in RTL) --}}
            <div class="flex items-center gap-1.5">
                {{-- Dark/Light Mode Toggle --}}
                <button onclick="toggleTheme()" type="button"
                    class="relative p-2.5 rounded-full text-nassaj-text-muted dark:text-gray-400 hover:text-nassaj-gold dark:hover:text-nassaj-gold hover:bg-nassaj-primary/5 dark:hover:bg-white/5 transition-all duration-200 cursor-pointer"
                    aria-label="تبديل الوضع">
                    {{-- Sun Icon (show in dark mode) --}}
                    <svg class="w-5 h-5 hidden dark:block pointer-events-none" fill="none" stroke="currentColor"
                        viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M12 3v1m0 16v1m9-9h-1M4 12H3m15.364 6.364l-.707-.707M6.343 6.343l-.707-.707m12.728 0l-.707.707M6.343 17.657l-.707.707M16 12a4 4 0 11-8 0 4 4 0 018 0z" />
                    </svg>
                    {{-- Moon Icon (show in light mode) --}}
                    <svg class="w-5 h-5 block dark:hidden pointer-events-none" fill="none" stroke="currentColor"
                        viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9.003 9.003 0 008.354-5.646z" />
                    </svg>
                </button>

                {{-- User Account with Dropdown --}}
                @auth('client')
                    <div class="relative" x-data="{ open: false }" @click.outside="open = false">
                        <button @click="open = !open"
                            class="flex items-center gap-2 p-1.5 pr-3 rounded-full bg-nassaj-primary/5 dark:bg-white/5 border border-nassaj-primary/10 dark:border-white/10 hover:border-nassaj-gold/30 text-nassaj-text-secondary dark:text-gray-300 hover:text-nassaj-gold dark:hover:text-nassaj-gold transition-all duration-200">
                            <span class="text-sm font-bold hidden sm:inline">{{ auth('client')->user()->name }}</span>
                            <span
                                class="w-8 h-8 rounded-full bg-nassaj-gold flex items-center justify-center text-nassaj-primary font-black text-sm">
                                {{ mb_substr(auth('client')->user()->name, 0, 1) }}
                            </span>
                            <svg class="w-3.5 h-3.5 transition-transform text-nassaj-text-muted dark:text-gray-400"
                                :class="{ 'rotate-180': open }" fill="none" stroke="currentColor" stroke-width="2.5"
                                viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M19.5 8.25l-7.5 7.5-7.5-7.5" />
                            </svg>
                        </button>

                        {{-- Dropdown Panel --}}
                        <div x-show="open" x-transition:enter="transition ease-out duration-200"
                            x-transition:enter-start="opacity-0 translate-y-2 scale-95"
                            x-transition:enter-end="opacity-100 translate-y-0 scale-100"
                            x-transition:leave="transition ease-in duration-150"
                            x-transition:leave-start="opacity-100 translate-y-0 scale-100"
                            x-transition:leave-end="opacity-0 translate-y-2 scale-95" x-cloak
                            class="absolute left-0 top-full mt-3 w-72 bg-white dark:bg-[#111111] border border-nassaj-primary/10 dark:border-white/10 rounded-2xl shadow-dropdown dark:shadow-2xl dark:shadow-black/50 overflow-hidden z-50">

                            {{-- User Info --}}
                            <div class="p-5 text-center border-b border-nassaj-primary/5 dark:border-white/5">
                                <div
                                    class="w-14 h-14 rounded-full bg-nassaj-gold flex items-center justify-center text-nassaj-primary font-black text-xl mx-auto mb-3">
                                    {{ mb_substr(auth('client')->user()->name, 0, 1) }}
                                </div>
                                <h4 class="text-nassaj-text-primary dark:text-white font-bold text-base">
                                    {{ auth('client')->user()->name }}</h4>
                                <p class="text-nassaj-text-muted dark:text-gray-500 text-sm direction-ltr">
                                    {{ auth('client')->user()->phone }}</p>
                            </div>

                            {{-- Order Stats --}}
                            @php
                                $user = auth('client')->user();
                                $totalOrders = $user->orders()->count();
                                $completedOrders = $user->orders()->where('status', 'completed')->count();
                                $pendingOrders = $user->orders()->where('status', 'pending')->count();
                            @endphp
                            <div class="grid grid-cols-3 gap-2 p-4 border-b border-nassaj-primary/5 dark:border-white/5">
                                <div class="text-center p-2 rounded-xl bg-nassaj-primary/5 dark:bg-white/5">
                                    <span class="block text-nassaj-gold font-black text-lg">{{ $totalOrders }}</span>
                                    <span class="text-nassaj-text-muted dark:text-gray-500 text-xs font-bold">طلب</span>
                                </div>
                                <div class="text-center p-2 rounded-xl bg-nassaj-primary/5 dark:bg-white/5">
                                    <span
                                        class="block text-green-600 dark:text-green-400 font-black text-lg">{{ $completedOrders }}</span>
                                    <span class="text-nassaj-text-muted dark:text-gray-500 text-xs font-bold">مكتمل</span>
                                </div>
                                <div class="text-center p-2 rounded-xl bg-nassaj-primary/5 dark:bg-white/5">
                                    <span
                                        class="block text-amber-600 dark:text-amber-400 font-black text-lg">{{ $pendingOrders }}</span>
                                    <span class="text-nassaj-text-muted dark:text-gray-500 text-xs font-bold">قيد
                                        الانتظار</span>
                                </div>
                            </div>

                            {{-- Menu Items --}}
                            <div class="p-3 space-y-1">
                                <a href="{{ route('client.dashboard') }}"
                                    class="flex items-center gap-3 px-3 py-2.5 rounded-xl text-nassaj-text-secondary dark:text-gray-300 hover:bg-nassaj-primary/5 dark:hover:bg-white/5 hover:text-nassaj-text-primary dark:hover:text-white transition-all">
                                    <span class="w-9 h-9 rounded-xl bg-nassaj-gold/15 flex items-center justify-center">
                                        <svg class="w-4.5 h-4.5 text-nassaj-gold" fill="none" stroke="currentColor"
                                            stroke-width="1.5" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                d="M2.25 12l8.954-8.955c.44-.439 1.152-.439 1.591 0L21.75 12M4.5 9.75v10.125c0 .621.504 1.125 1.125 1.125H9.75v-4.875c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125V21h4.125c.621 0 1.125-.504 1.125-1.125V9.75M8.25 21h8.25" />
                                        </svg>
                                    </span>
                                    <div>
                                        <span class="font-bold text-sm block">لوحة التحكم</span>
                                        <span class="text-nassaj-text-muted dark:text-gray-500 text-xs">إحصائيات ونظرة
                                            عامة</span>
                                    </div>
                                </a>

                                <a href="{{ route('client.orders') }}"
                                    class="flex items-center gap-3 px-3 py-2.5 rounded-xl text-nassaj-text-secondary dark:text-gray-300 hover:bg-nassaj-primary/5 dark:hover:bg-white/5 hover:text-nassaj-text-primary dark:hover:text-white transition-all">
                                    <span class="w-9 h-9 rounded-xl bg-purple-500/15 flex items-center justify-center">
                                        <svg class="w-4.5 h-4.5 text-purple-500 dark:text-purple-400" fill="none"
                                            stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                d="M15.75 10.5V6a3.75 3.75 0 10-7.5 0v4.5m11.356-1.993l1.263 12c.07.665-.45 1.243-1.119 1.243H4.25a1.125 1.125 0 01-1.12-1.243l1.264-12A1.125 1.125 0 015.513 7.5h12.974c.576 0 1.059.435 1.119 1.007zM8.625 10.5a.375.375 0 11-.75 0 .375.375 0 01.75 0zm7.5 0a.375.375 0 11-.75 0 .375.375 0 01.75 0z" />
                                        </svg>
                                    </span>
                                    <div>
                                        <span class="font-bold text-sm block">طلباتي</span>
                                        <span class="text-nassaj-text-muted dark:text-gray-500 text-xs">تتبع ومراجعة
                                            الطلبات</span>
                                    </div>
                                </a>

                                <a href="{{ route('client.profile') }}"
                                    class="flex items-center gap-3 px-3 py-2.5 rounded-xl text-nassaj-text-secondary dark:text-gray-300 hover:bg-nassaj-primary/5 dark:hover:bg-white/5 hover:text-nassaj-text-primary dark:hover:text-white transition-all">
                                    <span class="w-9 h-9 rounded-xl bg-green-500/15 flex items-center justify-center">
                                        <svg class="w-4.5 h-4.5 text-green-500 dark:text-green-400" fill="none"
                                            stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                d="M15.75 6a3.75 3.75 0 11-7.5 0 3.75 3.75 0 017.5 0zM4.501 20.118a7.5 7.5 0 0114.998 0A17.933 17.933 0 0112 21.75c-2.676 0-5.216-.584-7.499-1.632z" />
                                        </svg>
                                    </span>
                                    <div>
                                        <span class="font-bold text-sm block">الملف الشخصي</span>
                                        <span class="text-nassaj-text-muted dark:text-gray-500 text-xs">تعديل البيانات
                                            الشخصية</span>
                                    </div>
                                </a>

                                <a href="{{ route('client.addresses') }}"
                                    class="flex items-center gap-3 px-3 py-2.5 rounded-xl text-nassaj-text-secondary dark:text-gray-300 hover:bg-nassaj-primary/5 dark:hover:bg-white/5 hover:text-nassaj-text-primary dark:hover:text-white transition-all">
                                    <span class="w-9 h-9 rounded-xl bg-blue-500/15 flex items-center justify-center">
                                        <svg class="w-4.5 h-4.5 text-blue-500 dark:text-blue-400" fill="none"
                                            stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                d="M15 10.5a3 3 0 11-6 0 3 3 0 016 0z" />
                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                d="M19.5 10.5c0 7.142-7.5 11.25-7.5 11.25S4.5 17.642 4.5 10.5a7.5 7.5 0 1115 0z" />
                                        </svg>
                                    </span>
                                    <div>
                                        <span class="font-bold text-sm block">العناوين</span>
                                        <span class="text-nassaj-text-muted dark:text-gray-500 text-xs">إدارة عناوين
                                            الشحن</span>
                                    </div>
                                </a>
                            </div>

                            {{-- Logout --}}
                            <div class="p-3 pt-0">
                                <form action="{{ route('client.logout') }}" method="POST">
                                    @csrf
                                    <button type="submit"
                                        class="w-full flex items-center justify-center gap-2 px-4 py-3 rounded-xl text-red-500 dark:text-red-400 hover:bg-red-500/10 transition-all font-bold text-sm">
                                        <svg class="w-4.5 h-4.5" fill="none" stroke="currentColor" stroke-width="1.5"
                                            viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                d="M15.75 9V5.25A2.25 2.25 0 0013.5 3h-6a2.25 2.25 0 00-2.25 2.25v13.5A2.25 2.25 0 007.5 21h6a2.25 2.25 0 002.25-2.25V15M12 9l-3 3m0 0l3 3m-3-3h12.75" />
                                        </svg>
                                        تسجيل الخروج
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                @else
                    <a href="{{ route('client.login') }}"
                        class="p-2.5 rounded-full text-nassaj-text-muted dark:text-gray-400 hover:text-nassaj-gold dark:hover:text-nassaj-gold hover:bg-nassaj-primary/5 dark:hover:bg-white/5 transition-all duration-200">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="1.5"
                            viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M15.75 6a3.75 3.75 0 11-7.5 0 3.75 3.75 0 017.5 0zM4.501 20.118a7.5 7.5 0 0114.998 0A17.933 17.933 0 0112 21.75c-2.676 0-5.216-.584-7.499-1.632z" />
                        </svg>
                    </a>
                @endauth

                {{-- Cart, Compare, Wishlist counters --}}
                <livewire:store.navbar-counters />

                {{-- Mobile: search trigger (opens modal) --}}
                <button type="button" onclick="window.dispatchEvent(new CustomEvent('search-open'))"
                    class="lg:hidden p-2.5 rounded-full text-nassaj-text-muted dark:text-gray-400 hover:text-nassaj-gold dark:hover:text-nassaj-gold hover:bg-nassaj-primary/5 dark:hover:bg-white/5 transition-all duration-200"
                    aria-label="فتح البحث">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="1.5"
                        viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round"
                            d="M21 21l-5.197-5.197m0 0A7.5 7.5 0 105.196 5.196a7.5 7.5 0 0010.607 10.607z" />
                    </svg>
                </button>

                {{-- Mobile Menu Button --}}
                <button type="button"
                    class="lg:hidden p-2.5 rounded-full text-nassaj-text-muted dark:text-gray-400 hover:text-nassaj-gold dark:hover:text-nassaj-gold hover:bg-nassaj-primary/5 dark:hover:bg-white/5 transition-all duration-200"
                    onclick="document.getElementById('mobileMenu').classList.toggle('hidden')">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="1.5"
                        viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round"
                            d="M3.75 6.75h16.5M3.75 12h16.5m-16.5 5.25h16.5" />
                    </svg>
                </button>
            </div>
        </div>

        {{-- Mobile Navigation --}}
        <nav id="mobileMenu" class="hidden lg:hidden border-t border-nassaj-primary/10 dark:border-white/10 py-4">
            {{-- Mobile search (opens modal) --}}
            <div class="mb-4 px-2" onclick="window.dispatchEvent(new CustomEvent('search-open'))">
                <div
                    class="flex items-center gap-3 px-4 py-3 rounded-2xl bg-nassaj-primary/5 dark:bg-white/5 border border-nassaj-primary/10 dark:border-white/10 cursor-pointer">
                    <span class="w-10 h-10 rounded-full bg-nassaj-gold flex items-center justify-center shrink-0">
                        <svg class="w-5 h-5 text-nassaj-primary" fill="none" stroke="currentColor"
                            stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M21 21l-5.197-5.197m0 0A7.5 7.5 0 105.196 5.196a7.5 7.5 0 0010.607 10.607z" />
                        </svg>
                    </span>
                    <span class="text-nassaj-text-muted dark:text-gray-500 text-sm font-medium">ابحث عن جوارب، فئات،
                        ألوان...</span>
                </div>
            </div>
            <div class="flex flex-col gap-1">
                <a href="{{ route('home') }}"
                    class="flex items-center gap-3 text-sm font-bold px-4 py-3 rounded-2xl transition-colors
                    {{ request()->routeIs('home') ? 'text-nassaj-gold bg-nassaj-gold/10' : 'text-nassaj-text-secondary dark:text-gray-300 hover:text-nassaj-gold dark:hover:text-nassaj-gold hover:bg-nassaj-primary/5 dark:hover:bg-white/5' }}">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round"
                            d="M2.25 12l8.954-8.955c.44-.439 1.152-.439 1.591 0L21.75 12M4.5 9.75v10.125c0 .621.504 1.125 1.125 1.125H9.75v-4.875c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125V21h4.125c.621 0 1.125-.504 1.125-1.125V9.75M8.25 21h8.25" />
                    </svg>
                    الرئيسية
                </a>
                <a href="{{ route('shop') }}"
                    class="flex items-center gap-3 text-sm font-bold px-4 py-3 rounded-2xl transition-colors
                    {{ request()->routeIs('shop') || request()->routeIs('store.*') ? 'text-nassaj-gold bg-nassaj-gold/10' : 'text-nassaj-text-secondary dark:text-gray-300 hover:text-nassaj-gold dark:hover:text-nassaj-gold hover:bg-nassaj-primary/5 dark:hover:bg-white/5' }}">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round"
                            d="M13.5 21v-7.5a.75.75 0 01.75-.75h3a.75.75 0 01.75.75V21m-4.5 0H2.36m11.14 0H18m0 0h3.64m-1.39 0V9.349m-16.5 11.65V9.35m0 0a3.001 3.001 0 003.75-.615A2.993 2.993 0 009.75 9.75c.896 0 1.7-.393 2.25-1.016a2.993 2.993 0 002.25 1.016c.896 0 1.7-.393 2.25-1.016a3.001 3.001 0 003.75.614m-16.5 0a3.004 3.004 0 01-.621-4.72L4.318 3.44A1.5 1.5 0 015.378 3h13.243a1.5 1.5 0 011.06.44l1.19 1.189a3 3 0 01-.621 4.72m-13.5 8.65h3.75a.75.75 0 00.75-.75V13.5a.75.75 0 00-.75-.75H6.75a.75.75 0 00-.75.75v3.15c0 .415.336.75.75.75z" />
                    </svg>
                    المتجر
                </a>
                <a href="{{ route('about-us') }}"
                    class="flex items-center gap-3 text-sm font-bold px-4 py-3 rounded-2xl transition-colors
                    {{ request()->routeIs('about-us') ? 'text-nassaj-gold bg-nassaj-gold/10' : 'text-nassaj-text-secondary dark:text-gray-300 hover:text-nassaj-gold dark:hover:text-nassaj-gold hover:bg-nassaj-primary/5 dark:hover:bg-white/5' }}">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round"
                            d="M9.813 15.904L9 18.75l-.813-2.846a4.5 4.5 0 00-3.09-3.09L2.25 12l2.846-.813a4.5 4.5 0 003.09-3.09L9 5.25l.813 2.846a4.5 4.5 0 003.09 3.09L15.75 12l-2.846.813a4.5 4.5 0 00-3.09 3.09z" />
                    </svg>
                    العروض
                </a>
                <a href="{{ route('contact-us') }}"
                    class="flex items-center gap-3 text-sm font-bold px-4 py-3 rounded-2xl transition-colors
                    {{ request()->routeIs('contact-us') ? 'text-nassaj-gold bg-nassaj-gold/10' : 'text-nassaj-text-secondary dark:text-gray-300 hover:text-nassaj-gold dark:hover:text-nassaj-gold hover:bg-nassaj-primary/5 dark:hover:bg-white/5' }}">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round"
                            d="M21.75 6.75v10.5a2.25 2.25 0 01-2.25 2.25h-15a2.25 2.25 0 01-2.25-2.25V6.75m19.5 0A2.25 2.25 0 0019.5 4.5h-15a2.25 2.25 0 00-2.25 2.25m19.5 0v.243a2.25 2.25 0 01-1.07 1.916l-7.5 4.615a2.25 2.25 0 01-2.36 0L3.32 8.91a2.25 2.25 0 01-1.07-1.916V6.75" />
                    </svg>
                    اتصل بنا
                </a>
            </div>
        </nav>
    </div>
</header>
