{{-- Footer --}}
<footer class="relative bg-[#442247] dark:bg-[#0a0a0a] border-t border-white/5 pt-16 pb-8 overflow-hidden">
    {{-- Background subtle gradient --}}
    <div
        class="absolute inset-0 bg-gradient-to-b from-transparent via-nassaj-primary/5 to-transparent pointer-events-none">
    </div>

    <div class="relative z-10 site-container">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-10 mb-12">

            {{-- Logo & Description --}}
            <div class="lg:col-span-1">
                <div class="mb-5">
                    <img src="{{ asset('images/logo/dark.png') }}" alt="نساج" class="h-12 w-auto">
                </div>
                <p class="text-gray-400 text-sm leading-relaxed mb-6 font-medium">
                    متجر عراقي متخصص في صناعة وبيع أفخم أنواع الجوارب، نجمع بين الجودة العراقية الأصيلة والتصاميم
                    العصرية
                </p>
                {{-- Social Icons --}}
                <div class="flex gap-2.5">
                    <a href="#"
                        class="w-9 h-9 rounded-lg bg-white/5 border border-white/10 flex items-center justify-center text-gray-400 hover:text-white hover:bg-nassaj-primary hover:border-nassaj-primary transition-all duration-300">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M12 21a9.004 9.004 0 008.354-5.646M12 21a9.004 9.004 0 01-8.354-5.646M12 21c2.485 0 4.5-4.03 4.5-9S14.485 3 12 3m0 18c-2.485 0-4.5-4.03-4.5-9S9.515 3 12 3m0 0a8.997 8.997 0 017.843 4.582M12 3a8.997 8.997 0 00-7.843 4.582m15.686 0A11.953 11.953 0 0112 10.5c-2.998 0-5.74-1.1-7.843-2.918m15.686 0A8.959 8.959 0 0121 12c0 .778-.099 1.533-.284 2.253m0 0A17.919 17.919 0 0112 16.5c-3.162 0-6.133-.815-8.716-2.247m0 0A9.015 9.015 0 013 12c0-1.605.42-3.113 1.157-4.418" />
                        </svg>
                    </a>
                    <a href="https://wa.me/9640000000770"
                        class="w-9 h-9 rounded-lg bg-white/5 border border-white/10 flex items-center justify-center text-gray-400 hover:text-white hover:bg-[#25D366] hover:border-[#25D366] transition-all duration-300">
                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 24 24">
                            <path
                                d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413z" />
                        </svg>
                    </a>
                    <a href="#"
                        class="w-9 h-9 rounded-lg bg-white/5 border border-white/10 flex items-center justify-center text-gray-400 hover:text-white hover:bg-black hover:border-gray-600 transition-all duration-300">
                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 24 24">
                            <path
                                d="M19.59 6.69a4.83 4.83 0 01-3.77-4.25V2h-3.45v13.67a2.89 2.89 0 01-2.88 2.5 2.89 2.89 0 01-2.89-2.89 2.89 2.89 0 012.89-2.89c.28 0 .54.04.79.11V9.02a6.27 6.27 0 00-.79-.05 6.34 6.34 0 00-6.34 6.34 6.34 6.34 0 006.34 6.34 6.34 6.34 0 006.34-6.34V8.83a8.18 8.18 0 004.76 1.52V6.9a4.84 4.84 0 01-1-.21z" />
                        </svg>
                    </a>
                    <a href="#"
                        class="w-9 h-9 rounded-lg bg-white/5 border border-white/10 flex items-center justify-center text-gray-400 hover:text-white hover:bg-gradient-to-br hover:from-[#f09433] hover:via-[#dc2743] hover:to-[#bc1888] hover:border-transparent transition-all duration-300">
                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 24 24">
                            <path
                                d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z" />
                        </svg>
                    </a>
                    <a href="#"
                        class="w-9 h-9 rounded-lg bg-white/5 border border-white/10 flex items-center justify-center text-gray-400 hover:text-white hover:bg-[#1877F2] hover:border-[#1877F2] transition-all duration-300">
                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 24 24">
                            <path
                                d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z" />
                        </svg>
                    </a>
                </div>
            </div>

            {{-- Quick Links --}}
            <div>
                <h4 class="text-nassaj-gold font-black text-sm mb-5 relative inline-block">
                    روابط سريعة
                    <span
                        class="absolute -bottom-1.5 right-0 w-full h-0.5 bg-gradient-to-l from-nassaj-gold to-transparent"></span>
                </h4>
                <ul class="space-y-2.5">
                    <li><a href="{{ route('home') }}"
                            class="text-gray-400 text-sm hover:text-nassaj-gold transition-colors inline-flex items-center gap-2 group">
                            <span
                                class="w-1 h-1 rounded-full bg-gray-600 group-hover:bg-nassaj-gold transition-colors"></span>
                            الصفحة الرئيسية
                        </a></li>
                    <li><a href="{{ route('shop') }}"
                            class="text-gray-400 text-sm hover:text-nassaj-gold transition-colors inline-flex items-center gap-2 group">
                            <span
                                class="w-1 h-1 rounded-full bg-gray-600 group-hover:bg-nassaj-gold transition-colors"></span>
                            المتجر
                        </a></li>
                    <li><a href="{{ route('shop') }}"
                            class="text-gray-400 text-sm hover:text-nassaj-gold transition-colors inline-flex items-center gap-2 group">
                            <span
                                class="w-1 h-1 rounded-full bg-gray-600 group-hover:bg-nassaj-gold transition-colors"></span>
                            مكتبة التصاميم
                        </a></li>
                    <li><a href="{{ route('about-us') }}"
                            class="text-gray-400 text-sm hover:text-nassaj-gold transition-colors inline-flex items-center gap-2 group">
                            <span
                                class="w-1 h-1 rounded-full bg-gray-600 group-hover:bg-nassaj-gold transition-colors"></span>
                            العروض والخصومات
                        </a></li>
                    <li><a href="{{ route('contact-us') }}"
                            class="text-gray-400 text-sm hover:text-nassaj-gold transition-colors inline-flex items-center gap-2 group">
                            <span
                                class="w-1 h-1 rounded-full bg-gray-600 group-hover:bg-nassaj-gold transition-colors"></span>
                            اتصل بنا
                        </a></li>
                </ul>
            </div>

            {{-- Account & Orders --}}
            <div>
                <h4 class="text-nassaj-gold font-black text-sm mb-5 relative inline-block">
                    الحساب والطلبات
                    <span
                        class="absolute -bottom-1.5 right-0 w-full h-0.5 bg-gradient-to-l from-nassaj-gold to-transparent"></span>
                </h4>
                <ul class="space-y-2.5">
                    <li><a href="{{ route('client.login') }}"
                            class="text-gray-400 text-sm hover:text-nassaj-gold transition-colors inline-flex items-center gap-2 group">
                            <span
                                class="w-1 h-1 rounded-full bg-gray-600 group-hover:bg-nassaj-gold transition-colors"></span>
                            تسجيل الدخول
                        </a></li>
                    <li><a href="{{ route('client.register') }}"
                            class="text-gray-400 text-sm hover:text-nassaj-gold transition-colors inline-flex items-center gap-2 group">
                            <span
                                class="w-1 h-1 rounded-full bg-gray-600 group-hover:bg-nassaj-gold transition-colors"></span>
                            إنشاء حساب
                        </a></li>
                    @auth('client')
                        <li><a href="{{ route('client.dashboard') }}"
                                class="text-gray-400 text-sm hover:text-nassaj-gold transition-colors inline-flex items-center gap-2 group">
                                <span
                                    class="w-1 h-1 rounded-full bg-gray-600 group-hover:bg-nassaj-gold transition-colors"></span>
                                لوحة التحكم
                            </a></li>
                    @endauth
                    <li><a href="{{ route('shop') }}"
                            class="text-gray-400 text-sm hover:text-nassaj-gold transition-colors inline-flex items-center gap-2 group">
                            <span
                                class="w-1 h-1 rounded-full bg-gray-600 group-hover:bg-nassaj-gold transition-colors"></span>
                            سلة التسوق
                        </a></li>
                    <li><a href="{{ route('checkout.index') }}"
                            class="text-gray-400 text-sm hover:text-nassaj-gold transition-colors inline-flex items-center gap-2 group">
                            <span
                                class="w-1 h-1 rounded-full bg-gray-600 group-hover:bg-nassaj-gold transition-colors"></span>
                            إتمام الشراء
                        </a></li>
                </ul>
            </div>

            {{-- Newsletter --}}
            <div>
                <h4 class="text-nassaj-gold font-black text-sm mb-5 relative inline-block">
                    النشرة البريدية
                    <span
                        class="absolute -bottom-1.5 right-0 w-full h-0.5 bg-gradient-to-l from-nassaj-gold to-transparent"></span>
                </h4>
                <p class="text-gray-400 text-xs mb-4 leading-relaxed">احصل على أحدث العروض والمنتجات الجديدة</p>
                <form id="newsletterForm" class="space-y-2.5">
                    <input type="email" required placeholder="بريدك الإلكتروني"
                        class="w-full px-4 py-2.5 rounded-lg bg-white/5 border border-white/10 text-white placeholder:text-gray-500 outline-none focus:border-nassaj-gold transition-colors text-sm">
                    <button type="submit"
                        class="w-full bg-nassaj-gold hover:bg-nassaj-gold-light text-nassaj-primary px-5 py-2.5 rounded-lg font-black text-sm transition-all duration-300 hover:scale-[1.02]">
                        اشتراك
                    </button>
                </form>

                {{-- Payment Methods --}}
                <div class="mt-5 pt-4 border-t border-white/5">
                    <span class="text-gray-500 text-xs block mb-2.5">طرق الدفع:</span>
                    <div class="flex gap-2">
                        <div
                            class="px-2.5 py-1.5 rounded bg-white/5 border border-white/10 text-gray-400 text-xs font-bold">
                            VISA</div>
                        <div
                            class="px-2.5 py-1.5 rounded bg-white/5 border border-white/10 text-gray-400 text-xs font-bold">
                            MC</div>
                    </div>
                </div>
            </div>
        </div>

        {{-- Bottom Bar --}}
        <div class="border-t border-white/5 pt-6">
            <div class="flex flex-col md:flex-row items-center justify-between gap-4 text-center md:text-right">
                <p class="text-gray-500 text-xs">
                    © {{ date('Y') }} نساج — جميع الحقوق محفوظة
                </p>
                <p class="text-gray-500 text-xs">
                    تم التطوير بواسطة <a href="#" class="text-nassaj-gold hover:underline font-bold">إيوان</a>
                </p>
            </div>
        </div>
    </div>
</footer>
