<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title', config('app.name'))</title>
    <meta name="description" content="@yield('description', 'نساج - متجرك المفضل للجوارب الفاخرة')">

    {{-- Google Fonts --}}
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Tajawal:wght@300;400;500;700;800&family=Cairo:wght@300;400;600;700;900&display=swap"
        rel="stylesheet">

    {{-- Vite Assets (Tailwind v4) --}}
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    @livewireStyles
    @stack('styles')

    {{-- Theme Initialization (before body renders to prevent FOUC) --}}
    <script>
        (function() {
            var theme = localStorage.getItem('theme');
            if (!theme) {
                theme = 'light'; // Default to light mode
            }
            if (theme === 'dark') {
                document.documentElement.classList.add('dark');
            } else {
                document.documentElement.classList.remove('dark');
            }
        })();
    </script>
</head>

<body
    class="font-sans antialiased bg-gradient-to-b from-white light:bg-#FAF8F2 dark:bg-[#0a0a0a] text-nassaj-text-primary dark:text-white transition-colors duration-300"
    data-page="@yield('page')">
    {{-- Livewire Store Components --}}
    @if (!isset($hideStoreComponents) || !$hideStoreComponents)
        <livewire:store.cart-manager />
        <livewire:store.wishlist-manager />
        <livewire:store.compare-manager />
        <livewire:store.quick-view-modal />
        <livewire:store.search-modal />
    @endif

    {{-- Toast Notifications --}}
    <div x-data="{
        notifications: [],
        add(type, message) {
            const id = Date.now();
            this.notifications.push({ id, type, message });
            setTimeout(() => this.remove(id), 4000);
        },
        remove(id) {
            this.notifications = this.notifications.filter(n => n.id !== id);
        }
    }" @notification.window="add($event.detail.type, $event.detail.message)"
        class="fixed top-20 left-4 z-[100] space-y-3">
        <template x-for="notification in notifications" :key="notification.id">
            <div x-show="true" x-transition:enter="transition ease-out duration-300"
                x-transition:enter-start="opacity-0 translate-x-8" x-transition:enter-end="opacity-100 translate-x-0"
                x-transition:leave="transition ease-in duration-200"
                x-transition:leave-start="opacity-100 translate-x-0" x-transition:leave-end="opacity-0 translate-x-8"
                class="flex items-center gap-3 px-4 py-3 rounded-xl shadow-xl backdrop-blur-md border"
                :class="{
                    'bg-green-50 dark:bg-green-500/20 border-green-200 dark:border-green-500/30 text-green-700 dark:text-green-300': notification
                        .type === 'success',
                    'bg-red-50 dark:bg-red-500/20 border-red-200 dark:border-red-500/30 text-red-700 dark:text-red-300': notification
                        .type === 'error',
                    'bg-amber-50 dark:bg-yellow-500/20 border-amber-200 dark:border-yellow-500/30 text-amber-700 dark:text-yellow-300': notification
                        .type === 'warning',
                    'bg-blue-50 dark:bg-blue-500/20 border-blue-200 dark:border-blue-500/30 text-blue-700 dark:text-blue-300': notification
                        .type === 'info'
                }">
                <template x-if="notification.type === 'success'">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                    </svg>
                </template>
                <template x-if="notification.type === 'error'">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12">
                        </path>
                    </svg>
                </template>
                <template x-if="notification.type === 'warning'">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z">
                        </path>
                    </svg>
                </template>
                <template x-if="notification.type === 'info'">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </template>
                <span class="font-bold text-sm" x-text="notification.message"></span>
                <button @click="remove(notification.id)" class="mr-2 opacity-70 hover:opacity-100">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12">
                        </path>
                    </svg>
                </button>
            </div>
        </template>
    </div>

    {{-- Top Bar & Header --}}
    @if (!isset($hideHeader) || !$hideHeader)
        @include('layouts.partials.topbar')
        @include('layouts.partials.navbar')
    @endif

    {{-- Page Hero (shown on all pages except home and client dashboard) --}}
    @if (!isset($hideHeader) || !$hideHeader)
        @unless (request()->routeIs('home') || request()->routeIs('client.*'))
            @include('layouts.partials.page-hero')
        @endunless
    @endif

    {{-- Main Content --}}
    <main>
        {{ $slot ?? '' }}
        @yield('content')
    </main>

    {{-- Footer & Mobile Nav --}}
    @if (!isset($hideFooter) || !$hideFooter)
        @include('layouts.partials.footer')
        @include('layouts.partials.mobile-nav')
    @endif

    {{-- Back to Top Button (fixed, above mobile nav on small screens) --}}
    @if (!isset($hideFooter) || !$hideFooter)
        <button id="backToTop" type="button" onclick="window.scrollTo({top: 0, behavior: 'smooth'})"
            class="fixed bottom-24 md:bottom-8 right-6 z-[60] w-12 h-12 rounded-full bg-nassaj-gold hover:bg-nassaj-gold-light text-nassaj-primary shadow-btn-gold dark:shadow-2xl opacity-0 invisible translate-y-4 transition-all duration-300 flex items-center justify-center group"
            aria-label="العودة للأعلى">
            <svg class="w-5 h-5 transition-transform group-hover:-translate-y-0.5" fill="none" stroke="currentColor"
                stroke-width="2.5" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M4.5 15.75l7.5-7.5 7.5 7.5" />
            </svg>
        </button>
        <script>
            (function() {
                var btn = document.getElementById('backToTop');
                if (!btn) return;

                function update() {
                    if (window.scrollY > 400) {
                        btn.classList.remove('opacity-0', 'invisible', 'translate-y-4');
                        btn.classList.add('opacity-100', 'visible', 'translate-y-0');
                    } else {
                        btn.classList.add('opacity-0', 'invisible', 'translate-y-4');
                        btn.classList.remove('opacity-100', 'visible', 'translate-y-0');
                    }
                }
                window.addEventListener('scroll', update, {
                    passive: true
                });
                update();
            })();
        </script>
    @endif

    @livewireScripts
    @stack('scripts')

    {{-- Dark/Light Mode Toggle Script --}}
    <script>
        function toggleTheme() {
            var html = document.documentElement;
            var isDark = html.classList.contains('dark');

            if (isDark) {
                html.classList.remove('dark');
                localStorage.setItem('theme', 'light');
            } else {
                html.classList.add('dark');
                localStorage.setItem('theme', 'dark');
            }
        }
    </script>
</body>

</html>
