<!DOCTYPE html>
<html lang="ar" dir="rtl" class="scroll-smooth">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title', 'تسجيل الدخول') - نساج</title>

    {{-- Google Fonts --}}
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Tajawal:wght@300;400;500;700;800&family=Cairo:wght@300;400;600;700;900&display=swap"
        rel="stylesheet">

    {{-- Vite Assets --}}
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    @livewireStyles
</head>

<body
    class="min-h-screen font-sans antialiased
           bg-white text-gray-900
           dark:bg-[#0a0a0a] dark:text-white">

    {{-- Background Pattern --}}
    <div class="fixed inset-0 z-0 pointer-events-none">
        {{-- Light mode wash --}}
        <div class="absolute inset-0 bg-gradient-to-br from-amber-500/5 via-transparent to-purple-500/5 dark:hidden">
        </div>

        {{-- Dark mode wash --}}
        <div
            class="absolute inset-0 hidden dark:block bg-gradient-to-br from-[#D4A356]/5 via-transparent to-[#D4A356]/5">
        </div>

        {{-- Orbs (shared but tuned per mode) --}}
        <div
            class="absolute top-0 left-0 w-96 h-96 rounded-full blur-3xl -translate-x-1/2 -translate-y-1/2
                   bg-amber-400/20 dark:bg-[#D4A356]/10">
        </div>
        <div
            class="absolute bottom-0 right-0 w-96 h-96 rounded-full blur-3xl translate-x-1/2 translate-y-1/2
                   bg-purple-400/20 dark:bg-[#D4A356]/10">
        </div>

        {{-- Subtle grid for light --}}
        <div class="absolute inset-0 opacity-[0.06] dark:hidden"
            style="background-image: linear-gradient(to right, rgba(0,0,0,.08) 1px, transparent 1px), linear-gradient(to bottom, rgba(0,0,0,.08) 1px, transparent 1px); background-size: 32px 32px;">
        </div>
    </div>

    <div class="relative z-10 min-h-screen flex flex-col">
        {{-- Header --}}
        <header class="py-6">
            <div class="site-container">
                <div class="flex items-center justify-between">
                    <a href="{{ route('home') }}" class="flex items-center gap-3">
                        {{-- Logo switches automatically --}}
                        <img src="{{ asset('images/logo/light.png') }}" alt="نساج" class="h-12 w-auto dark:hidden">
                        <img src="{{ asset('images/logo/dark.png') }}" alt="نساج"
                            class="h-12 w-auto hidden dark:block">
                    </a>

                    <a href="{{ route('home') }}"
                        class="inline-flex items-center gap-2 rounded-full px-4 py-2 text-sm font-medium
                               text-gray-600 hover:text-gray-900
                               bg-white/60 hover:bg-white/80
                               ring-1 ring-black/5 hover:ring-black/10
                               shadow-sm
                               transition
                               dark:text-gray-300 dark:hover:text-white
                               dark:bg-white/5 dark:hover:bg-white/10
                               dark:ring-white/10">
                        <span class="hidden sm:inline">العودة للرئيسية</span>
                        <svg class="w-5 h-5 rotate-180" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M17 8l4 4m0 0l-4 4m4-4H3" />
                        </svg>
                    </a>
                </div>
            </div>
        </header>

        {{-- Main Content --}}
        <main class="flex-1 flex items-center justify-center py-12 px-4">
            @yield('content')
        </main>

        {{-- Footer --}}
        <footer class="py-6 border-t border-black/5 dark:border-white/5">
            <div class="site-container">
                <p class="text-center text-sm text-gray-600 dark:text-gray-400">
                    &copy; {{ date('Y') }}
                    نساج. جميع الحقوق محفوظة. تصميم وتطوير
                    <a href="tel:07710811093"
                        class="font-medium text-amber-600 hover:text-amber-700
                               dark:text-amber-300 dark:hover:text-white
                               transition-colors duration-200">
                        نساج
                    </a>.
                </p>
            </div>
        </footer>
    </div>

    @livewireScripts
    @stack('scripts')
</body>

</html>
