<x-filament-widgets::widget>
    <style>
        @keyframes slideIn {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .filter-section {
            animation: slideIn 0.3s ease-out;
        }
    </style>

    @php
        $periodNames = [
            'today' => 'اليوم',
            'yesterday' => 'أمس',
            'this_week' => 'الأسبوع الحالي',
            'last_week' => 'الأسبوع الماضي',
            'last_7_days' => 'آخر 7 أيام',
            'this_month' => 'الشهر الحالي',
            'last_month' => 'الشهر الماضي',
            'last_30_days' => 'آخر 30 يوم',
            'last_90_days' => 'آخر 90 يوم',
            'this_year' => 'هذه السنة',
            'last_year' => 'السنة الماضية',
            'custom' => 'مخصص',
            'all' => 'كل الفترات',
        ];

        $currentPeriod = $this->data['period'] ?? ($this->filters['dateRange'] ?? 'today');
        $fromVal = $this->data['from_date'] ?? ($this->filters['startDate'] ?? null);
        $toVal = $this->data['to_date'] ?? ($this->filters['endDate'] ?? null);

        $showComparison =
            (string) ($this->data['show_comparison'] ?? ($this->filters['show_comparison'] ?? '1')) === '1';

        $hasSelection = method_exists($this, 'hasActiveSelection') ? $this->hasActiveSelection() : false;

        $statsData =
            $hasSelection && $showComparison && method_exists($this, 'getStatsData') ? $this->getStatsData() : [];
    @endphp

    {{-- قسم الفلتر --}}
    <div class="filter-section mb-6 relative z-[9] overflow-visible">
        <div
            class="rounded-2xl bg-white shadow-lg ring-1 ring-gray-950/5 dark:bg-gray-900 dark:ring-white/10 overflow-visible">

            {{-- Header --}}
            <div
                class="border-b border-gray-200/60 bg-gradient-to-r from-primary-50/50 to-transparent px-6 py-4
                       dark:border-gray-700/40 dark:from-primary-900/20">
                <div class="flex items-center justify-between gap-3">
                    <div class="flex items-center gap-3">
                        <div
                            class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-primary-500 to-primary-600 shadow-lg shadow-primary-500/30">
                            <svg class="h-5 w-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M3 4a1 1 0 011-1h16a1 1 0 011 1v2.586a1 1 0 01-.293.707l-6.414 6.414a1 1 0 00-.293.707V17l-4 4v-6.586a1 1 0 00-.293-.707L3.293 7.293A1 1 0 013 6.586V4z" />
                            </svg>
                        </div>
                        <div>
                            <h3 class="text-lg font-bold text-gray-900 dark:text-white">تصفية الإحصائيات</h3>
                            <p class="text-xs text-gray-500 dark:text-gray-400">
                                اختر الفترة الزمنية لعرض البيانات والمقارنة مع اليوم
                            </p>
                        </div>
                    </div>

                    {{-- زر التصدير --}}
                    <button type="button" wire:click="exportStats" wire:loading.attr="disabled"
                        wire:target="exportStats"
                        class="group flex items-center gap-2 rounded-xl bg-gradient-to-r from-success-600 to-success-500 px-4 py-2.5
                               text-sm font-bold text-white shadow-lg shadow-success-500/30 transition-all hover:from-success-700
                               hover:to-success-600 hover:shadow-xl hover:shadow-success-500/40 disabled:opacity-60 disabled:cursor-not-allowed">
                        <svg class="h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4" />
                        </svg>

                        <span wire:loading.remove wire:target="exportStats">تصدير</span>
                        <span wire:loading wire:target="exportStats">جاري التصدير...</span>
                    </button>
                </div>
            </div>

            {{-- المحتوى --}}
            <div class="p-6 overflow-visible">
                <div class="space-y-5">
                    <div>
                        {{ $this->form }}
                    </div>

                    {{-- شريط الفترة --}}
                    @if ($hasSelection)
                        <div
                            class="flex flex-wrap items-center justify-between gap-3 rounded-xl bg-gray-50 px-4 py-3 dark:bg-gray-800/50">
                            <div class="flex items-center gap-2">
                                <div
                                    class="flex h-8 w-8 items-center justify-center rounded-lg bg-primary-100 dark:bg-primary-900/50">
                                    <svg class="h-4 w-4 text-primary-600 dark:text-primary-400" fill="none"
                                        stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                    </svg>
                                </div>

                                <div>
                                    <p class="text-xs text-gray-500 dark:text-gray-400">الفترة المحددة</p>
                                    <p class="text-sm font-bold text-gray-900 dark:text-white">
                                        {{ $periodNames[$currentPeriod] ?? 'اليوم' }}

                                        @if ($currentPeriod === 'custom' && !empty($fromVal) && !empty($toVal))
                                            <span class="text-xs text-gray-500">
                                                ({{ \Carbon\Carbon::parse($fromVal)->format('Y/m/d') }} →
                                                {{ \Carbon\Carbon::parse($toVal)->format('Y/m/d') }})
                                            </span>
                                        @endif
                                    </p>
                                </div>
                            </div>

                            <div class="flex items-center gap-3">
                                <button type="button" wire:click="resetFilters"
                                    class="group flex items-center gap-2 rounded-xl border-2 border-gray-200 bg-white px-4 py-2.5 text-sm font-bold
                                           text-gray-700 shadow-sm transition-all hover:border-gray-300 hover:bg-gray-50 hover:shadow-md
                                           dark:border-gray-700 dark:bg-gray-950 dark:text-gray-300 dark:hover:border-gray-600 dark:hover:bg-gray-800">
                                    <svg class="h-4 w-4 transition-transform group-hover:rotate-180" fill="none"
                                        stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15" />
                                    </svg>
                                    <span>إعادة تعيين</span>
                                </button>
                            </div>
                        </div>
                    @endif

                    {{-- لوحة المقارنة --}}
                    @if ($hasSelection && $showComparison)
                        <div
                            class="rounded-2xl bg-blue-50/70 px-4 py-4 ring-1 ring-blue-200/60 dark:bg-blue-900/20 dark:ring-blue-500/20">
                            <div class="flex items-start gap-3">
                                <div
                                    class="flex h-9 w-9 flex-shrink-0 items-center justify-center rounded-xl bg-blue-500/15 dark:bg-blue-500/20">
                                    <svg class="h-5 w-5 text-blue-700 dark:text-blue-300" fill="none"
                                        stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                </div>

                                <div class="flex-1">
                                    <p class="text-sm font-extrabold text-blue-900 dark:text-blue-200">المقارنة مفعّلة
                                    </p>
                                    <p class="mt-0.5 text-xs text-blue-800/80 dark:text-blue-200/80">
                                        تم مقارنة بيانات الفترة المختارة مع <span class="font-bold">اليوم</span>
                                    </p>

                                    <div class="mt-3 grid grid-cols-1 gap-2 md:grid-cols-2 xl:grid-cols-3">
                                        @foreach ($statsData as $row)
                                            @php
                                                $cmp = $row['cmp'] ?? [
                                                    'has' => false,
                                                    'dir' => 'same',
                                                    'text' => '',
                                                    'diff' => 0,
                                                ];
                                                $dir = $cmp['dir'] ?? 'same';
                                                $diff = (int) ($cmp['diff'] ?? 0);

                                                $badgeClass =
                                                    $dir === 'up'
                                                        ? 'bg-emerald-500/15 text-emerald-700 dark:text-emerald-300'
                                                        : ($dir === 'down'
                                                            ? 'bg-rose-500/15 text-rose-700 dark:text-rose-300'
                                                            : 'bg-gray-500/10 text-gray-700 dark:text-gray-300');

                                                $arrow = $dir === 'up' ? '▲' : ($dir === 'down' ? '▼' : '■');
                                            @endphp

                                            <div
                                                class="flex items-center justify-between rounded-xl bg-white/70 px-3 py-2 ring-1 ring-gray-200/60 dark:bg-gray-950/40 dark:ring-white/10">
                                                <div class="min-w-0">
                                                    <p class="truncate text-xs font-bold text-gray-900 dark:text-white">
                                                        {{ $row['title'] ?? '-' }}
                                                    </p>
                                                    <p class="mt-0.5 text-[11px] text-gray-600 dark:text-gray-400">
                                                        {{ $cmp['has'] ? $cmp['text'] ?? '' : 'لا توجد بيانات للمقارنة' }}
                                                    </p>
                                                </div>

                                                <div class="flex items-center gap-2">
                                                    <span
                                                        class="rounded-lg px-2 py-1 text-[11px] font-extrabold {{ $badgeClass }}">
                                                        {{ $arrow }} {{ number_format(abs($diff), 0, '.', ',') }}
                                                    </span>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>

                                </div>
                            </div>
                        </div>
                    @endif

                </div>
            </div>
        </div>
    </div>

    {{-- كروت الإحصائيات --}}
    <div class="animate-[slideIn_0.4s_ease-out]">
        @include('filament-widgets::stats-overview-widget')
    </div>
</x-filament-widgets::widget>
