<x-filament-widgets::widget>
    <style>
        @keyframes slideIn {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .filter-section {
            animation: slideIn 0.3s ease-out;
        }
    </style>

    @php
        $periodNames = [
            'today' => 'اليوم',
            'yesterday' => 'أمس',
            'this_week' => 'الأسبوع الحالي',
            'last_week' => 'الأسبوع الماضي',
            'last_7_days' => 'آخر 7 أيام',
            'this_month' => 'الشهر الحالي',
            'last_month' => 'الشهر الماضي',
            'last_30_days' => 'آخر 30 يوم',
            'this_year' => 'هذه السنة',
            'custom' => 'مخصص',
            'all' => 'كل الفترات',
        ];

        $currentPeriod = $this->data['period'] ?? 'today';
        $fromVal = $this->data['from_date'] ?? null;
        $toVal = $this->data['to_date'] ?? null;
        $hasSelection = method_exists($this, 'hasActiveSelection') ? $this->hasActiveSelection() : false;
    @endphp

    {{-- قسم الفلتر --}}
    <div class="filter-section mb-6 relative z-[9] overflow-visible">
        <div
            class="rounded-2xl bg-white shadow-lg ring-1 ring-gray-950/5 dark:bg-gray-900 dark:ring-white/10 overflow-visible">

            {{-- Header --}}
            <div
                class="border-b border-gray-200/60 bg-gradient-to-r from-primary-50/50 to-transparent px-6 py-4
                       dark:border-gray-700/40 dark:from-primary-900/20">
                <div class="flex items-center justify-between gap-3">
                    <div class="flex items-center gap-3">
                        <div
                            class="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-primary-500 to-primary-600 shadow-lg shadow-primary-500/30">
                            <x-heroicon-o-shopping-cart class="h-5 w-5 text-white" />
                        </div>
                        <div>
                            <h3 class="text-lg font-bold text-gray-900 dark:text-white">إحصائيات الطلبات</h3>
                            <p class="text-xs text-gray-500 dark:text-gray-400">
                                عرض حالات الطلبات حسب الفترة الزمنية
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            {{-- المحتوى --}}
            <div class="p-6 overflow-visible">
                <div class="space-y-5">
                    <div>
                        {{ $this->form }}
                    </div>

                    {{-- شريط الفترة --}}
                    @if ($hasSelection)
                        <div
                            class="flex flex-wrap items-center justify-between gap-3 rounded-xl bg-gray-50 px-4 py-3 dark:bg-gray-800/50">
                            <div class="flex items-center gap-2">
                                <div
                                    class="flex h-8 w-8 items-center justify-center rounded-lg bg-primary-100 dark:bg-primary-900/50">
                                    <x-heroicon-o-calendar class="h-4 w-4 text-primary-600 dark:text-primary-400" />
                                </div>

                                <div>
                                    <p class="text-xs text-gray-500 dark:text-gray-400">الفترة المحددة</p>
                                    <p class="text-sm font-bold text-gray-900 dark:text-white">
                                        {{ $periodNames[$currentPeriod] ?? 'اليوم' }}

                                        @if ($currentPeriod === 'custom' && !empty($fromVal) && !empty($toVal))
                                            <span class="text-xs text-gray-500">
                                                ({{ \Carbon\Carbon::parse($fromVal)->format('Y/m/d') }} →
                                                {{ \Carbon\Carbon::parse($toVal)->format('Y/m/d') }})
                                            </span>
                                        @endif
                                    </p>
                                </div>
                            </div>

                            <div class="flex items-center gap-3">
                                <button type="button" wire:click="resetFilters"
                                    class="group flex items-center gap-2 rounded-xl border-2 border-gray-200 bg-white px-4 py-2.5 text-sm font-bold
                                           text-gray-700 shadow-sm transition-all hover:border-gray-300 hover:bg-gray-50 hover:shadow-md
                                           dark:border-gray-700 dark:bg-gray-950 dark:text-gray-300 dark:hover:border-gray-600 dark:hover:bg-gray-800">
                                    <svg class="h-4 w-4 transition-transform group-hover:rotate-180" fill="none"
                                        stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15" />
                                    </svg>
                                    <span>إعادة تعيين</span>
                                </button>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    {{-- كروت الإحصائيات --}}
    <div class="animate-[slideIn_0.4s_ease-out]">
        @include('filament-widgets::stats-overview-widget')
    </div>
</x-filament-widgets::widget>
