@php
    try {
        $settings = \Illuminate\Support\Facades\DB::table('general_settings')->first();
        $logoUrl = $settings?->site_logo
            ? \Illuminate\Support\Facades\Storage::disk('upload')->url($settings->site_logo)
            : asset('images/logo.svg'); // fallback
        $logoDarkUrl = $settings?->site_logo_dark
            ? \Illuminate\Support\Facades\Storage::disk('upload')->url($settings->site_logo_dark)
            : asset('images/logo-dark.svg'); // fallback
    } catch (\Throwable $e) {
        $logoUrl = asset('images/logo.svg');
        $logoDarkUrl = asset('images/logo-dark.svg');
    }
@endphp

{{-- شعار في أعلى السايدبار --}}
<div class="px-3 pt-4 pb-3">
    <a href="{{ filament()->getUrl() }}" class="block">
        {{-- عند الطيّ: أيقونة صغيرة --}}
        <span x-show="! $store.sidebar.isOpen">
            <img src="{{ $logoUrl }}" alt="Logo" class="h-8 w-8 object-contain dark:hidden">
            <img src="{{ $logoDarkUrl }}" alt="Logo" class="h-8 w-8 object-contain hidden dark:block">
        </span>

        {{-- عند الفتح: الشعار بعرض كامل (بدون نص اسم الموقع) --}}
        <div x-show="$store.sidebar.isOpen" x-transition>
            <img src="{{ $logoUrl }}" alt="Logo" class="w-full h-auto max-h-12 object-contain dark:hidden">
            <img src="{{ $logoDarkUrl }}" alt="Logo"
                class="w-full h-auto max-h-12 object-contain hidden dark:block">
        </div>
    </a>
</div>
