@php
    /** @var \App\Models\User $user */
    $user = $getRecord();

    $avatar = $user?->avatar_url ?: 'https://placehold.co/160x160?text=Avatar';

    $roleNames = $user->roles?->pluck('name')->implode(' • ') ?: 'مستخدم';
    $branch = $user->branch?->name ?: 'بدون فرع';
    $email = $user->email ?: '—';
    $phone = $user->phone ?: '—';
    $username = $user->username ?: '—';
    $address = $user->address ?: '—';

    // ========= ألوان الفرع (نستخدمها فقط كـ Accent) =========
    $currentBranchId = user_info('branch_id');
    $branchSettings = $currentBranchId ? \App\Models\BranchSetting::forBranch($currentBranchId)->first() : null;

    // ألوان افتراضية مودرن (دافئة وحيادية)
    $palette = $branchSettings?->themePaletteOrGenerate() ?? [
        'base' => '#C26D3C', // لهجة نحاسية دافئة
        'mid' => '#D8925F',
        'dark' => '#8A4B2A',
        'muted' => '#9CA3AF',
        'border' => '#E5D3C3',
        'bg' => '#FFF8F1',
    ];

    // ========= إعداد الفلتر الزمني =========
    $filter = request('stats_range', 'today');
    $fromDate = request('stats_from');
    $toDate = request('stats_to');

    $applyDateFilter = function ($query, string $column) use ($filter, $fromDate, $toDate) {
        return match ($filter) {
            'today' => $query->whereDate($column, today()),
            'week' => $query->whereBetween($column, [now()->startOfWeek(), now()->endOfWeek()]),
            'month' => $query->whereBetween($column, [now()->startOfMonth(), now()->endOfMonth()]),
            'custom' => $fromDate && $toDate ? $query->whereBetween($column, [$fromDate, $toDate]) : $query,
            default => $query->whereDate($column, today()),
        };
    };

    // ================== حساب الإحصائيات ==================
    $salesQuery = $applyDateFilter($user->sales(), 'invoice_date');
    $salesCount = $salesQuery->count();
    $salesTotal = (int) $salesQuery->sum('total_amount');
    $salesPaid = (int) $salesQuery->sum('paid_amount');
    $salesRemaining = (int) $salesQuery->sum('remaining_amount');

    $purchasesQuery = $applyDateFilter($user->purchases(), 'invoice_date');
    $purchasesCount = $purchasesQuery->count();
    $purchasesTotal = (int) $purchasesQuery->sum('total_amount');
    $purchasesPaid = (int) $purchasesQuery->sum('paid_amount');
    $purchasesRemaining = (int) $purchasesQuery->sum('remaining_amount');

    $receiptsQuery = $applyDateFilter($user->clientReceipts()->issued(), 'receipt_date');
    $receiptsCount = $receiptsQuery->count();
    $receiptsTotal = (int) $receiptsQuery->sum('total_amount');
    $receiptsPaid = (int) $receiptsQuery->sum('total_paid');

    $formatMoney = fn($val) => number_format($val, 0, '.', ',') . ' د.ع';
    $formatInt = fn($val) => number_format($val, 0, '.', ',');

    // نسبة التقدم
    $percent = function (int $paid, int $total): int {
        return $total > 0 ? max(0, min(100, (int) round(($paid * 100) / $total))) : 0;
    };

    $salesPercent = $percent($salesPaid, $salesTotal);
    $purchasesPercent = $percent($purchasesPaid, $purchasesTotal);
    $receiptsPercent = $percent($receiptsPaid, $receiptsTotal);

    $baseUrl = request()->url();
    $buildUrl = function (array $params = []) use ($baseUrl) {
        return $baseUrl .
            '?' .
            http_build_query(array_merge(request()->except(['stats_range', 'stats_from', 'stats_to']), $params));
    };
@endphp

{{-- Flatpickr CSS & JS --}}
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr@4.6.13/dist/flatpickr.min.css">
<script src="https://cdn.jsdelivr.net/npm/flatpickr@4.6.13/dist/flatpickr.min.js"></script>

<style>
    :root {
        --branch-base: {{ $palette['base'] }};
        --branch-mid: {{ $palette['mid'] }};
        --branch-dark: {{ $palette['dark'] }};
        --branch-border: {{ $palette['border'] }};
        --shell-bg-light-1: #FFF8F1;
        --shell-bg-light-2: #FDEFE4;
        --shell-bg-light-3: #F7E4D6;
        --shell-bg-dark-1: #020617;
        --shell-bg-dark-2: #020617;
    }

    .stat-shell {
        position: relative;
        overflow: hidden;
        border-radius: 1.75rem;
    }

    .stat-shell::before {
        content: '';
        position: absolute;
        inset: 0;
        background:
            radial-gradient(circle at top left, rgba(255, 255, 255, 0.7), transparent 60%),
            radial-gradient(circle at bottom right, rgba(255, 255, 255, 0.55), transparent 60%);
        opacity: 0.9;
        pointer-events: none;
    }

    .dark .stat-shell::before {
        background:
            radial-gradient(circle at top left, rgba(148, 163, 184, 0.14), transparent 60%),
            radial-gradient(circle at bottom right, rgba(148, 163, 184, 0.08), transparent 60%);
        opacity: 1;
    }

    .stat-card {
        transition: all 0.2s ease;
        backdrop-filter: blur(6px);
    }

    .stat-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 18px 40px rgba(15, 23, 42, 0.12);
    }

    .dark .stat-card:hover {
        box-shadow: 0 18px 40px rgba(0, 0, 0, 0.42);
    }

    /* Flatpickr */
    .flatpickr-calendar {
        border-radius: 14px;
        box-shadow: 0 16px 45px rgba(15, 23, 42, 0.25);
        border: 1px solid var(--branch-border);
        background: #fffdfb;
    }

    .dark .flatpickr-calendar {
        background: #020617;
        border-color: rgb(51, 65, 85);
    }

    .flatpickr-day.selected {
        background: var(--branch-base) !important;
        border-color: var(--branch-base) !important;
        color: #fff !important;
    }

    .flatpickr-day:hover {
        background: rgba(194, 109, 60, 0.12) !important;
        border-color: var(--branch-base) !important;
    }

    .dark .flatpickr-day:hover {
        background: rgba(194, 109, 60, 0.32) !important;
    }

    .flatpickr-months .flatpickr-month {
        background: #fff7f2;
    }

    .dark .flatpickr-months .flatpickr-month {
        background: #020617;
    }

    .flatpickr-current-month .flatpickr-monthDropdown-months {
        background: #fff7f2;
    }

    .dark .flatpickr-current-month .flatpickr-monthDropdown-months {
        background: #020617;
    }

    .dark .flatpickr-day {
        color: rgb(226, 232, 240);
    }

    .dark .flatpickr-months .flatpickr-prev-month,
    .dark .flatpickr-months .flatpickr-next-month {
        fill: rgb(226, 232, 240);
    }

    /* حقول التاريخ */
    .date-input-custom {
        border-radius: 0.75rem;
        border: 1px solid rgba(148, 163, 184, 0.7);
        background: rgba(255, 255, 255, 0.9);
        padding: 0.5rem 0.875rem;
        font-size: 0.875rem;
        cursor: pointer;
        transition: all 0.2s ease;
        color: rgb(15, 23, 42);
    }

    .dark .date-input-custom {
        background: rgba(15, 23, 42, 0.92);
        border-color: rgb(71, 85, 105);
        color: rgb(226, 232, 240);
    }

    .date-input-custom:focus {
        outline: none;
        border-color: var(--branch-base);
        box-shadow: 0 0 0 2px rgba(194, 109, 60, 0.25);
    }

    .dark .date-input-custom:focus {
        box-shadow: 0 0 0 2px rgba(194, 109, 60, 0.4);
    }

    .custom-date-wrapper {
        background: linear-gradient(135deg, #fff8f2 0%, #fef2e9 100%);
        border: 1px solid rgba(248, 211, 182, 0.9);
        border-radius: 1rem;
        padding: 1rem;
        margin-top: 0.5rem;
    }

    .dark .custom-date-wrapper {
        background: linear-gradient(135deg, rgba(15, 23, 42, 0.98) 0%, rgba(15, 23, 42, 0.96) 100%);
        border-color: rgba(71, 85, 105, 0.85);
    }

    /* RTL */
    [dir="rtl"] .flatpickr-calendar {
        direction: rtl !important;
    }
</style>

<div dir="rtl" x-data="{ showCustom: {{ $filter === 'custom' ? 'true' : 'false' }} }" class="stat-shell relative w-full shadow-sm" {{-- ✅ حذفنا border هنا --}}>
    {{-- Light Mode Background --}}
    <div class="absolute inset-0 dark:hidden"
        style="
            background:
                radial-gradient(circle at top left,#ffffff 0,transparent 60%),
                radial-gradient(circle at bottom right,#fff3e6 0,transparent 65%),
                linear-gradient(135deg,var(--shell-bg-light-1) 0%,var(--shell-bg-light-2) 45%,var(--shell-bg-light-3) 100%);
            border-color: {{ $palette['border'] }};
        ">
    </div>

    {{-- Dark Mode Background --}}
    <div class="absolute inset-0 hidden dark:block"
        style="
            background:
                radial-gradient(circle at top left,rgba(248,250,252,0.06),transparent 55%),
                linear-gradient(135deg,var(--shell-bg-dark-1) 0%,var(--shell-bg-dark-2) 100%);
        ">
    </div>

    <div class="relative px-5 py-5 sm:px-7 sm:py-6">
        <div class="flex flex-col gap-6 md:flex-row-reverse md:items-stretch md:gap-6">

            {{-- القسم الأيسر: الفلاتر + الإحصائيات --}}
            <div class="flex-1 rounded-2xl border bg-white/85 dark:bg-slate-950/70 backdrop-blur-md px-4 py-4 sm:px-5 sm:py-5 flex flex-col gap-4"
                style="border-color: rgba(226, 232, 240, 0.7);">
                {{-- الهيدر + الفلاتر --}}
                <div class="flex flex-col gap-3 lg:flex-row lg:items-center lg:justify-between">
                    <div class="text-right space-y-1">
                        <p class="text-xs tracking-wide text-slate-500 dark:text-slate-400">
                            نشاط المستخدم
                        </p>
                        <h3 class="text-base sm:text-lg font-semibold text-slate-900 dark:text-slate-100">
                            إحصائيات النشاط
                        </h3>

                        @if ($filter === 'custom' && $fromDate && $toDate)
                            <p class="mt-1 text-[0.8rem] text-slate-500 dark:text-slate-400">
                                عرض نشاط الفترة من
                                <span class="font-medium text-slate-800 dark:text-slate-100">{{ $fromDate }}</span>
                                إلى
                                <span class="font-medium text-slate-800 dark:text-slate-100">{{ $toDate }}</span>
                            </p>
                        @else
                            <p class="mt-1 text-[0.8rem] text-slate-500 dark:text-slate-400">
                                عرض نشاطات
                                <span class="font-semibold text-slate-900 dark:text-slate-100">
                                    @switch($filter)
                                        @case('week')
                                            هذا الأسبوع
                                        @break

                                        @case('month')
                                            هذا الشهر
                                        @break

                                        @case('custom')
                                            فترة مخصصة
                                        @break

                                        @default
                                            اليوم
                                    @endswitch
                                </span>
                            </p>
                        @endif
                    </div>

                    {{-- الفلاتر --}}
                    <div class="flex flex-col gap-2 items-stretch lg:items-end">
                        <div class="flex flex-wrap items-center gap-2 text-xs sm:text-sm">
                            @foreach (['today' => 'اليوم', 'week' => 'هذا الأسبوع', 'month' => 'هذا الشهر'] as $key => $label)
                                <a href="{{ $buildUrl(['stats_range' => $key]) }}" @class([
                                    'inline-flex items-center justify-center rounded-full px-3 py-1.5 border text-xs sm:text-sm transition-all',
                                    'bg-slate-900 text-white border-slate-900 shadow-sm shadow-slate-400/50 dark:bg-white dark:text-slate-900 dark:border-white' =>
                                        $filter === $key,
                                    'bg-white/70 text-slate-800 border-slate-200 hover:bg-slate-50 dark:bg-slate-900/60 dark:text-slate-200 dark:border-slate-700 dark:hover:bg-slate-900' =>
                                        $filter !== $key,
                                ])>
                                    {{ $label }}
                                </a>
                            @endforeach

                            <button type="button" x-on:click="showCustom = !showCustom" @class([
                                'inline-flex items-center justify-center rounded-full px-3 py-1.5 border text-xs sm:text-sm transition-all',
                                'bg-slate-900 text-white border-slate-900 shadow-sm shadow-slate-400/50 dark:bg-white dark:text-slate-900 dark:border-white' =>
                                    $filter === 'custom',
                                'bg-white/70 text-slate-800 border-slate-200 hover:bg-slate-50 dark:bg-slate-900/60 dark:text-slate-200 dark:border-slate-700 dark:hover:bg-slate-900' =>
                                    $filter !== 'custom',
                            ])>
                                مخصص
                            </button>
                        </div>

                        {{-- فورم التاريخ المخصص --}}
                        <div x-show="showCustom" x-cloak x-transition class="custom-date-wrapper w-full max-w-md">
                            <form method="GET" class="space-y-3">
                                <input type="hidden" name="stats_range" value="custom">

                                <div class="grid grid-cols-2 gap-3">
                                    <div>
                                        <label
                                            class="block text-xs font-semibold mb-1.5 text-slate-700 dark:text-slate-200">
                                            من تاريخ
                                        </label>
                                        <input id="stats_from_picker" name="stats_from" type="text"
                                            value="{{ $fromDate }}" class="date-input-custom w-full" readonly
                                            required placeholder="اختر التاريخ">
                                    </div>

                                    <div>
                                        <label
                                            class="block text-xs font-semibold mb-1.5 text-slate-700 dark:text-slate-200">
                                            إلى تاريخ
                                        </label>
                                        <input id="stats_to_picker" name="stats_to" type="text"
                                            value="{{ $toDate }}" class="date-input-custom w-full" readonly
                                            required placeholder="اختر التاريخ">
                                    </div>
                                </div>

                                <button type="submit"
                                    class="w-full inline-flex items-center justify-center gap-2 rounded-lg text-white text-sm font-semibold px-4 py-2.5 shadow-md hover:shadow-lg transition-all"
                                    style="background: var(--branch-base);">
                                    <x-filament::icon icon="heroicon-m-funnel" class="w-4 h-4" />
                                    عرض النتائج
                                </button>
                            </form>
                        </div>
                    </div>
                </div>

                {{-- كروت الإحصائيات --}}
                <div class="mt-3 grid grid-cols-1 md:grid-cols-3 gap-4">
                    {{-- الوصولات --}}
                    <div
                        class="stat-card rounded-2xl border border-indigo-100 dark:border-indigo-900/70 bg-gradient-to-br from-indigo-50 via-white to-slate-50 dark:from-slate-950 dark:via-slate-950/70 dark:to-slate-950 p-4 text-right">
                        <div class="flex items-start justify-between gap-2 flex-row-reverse">
                            <div class="space-y-3 flex-1">
                                <div class="flex items-center gap-2 flex-row-reverse">
                                    <span
                                        class="inline-flex items-center justify-center rounded-2xl bg-indigo-500 text-white p-2 shadow-md shadow-indigo-200/70 dark:shadow-indigo-900/50">
                                        <x-filament::icon icon="heroicon-o-receipt-refund" class="w-5 h-5" />
                                    </span>
                                    <div class="text-right">
                                        <p class="text-xs font-semibold text-indigo-900 dark:text-indigo-100">
                                            الوصولات
                                        </p>
                                        <p class="text-[0.78rem] text-indigo-700/90 dark:text-indigo-200/90">
                                            حركة الوصولات
                                        </p>
                                    </div>
                                </div>

                                <p class="text-2xl font-bold text-indigo-950 dark:text-indigo-50 tracking-tight">
                                    {{ $formatMoney($receiptsTotal) }}
                                </p>

                                <div
                                    class="mt-1 h-1.5 w-full rounded-full bg-indigo-100 dark:bg-indigo-950/40 overflow-hidden">
                                    <div class="h-full rounded-full bg-indigo-500"
                                        style="width: {{ $receiptsPercent }}%"></div>
                                </div>

                                <dl class="mt-2 space-y-1.5 text-[0.78rem] text-indigo-900/90 dark:text-indigo-100/90">
                                    <div class="flex justify-between gap-2">
                                        <dt>عدد الوصولات</dt>
                                        <dd class="font-semibold">{{ $formatInt($receiptsCount) }}</dd>
                                    </div>
                                    <div class="flex justify-between gap-2">
                                        <dt>مجموع المدفوع</dt>
                                        <dd class="font-semibold">{{ $formatMoney($receiptsPaid) }}</dd>
                                    </div>
                                </dl>
                            </div>
                        </div>
                    </div>

                    {{-- المشتريات --}}
                    <div
                        class="stat-card rounded-2xl border border-amber-100 dark:border-amber-900/70 bg-gradient-to-br from-amber-50 via-white to-slate-50 dark:from-slate-950 dark:via-slate-950/70 dark:to-slate-950 p-4 text-right">
                        <div class="flex items-start justify-between gap-2 flex-row-reverse">
                            <div class="space-y-3 flex-1">
                                <div class="flex items-center gap-2 flex-row-reverse">
                                    <span
                                        class="inline-flex items-center justify-center rounded-2xl bg-amber-500 text-white p-2 shadow-md shadow-amber-200/70 dark:shadow-amber-900/50">
                                        <x-filament::icon icon="heroicon-o-shopping-bag" class="w-5 h-5" />
                                    </span>
                                    <div class="text-right">
                                        <p class="text-xs font-semibold text-amber-900 dark:text-amber-100">
                                            المشتريات
                                        </p>
                                        <p class="text-[0.78rem] text-amber-800/90 dark:text-amber-200/90">
                                            فواتير الشراء
                                        </p>
                                    </div>
                                </div>

                                <p class="text-2xl font-bold text-amber-950 dark:text-amber-50 tracking-tight">
                                    {{ $formatMoney($purchasesTotal) }}
                                </p>

                                <div
                                    class="mt-1 h-1.5 w-full rounded-full bg-amber-100 dark:bg-amber-950/40 overflow-hidden">
                                    <div class="h-full rounded-full bg-amber-500"
                                        style="width: {{ $purchasesPercent }}%"></div>
                                </div>

                                <dl class="mt-2 space-y-1.5 text-[0.78rem] text-amber-900/90 dark:text-amber-100/90">
                                    <div class="flex justify-between gap-2">
                                        <dt>عدد الفواتير</dt>
                                        <dd class="font-semibold">{{ $formatInt($purchasesCount) }}</dd>
                                    </div>
                                    <div class="flex justify-between gap-2">
                                        <dt>مدفوع</dt>
                                        <dd class="font-semibold">{{ $formatMoney($purchasesPaid) }}</dd>
                                    </div>
                                    <div class="flex justify-between gap-2">
                                        <dt>متبقي</dt>
                                        <dd class="font-semibold">{{ $formatMoney($purchasesRemaining) }}</dd>
                                    </div>
                                </dl>
                            </div>
                        </div>
                    </div>

                    {{-- المبيعات --}}
                    <div
                        class="stat-card rounded-2xl border border-emerald-100 dark:border-emerald-900/70 bg-gradient-to-br from-emerald-50 via-white to-slate-50 dark:from-slate-950 dark:via-slate-950/70 dark:to-slate-950 p-4 text-right">
                        <div class="flex items-start justify-between gap-2 flex-row-reverse">
                            <div class="space-y-3 flex-1">
                                <div class="flex items-center gap-2 flex-row-reverse">
                                    <span
                                        class="inline-flex items-center justify-center rounded-2xl bg-emerald-500 text-white p-2 shadow-md shadow-emerald-200/70 dark:shadow-emerald-900/50">
                                        <x-filament::icon icon="heroicon-o-shopping-cart" class="w-5 h-5" />
                                    </span>
                                    <div class="text-right">
                                        <p class="text-xs font-semibold text-emerald-900 dark:text-emerald-100">
                                            المبيعات
                                        </p>
                                        <p class="text-[0.78rem] text-emerald-800/90 dark:text-emerald-200/90">
                                            فواتير البيع
                                        </p>
                                    </div>
                                </div>

                                <p class="text-2xl font-bold text-emerald-950 dark:text-emerald-50 tracking-tight">
                                    {{ $formatMoney($salesTotal) }}
                                </p>

                                <div
                                    class="mt-1 h-1.5 w-full rounded-full bg-emerald-100 dark:bg-emerald-950/40 overflow-hidden">
                                    <div class="h-full rounded-full bg-emerald-500"
                                        style="width: {{ $salesPercent }}%"></div>
                                </div>

                                <dl
                                    class="mt-2 space-y-1.5 text-[0.78rem] text-emerald-900/90 dark:text-emerald-100/90">
                                    <div class="flex justify-between gap-2">
                                        <dt>عدد الفواتير</dt>
                                        <dd class="font-semibold">{{ $formatInt($salesCount) }}</dd>
                                    </div>
                                    <div class="flex justify-between gap-2">
                                        <dt>مدفوع</dt>
                                        <dd class="font-semibold">{{ $formatMoney($salesPaid) }}</dd>
                                    </div>
                                    <div class="flex justify-between gap-2">
                                        <dt>متبقي</dt>
                                        <dd class="font-semibold">{{ $formatMoney($salesRemaining) }}</dd>
                                    </div>
                                </dl>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- القسم الأيمن: كارت المستخدم --}}
            <div class="relative w-full md:w-72 lg:w-80 flex flex-col items-center text-center rounded-3xl border px-4 py-5 shadow-sm bg-white/80 dark:bg-slate-950/80 backdrop-blur-md"
                style="border-color: rgba(226, 232, 240, 0.8);">
                {{-- خلفية داخلية للكارت --}}
                <div class="pointer-events-none absolute inset-0 rounded-3xl -z-10">
                    <div
                        class="absolute inset-0 rounded-3xl bg-gradient-to-b from-white/70 via-white/40 to-amber-50/60 dark:from-slate-900/80 dark:via-slate-950/80 dark:to-slate-950/90">
                    </div>
                    <div
                        class="absolute -top-10 right-10 h-20 w-20 rounded-full bg-white/60 blur-xl dark:bg-amber-500/5">
                    </div>
                    <div
                        class="absolute -bottom-10 left-6 h-24 w-24 rounded-full bg-amber-200/40 blur-2xl dark:bg-amber-500/10">
                    </div>
                </div>

                {{-- الأفاتار --}}
                <div class="inline-flex items-center justify-center rounded-full ring-1 overflow-hidden shadow-md w-24 h-24 sm:w-28 sm:h-28 relative z-10"
                    style="border-color: {{ $palette['base'] }}; background: #fff7ec;">
                    <img src="{{ $avatar }}" alt="avatar" class="w-full h-full object-cover" />
                </div>

                {{-- نشط / موقوف --}}
                <div class="mt-3 relative z-10">
                    @if ($user->is_active)
                        <span
                            class="inline-flex items-center gap-1 rounded-full bg-emerald-500/90 dark:bg-emerald-600 text-white px-3 py-1 text-xs sm:text-[0.8rem] shadow-sm shadow-emerald-300/60">
                            نشط
                            <x-filament::icon icon="heroicon-m-check-badge" class="w-4 h-4" />
                        </span>
                    @else
                        <span
                            class="inline-flex items-center gap-1 rounded-full bg-rose-500/90 dark:bg-rose-600 text-white px-3 py-1 text-xs sm:text-[0.8rem] shadow-sm shadow-rose-300/60">
                            موقوف
                            <x-filament::icon icon="heroicon-m-no-symbol" class="w-4 h-4" />
                        </span>
                    @endif
                </div>

                {{-- الاسم --}}
                <h2
                    class="mt-3 text-xl sm:text-2xl font-semibold leading-tight text-slate-900 dark:text-slate-100 truncate max-w-[14rem] relative z-10">
                    {{ $user->name }}
                </h2>

                {{-- معلومات سريعة --}}
                <div class="mt-3 space-y-1.5 text-xs sm:text-sm text-slate-700 dark:text-slate-300 relative z-10">
                    <div class="flex flex-col gap-1">
                        <span class="inline-flex items-center justify-center gap-1">
                            <x-filament::icon icon="heroicon-m-user-circle"
                                class="w-4 h-4 text-amber-600 dark:text-amber-400" />
                            <span class="font-medium dark:text-slate-200">
                                {{ __("roles.$roleNames") }}
                            </span>
                        </span>

                        <span class="inline-flex items-center justify-center gap-1">
                            <x-filament::icon icon="heroicon-m-building-office-2"
                                class="w-4 h-4 text-amber-600 dark:text-amber-400" />
                            <span class="dark:text-slate-200">{{ $branch }}</span>
                        </span>
                    </div>

                    <div class="flex flex-col gap-1 mt-2">
                        <span class="inline-flex items-center justify-center gap-1">
                            <x-filament::icon icon="heroicon-m-at-symbol"
                                class="w-4 h-4 text-slate-500 dark:text-slate-400" />
                            <span class="text-slate-900 dark:text-slate-100">
                                {{ $username }}
                            </span>
                        </span>

                        <span class="inline-flex items-center justify-center gap-1">
                            <x-filament::icon icon="heroicon-m-envelope"
                                class="w-4 h-4 text-slate-500 dark:text-slate-400" />
                            <span class="dark:text-slate-200">{{ $email }}</span>
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    const arabicLocale = {
        weekdays: {
            shorthand: ["أحد", "إثنين", "ثلاثاء", "أربعاء", "خميس", "جمعة", "سبت"],
            longhand: ["الأحد", "الإثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"],
        },
        months: {
            shorthand: ["1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"],
            longhand: ["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر",
                "نوفمبر", "ديسمبر"
            ],
        },
        firstDayOfWeek: 6,
        rangeSeparator: " إلى ",
    };

    document.addEventListener("DOMContentLoaded", function() {
        const fromPicker = flatpickr("#stats_from_picker", {
            locale: arabicLocale,
            dateFormat: "Y-m-d",
            altInput: true,
            altFormat: "Y/m/d",
            allowInput: false,
            onChange: function(selectedDates, dateStr) {
                if (toPicker) {
                    toPicker.set("minDate", dateStr);
                }
            },
        });

        const toPicker = flatpickr("#stats_to_picker", {
            locale: arabicLocale,
            dateFormat: "Y-m-d",
            altInput: true,
            altFormat: "Y/m/d",
            allowInput: false,
            minDate: document.querySelector("#stats_from_picker")?.value || null,
        });
    });
</script>
