{{-- resources/views/filament/suppliers/view.blade.php --}}
<x-filament-panels::page>
    @php
        /** @var \App\Models\Supplier $supplier */
        $invoiceStats = $invoiceStats ?? null;
        $paymentStats = $paymentStats ?? null;
        $returnsStats = $returnsStats ?? null;
        $ledgerStats = $ledgerStats ?? null;
        $returnsSummary = $returnsSummary ?? null;
        $lastPayment = $lastPayment ?? null;

        // دالة تنسيق الأرقام (مبالغ صحيحة مع فواصل)
        $nf = fn($value) => number_format((int) ($value ?? 0));

        // ========== رصيد المورد من دفتر المورد ==========
        $balance = (int) ($ledgerStats->balance ?? 0);

        $balanceColor =
            $balance > 0
                ? 'text-emerald-600 dark:text-emerald-400'
                : ($balance < 0
                    ? 'text-rose-600 dark:text-rose-400'
                    : 'text-slate-700 dark:text-slate-300');

        $balanceLabel = $balance > 0 ? 'لصالحنا' : ($balance < 0 ? 'لصالح الجهة' : 'مصفّى');

        $debits = (int) ($ledgerStats->debits ?? 0);
        $credits = (int) ($ledgerStats->credits ?? 0);

        // لون الشريط العلوي لكرت الرصيد
        $balanceStripClass = $balance > 0 ? 'bg-emerald-400' : ($balance < 0 ? 'bg-rose-400' : 'bg-slate-400');

        // ========== المشتريات ==========
        $invoicesCount = (int) ($invoiceStats->invoices_count ?? 0);
        $totalPurchases = (int) ($invoiceStats->total ?? 0);
        $totalPaidInvoices = (int) ($invoiceStats->paid ?? 0);
        $totalDueInvoices = (int) ($invoiceStats->due ?? 0);

        $paidPercentage = $totalPurchases > 0 ? ($totalPaidInvoices / $totalPurchases) * 100 : 0;
        $paidPercentage = (float) number_format($paidPercentage, 1, '.', '');
        $duePercentage = max(0, 100 - $paidPercentage);

        // ========== المدفوعات ==========
        $paymentsCount = (int) ($paymentStats->payments_count ?? 0);
        $totalPayments = (int) ($paymentStats->total_paid ?? 0);
        $avgPayment = $paymentsCount > 0 ? (int) floor($totalPayments / $paymentsCount) : 0;

        // ========== المرتجعات ==========
        $returnsCount = (int) ($returnsSummary['count'] ?? ($returnsStats->returns_count ?? 0));
        $returnsTotal = (int) ($returnsSummary['total'] ?? ($returnsStats->total_returns ?? 0));
        $returnsAvg =
            (int) ($returnsSummary['avg'] ?? ($returnsCount > 0 ? (int) floor($returnsTotal / $returnsCount) : 0));

        $returnsPercentage = $totalPurchases > 0 ? ($returnsTotal / $totalPurchases) * 100 : 0;
        $returnsPercentage = (float) number_format($returnsPercentage, 1, '.', '');
        $returnsPercentageBar = min(100, $returnsPercentage);
    @endphp

    <style>
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(10px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .animate-fade-in-up {
            animation: fadeInUp 0.35s ease-out forwards;
        }

        .stat-card {
            transition: all 0.25s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .stat-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 18px 40px rgba(15, 23, 42, 0.1);
        }
    </style>

    <div dir="rtl" class="space-y-5">

        {{-- رأس الصفحة --}}
        <div class="animate-fade-in-up" style="opacity: 0">
            <div
                class="overflow-hidden rounded-2xl border border-slate-200/80 bg-white shadow-sm
                       dark:border-slate-700/80 dark:bg-slate-900">

                <div class="p-5">
                    <div class="flex flex-col gap-4 lg:flex-row lg:items-center lg:justify-between">

                        {{-- بيانات الجهة --}}
                        <div class="flex items-start gap-4">
                            <div
                                class="flex h-14 w-14 items-center justify-center rounded-2xl bg-slate-800 text-white shadow-md
                                       dark:bg-slate-700">
                                <x-heroicon-o-user class="h-7 w-7" />
                            </div>

                            <div class="space-y-2">
                                <div class="flex flex-wrap items-center gap-2.5">
                                    <h1 class="text-2xl font-bold text-slate-900 dark:text-white">
                                        {{ $supplier->name }}
                                    </h1>

                                    <span
                                        class="inline-flex items-center gap-1.5 rounded-full bg-emerald-100 px-2.5 py-1 text-[11px] font-semibold text-emerald-700
                                               dark:bg-emerald-900/40 dark:text-emerald-300">
                                        <span class="h-1.5 w-1.5 rounded-full bg-emerald-500 animate-pulse"></span>
                                        نشط
                                    </span>
                                </div>

                                <div
                                    class="flex flex-wrap items-center gap-3 text-xs text-slate-600 dark:text-slate-300">
                                    @if ($supplier->company)
                                        <div class="flex items-center gap-1.5">
                                            <x-heroicon-o-building-office class="h-4 w-4 text-slate-400" />
                                            <span class="font-medium">{{ $supplier->company }}</span>
                                        </div>
                                    @endif

                                    @if ($supplier->phone)
                                        <div class="flex items-center gap-1.5">
                                            <x-heroicon-o-device-phone-mobile class="h-4 w-4 text-slate-400" />
                                            <span class="font-medium">{{ $supplier->phone }}</span>
                                        </div>
                                    @endif

                                    @if ($supplier->address)
                                        <div class="flex items-center gap-1.5">
                                            <x-heroicon-o-map-pin class="h-4 w-4 text-slate-400" />
                                            <span class="font-medium">{{ $supplier->address }}</span>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>

                        {{-- شرائح سريعة أعلى الصفحة --}}
                        <div class="flex flex-wrap gap-2 text-xs">
                            <div
                                class="flex items-center gap-2 rounded-2xl border border-slate-200 bg-slate-50 px-3 py-2
                                       dark:border-slate-700 dark:bg-slate-800/70">
                                <span class="text-[11px] text-slate-500 dark:text-slate-300">
                                    إجمالي المشتريات
                                </span>
                                <span class="text-sm font-bold text-slate-900 dark:text-white">
                                    {{ $nf($totalPurchases) }}
                                    <span class="text-[10px] text-slate-500">د.ع</span>
                                </span>
                            </div>

                            <div
                                class="flex items-center gap-2 rounded-2xl border border-emerald-200 bg-emerald-50 px-3 py-2
                                       dark:border-emerald-800 dark:bg-emerald-900/40">
                                <span class="text-[11px] text-emerald-700 dark:text-emerald-200">
                                    إجمالي المدفوع
                                </span>
                                <span class="text-sm font-bold text-emerald-700 dark:text-emerald-300">
                                    {{ $nf($totalPayments) }}
                                    <span class="text-[10px] text-emerald-900/70 dark:text-emerald-200">د.ع</span>
                                </span>
                            </div>

                            <div
                                class="flex items-center gap-2 rounded-2xl border border-amber-200 bg-amber-50 px-3 py-2
                                       dark:border-amber-800 dark:bg-amber-900/40">
                                <span class="text-[11px] text-amber-700 dark:text-amber-200">
                                    صافي الدين (متبقّي)
                                </span>
                                <span class="text-sm font-bold text-amber-700 dark:text-amber-300">
                                    {{ $nf($totalDueInvoices) }}
                                    <span class="text-[10px] text-amber-900/70 dark:text-amber-200">د.ع</span>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- كروت الإحصائيات الرئيسية (٤ كروت) --}}
        <div class="grid gap-4 lg:grid-cols-4">

            {{-- بطاقة المشتريات --}}
            <div class="animate-fade-in-up h-full" style="animation-delay: .05s; opacity: 0">
                <div
                    class="stat-card relative flex h-full flex-col overflow-hidden rounded-2xl border border-slate-200 bg-white shadow-sm
                           dark:border-slate-700 dark:bg-slate-900">

                    {{-- شريط علوي ملوّن --}}
                    <div
                        class="h-1 w-full bg-gradient-to-l from-emerald-500 to-emerald-400 dark:from-emerald-500 dark:to-emerald-400">
                    </div>

                    <div class="flex h-full flex-col p-5">
                        {{-- الهيدر --}}
                        <div class="mb-4 flex items-center justify-between">
                            <div class="flex items-center gap-3">
                                <div
                                    class="flex h-10 w-10 items-center justify-center rounded-xl bg-emerald-100 text-emerald-700
                                           dark:bg-emerald-900/40 dark:text-emerald-300">
                                    <x-heroicon-o-shopping-bag class="h-5 w-5" />
                                </div>
                                <div>
                                    <p class="text-xs font-semibold text-emerald-700 dark:text-emerald-300">
                                        المشتريات
                                    </p>
                                    <p class="text-[11px] text-slate-500 dark:text-slate-400">
                                        فواتير الشراء الخاصة بالجهة.
                                    </p>
                                </div>
                            </div>

                            <div
                                class="rounded-full bg-slate-50 px-3 py-1 text-[10px] font-semibold text-slate-600
                                       dark:bg-slate-800 dark:text-slate-200">
                                عدد الفواتير:
                                <span class="font-bold text-slate-900 dark:text-white">
                                    {{ $invoicesCount }}
                                </span>
                            </div>
                        </div>

                        {{-- الرقم الرئيسي --}}
                        <div class="mb-3 text-center">
                            <p class="text-[11px] text-slate-500 dark:text-slate-400">
                                إجمالي قيمة فواتير المشتريات.
                            </p>
                            <div class="mt-1 flex items-baseline justify-center gap-1.5">
                                <span
                                    class="js-counter text-3xl font-extrabold tracking-wide text-slate-900 dark:text-white"
                                    data-target="{{ $totalPurchases }}">
                                    0
                                </span>
                                <span class="text-xs font-semibold text-slate-500 dark:text-slate-400">
                                    د.ع
                                </span>
                            </div>
                        </div>

                        {{-- مدفوع / متبقي --}}
                        <div class="mb-4 flex gap-3 text-xs">
                            <div
                                class="flex flex-1 items-center justify-between rounded-2xl bg-emerald-50 px-3 py-2.5
                                       dark:bg-emerald-900/20">
                                <span class="text-[11px] font-medium text-slate-600 dark:text-slate-200">
                                    مدفوع
                                </span>
                                <span class="font-bold text-emerald-700 dark:text-emerald-300">
                                    <span class="js-counter" data-target="{{ $totalPaidInvoices }}">0</span>
                                    <span class="text-[10px]">د.ع</span>
                                </span>
                            </div>

                            <div
                                class="flex flex-1 items-center justify-between rounded-2xl bg-amber-50 px-3 py-2.5
                                       dark:bg-amber-900/20">
                                <span class="text-[11px] font-medium text-slate-600 dark:text-slate-200">
                                    متبقّي (دين)
                                </span>
                                <span class="font-bold text-amber-700 dark:text-amber-300">
                                    <span class="js-counter" data-target="{{ $totalDueInvoices }}">0</span>
                                    <span class="text-[10px]">د.ع</span>
                                </span>
                            </div>
                        </div>

                        {{-- شريط نسبة الدفع متعدد الألوان --}}
                        <div class="mt-auto pt-2 text-[11px]">
                            <div class="mb-1 flex items-center justify-between">
                                <span class="text-slate-600 dark:text-slate-300">
                                    نسبة الدفع
                                </span>
                                <span class="font-semibold text-emerald-700 dark:text-emerald-300">
                                    <span class="js-counter" data-target="{{ $paidPercentage }}"
                                        data-decimals="1">0</span>%
                                </span>
                            </div>

                            <div class="h-1.5 w-full overflow-hidden rounded-full bg-slate-100 dark:bg-slate-800">
                                <div class="flex h-full w-full">
                                    <div class="h-full rounded-r-full bg-emerald-500"
                                        style="width: {{ $paidPercentage }}%"></div>
                                    <div class="h-full rounded-l-full bg-amber-400"
                                        style="width: {{ $duePercentage }}%"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- بطاقة المدفوعات --}}
            <div class="animate-fade-in-up h-full" style="animation-delay: .1s; opacity: 0">
                <div
                    class="stat-card relative flex h-full flex-col overflow-hidden rounded-2xl border border-slate-200 bg-white shadow-sm
                           dark:border-slate-700 dark:bg-slate-900">

                    <div
                        class="h-1 w-full bg-gradient-to-l from-indigo-500 to-indigo-400 dark:from-indigo-500 dark:to-indigo-400">
                    </div>

                    <div class="flex h-full flex-col p-5">
                        <div class="mb-4 flex items-center justify-between">
                            <div class="flex items-center gap-3">
                                <div
                                    class="flex h-10 w-10 items-center justify-center rounded-xl bg-indigo-100 text-indigo-700
                                           dark:bg-indigo-900/30 dark:text-indigo-300">
                                    <x-heroicon-o-credit-card class="h-5 w-5" />
                                </div>
                                <div>
                                    <p class="text-xs font-semibold text-indigo-700 dark:text-indigo-300">
                                        المدفوعات
                                    </p>
                                    <p class="text-[11px] text-slate-500 dark:text-slate-400">
                                        الدفعات النقدية أو التحويلات.
                                    </p>
                                </div>
                            </div>

                            <div
                                class="rounded-full bg-slate-50 px-3 py-1 text-[10px] font-semibold text-slate-600
                                       dark:bg-slate-800 dark:text-slate-200">
                                عدد الدفعات:
                                <span class="font-bold text-slate-900 dark:text-white">
                                    {{ $paymentsCount }}
                                </span>
                            </div>
                        </div>

                        {{-- إجمالي المدفوعات --}}
                        <div class="mb-3 text-center">
                            <p class="text-[11px] text-slate-500 dark:text-slate-400">
                                إجمالي المبالغ المدفوعة لهذه الجهة.
                            </p>
                            <div class="mt-1 flex items-baseline justify-center gap-1.5">
                                <span
                                    class="js-counter text-3xl font-extrabold tracking-wide text-slate-900 dark:text-white"
                                    data-target="{{ $totalPayments }}">
                                    0
                                </span>
                                <span class="text-xs font-semibold text-slate-500 dark:text-slate-400">
                                    د.ع
                                </span>
                            </div>
                        </div>

                        {{-- متوسط الدفعة --}}
                        <div class="mb-4 rounded-2xl bg-slate-50 px-3 py-2.5 text-xs dark:bg-slate-800/60">
                            <div class="flex items-center justify-between gap-2">
                                <span class="text-slate-600 dark:text-slate-200">
                                    متوسط الدفعة الواحدة
                                </span>
                                <span class="font-bold text-indigo-700 dark:text-indigo-300">
                                    <span class="js-counter" data-target="{{ $avgPayment }}">0</span>
                                    <span class="text-[10px]">د.ع</span>
                                </span>
                            </div>
                        </div>

                        {{-- آخر دفعة --}}
                        <div
                            class="mt-auto border-t border-slate-100 pt-3 text-[11px] text-slate-500 dark:border-slate-800 dark:text-slate-400">
                            @if ($lastPayment ?? null)
                                @php
                                    /** @var \App\Models\SupplierPayment $lastPayment */
                                    $lastPaymentDate = $lastPayment->payment_date?->format('Y-m-d');
                                    $lastPaymentAmount = (int) $lastPayment->amount;
                                    $lastPaymentMethod = $lastPayment->payment_method ?: null;
                                @endphp

                                <div class="flex flex-wrap items-center justify-between gap-2">
                                    <div class="flex items-center gap-1.5">
                                        <span>آخر دفعة:</span>
                                        <span class="font-semibold text-slate-800 dark:text-slate-100">
                                            {{ $lastPaymentDate }}
                                        </span>
                                    </div>

                                    <div class="flex flex-wrap items-center gap-2">
                                        <span class="font-semibold text-indigo-700 dark:text-indigo-300">
                                            {{ $nf($lastPaymentAmount) }} د.ع
                                        </span>

                                        @if ($lastPaymentMethod)
                                            <span class="text-slate-400">|</span>
                                            <span class="text-[11px] text-slate-500 dark:text-slate-400">
                                                طريقة الدفع:
                                                <span class="font-medium">
                                                    {{ $lastPaymentMethod }}
                                                </span>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            @else
                                لا توجد دفعات مسجلة حتى الآن.
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            {{-- بطاقة المرتجعات --}}
            <div class="animate-fade-in-up h-full" style="animation-delay: .15s; opacity: 0">
                <div
                    class="stat-card relative flex h-full flex-col overflow-hidden rounded-2xl border border-slate-200 bg-white shadow-sm
                           dark:border-slate-700 dark:bg-slate-900">

                    <div
                        class="h-1 w-full bg-gradient-to-l from-amber-500 to-amber-400 dark:from-amber-500 dark:to-amber-400">
                    </div>

                    <div class="flex h-full flex-col p-5">
                        <div class="mb-4 flex items-center justify-between">
                            <div class="flex items-center gap-3">
                                <div
                                    class="flex h-10 w-10 items-center justify-center rounded-xl bg-amber-100 text-amber-700
                                           dark:bg-amber-900/30 dark:text-amber-300">
                                    <x-heroicon-o-arrow-uturn-left class="h-5 w-5" />
                                </div>
                                <div>
                                    <p class="text-xs font-semibold text-amber-700 dark:text-amber-300">
                                        المرتجعات
                                    </p>
                                    <p class="text-[11px] text-slate-500 dark:text-slate-400">
                                        فواتير المرتجعات مع نظرة على حجمها.
                                    </p>
                                </div>
                            </div>

                            <div
                                class="rounded-full bg-slate-50 px-3 py-1 text-[10px] font-semibold text-slate-600
                                       dark:bg-slate-800 dark:text-slate-200">
                                عدد المرتجعات:
                                <span class="font-bold text-slate-900 dark:text-white">
                                    {{ $returnsCount }}
                                </span>
                            </div>
                        </div>

                        {{-- إجمالي المرتجعات --}}
                        <div class="mb-3 text-center">
                            <p class="text-[11px] text-slate-500 dark:text-slate-400">
                                إجمالي قيمة فواتير المرتجعات.
                            </p>
                            <div class="mt-1 flex items-baseline justify-center gap-1.5">
                                <span
                                    class="js-counter text-3xl font-extrabold tracking-wide text-slate-900 dark:text-white"
                                    data-target="{{ $returnsTotal }}">
                                    0
                                </span>
                                <span class="text-xs font-semibold text-slate-500 dark:text-slate-400">
                                    د.ع
                                </span>
                            </div>
                        </div>

                        {{-- عدد الفواتير + متوسط القيمة --}}
                        <div class="mb-4 flex gap-3 text-xs">
                            <div
                                class="flex flex-1 flex-col justify-between rounded-2xl bg-slate-50 px-3 py-2.5
                                       dark:bg-slate-800/60">
                                <span class="text-[11px] font-medium text-slate-600 dark:text-slate-200">
                                    عدد فواتير المرتجعات
                                </span>
                                <span class="mt-1 text-sm font-bold text-slate-900 dark:text-white">
                                    {{ $returnsCount }}
                                </span>
                            </div>

                            <div
                                class="flex flex-1 flex-col justify-between rounded-2xl bg-slate-50 px-3 py-2.5
                                       dark:bg-slate-800/60">
                                <span class="text-[11px] font-medium text-slate-600 dark:text-slate-200">
                                    متوسط قيمة الفاتورة
                                </span>
                                <span class="mt-1 text-sm font-bold text-amber-700 dark:text-amber-300">
                                    <span class="js-counter" data-target="{{ $returnsAvg }}">0</span>
                                    <span class="text-[10px]">د.ع</span>
                                </span>
                            </div>
                        </div>

                        {{-- نسبة المرتجعات من إجمالي المشتريات --}}
                        <div class="mt-auto pt-1 text-[11px]">
                            <div class="mb-1 flex items-center justify-between">
                                <span class="text-slate-600 dark:text-slate-300">
                                    نسبة المرتجعات من إجمالي المشتريات
                                </span>
                                <span class="font-semibold text-amber-700 dark:text-amber-300">
                                    <span class="js-counter" data-target="{{ $returnsPercentage }}"
                                        data-decimals="1">0</span>%
                                </span>
                            </div>

                            <div class="h-1.5 w-full overflow-hidden rounded-full bg-slate-100 dark:bg-slate-800">
                                <div class="h-full rounded-full bg-amber-400"
                                    style="width: {{ $returnsPercentageBar }}%"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- بطاقة الرصيد --}}
            <div class="animate-fade-in-up h-full" style="animation-delay: .2s; opacity: 0">
                <div
                    class="stat-card relative flex h-full flex-col overflow-hidden rounded-2xl border border-slate-200 bg-white shadow-sm
                           dark:border-slate-700 dark:bg-slate-900">

                    <div class="h-1 w-full {{ $balanceStripClass }}"></div>

                    <div class="flex h-full flex-col p-5">
                        <div class="mb-4 flex items-center justify-between">
                            <div class="flex items-center gap-3">
                                <div
                                    class="flex h-10 w-10 items-center justify-center rounded-xl bg-slate-100 text-slate-700
                                           dark:bg-slate-800 dark:text-slate-100">
                                    <x-heroicon-o-scale class="h-5 w-5" />
                                </div>
                                <div>
                                    <p class="text-xs font-semibold text-slate-800 dark:text-slate-100">
                                        رصيد الحساب
                                    </p>
                                    <p class="text-[11px] text-slate-500 dark:text-slate-400">
                                        صافي المديونية بيننا وبين الجهة.
                                    </p>
                                </div>
                            </div>

                            <span
                                class="rounded-full px-3 py-1 text-[10px] font-semibold
                                @if ($balance > 0) bg-emerald-50 text-emerald-700 dark:bg-emerald-900/30 dark:text-emerald-300
                                @elseif($balance < 0)
                                    bg-rose-50 text-rose-700 dark:bg-rose-900/30 dark:text-rose-300
                                @else
                                    bg-slate-50 text-slate-700 dark:bg-slate-800 dark:text-slate-200 @endif
                            ">
                                {{ $balanceLabel }}
                            </span>
                        </div>

                        {{-- قيمة الرصيد --}}
                        <div class="mb-4 text-center">
                            <p class="text-[11px] text-slate-500 dark:text-slate-400">
                                الرصيد الحالي في دفتر المورد.
                            </p>
                            <div class="mt-1 flex items-baseline justify-center gap-1.5">
                                <span class="js-counter text-3xl font-extrabold {{ $balanceColor }}"
                                    data-target="{{ abs($balance) }}">0</span>
                                <span class="text-xs font-semibold text-slate-500 dark:text-slate-400">د.ع</span>
                            </div>
                        </div>

                        {{-- مدين / دائن تفصيلي --}}
                        <div class="mb-4 grid grid-cols-2 gap-3 text-xs">
                            <div class="rounded-2xl bg-emerald-50 px-3 py-2.5 dark:bg-emerald-900/20">
                                <p class="mb-1 text-[10px] font-semibold text-emerald-700 dark:text-emerald-300">
                                    مجموع المدين
                                </p>
                                <p class="text-sm font-bold text-emerald-700 dark:text-emerald-300">
                                    <span class="js-counter" data-target="{{ $debits }}">0</span>
                                    <span class="text-[10px]">د.ع</span>
                                </p>
                            </div>
                            <div class="rounded-2xl bg-rose-50 px-3 py-2.5 dark:bg-rose-900/20">
                                <p class="mb-1 text-[10px] font-semibold text-rose-700 dark:text-rose-300">
                                    مجموع الدائن
                                </p>
                                <p class="text-sm font-bold text-rose-700 dark:text-rose-300">
                                    <span class="js-counter" data-target="{{ abs($credits) }}">0</span>
                                    <span class="text-[10px]">د.ع</span>
                                </p>
                            </div>
                        </div>

                        {{-- ملاحظة بسيطة أسفل الكرت --}}
                        <p class="mt-auto text-[11px] text-slate-500 dark:text-slate-400">
                            الرصيد الإيجابي يعني أنه <span class="font-semibold">لصالحنا</span>،
                            والرصيد السالب يعني أنه <span class="font-semibold">لصالح الجهة</span>.
                        </p>
                    </div>
                </div>
            </div>
        </div>

        {{-- المحتوى الافتراضي (جداول / تبويبات Filament) --}}
        <div class="animate-fade-in-up" style="animation-delay: .25s; opacity: 0">
            <div
                class="overflow-hidden rounded-2xl border border-slate-200/80 bg-white shadow-sm
                       dark:border-slate-700/80 dark:bg-slate-950">
                <div class="p-5">
                    {{ $this->content }}
                </div>
            </div>
        </div>
    </div>

    {{-- سكربت تحريك الأرقام --}}
    <script>
        (function() {
            const formatter = new Intl.NumberFormat('en-US');

            function animateCounters() {
                document.querySelectorAll('.js-counter').forEach((el) => {
                    if (el.dataset.animated === '1') {
                        return;
                    }

                    const decimals = parseInt(el.dataset.decimals || '0', 10);
                    const targetRaw = parseFloat(el.dataset.target || '0');
                    const target = isNaN(targetRaw) ? 0 : targetRaw;

                    const duration = 800;
                    const start = performance.now();

                    function frame(now) {
                        const progress = Math.min((now - start) / duration, 1);
                        const easeProgress = 1 - Math.pow(1 - progress, 3); // ease-out cubic
                        let value = target * easeProgress;

                        if (decimals === 0) {
                            value = Math.round(value);
                            el.textContent = formatter.format(value);
                        } else {
                            value = parseFloat(value.toFixed(decimals));
                            el.textContent = value.toFixed(decimals);
                        }

                        if (progress < 1) {
                            requestAnimationFrame(frame);
                        } else {
                            if (decimals === 0) {
                                el.textContent = formatter.format(Math.round(target));
                            } else {
                                el.textContent = target.toFixed(decimals);
                            }
                            el.dataset.animated = '1';
                        }
                    }

                    requestAnimationFrame(frame);
                });
            }

            document.addEventListener('DOMContentLoaded', animateCounters);
            window.addEventListener('livewire:navigated', animateCounters);
        })();
    </script>
</x-filament-panels::page>
