@php
    $logoLight = $settings?->logo_light_url;
    $branchName = $branch?->name ?? '—';
    $address = (string) ($settings?->address ?? '—');

    $invoiceNumber = $record->invoice_number ?? '—';
    $invoiceDate = $record->invoice_date
        ? \Illuminate\Support\Carbon::parse($record->invoice_date)->format('Y-m-d')
        : '—';

    $clientName = $record->client->name ?? '—';
    $clientPhone = $record->client->phone ?? '—';
    $clientAddress = $record->client->address ?? '—';

    // items (products فقط)
    $itemsCollection = method_exists($record, 'items')
        ? $record->items
        : (method_exists($record, 'invoiceItems')
            ? $record->invoiceItems
            : collect());

    $itemsCollection = $itemsCollection
        ->filter(function ($it) {
            $t = (string) ($it->item_type ?? '');
            return $t === \App\Models\InvoiceItem::TYPE_PRODUCT || $t === 'product';
        })
        ->values();

    $maxItemsPerPage = 10;
    $pages = $itemsCollection->chunk($maxItemsPerPage);
    $totalPages = max(1, $pages->count());
    $showPageNumbers = $itemsCollection->count() > $maxItemsPerPage;

    // totals (أعداد صحيحة فقط)
    $subtotal = (int) ($record->subtotal ?? 0);
    $discount = (int) ($record->discount_total ?? 0);
    $shipping = (int) ($record->shipping_total ?? 0);
    $grandTotal = (int) ($record->grand_total ?? max($subtotal - $discount + $shipping, 0));
    $paid = (int) ($record->paid_amount ?? ($record->paid_total ?? 0));
    $remaining = (int) ($record->due_amount ?? max($grandTotal - $paid, 0));
    $clientDebts = (int) ($record->client?->total_debt ?? 0);

    // design shortcuts
    $h = (array) data_get($design, 'header', []);
    $cl = (array) data_get($design, 'client', []);
    $tb = (array) data_get($design, 'table', []);
    $tt = (array) data_get($design, 'totals', []);
    $nt = (array) data_get($design, 'notes', []);
    $sg = (array) data_get($design, 'signatures', []);

    $logo = (array) data_get($h, 'logo', []);
    $logoBorder = (array) data_get($logo, 'border', []);

    $currencyText = (string) data_get($tt, 'currency.text', 'د.ع');
    $currencyShow = (bool) data_get($tt, 'currency.show', true);

    $pageIndex = 0;

    /* =========================
     | محاذاة النصوص من الإعدادات
     | invoice_design.align.*
     ========================= */
    $align = (array) data_get($design, 'align', []);

    $alignGet = function (string $key, string $fallback = 'right') use ($align): string {
        $v = (string) data_get($align, $key, $fallback);
        return in_array($v, ['right', 'center', 'left'], true) ? $v : $fallback;
    };

    $cssAlign = function (string $key, string $fallback = 'right') use ($alignGet): string {
        return match ($alignGet($key, $fallback)) {
            'left' => 'left',
            'center' => 'center',
            default => 'right',
        };
    };

    /* =========================
     | ✅ توزيع عناصر الهيدر (header.slots)
     | invoice_design.header.slots.{right|center|left}
     ========================= */
    $slots = (array) data_get($design, 'header.slots', []);

    $slotMap = function (array $rows): array {
        $out = [];
        foreach ($rows as $row) {
            if (is_array($row) && isset($row['key'])) {
                $out[] = (string) $row['key']; // توافق قديم
            } elseif (is_string($row)) {
                $out[] = $row; // Multi Select
            }
        }
        $out = array_map(fn($v) => trim((string) $v), $out);
        $out = array_values(array_filter($out, fn($v) => $v !== ''));
        $out = array_values(array_unique($out));
        return $out;
    };

    $rightSlots = $slotMap((array) ($slots['right'] ?? ['logo', 'branch_name', 'branch_meta']));
    $centerSlots = $slotMap((array) ($slots['center'] ?? []));
    $leftSlots = $slotMap((array) ($slots['left'] ?? ['invoice_title', 'invoice_number', 'invoice_date']));

    // ✅ توحيد + منع تكرار "المفاتيح" بين الأعمدة (الأولوية: يمين ثم وسط ثم يسار)
    $seen = [];
    $filterKeepFirst = function (array $arr) use (&$seen): array {
        $out = [];
        foreach ($arr as $k) {
            if (isset($seen[$k])) {
                continue;
            }
            $seen[$k] = true;
            $out[] = $k;
        }
        return $out;
    };
    $rightSlots = $filterKeepFirst($rightSlots);
    $centerSlots = $filterKeepFirst($centerSlots);
    $leftSlots = $filterKeepFirst($leftSlots);

    // ✅ منع تكرار "المعنى": إذا pills موجود => لا تعرض invoice_number / invoice_date أبداً
    $allSlots = array_merge($rightSlots, $centerSlots, $leftSlots);
    if (in_array('pills', $allSlots, true)) {
        $rightSlots = array_values(array_diff($rightSlots, ['invoice_number', 'invoice_date']));
        $centerSlots = array_values(array_diff($centerSlots, ['invoice_number', 'invoice_date']));
        $leftSlots = array_values(array_diff($leftSlots, ['invoice_number', 'invoice_date']));
    }

    // تنسيق أرقام (أعداد صحيحة فقط)
    $nf = static fn($v): string => number_format((int) ($v ?? 0), 0, '.', ',');
@endphp

<style>
    @import url('https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700;800;900&display=swap');

    :root {
        --primary: {{ $vars['--primary'] }};
        --primary-400: {{ $vars['--primary-400'] }};
        --primary-700: {{ $vars['--primary-700'] }};
        --text: {{ $vars['--text'] }};
        --text-muted: {{ $vars['--text-muted'] }};
        --surface: {{ $vars['--surface'] }};
        --surface-field: {{ $vars['--surface-field'] }};
        --border: {{ $vars['--border'] }};
    }

    * {
        box-sizing: border-box
    }

    html,
    body {
        margin: 0;
        padding: 0;
        direction: rtl;
        font-family: 'Tajawal', system-ui, -apple-system, 'Segoe UI', sans-serif;
        color: var(--text);
        -webkit-print-color-adjust: exact;
        print-color-adjust: exact;
    }

    .fi-page-main {
        background: transparent
    }

    .invoice-root {
        max-width: 210mm;
        margin: 6mm auto 10mm
    }

    .sheet {
        width: 210mm;
        min-height: 297mm;
        background: var(--surface);
        border: 1px solid rgba(15, 23, 42, .08);
        border-radius: 16px;
        overflow: hidden;
        position: relative;
        box-shadow: 0 16px 40px rgba(15, 23, 42, .10);
        page-break-after: always;
    }

    .sheet:last-of-type {
        page-break-after: auto
    }

    .sheet::before {
        content: "";
        position: absolute;
        inset-inline-start: 0;
        top: 0;
        width: 10mm;
        height: 100%;
        background: linear-gradient(180deg, var(--primary-700), var(--primary-400));
    }

    .content {
        padding: 8mm 12mm 10mm 10mm;
        min-height: 297mm;
        display: flex;
        flex-direction: column;
        gap: 6mm;
        position: relative;
        z-index: 1;
    }

    /* HEADER */
    .header {
        border: 1px solid rgba(17, 24, 39, .08);
        border-radius: 14px;
        overflow: hidden;
        background:
            radial-gradient(800px 200px at 20% 0%, rgba(0, 0, 0, .06), transparent 60%),
            radial-gradient(700px 200px at 80% 0%, rgba(0, 0, 0, .04), transparent 60%),
            #ffffff;
    }

    /* ✅ Grid ثلاث أعمدة: يمين/وسط/يسار */
    .header-inner {
        display: grid;
        grid-template-columns: 1fr 1fr 1fr;
        align-items: start;
        padding: 6mm;
        gap: 6mm;
    }

    .h-col {
        display: flex;
        flex-direction: column;
        gap: 2.5mm;
        min-width: 0;
    }

    .h-col.right {
        align-items: flex-start;
        text-align: right;
    }

    .h-col.center {
        align-items: center;
        text-align: center;
    }

    .h-col.left {
        align-items: flex-end;
        text-align: left;
    }

    .h-item {
        min-width: 0;
    }

    .logo {
        width: {{ (int) data_get($logo, 'size_mm', 26) }}mm;
        height: {{ (int) data_get($logo, 'size_mm', 26) }}mm;
        border-radius: {{ (int) data_get($logo, 'radius_px', 14) }}px;
        background: {{ e((string) data_get($logo, 'bg', '#FFFFFF')) }};
        display: inline-flex;
        align-items: center;
        justify-content: center;
        overflow: hidden;
        box-shadow: 0 10px 20px rgba(15, 23, 42, .08);
        -webkit-print-color-adjust: exact;
        print-color-adjust: exact;

        @if ((bool) data_get($logoBorder, 'enabled', true))
            border: {{ (int) data_get($logoBorder, 'width_px', 2) }}px solid {{ e((string) data_get($logoBorder, 'color', '#E5E7EB')) }};
        @else
            border: none;
        @endif
    }

    .logo img {
        max-width: 80%;
        max-height: 80%;
        object-fit: contain;
        display: block;
    }

    .logo-fallback {
        font-weight: 900;
        font-size: 18px;
        color: var(--primary-700)
    }

    .brand-name {
        font-size: {{ (int) data_get($h, 'branch.name_size_px', 20) }}px;
        font-weight: 900;
        color: var(--primary-700);
        line-height: 1.1;
        text-align: {{ $cssAlign('header.branch', 'right') }};
    }

    .brand-meta {
        margin-top: 1.5mm;
        font-size: {{ (int) data_get($h, 'branch.meta_size_px', 9) }}px;
        color: var(--text-muted);
        display: flex;
        flex-direction: column;
        gap: 1mm;
        text-align: {{ $cssAlign('header.meta', 'right') }};
    }

    .meta-line {
        display: flex;
        align-items: center;
        gap: 2mm;
        min-width: 0
    }

    .dot {
        width: 6px;
        height: 6px;
        border-radius: 999px;
        background: var(--primary-400)
    }

    .ltr {
        direction: ltr;
        unicode-bidi: bidi-override
    }

    .inv-title {
        font-size: {{ (int) data_get($h, 'title.size_px', 22) }}px;
        font-weight: {{ (int) data_get($h, 'title.weight', 900) }};
        color: var(--primary-700);
        text-align: {{ $cssAlign('header.title', 'right') }};
        line-height: 1.15;
    }

    .pill-row {
        display: flex;
        gap: 2mm;
        flex-wrap: wrap;
        justify-content: flex-end;
    }

    .pill {
        display: inline-flex;
        align-items: center;
        gap: 2mm;
        padding: 2.5mm 3.2mm;
        border-radius: 999px;
        background: color-mix(in srgb, var(--primary-400) 10%, #ffffff);
        border: 1px solid color-mix(in srgb, var(--primary-400) 28%, transparent);
        font-size: {{ (int) data_get($h, 'pills.size_px', 10) }}px;
        font-weight: 800;
        color: var(--primary-700);
        white-space: nowrap;
    }

    .pill b {
        background: var(--primary-700);
        color: #fff;
        padding: 1px 8px;
        border-radius: 999px;
        font-size: 9px;
        font-weight: 900;
    }

    /* CLIENT */
    .client-bar {
        border: 1px solid rgba(17, 24, 39, .08);
        border-radius: {{ (int) data_get($cl, 'radius_px', 999) }}px;
        background: {{ e((string) data_get($cl, 'bg', '#E9ECEF')) }};
        padding: 4mm 5mm;
        display: grid;
        grid-template-columns: 1.6fr 1fr 1.5fr;
        gap: 4mm;
        align-items: center;
        font-size: {{ (int) data_get($cl, 'font_px', 10) }}px;
    }

    .client-item {
        display: flex;
        align-items: center;
        gap: 2mm;
        min-width: 0
    }

    .client-item .label {
        font-weight: {{ (int) data_get($cl, 'label_weight', 900) }};
        color: var(--primary-700);
        white-space: nowrap;
        text-align: {{ $cssAlign('client.label', 'right') }};
    }

    .client-item .value {
        font-weight: {{ (int) data_get($cl, 'value_weight', 700) }};
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
        text-align: {{ $cssAlign('client.value', 'right') }};
    }

    /* TABLE */
    .card {
        border: 1px solid rgba(17, 24, 39, .08);
        border-radius: 14px;
        overflow: hidden;
        background: #fff
    }

    table {
        width: 100%;
        border-collapse: collapse
    }

    thead th {
        background: linear-gradient(135deg,
                color-mix(in srgb, var(--primary-400) 12%, #ffffff),
                color-mix(in srgb, var(--primary-700) 8%, #ffffff));
        color: #0f172a;
        font-size: {{ (int) data_get($tb, 'head_font_px', 9) }}px;
        font-weight: 900;
        padding: 3mm 2mm;
        border-bottom: 1px solid rgba(17, 24, 39, .08);
        text-align: {{ $cssAlign('table.head', 'center') }};
    }

    tbody td {
        padding: 2.8mm 2mm;
        font-size: {{ (int) data_get($tb, 'font_px', 9) }}px;
        font-weight: 700;
        border-bottom: 1px dashed rgba(17, 24, 39, .12);
        color: #111827;
        vertical-align: middle;
    }

    @if ((bool) data_get($tb, 'row_alt', true))
        tbody tr:nth-child(even) td {
            background: rgba(246, 247, 249, .7)
        }
    @endif

    .barcode {
        display: inline-block;
        margin-top: 1.5mm;
        padding: 1px 8px;
        border-radius: 999px;
        background: color-mix(in srgb, var(--primary-400) 10%, #ffffff);
        border: 1px solid color-mix(in srgb, var(--primary-400) 25%, transparent);
        color: var(--primary-700);
        font-weight: 900
    }

    tfoot td {
        background: var(--primary-700);
        color: #fff;
        padding: 3.2mm 2mm;
        font-size: 10px;
        font-weight: 900;
        border-top: 1px solid rgba(255, 255, 255, .15);
    }

    .tfoot-label {
        text-align: {{ $cssAlign('totals.label', 'right') }};
    }

    .tfoot-value {
        text-align: {{ $cssAlign('totals.value', 'left') }};
        white-space: nowrap;
    }

    /* BOTTOM GRID */
    .bottom-grid {
        display: grid;
        grid-template-columns: 1.15fr 0.85fr;
        gap: 6mm;
        align-items: stretch
    }

    .summary,
    .note {
        border: 1px solid rgba(17, 24, 39, .08);
        border-radius: 14px;
        background: #fff;
        overflow: hidden
    }

    .box-head {
        padding: 3.5mm 4mm;
        font-size: 11px;
        font-weight: 900;
        color: #0f172a;
        background: linear-gradient(135deg,
                color-mix(in srgb, var(--primary-400) 12%, #ffffff),
                color-mix(in srgb, var(--primary-700) 6%, #ffffff));
        border-bottom: 1px solid rgba(17, 24, 39, .08)
    }

    .summary-body {
        padding: 4mm;
        display: flex;
        flex-direction: column;
        gap: 2.2mm
    }

    .row {
        display: flex;
        align-items: center;
        justify-content: space-between;
        gap: 4mm;
        font-size: 9.5px;
        padding: 2.2mm 0;
        border-bottom: 1px dashed rgba(17, 24, 39, .12)
    }

    .row:last-child {
        border-bottom: none
    }

    .row .k {
        color: var(--text-muted);
        font-weight: 800;
        text-align: {{ $cssAlign('totals.label', 'right') }};
    }

    .row .v {
        font-weight: 900;
        color: #111827;
        white-space: nowrap;
        text-align: {{ $cssAlign('totals.value', 'left') }};
    }

    .row.highlight {
        background: color-mix(in srgb, var(--primary-400) 10%, #ffffff);
        border: 1px solid color-mix(in srgb, var(--primary-400) 22%, transparent);
        border-radius: 12px;
        padding: 2.6mm 3mm;
        margin-top: 1mm
    }

    .row.highlight .k,
    .row.highlight .v {
        color: var(--primary-700)
    }

    .note-body {
        padding: 4mm;
        font-size: 9.2px;
        color: #374151;
        line-height: 1.8;
        font-weight: 700;
        text-align: {{ $cssAlign('notes.text', 'right') }};
    }

    .note-body .hint {
        color: #6b7280;
        font-weight: 700
    }

    .note-list {
        display: flex;
        flex-direction: column;
        gap: 2mm
    }

    .note-item {
        display: flex;
        gap: 2mm;
        align-items: flex-start
    }

    .note-bullet {
        width: 7px;
        height: 7px;
        border-radius: 999px;
        background: var(--primary-400);
        margin-top: 7px;
        flex: 0 0 auto
    }

    /* SIGNATURES */
    .signatures {
        margin-top: auto;
        padding-top: 4mm;
        display: flex;
        justify-content: center;
        gap: 14mm
    }

    .sign {
        min-width: 55mm;
        text-align: {{ $cssAlign('signatures.titles', 'center') }};
    }

    .sign .t {
        font-size: 12px;
        font-weight: 900;
        color: var(--primary-700)
    }

    .sign .line {
        margin-top: 4mm;
        border-top: 1.5px solid rgba(17, 24, 39, .12);
        padding-top: 2mm;
        font-size: 8px;
        color: #4b5563;
        font-weight: 700;
        text-align: {{ $cssAlign('signatures.line', 'center') }};
    }

    .page-number {
        margin-top: 3mm;
        text-align: center;
        font-size: 8px;
        color: #9ca3af
    }

    /* ACTION BUTTONS */
    .action-buttons {
        max-width: 210mm;
        margin: 0 auto 16px;
        display: flex;
        justify-content: center;
        gap: 10px
    }

    .btn {
        appearance: none;
        border-radius: 999px;
        padding: 8px 18px;
        font-size: 13px;
        font-weight: 900;
        cursor: pointer;
        border: 2px solid var(--primary-700);
        display: inline-flex;
        align-items: center;
        gap: 6px;
        text-decoration: none
    }

    .btn.primary {
        background: var(--primary-700);
        color: #fff
    }

    .btn.secondary {
        background: #fff;
        color: var(--primary-700)
    }

    /* PRINT */
    @media print {
        @page {
            size: A4 portrait;
            margin: 0
        }

        html,
        body {
            margin: 0 !important;
            padding: 0 !important;
            width: 210mm !important;
            background: #fff !important
        }

        .fi-sidebar,
        .fi-topbar,
        .fi-header,
        .fi-breadcrumbs,
        .action-buttons {
            display: none !important
        }

        .fi-main,
        .fi-main>div,
        .fi-page,
        .fi-page-main {
            margin: 0 !important;
            padding: 0 !important;
            background: #fff !important;
            box-shadow: none !important
        }

        body * {
            visibility: hidden !important
        }

        .invoice-root,
        .invoice-root * {
            visibility: visible !important
        }

        .invoice-root {
            width: 210mm !important;
            max-width: 210mm !important;
            margin: 0 !important;
            position: absolute;
            top: 0;
            left: 0
        }

        .sheet {
            width: 210mm !important;
            border-radius: 0 !important;
            box-shadow: none !important;
            border: none !important;
            page-break-after: always !important;
            page-break-inside: avoid !important
        }

        .sheet:last-of-type {
            page-break-after: auto !important
        }
    }
</style>

@php
    // ✅ رندر عنصر حسب key
    $renderHeaderItem = function (string $key) use (
        $logoLight,
        $branchName,
        $address,
        $phones,
        $invoiceNumber,
        $invoiceDate,
        $h,
        $logo,
        $cssAlign,
    ): string {
        $key = trim($key);

        if ($key === 'logo') {
            if (!(bool) data_get($logo, 'show', true)) {
                return '';
            }

            $img = $logoLight
                ? '<img src="' . e($logoLight) . '" alt="' . e($branchName) . '">'
                : '<div class="logo-fallback">' . e(mb_substr((string) $branchName, 0, 2)) . '</div>';

            return '<div class="h-item"><div class="logo">' . $img . '</div></div>';
        }

        if ($key === 'branch_name') {
            return '<div class="h-item" style="text-align:' .
                e($cssAlign('header.branch', 'right')) .
                ';">' .
                '<div class="brand-name">' .
                e($branchName) .
                '</div>' .
                '</div>';
        }

        if ($key === 'branch_meta') {
            return '<div class="h-item" style="text-align:' .
                e($cssAlign('header.meta', 'right')) .
                ';">' .
                '<div class="brand-meta">' .
                '<div class="meta-line"><span class="dot"></span><span>' .
                e($address) .
                '</span></div>' .
                '<div class="meta-line"><span class="dot"></span><span class="ltr">' .
                e((string) $phones) .
                '</span></div>' .
                '</div>' .
                '</div>';
        }

        if ($key === 'invoice_title') {
            return '<div class="h-item"><div class="inv-title">' .
                e((string) data_get($h, 'title.text', 'فاتورة مبيعات')) .
                '</div></div>';
        }

        // إذا pills موجود أصلاً، هذني راح ينشالن قبل العرض (بالأعلى)
        if ($key === 'invoice_number') {
            return '<div class="h-item"><div class="pill-row"><div class="pill"><b>رقم</b><span class="ltr">' .
                e((string) $invoiceNumber) .
                '</span></div></div></div>';
        }

        if ($key === 'invoice_date') {
            return '<div class="h-item"><div class="pill-row"><div class="pill"><b>التاريخ</b><span class="ltr">' .
                e((string) $invoiceDate) .
                '</span></div></div></div>';
        }

        if ($key === 'pills') {
            if (!(bool) data_get($h, 'pills.show', true)) {
                return '';
            }

            return '<div class="h-item"><div class="pill-row">' .
                '<div class="pill"><b>رقم</b><span class="ltr">' .
                e((string) $invoiceNumber) .
                '</span></div>' .
                '<div class="pill"><b>التاريخ</b><span class="ltr">' .
                e((string) $invoiceDate) .
                '</span></div>' .
                '</div></div>';
        }

        return '';
    };
@endphp

<div>
    <div class="invoice-root">
        @forelse ($pages as $chunk)
            @php $pageIndex++; @endphp

            <div class="sheet">
                <div class="content">

                    {{-- ✅ HEADER (حسب التوزيع من الفورم) --}}
                    <div class="header">
                        <div class="header-inner">
                            <div class="h-col right">
                                @foreach ($rightSlots as $k)
                                    {!! $renderHeaderItem($k) !!}
                                @endforeach
                            </div>

                            <div class="h-col center">
                                @foreach ($centerSlots as $k)
                                    {!! $renderHeaderItem($k) !!}
                                @endforeach
                            </div>

                            <div class="h-col left">
                                @foreach ($leftSlots as $k)
                                    {!! $renderHeaderItem($k) !!}
                                @endforeach
                            </div>
                        </div>
                    </div>

                    {{-- CLIENT --}}
                    @if ((bool) data_get($cl, 'show', true))
                        <div class="client-bar">
                            @if ((bool) data_get($cl, 'fields.name', true))
                                <div class="client-item">
                                    <span class="label">اسم العميل:</span>
                                    <span class="value">{{ $clientName }}</span>
                                </div>
                            @endif

                            @if ((bool) data_get($cl, 'fields.phone', true))
                                <div class="client-item">
                                    <span class="label">الهاتف:</span>
                                    <span class="value ltr">{{ $clientPhone }}</span>
                                </div>
                            @endif

                            @if ((bool) data_get($cl, 'fields.address', true))
                                <div class="client-item">
                                    <span class="label">العنوان:</span>
                                    <span class="value">{{ $clientAddress }}</span>
                                </div>
                            @endif
                        </div>
                    @endif

                    {{-- TABLE --}}
                    <div class="card">
                        <table>
                            <thead>
                                <tr>
                                    @if ((bool) data_get($tb, 'columns.no', true))
                                        <th style="width:6%; text-align:{{ $cssAlign('table.no', 'center') }};">ت</th>
                                    @endif
                                    @if ((bool) data_get($tb, 'columns.product', true))
                                        <th style="width:44%; text-align:{{ $cssAlign('table.product', 'right') }};">
                                            المنتج</th>
                                    @endif
                                    @if ((bool) data_get($tb, 'columns.variant', true))
                                        <th style="width:18%; text-align:{{ $cssAlign('table.variant', 'right') }};">
                                            المتغير</th>
                                    @endif
                                    @if ((bool) data_get($tb, 'columns.unit_price', true))
                                        <th style="width:14%; text-align:{{ $cssAlign('table.unit', 'center') }};">سعر
                                            الوحدة</th>
                                    @endif
                                    @if ((bool) data_get($tb, 'columns.qty', true))
                                        <th style="width:8%; text-align:{{ $cssAlign('table.qty', 'center') }};">الكمية
                                        </th>
                                    @endif
                                    @if ((bool) data_get($tb, 'columns.total', true))
                                        <th style="width:10%; text-align:{{ $cssAlign('table.total', 'center') }};">
                                            المجموع</th>
                                    @endif
                                </tr>
                            </thead>

                            <tbody>
                                @forelse ($chunk as $i => $item)
                                    @php
                                        $rowNumber = ($pageIndex - 1) * $maxItemsPerPage + $i + 1;

                                        $productName =
                                            $item->productVariant?->product?->name ?? ($item->product?->name ?? '—');

                                        $variantText = $item->productVariant?->attributeValues
                                            ?->pluck('display_value')
                                            ->filter()
                                            ->values()
                                            ->join(' / ');
                                        $variantText = $variantText ?: $item->productVariant?->sku ?? '—';

                                        $qty = (int) ($item->quantity ?? 0);
                                        $unitPrice = (int) ($item->unit_price ?? 0);
                                        $lineTotal = (int) ($item->line_total ?? $qty * $unitPrice);
                                    @endphp

                                    <tr>
                                        @if ((bool) data_get($tb, 'columns.no', true))
                                            <td class="ltr"
                                                style="text-align:{{ $cssAlign('table.no', 'center') }};">
                                                {{ $rowNumber }}</td>
                                        @endif

                                        @if ((bool) data_get($tb, 'columns.product', true))
                                            <td
                                                style="text-align:{{ $cssAlign('table.product', 'right') }}; font-weight:800;">
                                                {{ $productName }}
                                            </td>
                                        @endif

                                        @if ((bool) data_get($tb, 'columns.variant', true))
                                            <td
                                                style="text-align:{{ $cssAlign('table.variant', 'right') }}; font-size:8px; line-height:1.55; color:#374151;">
                                                @if ((bool) data_get($tb, 'show_variant', true))
                                                    <div>{{ $variantText }}</div>
                                                @endif

                                                @if ((bool) data_get($tb, 'show_barcode', true) && $item->productVariant?->primary_barcode)
                                                    <div class="barcode ltr">
                                                        {{ $item->productVariant->primary_barcode }}</div>
                                                @endif
                                            </td>
                                        @endif

                                        @if ((bool) data_get($tb, 'columns.unit_price', true))
                                            <td class="ltr"
                                                style="text-align:{{ $cssAlign('table.unit', 'center') }};">
                                                {{ $nf($unitPrice) }}</td>
                                        @endif

                                        @if ((bool) data_get($tb, 'columns.qty', true))
                                            <td class="ltr"
                                                style="text-align:{{ $cssAlign('table.qty', 'center') }};">
                                                {{ $qty }}</td>
                                        @endif

                                        @if ((bool) data_get($tb, 'columns.total', true))
                                            <td class="ltr"
                                                style="text-align:{{ $cssAlign('table.total', 'center') }};">
                                                {{ $nf($lineTotal) }}</td>
                                        @endif
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="6"
                                            style="padding:10mm 0;color:#9ca3af;font-size:10px;text-align:center;">
                                            لا توجد منتجات لهذه الفاتورة
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>

                            @if ($pageIndex === $pages->count() && (bool) data_get($tt, 'show_footer_total', true))
                                <tfoot>
                                    <tr>
                                        <td colspan="5" class="tfoot-label">المجموع الكلي المستحق:</td>
                                        <td class="tfoot-value ltr">
                                            {{ $nf($grandTotal) }}
                                            @if ($currencyShow)
                                                {{ $currencyText }}
                                            @endif
                                        </td>
                                    </tr>
                                </tfoot>
                            @endif
                        </table>
                    </div>

                    {{-- LAST PAGE ONLY --}}
                    @if ($pageIndex === $pages->count())
                        <div class="bottom-grid">
                            <div class="summary">
                                <div class="box-head">ملخص الفاتورة</div>
                                <div class="summary-body">

                                    @if ((bool) data_get($tt, 'show_shipping', true))
                                        <div class="row">
                                            <div class="k">أجور التوصيل:</div>
                                            <div class="v ltr">{{ $nf($shipping) }} @if ($currencyShow)
                                                    {{ $currencyText }}
                                                @endif
                                            </div>
                                        </div>
                                    @endif

                                    @if ((bool) data_get($tt, 'show_discount', true))
                                        <div class="row">
                                            <div class="k">الخصم:</div>
                                            <div class="v ltr">{{ $nf($discount) }} @if ($currencyShow)
                                                    {{ $currencyText }}
                                                @endif
                                            </div>
                                        </div>
                                    @endif

                                    @if ((bool) data_get($tt, 'show_paid', true))
                                        <div class="row">
                                            <div class="k">المدفوع:</div>
                                            <div class="v ltr">{{ $nf($paid) }} @if ($currencyShow)
                                                    {{ $currencyText }}
                                                @endif
                                            </div>
                                        </div>
                                    @endif

                                    @if ((bool) data_get($tt, 'show_remaining', true))
                                        <div class="row highlight">
                                            <div class="k">المتبقي على هذه الفاتورة:</div>
                                            <div class="v ltr">{{ $nf($remaining) }} @if ($currencyShow)
                                                    {{ $currencyText }}
                                                @endif
                                            </div>
                                        </div>
                                    @endif

                                    @if ((bool) data_get($tt, 'show_client_debts', true))
                                        <div class="row highlight">
                                            <div class="k">إجمالي ديون العميل بعد الفاتورة:</div>
                                            <div class="v ltr">{{ $nf($clientDebts) }} @if ($currencyShow)
                                                    {{ $currencyText }}
                                                @endif
                                            </div>
                                        </div>
                                    @endif

                                </div>
                            </div>

                            <div class="note">
                                <div class="box-head">ملاحظات</div>
                                <div class="note-body">
                                    @if (!(bool) data_get($nt, 'show', true))
                                        {{-- مخفي --}}
                                    @else
                                        @php
                                            $mode = (string) data_get($nt, 'mode', 'repeater');
                                            $items = data_get($nt, 'items', []);
                                            $items = is_array($items) ? $items : [];
                                            $items = array_values(
                                                array_filter(
                                                    $items,
                                                    fn($x) => is_array($x) && trim((string) ($x['text'] ?? '')) !== '',
                                                ),
                                            );
                                        @endphp

                                        @if ($record->notes)
                                            {!! nl2br(e($record->notes)) !!}
                                        @elseif($mode === 'repeater' && count($items))
                                            <div class="note-list">
                                                @foreach ($items as $it)
                                                    <div class="note-item">
                                                        <span class="note-bullet"></span>
                                                        <div>{{ (string) $it['text'] }}</div>
                                                    </div>
                                                @endforeach
                                            </div>
                                        @else
                                            <div class="hint">لا توجد ملاحظات</div>
                                        @endif
                                    @endif
                                </div>
                            </div>
                        </div>
                    @endif

                    {{-- SIGNATURES --}}
                    @if ((bool) data_get($sg, 'show', true))
                        <div class="signatures">
                            <div class="sign">
                                <div class="t">{{ (string) data_get($sg, 'receiver.label', 'المستلم') }}</div>
                                <div class="line">الاسم الثلاثي / التوقيع</div>
                            </div>
                            <div class="sign">
                                <div class="t">{{ (string) data_get($sg, 'employee.label', 'الموظف') }}</div>
                                <div class="line">الاسم الثلاثي / التوقيع</div>
                            </div>
                        </div>
                    @endif

                    @if ($showPageNumbers)
                        <div class="page-number">صفحة {{ $pageIndex }} من {{ $totalPages }}</div>
                    @endif

                </div>
            </div>

        @empty
            <div class="sheet">
                <div class="content" style="justify-content:center;align-items:center;">
                    <div style="text-align:center;color:#9ca3af;font-size:13px;font-weight:800;">
                        لا توجد منتجات لهذه الفاتورة
                    </div>
                </div>
            </div>
        @endforelse
    </div>

    <div class="action-buttons">
        <a href="{{ \App\Filament\Resources\Pos\PosResource::getUrl('index') }}" class="btn secondary">الرجوع</a>
        <button type="button" onclick="window.print()" class="btn primary">طباعة</button>
    </div>
</div>
