<x-filament-panels::page>
    @php
        /** فرع الوصل وإعداداته */
        $branch = $record->branch ?? null;
        $settings = $branch?->settings;

        /** أدوات مساعدة صغيرة وآمنة */
        $toText = fn($v) => is_array($v) ? implode(' / ', array_filter($v)) : (string) ($v ?? '—');
        $get = function ($src, string $key, $default = null) {
            if (is_array($src)) {
                return $src[$key] ?? $default;
            }
            if (is_object($src)) {
                return $src->$key ?? (method_exists($src, 'getAttribute') ? $src->getAttribute($key) : $default);
            }
            return $default;
        };

        /** بيانات الاتصال من إعدادات الفرع */
        $address = $toText($get($settings, 'address', 'البصرة . شارع الوفود مجاور مجسر المطيحة'));

        // phones: مصفوفة داخل settings->phones أو phone مفرد (احتياطي)
        $phonesArr = $get($settings, 'phones');
        $singlePh = $get($settings, 'phone');
        $phone = $toText($phonesArr ?: $singlePh ?: '07733600003');

        // السوشيال: يفضل استخدام settings->socials (JSON). احتياطيًا نقرأ instagram مفرد.
        $socials = $get($settings, 'socials', []);
        if (!is_array($socials)) {
            $socials = [];
        }
        $insta = $toText($socials['instagram'] ?? $get($settings, 'instagram', 'instagram'));

        /** الشعار من إعدادات الفرع (ميديا) مع fallback على ميديا الفرع */
        // الطباعة على خلفية بيضاء؛ نفضّل الشعار الداكن إن وجد وإلا الفاتح
        $logo = $settings?->logo_light_url ?: null;

        if (!$logo && is_object($branch) && method_exists($branch, 'getFirstMediaUrl')) {
            $logo = $branch->getFirstMediaUrl('logo_dark') ?: $branch->getFirstMediaUrl('logo_light') ?: null;
        }

        /** التاريخ (آسيا/بغداد) */
        $date = \Illuminate\Support\Carbon::parse($record->receipt_date ?? now('Asia/Baghdad'))
            ->timezone('Asia/Baghdad')
            ->format('Y-m-d');

        /** رقم السند (قصير) */
        $receiptNo = (string) ($record->receipt_number ?? '—');
        $receiptNoShort =
            $receiptNo !== '—' ? (isset($record->id) ? sprintf('RC-%06d', (int) $record->id) : 'RC-000000') : '—';

        /** مبالغ صحيحة بدون كسور */
        $amountFormatted = number_format((int) ($record->total_paid ?? 0), 0, '.', ',');
        $total_remaining = number_format((int) ($record->total_remaining ?? 0), 0, '.', ',');

        /** ألوان/متغيرات الطباعة من لوحة ألوان الفرع */
        $palette = $settings?->themePaletteOrGenerate(); // base, mid, dark, ink, muted, bg, field, pill, border
        $vars =
            is_array($palette) && !empty($palette)
                ? [
                    '--primary' => $palette['base'] ?? '#014d31',
                    '--primary-400' => $palette['mid'] ?? '#3DA37A',
                    '--primary-700' => $palette['dark'] ?? '#0C3E2C',
                    '--text' => $palette['ink'] ?? '#101216',
                    '--text-muted' => $palette['muted'] ?? '#7E8B86',
                    '--surface' => $palette['bg'] ?? '#FFFFFF',
                    '--surface-field' => $palette['field'] ?? '#E9ECEF',
                    '--surface-pill' => $palette['pill'] ?? '#F3F5F4',
                    '--border' => $palette['border'] ?? '#CFD6DC',
                ]
                : [
                    '--primary' => '#014d31',
                    '--primary-400' => '#3DA37A',
                    '--primary-700' => '#0C3E2C',
                    '--text' => '#101216',
                    '--text-muted' => '#7E8B86',
                    '--surface' => '#FFFFFF',
                    '--surface-field' => '#E9ECEF',
                    '--surface-pill' => '#F3F5F4',
                    '--border' => '#CFD6DC',
                ];
        $brand = $vars['--primary'] ?? '#014d31';

        /** معلومات العميل */
        $client = $record->client;
    @endphp

    <style>
        :root {
            --primary: #014d31;
            --primary-400: #3DA37A;
            --primary-700: #0C3E2C;
            --text: #101216;
            --text-muted: #7E8B86;
            --surface: #FFFFFF;
            --surface-field: #E9ECEF;
            --surface-pill: #F3F5F4;
            --border: #CFD6DC;
        }

        html,
        body {
            color: var(--text);
            margin: 0;
            padding: 0;
        }

        .page {
            position: relative;
            width: 210mm;
            height: 297mm;
            margin: 0 auto;
            background: #fff;
            box-sizing: border-box;
        }

        .copy {
            position: absolute;
            left: 0;
            right: 0;
            width: 210mm;
            height: 148.5mm;
            padding: 10mm 0;
            box-sizing: border-box;
            overflow: hidden;
        }

        .copy.top {
            top: 0;
            padding: 0;
        }

        .copy.bottom {
            top: 148.5mm;
        }

        .divider {
            position: absolute;
            left: 10mm;
            right: 10mm;
            top: 148.5mm;
            height: 0;
            border-top: 2px dashed var(--border);
            box-sizing: border-box;
        }

        .voucher {
            position: relative;
            width: 100%;
            height: 100%;
            border-radius: 8px;
            overflow: hidden;
        }

        .side {
            position: absolute;
            top: 0;
            width: 5mm;
            background: var(--primary);
        }

        .side.left {
            left: 0;
            height: 25%;
        }

        .side.right {
            right: 0;
            height: 25%;
        }

        .pad {
            padding: 6mm 8mm;
            height: 100%;
            box-sizing: border-box;
        }

        .header {
            display: grid;
            grid-template-columns: 1fr auto 1fr;
            align-items: center;
        }

        .hdr-left {
            direction: ltr;
        }

        .hdr-left .title {
            font-weight: 900;
            font-size: 18px;
        }

        .no-box {
            margin-top: 8px;
            width: 200px;
        }

        .no-label {
            background: var(--primary);
            color: #fff;
            padding: 6px 12px;
            border-radius: 18px 18px 0 0;
            font-weight: 800;
            font-size: 14px;
            height: 30px;
            display: block;
        }

        .no-field {
            height: 30px;
            border: 1px solid var(--border);
            border-radius: 0 0 18px 18px;
            background: var(--surface);
            display: flex;
            align-items: center;
            justify-content: center;
            direction: ltr;
            font-weight: 800;
            letter-spacing: 0.5px;
        }

        .logo {
            width: 80px;
            height: 80px;
            border: 1px solid var(--border);
            border-radius: 12px;
            margin: 6px auto 0;
            display: grid;
            place-items: center;
            overflow: hidden;
        }

        .logo img {
            width: 100%;
            height: 100%;
            object-fit: contain;
        }

        .hdr-right {
            text-align: right;
        }

        .hdr-right .ar {
            font-size: 28px;
            font-weight: 900;
        }

        .date-wrap {
            margin-top: 8px;
        }

        .date-label {
            background: var(--primary);
            color: #fff;
            padding: 4px 10px;
            border-radius: 6px;
            font-weight: 800;
            display: inline-block;
            margin-bottom: 4px;
        }

        .date-field {
            border: 1px solid var(--border);
            border-radius: 6px;
            padding: 4px 10px;
            display: inline-block;
            min-width: 120px;
            text-align: center;
            font-weight: 700;
        }

        .sep {
            border-bottom: 2px dotted #0003;
            margin: 12px 0;
            width: 60%;
            position: relative;
            right: 35%;
            top: 6%;
        }

        .row {
            display: flex;
            justify-content: space-between;
            font-weight: 700;
            margin: 8px 0;
        }

        .row.two-col {
            display: flex;
            gap: 16px;
            align-items: center;
            font-weight: 700;
            margin: 20px 0;
        }

        .row.two-col .label {
            width: 30%;
        }

        .row.two-col .value {
            flex: 1;
        }

        .big-field {
            background: var(--surface-pill);
            border-radius: 24px;
            padding: 10px 16px;
            font-weight: 700;
        }

        .sigs {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 16px;
            margin-top: 12px;
        }

        .sig {
            text-align: center;
        }

        .sig .ar {
            font-weight: 800;
        }

        .sig .en {
            font-weight: 800;
            color: var(--primary);
        }

        .sig .line {
            border-bottom: 2px dotted #0003;
            height: 26px;
            margin-top: 10px;
        }

        .action-bar {
            margin-top: 20px;
            display: flex;
            justify-content: center;
            gap: 16px;
        }

        .btn {
            appearance: none;
            border: 2px solid var(--primary);
            padding: 10px 18px;
            border-radius: 10px;
            font-weight: 800;
            background: #fff;
            color: var(--primary);
            text-decoration: none;
            cursor: pointer;
        }

        .btn.primary {
            background: var(--primary);
            color: #fff;
        }

        @media print {
            @page {
                size: 210mm 297mm;
                margin: 0;
            }

            html,
            body {
                width: 210mm;
                height: 297mm;
                margin: 0;
                padding: 0;
            }

            .fi-sidebar,
            .fi-topbar,
            .fi-header,
            .fi-breadcrumbs,
            .fi-page-sub-navigation,
            .fi-global-search,
            .fi-pagination,
            .fi-footer,
            .fi-notifications,
            .fi-sidebar-close-overlay,
            .fi-filament-brand {
                display: none !important;
            }

            .fi-main {
                padding: 0 !important;
            }

            body * {
                visibility: hidden !important;
            }

            .print-area,
            .print-area * {
                visibility: visible !important;
            }

            .print-area {
                position: fixed !important;
                inset: 0 !important;
                margin: 0 !important;
                background: #fff;
                z-index: 9999;
            }

            * {
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }

            .page,
            .copy,
            .voucher,
            .pad {
                page-break-inside: avoid;
            }

            .page {
                border: none !important;
                box-shadow: none !important;
            }

            .no-print {
                display: none !important;
            }
        }
    </style>

    {{-- نحقن متغيرات الألوان من الفرع --}}
    <div class="print-area"
        style="
        --primary: {{ $vars['--primary'] }};
        --primary-400: {{ $vars['--primary-400'] }};
        --primary-700: {{ $vars['--primary-700'] }};
        --text: {{ $vars['--text'] }};
        --text-muted: {{ $vars['--text-muted'] }};
        --surface: {{ $vars['--surface'] }};
        --surface-field: {{ $vars['--surface-field'] }};
        --surface-pill: {{ $vars['--surface-pill'] }};
        --border: {{ $vars['--border'] }};
    ">
        <div class="page">
            {{-- النسخة الأولى --}}
            <div class="copy top">
                <div class="voucher">
                    <div class="side left"></div>
                    <div class="side right"></div>

                    <div class="pad">
                        <div class="header">
                            <div class="hdr-right">
                                <div class="ar">سند قبض</div>
                                <div class="date-wrap">
                                    <div class="date-label">التاريخ</div>
                                    <div class="date-field">{{ $date }}</div>
                                </div>
                            </div>

                            <div class="hdr-mid" style="text-align:center;">
                                <div class="logo">
                                    @if ($logo)
                                        <img src="{{ $logo }}" alt="logo">
                                    @else
                                        <svg viewBox="0 0 64 64" width="64" height="64" aria-hidden="true">
                                            <circle cx="32" cy="32" r="28" fill="#e7eaeb" />
                                            <path d="M20 36l8-16 8 16" stroke="{{ $brand }}" fill="none"
                                                stroke-width="3" />
                                        </svg>
                                    @endif
                                </div>
                            </div>

                            <div class="hdr-left">
                                <div class="title">RECEIPT VOUCHER</div>
                                <div class="no-box text-center">
                                    <div class="no-label">No : {{ $receiptNoShort }}</div>
                                    <div class="no-field">{{ $date }}</div>
                                </div>
                            </div>
                        </div>

                        {{-- نصوص الشركات الذهبية + مبالغ صحيحة --}}
                        <div class="flex items-center font-bold my-6">
                            <div class="w-[35%] text-md">تم استلام المبلغ من العميل</div>
                            <div class="w-[60%] border-b-2 border-dotted border-black/30 pb-1 text-xl">
                                {{ $amountFormatted }} دينار
                            </div>
                        </div>

                        <div class="row two-col">
                            <div class="label">الـسّــيّـد الـعـمـيـل الـمُحتــرم</div>
                            <div class="value big-field">{{ $client->name ?? '—' }}</div>
                        </div>

                        <div class="flex items-center font-bold my-6">
                            <div class="w-[35%] text-md">إجمالي المستحقات المتبقية</div>
                            <div class="w-[60%] border-b-2 border-dotted border-black/30 pb-1 text-xl">
                                {{ $total_remaining }} دينار
                            </div>
                        </div>

                        <div class="sigs">
                            <div class="sig">
                                <div class="ar">الإدارة</div>
                                <div class="en">Management</div>
                                <div class="line"></div>
                            </div>
                            <div class="sig">
                                <div class="ar">المستلم</div>
                                <div class="en">Receiver</div>
                                <div class="line"></div>
                            </div>
                        </div>
                        <p class="text-center font-bold mt-10 note">
                            هذة الفاتورة صادرة رسومية من {{ $branch->name }}
                            ويمكن الرجوع اليها في حال السهو او الخطا
                        </p>
                    </div>
                </div>
            </div>

            {{-- النسخة الثانية (مطابقة أولاً لكن مختصرة) --}}
            <div class="copy bottom">
                <div class="voucher">
                    <div class="side left"></div>
                    <div class="side right"></div>

                    <div class="pad">
                        <div class="header">
                            <div class="hdr-right">
                                <div class="ar">سند قبض</div>
                                <div class="date-wrap">
                                    <div class="date-label">التاريخ</div>
                                    <div class="date-field">{{ $date }}</div>
                                </div>
                            </div>

                            <div class="hdr-mid" style="text-align:center;">
                                @if (!empty($branch?->name))
                                    <div class="font-bold" style="margin-bottom:6px;">{{ $branch->name }}</div>
                                @endif
                                <div class="logo">
                                    @if ($logo)
                                        <img src="{{ $logo }}" alt="logo">
                                    @else
                                        <svg viewBox="0 0 64 64" width="64" height="64" aria-hidden="true">
                                            <circle cx="32" cy="32" r="28" fill="#e7eaeb" />
                                            <path d="M20 36l8-16 8 16" stroke="{{ $brand ?? '#014d31' }}"
                                                fill="none" stroke-width="3" />
                                        </svg>
                                    @endif
                                </div>
                            </div>

                            <div class="hdr-left">
                                <div class="title">RECEIPT VOUCHER</div>
                                <div class="no-box">
                                    <div class="no-label">No.</div>
                                    <div class="no-field">{{ $receiptNoShort }}</div>
                                </div>
                            </div>
                        </div>

                        <div class="flex items-center font-bold my-6">
                            <div class="w-[35%] text-md">تم استلام المبلغ من العميل</div>
                            <div class="w-[60%] border-b-2 border-dotted border-black/30 pb-1 text-xl">
                                {{ $amountFormatted }} دينار
                            </div>
                        </div>

                        <div class="row two-col">
                            <div class="label">الـسّــيّـد الـعـمـيـل الـمُحتــرم</div>
                            <div class="value big-field">{{ $client->name ?? '—' }}</div>
                        </div>

                        <div class="flex items-center font-bold my-6">
                            <div class="w-[35%] text-md">إجمالي المستحقات المتبقية</div>
                            <div class="w-[60%] border-b-2 border-dotted border-black/30 pb-1 text-xl">
                                {{ $total_remaining }} دينار
                            </div>
                        </div>

                        <div class="sigs">
                            <div class="sig">
                                <div class="ar">الإدارة</div>
                                <div class="en">Management</div>
                                <div class="line"></div>
                            </div>
                            <div class="sig">
                                <div class="ar">المستلم</div>
                                <div class="en">Receiver</div>
                                <div class="line"></div>
                            </div>
                        </div>
                        <div class="footer">
                            <p class="text-center font-bold mt-10 note">
                                هذة الفاتورة صادرة رسومية من {{ $branch->name }}
                                ويمكن الرجوع اليها في حال السهو او الخطا
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="divider" aria-hidden="true"></div>
        </div>
    </div>

    {{-- أزرار الشاشة فقط --}}
    <div class="action-bar no-print">
        <button onclick="window.print()" class="btn primary">🖨️ طباعة</button>
        <a href="{{ \App\Filament\Resources\ClientReceipts\ClientReceiptResource::getUrl('index') }}"
            class="btn">العودة</a>
    </div>
</x-filament-panels::page>
