<x-filament-panels::page>
    @php
        /** @var \App\Models\ProductCard $r */
        $r = $this->record;

        $settings = $r->branch?->settings;

        $branchLogo = $settings?->logo_light_url ?? null;
        $branchName = (string) ($r->branch?->name ?? '—');

        $palette = $settings?->themePaletteOrGenerate() ?? [
            'base' => '#C26D3C',
            'mid' => '#D8925E',
            'dark' => '#8A4A24',
            'muted' => '#7E8B86',
            'field' => '#E9ECEF',
            'bg' => '#FFFFFF',
            'pill' => '#F3F5F4',
            'border' => '#DDE6E1',
            'ink' => '#0A3326',
        ];

        $titleAr = (string) ($r->title ?? '');
        $description = trim((string) ($r->description ?? ''));
        $notes = trim((string) ($r->notes ?? ''));

        // ✅ مبالغ عدد صحيح
        $originalPrice = (int) ($r->price ?? 0);
        $discountPercent = (int) ($r->discount_percent ?? 0);
        $hasDiscount = (bool) ($r->has_discount ?? false) && $discountPercent > 0;

        $discountedPrice = $hasDiscount
            ? (int) round($originalPrice - ($originalPrice * $discountPercent) / 100)
            : $originalPrice;

        $originalText = number_format($originalPrice);
        $discountedText = number_format($discountedPrice);

        $img = $r->image_thumb_url ?: $r->image_url;

        // ✅ افتراضات للطباعة (قياسات مخصصة)
        $defaultOrientation = 'portrait'; // portrait | landscape
        $defaultPaper = '80x150'; // 80x150 | 100x180

        // ==========================
        // إعدادات تصميم الكارت (من BranchSetting)
        // ==========================
        $cardDesign = $settings?->productCardDesignOrDefault() ?? [];

        $logoShow = (bool) data_get($cardDesign, 'logo.show', true);
        $logoMaxW = (int) data_get($cardDesign, 'logo.max_width_mm', 70);
        $logoMaxH = (int) data_get($cardDesign, 'logo.max_height_mm', 18);

        // ✅ محاذاة السعر (مستقلة)
        $priceAlign = (string) data_get($cardDesign, 'price.align', 'right'); // right|center|left
        if (!in_array($priceAlign, ['right', 'center', 'left'], true)) {
            $priceAlign = 'right';
        }

        $currencyInline = (bool) data_get($cardDesign, 'price.currency_inline', true);
        $showCurrency = (bool) data_get($cardDesign, 'price.show_currency', true);
        $currencyText = trim((string) data_get($cardDesign, 'price.currency_text', 'د.ع'));

        // ✅ الصورة
        $showImage = (bool) data_get($cardDesign, 'image.show', true);
        $showDiscountBadge = (bool) data_get($cardDesign, 'discount.show_badge', true);

        $showDescription = (bool) data_get($cardDesign, 'fields.show_description', true);
        $showNotes = (bool) data_get($cardDesign, 'fields.show_notes', true);

        $hasImage = (bool) $img;
        $renderImageSection = $showImage && $hasImage;
        $noImageClass = $renderImageSection ? '' : 'no-image';

        // ✅ محاذاة مستقلة لكل نص
        $titleAlign = (string) data_get($cardDesign, 'text.title_align', 'center');
        $descAlign = (string) data_get($cardDesign, 'text.description_align', 'center');
        $notesAlign = (string) data_get($cardDesign, 'text.notes_align', 'right');

        if (!in_array($titleAlign, ['right', 'center', 'left'], true)) {
            $titleAlign = 'center';
        }
        if (!in_array($descAlign, ['right', 'center', 'left'], true)) {
            $descAlign = 'center';
        }
        if (!in_array($notesAlign, ['right', 'center', 'left'], true)) {
            $notesAlign = 'right';
        }
    @endphp

    <style>
        /* =========================
           ✅ قياسات مخصصة (سم)
           - 8cm x 15cm  => 80mm x 150mm
           - 10cm x 18cm => 100mm x 180mm
           ========================= */
        :root {
            --card-w: 80mm;
            --card-h: 150mm;
        }

        .sheet.size-80x150 {
            --card-w: 80mm;
            --card-h: 150mm;
        }

        .sheet.size-80x150.is-landscape {
            --card-w: 150mm;
            --card-h: 80mm;
        }

        .sheet.size-100x180 {
            --card-w: 100mm;
            --card-h: 180mm;
        }

        .sheet.size-100x180.is-landscape {
            --card-w: 180mm;
            --card-h: 100mm;
        }

        /* =========================
           ✅ إعدادات @page للطباعة (مقاسات فعلية بالـ mm)
           ========================= */
        @page {
            size: 80mm 150mm;
            margin: 0;
        }

        @page card-80x150-landscape {
            size: 150mm 80mm;
            margin: 0;
        }

        @page card-100x180 {
            size: 100mm 180mm;
            margin: 0;
        }

        @page card-100x180-landscape {
            size: 180mm 100mm;
            margin: 0;
        }

        html,
        body {
            margin: 0;
            padding: 0;
        }

        body {
            font-family: "Tajawal", Arial, sans-serif;
        }

        @media print {

            html,
            body {
                margin: 0 !important;
                padding: 0 !important;
                background: #fff !important;
                overflow: hidden !important;
            }

            body * {
                visibility: hidden !important;
            }

            #print-only,
            #print-only * {
                visibility: visible !important;
            }

            #print-only {
                position: fixed !important;
                inset: 0 !important;
                margin: 0 !important;
                padding: 0 !important;
                background: #fff !important;
                display: flex !important;
                align-items: flex-start !important;
                justify-content: center !important;
            }

            .sheet {
                box-shadow: none !important;
                border: 0 !important;
                border-radius: 0 !important;
                background: #fff !important;
            }

            .no-print {
                display: none !important;
            }

            * {
                -webkit-print-color-adjust: exact !important;
                print-color-adjust: exact !important;
                animation: none !important;

                /* ✅ يمنع مربعات خلف النص/الصور */
                filter: none !important;
                backdrop-filter: none !important;
                box-shadow: none !important;
                text-shadow: none !important;
                outline: none !important;
            }

            /* ✅ ربط كل حالة بـ page مناسبة */
            .sheet.size-80x150.is-landscape {
                page: card-80x150-landscape;
            }

            .sheet.size-80x150:not(.is-landscape) {
                page: auto;
                /* @page الافتراضية 80x150 */
            }

            .sheet.size-100x180:not(.is-landscape) {
                page: card-100x180;
            }

            .sheet.size-100x180.is-landscape {
                page: card-100x180-landscape;
            }

            /* ✅ إلغاء الطبقات المعقدة بالطباعة */
            .paper-bg {
                display: none !important;
            }

            .image-box::after,
            .discount-badge::before,
            .discount-inner::before {
                content: none !important;
                background: transparent !important;
            }

            /* ✅ الشعار والصورة: بدون ظل/فلتر/خلفية */
            .brand-logo,
            .image-box img {
                background: transparent !important;
                filter: none !important;
                box-shadow: none !important;
                mix-blend-mode: normal !important;
                transform: none !important;
            }

            /* ✅ النصوص: لون صريح بدل background-clip text */
            .new-price {
                background: none !important;
                -webkit-text-fill-color: var(--brand-dark) !important;
                color: var(--brand-dark) !important;
            }

            /* خطوط بسيطة بدل gradients */
            .header-line,
            .divider {
                background: var(--brand-base) !important;
                height: 1px !important;
            }

            .header,
            .title-block,
            .price-discount-section,
            .notes {
                background: transparent !important;
            }

            /* ✅ إزالة أي تدرجات من صندوق الصورة */
            .image-box {
                background: #fff !important;
                border: 1px solid rgba(0, 0, 0, .06) !important;
            }
        }

        /* =========================
           ألوان العلامة التجارية + متغيرات التصميم
           ========================= */
        #printSheet {
            --brand-base: {{ $palette['base'] }};
            --brand-mid: {{ $palette['mid'] }};
            --brand-dark: {{ $palette['dark'] }};
            --brand-muted: {{ $palette['muted'] }};
            --brand-field: {{ $palette['field'] }};
            --brand-bg: {{ $palette['bg'] }};
            --brand-pill: {{ $palette['pill'] }};
            --brand-border: {{ $palette['border'] }};
            --brand-ink: {{ $palette['ink'] }};
            --shadow: 0 26px 54px rgba(0, 0, 0, .14), 0 10px 20px rgba(0, 0, 0, .10);

            --logo-max-w: {{ (int) $logoMaxW }}mm;
            --logo-max-h: {{ (int) $logoMaxH }}mm;
        }

        .sheet {
            width: var(--card-w);
            height: var(--card-h);
            position: relative;
            overflow: hidden;
            background: var(--brand-bg);
            border-radius: 22px;
            border: 1px solid rgba(0, 0, 0, .04);
            box-shadow: var(--shadow);
        }

        .paper-bg {
            position: absolute;
            inset: 0;
            background:
                radial-gradient(circle at 70% 10%, color-mix(in srgb, var(--brand-base) 10%, transparent), transparent 55%),
                radial-gradient(circle at 20% 85%, color-mix(in srgb, var(--brand-base) 7%, transparent), transparent 58%),
                linear-gradient(180deg, var(--brand-bg) 0%, var(--brand-field) 100%);
            pointer-events: none;
        }

        .content {
            position: relative;
            z-index: 2;
            height: 100%;
            box-sizing: border-box;
        }

        /* =========================
           ✅ أدوات محاذاة عامة
           ========================= */
        .text-align-right {
            text-align: right;
        }

        .text-align-center {
            text-align: center;
        }

        .text-align-left {
            text-align: left;
        }

        /* =========================
           الهيدر
           ========================= */
        .header {
            padding: 5mm 10mm 4mm 10mm;
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 5;
            position: relative;
            min-height: 18mm;
            background: transparent;
        }

        .brand-logo {
            max-width: var(--logo-max-w, 70mm);
            max-height: var(--logo-max-h, 18mm);
            object-fit: contain;
            filter: drop-shadow(0 3px 8px rgba(0, 0, 0, .12));
            background: transparent !important;
        }

        .header-line {
            width: calc(100% - 20mm);
            height: 1px;
            margin: 0 auto;
            background: linear-gradient(90deg,
                    transparent 0%,
                    color-mix(in srgb, var(--brand-base) 22%, transparent) 18%,
                    var(--brand-base) 50%,
                    color-mix(in srgb, var(--brand-base) 22%, transparent) 82%,
                    transparent 100%);
        }

        /* =========================
           العنوان + الوصف
           ========================= */
        .title-block {
            padding: 0 10mm;
            margin-top: 3mm;
            position: relative;
            z-index: 6;
        }

        .title-ar {
            font-size: 26px;
            font-weight: 950;
            color: var(--brand-ink);
            line-height: 1.15;
            direction: rtl;
            text-shadow: 0 1px 3px rgba(0, 0, 0, .04);
        }

        .title-desc {
            margin-top: 1.8mm;
            font-size: 12.5px;
            font-weight: 800;
            color: var(--brand-muted);
            line-height: 1.5;
            direction: rtl;
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
            overflow: hidden;
        }

        .title-desc.text-align-left,
        .notes.text-align-left {
            direction: ltr;
        }

        .divider {
            margin: 3.5mm auto 0;
            width: 55mm;
            height: 2px;
            background: linear-gradient(90deg,
                    transparent 0%,
                    color-mix(in srgb, var(--brand-base) 30%, transparent) 12%,
                    var(--brand-base) 50%,
                    color-mix(in srgb, var(--brand-base) 30%, transparent) 88%,
                    transparent 100%);
            position: relative;
            z-index: 6;
        }

        /* =========================
           السعر + الخصم
           ========================= */
        .price-discount-section {
            padding: 0 10mm;
            margin-top: 5mm;
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: relative;
            z-index: 6;
        }

        .price-left {
            text-align: right;
            flex: 1;
        }

        .sheet.price-align-right .price-left {
            text-align: right;
        }

        .sheet.price-align-center .price-left {
            text-align: center;
        }

        .sheet.price-align-left .price-left {
            text-align: left;
        }

        .new-price {
            font-size: 34px;
            font-weight: 950;
            background: linear-gradient(135deg, var(--brand-dark), var(--brand-base));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            line-height: 1;
            display: block;
            white-space: nowrap;
        }

        .price-inline {
            display: flex;
            align-items: baseline;
            gap: 2.5mm;
            justify-content: flex-start;
        }

        .sheet.price-align-right .price-inline {
            justify-content: flex-end;
        }

        .sheet.price-align-center .price-inline {
            justify-content: center;
        }

        .sheet.price-align-left .price-inline {
            justify-content: flex-start;
        }

        .currency-inline {
            font-size: 14px;
            font-weight: 900;
            color: var(--brand-muted);
            white-space: nowrap;
        }

        .currency {
            font-size: 12px;
            font-weight: 850;
            color: var(--brand-muted);
            margin-top: 1.5mm;
            display: block;
        }

        .old-price {
            font-size: 14px;
            font-weight: 850;
            color: color-mix(in srgb, var(--brand-ink) 40%, transparent);
            text-decoration: line-through;
            text-decoration-thickness: 2.5px;
            text-decoration-color: color-mix(in srgb, var(--brand-dark) 55%, transparent);
            margin-top: 1.5mm;
            display: block;
            white-space: nowrap;
        }

        .discount-badge {
            width: 22mm;
            height: 22mm;
            flex-shrink: 0;
            margin-right: 5mm;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
        }

        .discount-badge::before {
            content: "";
            position: absolute;
            inset: 0;
            background: linear-gradient(135deg, var(--brand-base), var(--brand-dark));
            border-radius: 50%;
            box-shadow: 0 6px 18px color-mix(in srgb, var(--brand-base) 30%, transparent);
        }

        .discount-inner {
            width: calc(100% - 3mm);
            height: calc(100% - 3mm);
            border-radius: 50%;
            background: linear-gradient(135deg, var(--brand-mid), var(--brand-base));
            border: 2px solid rgba(255, 255, 255, .28);
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            overflow: hidden;
            z-index: 1;
        }

        .discount-inner::before {
            content: "";
            position: absolute;
            inset: 3.2mm;
            border-radius: 50%;
            border: 2px dashed rgba(255, 255, 255, .80);
        }

        .discount-text {
            text-align: center;
            color: #fff;
            font-weight: 950;
            line-height: 1;
            position: relative;
            z-index: 2;
            text-shadow: 0 2px 6px rgba(0, 0, 0, .22);
        }

        .discount-text .percent {
            font-size: 16px;
            display: block;
        }

        .discount-text .label {
            font-size: 9px;
            margin-top: 1.2mm;
            display: block;
        }

        /* =========================
           الصورة
           ========================= */
        .image-container {
            margin: 4mm 10mm 0 10mm;
            position: relative;
            z-index: 5;
        }

        .image-box {
            position: relative;
            border-radius: 18px;
            overflow: hidden;
            padding: 0;
            min-height: 46mm;
            display: flex;
            justify-content: center;
            align-items: center;
            background:
                radial-gradient(circle at 50% 40%, rgba(255, 255, 255, .92), rgba(255, 255, 255, 0) 65%),
                linear-gradient(180deg,
                    color-mix(in srgb, var(--brand-bg) 92%, var(--brand-field)),
                    color-mix(in srgb, var(--brand-field) 90%, var(--brand-bg)));
            box-shadow:
                inset 0 0 0 1px rgba(255, 255, 255, .55),
                inset 0 -14px 22px rgba(0, 0, 0, .04);
        }

        .image-box::after {
            content: "";
            position: absolute;
            inset: 0;
            border-radius: 18px;
            pointer-events: none;
            background:
                radial-gradient(circle at 50% 45%, rgba(255, 255, 255, .40), rgba(255, 255, 255, 0) 55%),
                radial-gradient(circle at 50% 110%, color-mix(in srgb, var(--brand-base) 10%, transparent), transparent 60%);
            opacity: .85;
        }

        .image-box img {
            position: relative;
            z-index: 1;
            background: transparent !important;
            max-width: 84%;
            max-height: 40mm;
            object-fit: contain;
            filter: drop-shadow(0 6px 14px rgba(0, 0, 0, .10));
            transform: translateY(0.5mm);
        }

        /* =========================
           الملاحظات
           ========================= */
        .notes {
            position: absolute;
            bottom: 5mm;
            left: 10mm;
            right: 10mm;
            padding-top: 3mm;
            border-top: 1px solid color-mix(in srgb, var(--brand-border) 40%, transparent);
            font-size: 10px;
            font-weight: 800;
            color: var(--brand-muted);
            z-index: 6;
            direction: rtl;

            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
            overflow: hidden;
        }

        /* =========================
           تحسين الأفقي
           ========================= */
        .sheet.is-landscape .content {
            display: grid;
            grid-template-columns: 1fr 1fr;
            grid-template-rows: auto auto auto 1fr auto;
            height: 100%;
            gap: 0;
        }

        .sheet.is-landscape .header {
            grid-column: 1 / -1;
            padding: 3.5mm 8mm 2.5mm 8mm;
        }

        .sheet.is-landscape .header-line {
            grid-column: 1 / -1;
        }

        .sheet.is-landscape .title-block {
            grid-column: 1 / 2;
            padding: 0 8mm;
            margin-top: 2mm;
        }

        .sheet.is-landscape .title-ar {
            font-size: 24px;
        }

        .sheet.is-landscape .title-desc {
            font-size: 12px;
            margin-top: 1mm;
        }

        .sheet.is-landscape .divider {
            grid-column: 1 / 2;
            margin: 2mm 8mm 0;
            width: auto;
        }

        .sheet.is-landscape .price-discount-section {
            grid-column: 1 / 2;
            grid-row: 4 / 5;
            padding: 0 8mm 6mm 8mm;
            margin-top: 0;
            display: flex;
            flex-direction: row;
            justify-content: flex-end;
            align-items: flex-end;
            padding-bottom: 8mm;
        }

        .sheet.is-landscape .new-price {
            font-size: 44px;
        }

        .sheet.is-landscape .currency {
            font-size: 15px;
            margin-top: 1.5mm;
        }

        .sheet.is-landscape .old-price {
            font-size: 17px;
            margin-top: 1.5mm;
        }

        .sheet.is-landscape .discount-badge {
            width: 26mm;
            height: 26mm;
            margin-right: 0;
            margin-top: 3.5mm;
        }

        .sheet.is-landscape .discount-text .percent {
            font-size: 19px;
        }

        .sheet.is-landscape .discount-text .label {
            font-size: 10.5px;
        }

        .sheet.is-landscape .image-container {
            grid-column: 2 / 3;
            grid-row: 3 / 5;
            margin: 0 6mm 8mm 4mm;
            align-self: stretch;
        }

        .sheet.is-landscape .image-box {
            min-height: 70mm;
            height: 100%;
        }

        .sheet.is-landscape .image-box img {
            max-height: 66mm;
            max-width: 90%;
            transform: translateY(0);
        }

        .sheet.is-landscape .notes {
            grid-column: 1 / -1;
            grid-row: 5 / 6;
            position: static;
            left: 8mm;
            right: 8mm;
            bottom: auto;
            margin: 0 8mm 4mm 8mm;
        }

        .sheet.is-landscape.no-image .content {
            grid-template-columns: 1fr;
        }

        .sheet.is-landscape.no-image .title-block,
        .sheet.is-landscape.no-image .divider,
        .sheet.is-landscape.no-image .price-discount-section {
            grid-column: 1 / -1;
        }

        .paper-select {
            height: 32px;
            padding: 0 10px;
            border-radius: 10px;
            border: 1px solid rgba(255, 255, 255, .18);
            background: rgba(255, 255, 255, .06);
            color: inherit;
            outline: none;
        }

        .paper-select option {
            color: #111;
        }
    </style>

    {{-- أزرار الشاشة فقط --}}
    <div class="no-print mb-6 flex items-center justify-between">
        <a href="{{ \App\Filament\Resources\ProductCards\ProductCardResource::getUrl('index') }}"
            class="fi-btn fi-btn-color-gray fi-btn-size-sm">العودة</a>

        <div class="flex items-center gap-2">
            <a href="{{ \App\Filament\Resources\ProductCards\ProductCardResource::getUrl('edit', ['record' => $r]) }}"
                class="fi-btn fi-btn-color-primary fi-btn-size-sm">تعديل</a>

            <select id="paperSize" class="paper-select" title="قياس الكارت">
                <option value="80x150" selected>8×15 سم</option>
                <option value="100x180">10×18 سم</option>
            </select>

            <button type="button" class="fi-btn fi-btn-color-gray fi-btn-size-sm" id="btnToggleOrientation">
                تدوير
            </button>

            <button type="button" class="fi-btn fi-btn-color-warning fi-btn-size-sm" id="btnPrint">
                طباعة
            </button>
        </div>
    </div>

    {{-- منطقة العرض + الطباعة --}}
    <div class="print-area flex justify-center">
        <div id="print-only">
            <div class="sheet
                    size-{{ $defaultPaper }}
                    {{ $defaultOrientation === 'landscape' ? 'is-landscape' : '' }}
                    price-align-{{ $priceAlign }}
                    {{ $noImageClass }}
                "
                id="printSheet">
                <div class="paper-bg"></div>

                <div class="content">
                    <div class="header">
                        @if ($logoShow)
                            @if ($branchLogo)
                                <img class="brand-logo" src="{{ $branchLogo }}" alt="Logo">
                            @else
                                <div style="font-weight:950;color:var(--brand-dark);font-size:20px">{{ $branchName }}
                                </div>
                            @endif
                        @endif
                    </div>

                    <div class="header-line"></div>

                    <div class="title-block">
                        <div class="title-ar text-align-{{ $titleAlign }}">{{ $titleAr }}</div>

                        @if ($showDescription && $description !== '')
                            <div class="title-desc text-align-{{ $descAlign }}">{{ $description }}</div>
                        @endif
                    </div>

                    <div class="divider"></div>

                    <div class="price-discount-section">
                        <div class="price-left">
                            @if ($currencyInline)
                                <div class="price-inline">
                                    <span class="new-price">{{ $discountedText }}</span>

                                    @if ($showCurrency && $currencyText !== '')
                                        <span class="currency-inline">{{ $currencyText }}</span>
                                    @endif
                                </div>
                            @else
                                <span class="new-price">{{ $discountedText }}</span>

                                @if ($showCurrency && $currencyText !== '')
                                    <span class="currency">{{ $currencyText }}</span>
                                @endif
                            @endif

                            @if ($hasDiscount)
                                <span class="old-price">{{ $originalText }}
                                    {{ $showCurrency ? $currencyText : '' }}</span>
                            @endif
                        </div>

                        @if ($hasDiscount && $showDiscountBadge)
                            <div class="discount-badge">
                                <div class="discount-inner">
                                    <div class="discount-text">
                                        <span class="percent">{{ $discountPercent }}%</span>
                                        <span class="label">خصم</span>
                                    </div>
                                </div>
                            </div>
                        @endif
                    </div>

                    {{-- ✅ قسم الصورة --}}
                    @if ($renderImageSection)
                        <div class="image-container">
                            <div class="image-box">
                                <img src="{{ $img }}" alt="product" loading="eager">
                            </div>
                        </div>
                    @endif

                    @if ($showNotes && $notes !== '')
                        <div class="notes text-align-{{ $notesAlign }}">{{ $notes }}</div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <script>
        (function() {
            const sheet = document.getElementById('printSheet');
            const paperSize = document.getElementById('paperSize');
            const btnToggle = document.getElementById('btnToggleOrientation');
            const btnPrint = document.getElementById('btnPrint');

            if (!sheet) return;

            function syncSelectWithSheet() {
                if (!paperSize) return;
                paperSize.value = sheet.classList.contains('size-100x180') ? '100x180' : '80x150';
            }

            function applyPaperSize(size) {
                sheet.classList.remove('size-80x150', 'size-100x180');
                sheet.classList.add(size === '100x180' ? 'size-100x180' : 'size-80x150');
                syncSelectWithSheet();
            }

            if (paperSize) {
                paperSize.addEventListener('change', (e) => applyPaperSize(e.target.value));
            }

            if (btnToggle) {
                btnToggle.addEventListener('click', () => sheet.classList.toggle('is-landscape'));
            }

            function doPrint() {
                window.requestAnimationFrame(() => window.print());
            }

            if (btnPrint) {
                btnPrint.addEventListener('click', doPrint);
            }

            syncSelectWithSheet();
        })();
    </script>
</x-filament-panels::page>
