<x-filament-panels::page>
    @php
        /** @var \App\Models\Invoice $record */
        $record = $this->record;

        $branch = $record->branch ?? null;
        $settings = $branch?->settings ?? null;

        $templateKey = $settings?->invoiceTemplateKey() ?? 'template-01';
        $template = is_string($templateKey) && $templateKey !== '' ? $templateKey : 'template-01';

        $design = $settings?->invoiceDesignMerged() ?? [];

        $nf = static fn($v): string => number_format((int) ($v ?? 0), 0, '.', ',');

        // phones
        $phonesArr = $settings?->phones;
        if (is_array($phonesArr)) {
            $list = [];
            if (!empty($phonesArr['main'])) {
                $list[] = $phonesArr['main'];
            }
            if (!empty($phonesArr['support'])) {
                $list[] = $phonesArr['support'];
            }
            $extra = $phonesArr['list'] ?? [];
            if (is_array($extra)) {
                foreach ($extra as $p) {
                    $p = trim((string) $p);
                    if ($p !== '') {
                        $list[] = $p;
                    }
                }
            }
            $list = array_values(array_unique(array_filter($list, fn($v) => trim((string) $v) !== '')));
            $phones = count($list) ? implode(' - ', $list) : '—';
        } else {
            $phones = '—';
        }

        $palette =
            is_object($settings) && method_exists($settings, 'themePaletteOrGenerate')
                ? (array) $settings->themePaletteOrGenerate()
                : [];

        $vars = [
            '--primary' => $palette['base'] ?? '#006837',
            '--primary-400' => $palette['mid'] ?? '#1F7A52',
            '--primary-700' => $palette['dark'] ?? '#00512B',
            '--text' => $palette['ink'] ?? '#0A3326',
            '--text-muted' => $palette['muted'] ?? '#7E8B86',
            '--surface' => $palette['bg'] ?? '#FFFFFF',
            '--surface-field' => $palette['field'] ?? '#E9ECEF',
            '--border' => $palette['border'] ?? '#DDE6E1',
        ];

        $currencyShow = (bool) data_get($design, 'totals.currency.show', true);
        $currencyText = (string) data_get($design, 'totals.currency.text', 'د.ع');

        // ✅ صورة هيدر القالب الحالي
        $headerBgUrl = $settings?->invoiceHeaderBgUrl($template);

        $invoiceVars = [
            'currency_show' => $currencyShow,
            'currency_text' => $currencyText,
            'header_bg_url' => $headerBgUrl,
        ];
    @endphp

    @includeIf("filament.pos.templates.$template", [
        'record' => $record,
        'branch' => $branch,
        'settings' => $settings,
        'design' => $design,
        'phones' => $phones,
        'vars' => $vars,
        'nf' => $nf,

        'templateKey' => $template,
        'invoiceVars' => $invoiceVars,

        'currencyShow' => $currencyShow,
        'currencyText' => $currencyText,

        // ✅ مباشر للقوالب
        'headerBgUrl' => $headerBgUrl,
    ])
</x-filament-panels::page>
