<x-filament-panels::page>
    @php
    // الاشتراك (object/array)
    $sub = user_info('subscription');
    $subGet = function (string $k, $d = null) use ($sub) {
    if (is_object($sub)) return $sub->$k ?? $d;
    if (is_array($sub)) return $sub[$k] ?? $d;
    return $d;
    };

    // الشعار
    $logo = null;
    if ($subGet('logo_url')) {
    $logo = $subGet('logo_url');
    } elseif (is_object($sub) && method_exists($sub, 'getFirstMediaUrl')) {
    $logo = $sub->getFirstMediaUrl('logo') ?: null;
    }

    // التاريخ المطبوع
    $printedAt = \Illuminate\Support\Carbon::parse(
    $record->posted_at ?? $record->period_month ?? now('Asia/Baghdad')
    )->timezone('Asia/Baghdad')->format('Y-m-d');

    // رقم مختصر PR-000001 (id) أو accessor
    $shortNo = method_exists($record, 'getShortNumberAttribute')
    ? $record->short_number
    : sprintf('PR-%06d', (int) $record->id);

    // ألوان من الاشتراك أو افتراضيات
    $vars = is_array($subGet('invoice_css_vars')) ? $subGet('invoice_css_vars') : [
    '--primary' => '#014d31','--primary-400' => '#3DA37A','--primary-700' => '#0C3E2C',
    '--text' => '#101216','--text-muted' => '#7E8B86','--surface' => '#FFFFFF',
    '--surface-field' => '#E9ECEF','--surface-pill' => '#F3F5F4','--border' => '#CFD6DC',
    ];
    $brand = $vars['--primary'] ?? '#014d31';

    // الجهات
    $employeeName = $record->employee->name ?? '—';
    $accountant = auth()->user()->name ?? '—';

    // المجاميع
    $base = (int)($record->base_amount ?? 0);
    $bonus = (int)($record->bonus_total ?? 0);
    $ded = (int)($record->deduction_total ?? 0);
    $advance = (int)($record->advance_applied_total ?? 0);
    $net = (int)($record->net_amount ?? max(0, $base + $bonus - $ded - $advance));
    @endphp

    <style>
        :root {
            --primary: #014d31;
            --primary-400: #3DA37A;
            --primary-700: #0C3E2C;
            --text: #101216;
            --text-muted: #7E8B86;
            --surface: #fff;
            --surface-field: #E9ECEF;
            --surface-pill: #F3F5F4;
            --border: #CFD6DC
        }

        html,
        body {
            background: #fff;
            color: var(--text);
            margin: 0;
            padding: 0
        }

        /* صفحة A4 بنسختين */
        .page {
            position: relative;
            width: 210mm;
            height: 297mm;
            margin: 0 auto;
            background: #fff;
            box-sizing: border-box
        }

        .copy {
            position: absolute;
            left: 0;
            right: 0;
            width: 210mm;
            height: 148.5mm;
            box-sizing: border-box;
            overflow: hidden;
            padding: 10mm
        }

        .copy.top {
            top: 0
        }

        .copy.bottom {
            top: 148.5mm
        }

        .divider {
            position: absolute;
            left: 10mm;
            right: 10mm;
            top: 148.5mm;
            height: 0;
            border-top: 2px dashed var(--border)
        }

        .voucher {
            position: relative;
            width: 100%;
            height: 100%;
            border-radius: 8px;
            overflow: hidden
        }

        .side {
            position: absolute;
            top: 0;
            width: 5mm;
            background: var(--primary)
        }

        .side.left {
            left: 0;
            height: 20%
        }

        .pad {
            padding: 2mm 10mm;
            height: 100%;
            box-sizing: border-box
        }

        /* ===== Header ===== */
        .header {
            display: grid;
            grid-template-columns: 1fr auto 1fr;
            align-items: center
        }

        .ar-title {
            font-size: 28px;
            font-weight: 900;
            text-align: right
        }

        .date-wrap {
            margin-top: 8px;
            text-align: right
        }

        .date-label {
            display: inline-block;
            background: var(--primary);
            color: #fff;
            border-radius: 6px;
            padding: 4px 10px;
            font-weight: 800;
            margin-inline-start: 8px
        }

        .date-field {
            display: inline-block;
            border: 1px solid var(--border);
            border-radius: 6px;
            padding: 4px 10px;
            min-width: 120px;
            text-align: center;
            font-weight: 700
        }

        .title-en {
            font-weight: 900;
            font-size: 18px;
        }

        .no-under {
            display: inline-block;
            margin-top: 8px;
            padding: 6px 14px;
            border: 1px solid var(--border);
            border-radius: 12px;
            background: var(--surface);
            font-weight: 900;
            letter-spacing: 1px;
            direction: ltr
        }

        .logo {
            width: 56px;
            height: 56px;
            border: 1px solid var(--border);
            border-radius: 12px;
            margin: 0 auto;
            display: grid;
            place-items: center;
            overflow: hidden
        }

        .logo img {
            width: 100%;
            height: 100%;
            object-fit: contain
        }

        .sep {
            border-bottom: 2px dotted #0003;
            margin: 14px 0
        }

        /* ===== Body ===== */
        .grid-2 {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 12px
        }

        .box {
            border: 1px solid var(--border);
            border-radius: 10px;
            padding: 12px
        }

        .label {
            color: var(--text-muted);
            font-weight: 700;
            margin-bottom: 6px
        }

        .pill {
            background: var(--surface-pill);
            border-radius: 14px;
            padding: 10px 16px;
            font-weight: 800
        }

        /* مجاميع بشكل GRID */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 12px;
            margin-top: 12px
        }

        .stat {
            border: 1px solid var(--border);
            border-radius: 12px;
            padding: 12px 14px
        }

        .stat .t {
            color: var(--text-muted);
            font-weight: 700;
            margin-bottom: 6px
        }

        .stat .v {
            font-weight: 900;
            font-size: 16px
        }

        .stat.net {
            border-color: var(--primary);
            box-shadow: 0 0 0 2px #0000
        }

        .stat.net .t {
            color: var(--primary)
        }

        .stat.net .v {
            font-size: 18px
        }

        .sigs {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 24px;
            margin-top: 14px
        }

        .sig {
            text-align: center
        }

        .sig .title {
            font-weight: 900
        }

        .sig .name {
            color: var(--text-muted);
            margin-top: 6px
        }

        .sig .line {
            border-bottom: 2px dotted #0003;
            height: 24px;
            margin-top: 8px
        }

        .action-bar {
            margin-top: 10px;
            display: flex;
            justify-content: center;
            gap: 12px
        }

        .btn {
            appearance: none;
            border: 2px solid var(--primary);
            padding: 8px 16px;
            border-radius: 10px;
            font-weight: 800;
            background: #fff;
            color: var(--primary);
            text-decoration: none;
            cursor: pointer
        }

        .btn.primary {
            background: var(--primary);
            color: #fff
        }

        .receipt {
            text-align: left
        }

        .print-area {
            position: relative;
            background: #fff
        }

        @media print {
            @page {
                size: 210mm 297mm;
                margin: 0
            }

            .fi-header,
            .fi-topbar,
            .fi-sidebar,
            .fi-breadcrumbs,
            .fi-footer,
            .fi-global-search,
            .fi-notifications,
            .fi-sidebar-close-overlay,
            [class*="overlay"],
            [class*="Overlay"],
            .fi-modal,
            .fi-panels-modal,
            .action-bar {
                display: none !important
            }

            body * {
                visibility: hidden !important
            }

            .print-area,
            .print-area * {
                visibility: visible !important
            }

            .print-area {
                position: fixed !important;
                inset: 0 !important;
                margin: 0 !important;
                background: #fff !important;
                z-index: 9999 !important
            }

            .page,
            .copy,
            .voucher,
            .pad {
                page-break-inside: avoid
            }

            * {
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact
            }

            html,
            body {
                background: #fff
            }
        }
    </style>

    <div class="print-area" style="
        --primary: {{ $vars['--primary'] }};
        --primary-400: {{ $vars['--primary-400'] }};
        --primary-700: {{ $vars['--primary-700'] }};
        --text: {{ $vars['--text'] }};
        --text-muted: {{ $vars['--text-muted'] }};
        --surface: {{ $vars['--surface'] }};
        --surface-field: {{ $vars['--surface-field'] }};
        --surface-pill: {{ $vars['--surface-pill'] }};
        --border: {{ $vars['--border'] }};
    ">
        <div class="page">
            @foreach (['top','bottom'] as $pos)
            <div class="copy {{ $pos }}">
                <div class="voucher">
                    <div class="side left"></div>
                    <div class="pad">
                        <div class="header">
                            <div>
                                <div class="ar-title">وصل استلام الراتب</div>
                                <div class="date-wrap">
                                    <span class="date-label">التاريخ</span>
                                    <span class="date-field">{{ $printedAt }}</span>
                                </div>
                            </div>
                            <div>
                                <div class="logo">
                                    @if ($logo)
                                    <img src="{{ $logo }}" alt="logo">
                                    @else
                                    <svg viewBox="0 0 64 64" width="64" height="64" aria-hidden="true">
                                        <circle cx="32" cy="32" r="28" fill="#e7eaeb" />
                                        <path d="M20 36l8-16 8 16" stroke="{{ $brand }}" fill="none" stroke-width="3" />
                                    </svg>
                                    @endif
                                </div>
                            </div>
                            <div class="receipt">
                                <div class="title-en">PAYROLL RECEIPT</div>
                                <div class="no-under">{{ $shortNo }}</div>
                            </div>
                        </div>

                        <div class="sep"></div>

                        <div class="grid-2">
                            <div class="box">
                                <div class="label"> المحاسب</div>
                                <div class="pill">{{ $accountant }}</div>
                            </div>
                            <div class="box">
                                <div class="label"> الموظف</div>
                                <div class="pill">{{ $employeeName }}</div>
                            </div>
                        </div>

                        <!-- أزلنا "فترة الراتب" كما طلبت -->

                        <!-- GRID للقيم المالية -->
                        <div class="stats-grid">
                            <div class="stat">
                                <div class="t">الراتب الأساسي</div>
                                <div class="v">{{ number_format($base) }}</div>
                            </div>
                            <div class="stat">
                                <div class="t">إجمالي المكافآت</div>
                                <div class="v">{{ number_format($bonus) }}</div>
                            </div>
                            <div class="stat">
                                <div class="t">إجمالي الخصومات</div>
                                <div class="v">{{ number_format($ded) }}</div>
                            </div>
                            <div class="stat">
                                <div class="t">اقتطاعات السُلف</div>
                                <div class="v">{{ number_format($advance) }}</div>
                            </div>
                            <div class="stat net" style="grid-column: span 2">
                                <div class="t">الصافي المستلم</div>
                                <div class="v">{{ number_format($net) }}</div>
                            </div>
                        </div>

                        <div class="sigs">
                            <div class="sig">
                                <div class="title">الموظف المستلم</div>
                                <div class="name"></div>
                                <div class="line"></div>
                            </div>
                            <div class="sig">
                                <div class="title">المحاسب</div>
                                <div class="name"></div>
                                <div class="line"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @endforeach

            <div class="divider" aria-hidden="true"></div>
        </div>
    </div>

    <div class="action-bar no-print">
        <button class="btn primary" onclick="window.print()">🖨️ طباعة</button>
        <a class="btn"
            href="{{ \App\Filament\Resources\EmployeePayrolls\EmployeePayrollResource::getUrl('index') }}">العودة</a>
    </div>
</x-filament-panels::page>