<x-filament-panels::page>
    @php
        /** @var \App\Models\Invoice $record */
        $record = $this->record;

        // ========== الفرع وإعداداته ==========
        /** @var \App\Models\Branch|null $branch */
        $branch = $record->branch ?? null;

        /** @var \App\Models\BranchSetting|null $settings */
        $settings = $branch?->settings ?? null;

        $logoLight = $settings?->logo_light_url;
        $logoDark = $settings?->logo_dark_url ?: $logoLight;

        $branchName = $branch?->name ?? '—';

        // العنوان والهواتف من إعدادات الفرع (بدل الثابت)
        $address = (string) ($settings?->address ?? '—');

        // phones: ممكن يكون JSON (array) أو null
        $phonesArr = $settings?->phones;
        if (is_array($phonesArr)) {
            // دعم أكثر من صيغة
            $phonesList = array_values(
                array_filter([
                    $phonesArr['main'] ?? null,
                    $phonesArr['support'] ?? null,
                    ...array_filter(is_array($phonesArr['list'] ?? null) ? $phonesArr['list'] : []),
                ]),
            );
            $phones = count($phonesList) ? implode(' - ', $phonesList) : '—';
        } else {
            $phones = '—';
        }

        // ========== إعدادات تصميم الفاتورة ==========
        $design = $settings?->invoiceDesignOrDefault() ?? [
            'header' => [
                'background' => ['type' => 'none', 'color' => '#FFFFFF'],
                'slots' => [
                    'right' => ['logo', 'branch_name', 'branch_meta'],
                    'center' => [],
                    'left' => ['invoice_title', 'invoice_number', 'invoice_date'],
                ],
            ],
        ];

        $headerBgType = data_get($design, 'header.background.type', 'none'); // none|color|image
        $headerBgColor = data_get($design, 'header.background.color', '#FFFFFF');
        $headerBgImage = $settings?->invoice_header_bg_url;

        $slots = data_get($design, 'header.slots', []);
        $slotsRight = is_array($slots['right'] ?? null) ? $slots['right'] : [];
        $slotsCenter = is_array($slots['center'] ?? null) ? $slots['center'] : [];
        $slotsLeft = is_array($slots['left'] ?? null) ? $slots['left'] : [];

        // ========== ألوان الفاتورة ==========
        $invoiceCss = $settings?->invoice_css_vars ?? [];
        $vars = [
            '--primary' => $invoiceCss['--primary'] ?? ($invoiceCss['--primary-400'] ?? '#C9A961'),
            '--primary-400' => $invoiceCss['--primary-400'] ?? ($invoiceCss['--primary'] ?? '#E5C66B'),
            '--primary-700' => $invoiceCss['--primary-700'] ?? '#B08B33',
            '--text' => $invoiceCss['--text'] ?? '#3F3A2B',
            '--text-muted' => $invoiceCss['--text-muted'] ?? '#8B8B8B',
            '--surface' => $invoiceCss['--surface'] ?? '#FFFFFF',
            '--surface-field' => $invoiceCss['--surface-field'] ?? '#F3F5F4',
            '--surface-pill' => $invoiceCss['--surface-pill'] ?? '#FBF6E9',
            '--border' => $invoiceCss['--border'] ?? '#E5D9B3',
        ];

        // ========== بيانات الفاتورة ==========
        $invoiceNumber = $record->invoice_number ?? '—';
        $invoiceDate = $record->invoice_date
            ? \Illuminate\Support\Carbon::parse($record->invoice_date)->format('Y-m-d')
            : '—';

        $clientName = $record->client->name ?? '—';
        $clientPhone = $record->client->phone ?? '—';
        $clientAddress = $record->client->address ?? '—';

        // تنسيق أرقام صحيحة فقط
        $nf = fn($v) => number_format((int) ($v ?? 0), 0, '.', ',');

        // عناصر الفاتورة
        $itemsCollection = method_exists($record, 'items')
            ? $record->items
            : (method_exists($record, 'invoiceItems')
                ? $record->invoiceItems
                : collect());

        $itemsCount = $itemsCollection->count();
        $maxItemsPerPage = 10;
        $pages = $itemsCollection->chunk($maxItemsPerPage);
        $totalPages = max(1, $pages->count());
        $showPageNumbers = $itemsCount > $maxItemsPerPage;

        // ========== المجاميع ==========
        $subtotal = (int) ($record->subtotal ?? 0);
        $discount = (int) ($record->discount_total ?? 0);
        $shipping = (int) ($record->shipping_total ?? 0);
        $grandTotal = (int) ($record->grand_total ?? max($subtotal - $discount + $shipping, 0));
        $required = $grandTotal;

        $paid = (int) ($record->paid_amount ?? ($record->paid_total ?? 0));
        $remaining = (int) ($record->due_amount ?? max($grandTotal - $paid, 0));
        $clientDebts = (int) ($record->client?->total_debt ?? 0);

        // ========== QR ==========
        $qrPayload = [
            'invoice_number' => $invoiceNumber,
            'invoice_date' => $invoiceDate,
            'amount' => $grandTotal,
            'branch' => $branchName,
        ];
        $qrText = json_encode($qrPayload, JSON_UNESCAPED_UNICODE);

        // ========== Renderer لبلوكات الهيدر ==========
        $renderBlock = function (string $block) use (
            $logoLight,
            $branchName,
            $address,
            $phones,
            $invoiceNumber,
            $invoiceDate,
        ) {
            return match ($block) {
                'logo' => '
                    <div class="brand-row" style="justify-content:flex-start;">
                        <div class="logo-circle">
                            ' .
                    ($logoLight
                        ? '<img src="' . e($logoLight) . '" alt="' . e($branchName) . '">'
                        : '<div class="logo-fallback">' . e(mb_substr($branchName, 0, 2)) . '</div>') .
                    '
                        </div>
                    </div>
                ',
                'branch_name' => '<div class="brand-name">' . e($branchName) . '</div>',
                'branch_meta' => '
                    <div class="brand-meta">
                        <span><span class="meta-dot"></span>' .
                    e($address) .
                    '</span>
                        <span><span class="meta-dot"></span><span class="ltr">' .
                    e($phones) .
                    '</span></span>
                    </div>
                ',
                'invoice_title' => '<div class="invoice-title">فاتورة بيع</div>',
                'invoice_number' => '
                    <div class="invoice-number">
                        <span class="label">No.</span>
                        <span>' .
                    e($invoiceNumber) .
                    '</span>
                    </div>
                ',
                'invoice_date' => '
                    <div class="invoice-date-pill">
                        <span class="label">التاريخ</span>
                        <span>' .
                    e($invoiceDate) .
                    '</span>
                    </div>
                ',
                default => '',
            };
        };
    @endphp

    <style>
        @import url('https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;600;700;800;900&display=swap');

        :root {
            --primary: {{ $vars['--primary'] }};
            --primary-400: {{ $vars['--primary-400'] }};
            --primary-700: {{ $vars['--primary-700'] }};
            --text: {{ $vars['--text'] }};
            --text-muted: {{ $vars['--text-muted'] }};
            --surface: {{ $vars['--surface'] }};
            --surface-field: {{ $vars['--surface-field'] }};
            --surface-pill: {{ $vars['--surface-pill'] }};
            --border: {{ $vars['--border'] }};
        }

        * {
            box-sizing: border-box;
        }

        html,
        body {
            margin: 0;
            padding: 0;
            color: var(--text);
            direction: rtl;
            font-family: 'Tajawal', system-ui, -apple-system, 'Segoe UI', sans-serif;
            -webkit-print-color-adjust: exact;
            print-color-adjust: exact;
        }

        .fi-page-main {
            background: transparent;
        }

        .invoice-root {
            max-width: 210mm;
            margin: 4mm auto 8mm;
            padding: 0;
        }

        .invoice-sheet {
            width: 210mm;
            min-height: 297mm;
            background: var(--surface);
            border-radius: 18px;
            border: 1px solid rgba(15, 23, 42, 0.08);
            box-shadow:
                0 16px 40px rgba(15, 23, 42, 0.10),
                0 6px 18px rgba(15, 23, 42, 0.06),
                inset 0 1px 0 rgba(255, 255, 255, 0.9);
            overflow: hidden;
            position: relative;
            page-break-after: always;
        }

        .invoice-sheet:last-of-type {
            page-break-after: auto;
        }

        .invoice-sheet::before {
            content: "";
            position: absolute;
            inset-inline-start: 0;
            top: 0;
            width: 9mm;
            height: 100%;
            background: linear-gradient(180deg,
                    var(--primary-700) 0%,
                    var(--primary) 50%,
                    var(--primary-700) 100%);
        }

        .invoice-body {
            padding: 5mm 12mm 8mm 8mm;
            display: flex;
            flex-direction: column;
            min-height: 297mm;
            position: relative;
            z-index: 1;
        }

        /* ===== HEADER (UPDATED) ===== */
        .header {
            display: grid;
            grid-template-columns: 1fr 1fr 1fr;
            gap: 6mm;
            align-items: center;
            padding-bottom: 5mm;
            border-bottom: 1.5px solid var(--border);
            position: relative;
            border-radius: 14px;
            overflow: hidden;
        }

        .header::after {
            content: "";
            position: absolute;
            bottom: -1.5px;
            right: 0;
            width: 35%;
            height: 1.5px;
            background: linear-gradient(to left, var(--primary-400), transparent);
            z-index: 2;
        }

        .header-bg {
            position: absolute;
            inset: 0;
            z-index: 0;
        }

        .header-bg .bg-color {
            width: 100%;
            height: 100%;
        }

        .header-bg .bg-image {
            width: 100%;
            height: 100%;
            background-size: cover;
            background-position: center;
            opacity: .18;
        }

        .header-slot {
            min-height: 32mm;
            display: flex;
            flex-direction: column;
            justify-content: center;
            gap: 2.5mm;
            position: relative;
            z-index: 1;
        }

        .header-slot.right {
            align-items: flex-start;
            text-align: right;
        }

        .header-slot.center {
            align-items: center;
            text-align: center;
        }

        .header-slot.left {
            align-items: flex-end;
            text-align: left;
        }

        .brand-row {
            display: flex;
            align-items: center;
            gap: 6mm;
        }

        .logo-circle {
            width: 30mm;
            height: 30mm;
            border-radius: 18px;
            border: 3px solid var(--primary-400);
            box-shadow:
                0 6px 20px rgba(0, 0, 0, 0.12),
                0 0 0 5px rgba(201, 169, 97, 0.18),
                inset 0 2px 4px rgba(255, 255, 255, 0.8);
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
            background: linear-gradient(135deg, #ffffff 0%, #f9fafb 100%);
        }

        .logo-circle img {
            max-width: 82%;
            max-height: 82%;
            object-fit: contain;
        }

        .logo-fallback {
            font-size: 20px;
            font-weight: 900;
            background: linear-gradient(135deg, var(--primary-700), var(--primary));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .brand-name {
            font-size: 22px;
            font-weight: 900;
            background: linear-gradient(135deg, var(--primary-700), var(--primary));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .brand-meta {
            display: flex;
            flex-direction: column;
            gap: 1mm;
            font-size: 9px;
            color: var(--text-muted);
        }

        .brand-meta span {
            display: flex;
            align-items: center;
            gap: 2mm;
        }

        .meta-dot {
            width: 6px;
            height: 6px;
            border-radius: 999px;
            background: var(--primary-400);
        }

        .invoice-title {
            font-size: 23px;
            font-weight: 900;
            background: linear-gradient(135deg, var(--primary-700), var(--primary-400));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .invoice-number {
            display: inline-flex;
            align-items: center;
            justify-content: space-between;
            gap: 3mm;
            padding: 3px 12px;
            border-radius: 999px;
            background: linear-gradient(135deg, var(--primary-400), var(--primary));
            color: #fff;
            font-size: 11px;
            font-weight: 800;
            min-width: 145px;
        }

        .invoice-number span.label {
            background: #fff;
            color: var(--primary-700);
            border-radius: 999px;
            padding: 1px 9px;
            font-size: 10px;
            font-weight: 800;
        }

        .invoice-date-pill {
            display: inline-flex;
            align-items: center;
            justify-content: space-between;
            gap: 3mm;
            padding: 3px 12px;
            border-radius: 999px;
            border: 2px solid var(--primary-400);
            background: linear-gradient(135deg,
                    rgba(201, 169, 97, 0.08),
                    rgba(201, 169, 97, 0.12));
            font-size: 10px;
            font-weight: 700;
            color: var(--primary-700);
            min-width: 145px;
        }

        .invoice-date-pill span.label {
            background: var(--primary-400);
            color: #fff;
            border-radius: 999px;
            padding: 1px 9px;
            font-size: 10px;
            font-weight: 800;
        }

        .ltr {
            direction: ltr;
            unicode-bidi: bidi-override;
        }

        /* ===== CLIENT BAR ===== */
        .client-bar {
            margin-top: 5mm;
            padding: 4mm 5mm;
            border-radius: 999px;
            background: #fbf6e9;
            border: 1px solid rgba(201, 169, 97, 0.45);
            display: grid;
            grid-template-columns: 1.5fr 1.1fr 1.4fr;
            gap: 3mm;
            font-size: 10px;
            align-items: center;
        }

        .client-item {
            display: flex;
            align-items: center;
            gap: 2.5mm;
        }

        .client-label {
            font-weight: 800;
            color: var(--primary-700);
            white-space: nowrap;
        }

        .client-value {
            font-weight: 700;
            color: var(--text);
            min-width: 0;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }

        /* ===== MAIN AREA ===== */
        .main-area {
            margin-top: 3mm;
            display: flex;
            flex-direction: column;
            gap: 3mm;
            flex: 1;
        }

        .items-card {
            border-radius: 14px;
            border: 1px solid var(--border);
            background: #fff;
            overflow: hidden;
        }

        table.invoice-table {
            width: 100%;
            border-collapse: collapse;
        }

        table.invoice-table thead th {
            background: #faf3de;
            font-size: 9px;
            font-weight: 800;
            color: #5b5134;
            text-align: center;
            padding: 2.5mm 2mm;
            border-bottom: 1.5px solid var(--border);
        }

        table.invoice-table thead th span.en {
            display: block;
            font-size: 7px;
            font-weight: 700;
            color: #9ca3af;
            margin-top: 1px;
        }

        table.invoice-table tbody td {
            font-size: 8.5px;
            font-weight: 700;
            padding: 2.4mm 1.8mm;
            border-bottom: 1px dashed rgba(148, 131, 96, 0.35);
            text-align: center;
            color: #4b5563;
        }

        table.invoice-table tbody tr:nth-child(even) td {
            background: #fdfaf2;
        }

        table.invoice-table tbody td.item-name {
            text-align: right;
        }

        table.invoice-table tfoot td {
            padding: 3mm 2.2mm;
            font-size: 9px;
            font-weight: 800;
            background: #faf3de;
            border-top: 1.5px solid var(--border);
        }

        table.invoice-table tfoot .total-label {
            text-align: right;
            color: var(--primary-700);
        }

        table.invoice-table tfoot .total-value {
            text-align: left;
        }

        /* ===== TOTALS & NOTE + QR ===== */
        .bottom-grid {
            display: grid;
            grid-template-columns: 1.1fr 1fr;
            gap: 6mm;
            align-items: stretch;
        }

        .totals-box,
        .note-column {
            height: 100%;
        }

        .totals-box {
            border-radius: 12px;
            border: 1px solid var(--border);
            background: #fffdf6;
            padding: 4mm 5mm;
            display: flex;
            flex-direction: column;
            gap: 2mm;
        }

        .totals-title {
            font-size: 11px;
            font-weight: 800;
            color: var(--primary-700);
            margin-bottom: 2mm;
            padding-bottom: 2mm;
            border-bottom: 1.5px solid var(--border);
        }

        .total-row {
            display: grid;
            grid-template-columns: 1.2fr auto;
            gap: 4mm;
            font-size: 9px;
            align-items: center;
            padding: 1.3mm 0;
        }

        .total-row .label {
            text-align: right;
            color: var(--text-muted);
            font-weight: 700;
        }

        .total-row .value {
            text-align: left;
            font-weight: 800;
            color: #111827;
        }

        .total-row.highlight {
            background: #fbf1cf;
            border-radius: 7px;
            padding: 1.6mm 3mm;
            margin-top: 1mm;
        }

        .total-row.highlight .label {
            color: var(--primary-700);
        }

        .total-row+.total-row {
            border-top: 1px dashed rgba(148, 131, 96, 0.35);
            padding-top: 2mm;
        }

        .note-column {
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            gap: 4mm;
        }

        .note-box {
            border-radius: 12px;
            border: 1.5px dashed #f59e0b;
            background: #fffbeb;
            padding: 4mm 5mm;
            font-size: 9px;
            color: #92400e;
        }

        .note-title {
            font-weight: 800;
            margin-bottom: 2mm;
            font-size: 10px;
            color: #78350f;
        }

        .note-text {
            font-weight: 700;
            line-height: 1.7;
        }

        .qr-section {
            border-radius: 14px;
            border: 1.5px solid var(--border);
            background: #fdf7e9;
            padding: 4mm 5mm;
            display: grid;
            grid-template-columns: 1fr auto;
            align-items: center;
            gap: 4mm;
        }

        .qr-label {
            font-size: 9px;
            font-weight: 800;
            color: #1f2937;
            text-align: right;
            line-height: 1.6;
        }

        .qr-label span {
            display: inline-block;
            padding: 3px 9px;
            border-radius: 999px;
            background: #b08b33;
            color: #fff;
            font-size: 9px;
        }

        .qr-image-wrapper {
            width: 32mm;
            height: 32mm;
            border-radius: 12px;
            border: 1.5px dashed var(--border);
            background: #ffffff;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .qr-image svg,
        .qr-image img {
            width: 80%;
            height: 80%;
        }

        /* ===== FOOTER ===== */
        .footer-bar {
            margin-top: auto;
            padding-top: 4mm;
            border-top: none;
            display: flex;
            flex-direction: column;
            gap: 4mm;
            font-size: 8.5px;
            color: #6b7280;
            align-items: stretch;
        }

        .footer-signatures {
            display: flex;
            justify-content: center;
            gap: 14mm;
        }

        .sign-block {
            text-align: center;
            min-width: 50mm;
        }

        .sign-title {
            font-weight: 900;
            color: var(--primary-700);
            font-size: 12px;
        }

        .sign-sub {
            font-size: 8px;
            font-weight: 700;
            color: var(--primary-400);
        }

        .sign-line {
            margin-top: 4mm;
            border-top: 1.5px solid var(--border);
            padding-top: 2mm;
            font-size: 8px;
            color: #4b5563;
            font-weight: 700;
        }

        .page-number {
            margin-top: 2mm;
            text-align: center;
            font-size: 8px;
            color: #9ca3af;
        }

        .action-buttons {
            max-width: 210mm;
            margin: 0 auto 16px;
            display: flex;
            justify-content: center;
            gap: 10px;
        }

        .btn {
            appearance: none;
            border-radius: 999px;
            padding: 8px 18px;
            font-size: 13px;
            font-weight: 800;
            cursor: pointer;
            border-width: 2px;
            border-style: solid;
            display: inline-flex;
            align-items: center;
            gap: 6px;
            text-decoration: none;
        }

        .btn.primary {
            border-color: var(--primary-700);
            background: var(--primary-700);
            color: #fff;
        }

        .btn.secondary {
            border-color: var(--primary-700);
            background: #fff;
            color: var(--primary-700);
        }

        /* ===== الطباعة ===== */
        @media print {
            @page {
                size: A4 portrait;
                margin: 0;
            }

            html,
            body {
                margin: 0 !important;
                padding: 0 !important;
                width: 210mm !important;
                background: #ffffff !important;
                -webkit-print-color-adjust: exact !important;
                print-color-adjust: exact !important;
            }

            .fi-sidebar,
            .fi-topbar,
            .fi-header,
            .fi-breadcrumbs,
            .action-buttons {
                display: none !important;
            }

            .fi-main,
            .fi-main>div,
            .fi-page,
            .fi-page-main {
                margin: 0 !important;
                padding: 0 !important;
                background: #ffffff !important;
                box-shadow: none !important;
            }

            body * {
                visibility: hidden !important;
            }

            .invoice-root,
            .invoice-root * {
                visibility: visible !important;
            }

            .invoice-root {
                width: 210mm !important;
                max-width: 210mm !important;
                margin: 0 !important;
                padding: 0 !important;
                position: absolute;
                top: 0;
                left: 0;
            }

            .invoice-sheet {
                width: 210mm !important;
                min-height: auto !important;
                margin: 0 !important;
                padding: 0 !important;
                border-radius: 0 !important;
                box-shadow: none !important;
                border: none !important;
                page-break-before: auto !important;
                page-break-after: always !important;
                page-break-inside: avoid !important;
            }

            .invoice-sheet:last-of-type {
                page-break-after: auto !important;
            }

            .invoice-sheet::before {
                content: "";
                position: absolute;
                inset-inline-start: 0;
                top: 0;
                width: 9mm;
                height: 100%;
                background: linear-gradient(180deg,
                        var(--primary-700) 0%,
                        var(--primary) 50%,
                        var(--primary-700) 100%);
            }

            .invoice-body {
                background: transparent !important;
                margin: 0 !important;
                padding: 5mm 12mm 8mm 8mm !important;
                height: auto !important;
                min-height: auto !important;
            }
        }
    </style>

    <div
        style="
            --primary:       {{ $vars['--primary'] }};
            --primary-400:   {{ $vars['--primary-400'] }};
            --primary-700:   {{ $vars['--primary-700'] }};
            --text:          {{ $vars['--text'] }};
            --text-muted:    {{ $vars['--text-muted'] }};
            --surface:       {{ $vars['--surface'] }};
            --surface-field: {{ $vars['--surface-field'] }};
            --surface-pill:  {{ $vars['--surface-pill'] }};
            --border:        {{ $vars['--border'] }};
        ">
        <div class="invoice-root">
            @php $pageIndex = 0; @endphp

            @forelse ($pages as $chunk)
                @php $pageIndex++; @endphp

                <div class="invoice-sheet">
                    <div class="invoice-body">

                        {{-- HEADER (UPDATED: background + slots) --}}
                        <div class="header">

                            <div class="header-bg">
                                @if ($headerBgType === 'color')
                                    <div class="bg-color" style="background: {{ $headerBgColor }};"></div>
                                @elseif ($headerBgType === 'image' && $headerBgImage)
                                    <div class="bg-image" style="background-image: url('{{ $headerBgImage }}');"></div>
                                @else
                                    <div class="bg-color" style="background: transparent;"></div>
                                @endif
                            </div>

                            <div class="header-slot right">
                                @foreach ($slotsRight as $b)
                                    {!! $renderBlock((string) $b) !!}
                                @endforeach
                            </div>

                            <div class="header-slot center">
                                @foreach ($slotsCenter as $b)
                                    {!! $renderBlock((string) $b) !!}
                                @endforeach
                            </div>

                            <div class="header-slot left">
                                @foreach ($slotsLeft as $b)
                                    {!! $renderBlock((string) $b) !!}
                                @endforeach
                            </div>
                        </div>

                        {{-- CLIENT BAR --}}
                        <div class="client-bar">
                            <div class="client-item">
                                <span class="client-label">اسم العميل:</span>
                                <span class="client-value">{{ $clientName }}</span>
                            </div>
                            <div class="client-item">
                                <span class="client-label">الهاتف:</span>
                                <span class="client-value ltr">{{ $clientPhone }}</span>
                            </div>
                            <div class="client-item">
                                <span class="client-label">العنوان:</span>
                                <span class="client-value">{{ $clientAddress }}</span>
                            </div>
                        </div>

                        {{-- MAIN AREA --}}
                        <div class="main-area">
                            {{-- TABLE --}}
                            <div class="items-card">
                                <table class="invoice-table">
                                    <thead>
                                        <tr>
                                            <th style="width: 6%;">ت<span class="en">No.</span></th>
                                            <th style="width: 38%;">المادة<span class="en">Item</span></th>
                                            <th style="width: 14%;">القياس<span class="en">Measurement</span></th>
                                            <th style="width: 16%;">سعر المتر / القطعة<span class="en">Unit
                                                    Price</span></th>
                                            <th style="width: 10%;">الكمية<span class="en">Qty</span></th>
                                            <th style="width: 16%;">المجموع<span class="en">Total</span></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse ($chunk as $i => $item)
                                            @php
                                                $rowNumber = ($pageIndex - 1) * $maxItemsPerPage + $i + 1;

                                                $materialName =
                                                    $item->productVariant?->product?->name ??
                                                    ($item->product?->name ??
                                                        ($item->material?->name ?? ($item->notes ?? '—')));

                                                $measurement = (float) ($item->measurement ?? 0);
                                                if ($measurement > 0) {
                                                    $measurementValue = rtrim(
                                                        rtrim(number_format($measurement, 2, '.', ''), '0'),
                                                        '.',
                                                    );
                                                } else {
                                                    $measurementValue =
                                                        $item->productVariant?->size ??
                                                        (data_get($item, 'size') ?? '—');
                                                }

                                                $qty = (int) ($item->quantity ?? 0);
                                                $unitPrice = (int) ($item->unit_price ?? 0);
                                                $lineTotal = (int) ($item->line_total ?? $qty * $unitPrice);
                                            @endphp

                                            <tr>
                                                <td>{{ $rowNumber }}</td>
                                                <td class="item-name">{{ $materialName }}</td>
                                                <td>{{ $measurementValue }}</td>
                                                <td>{{ $nf($unitPrice) }}</td>
                                                <td>{{ $qty }}</td>
                                                <td>{{ $nf($lineTotal) }}</td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="6"
                                                    style="text-align:center;padding:8mm 0;font-size:9px;color:#9ca3af;">
                                                    لا توجد عناصر لهذه الفاتورة
                                                </td>
                                            </tr>
                                        @endforelse
                                    </tbody>

                                    @if ($pageIndex === $pages->count())
                                        <tfoot>
                                            <tr>
                                                <td colspan="5" class="total-label">المجموع الكلي المستحق:</td>
                                                <td class="total-value">{{ $nf($required) }} د.ع</td>
                                            </tr>
                                        </tfoot>
                                    @endif
                                </table>
                            </div>

                            {{-- TOTALS & NOTE & QR (آخر صفحة فقط) --}}
                            @if ($pageIndex === $pages->count())
                                <div class="bottom-grid">
                                    <div class="totals-box">
                                        <div class="totals-title">ملخص الفاتورة</div>

                                        <div class="total-row">
                                            <div class="label">أجور التوصيل:</div>
                                            <div class="value">{{ $nf($shipping) }} د.ع</div>
                                        </div>

                                        <div class="total-row">
                                            <div class="label">الخصم:</div>
                                            <div class="value">{{ $nf($discount) }} د.ع</div>
                                        </div>

                                        <div class="total-row">
                                            <div class="label">المدفوع:</div>
                                            <div class="value">{{ $nf($paid) }} د.ع</div>
                                        </div>

                                        <div class="total-row highlight">
                                            <div class="label">المتبقي على هذه الفاتورة:</div>
                                            <div class="value">{{ $nf($remaining) }} د.ع</div>
                                        </div>

                                        <div class="total-row highlight">
                                            <div class="label">إجمالي ديون العميل بعد الفاتورة:</div>
                                            <div class="value">{{ $nf($clientDebts) }} د.ع</div>
                                        </div>
                                    </div>

                                    <div class="note-column">
                                        <div class="note-box">
                                            <div class="note-title">ملاحظات:</div>
                                            <div class="note-text">
                                                @if ($record->notes)
                                                    {!! nl2br(e($record->notes)) !!}
                                                @else
                                                    • يرجى التحقق من البضاعة ومطابقة المواصفات قبل المغادرة.<br>
                                                    • تعتبر هذه الفاتورة مرجعاً رسمياً للطرفين في حال حدوث أي خلاف
                                                    تجاري.
                                                @endif
                                            </div>
                                        </div>

                                        <div class="qr-section">
                                            <div class="qr-label">
                                                <span>رمز التحقق QR</span>
                                                <br>
                                                <p style="font-size:8px;font-weight:600;margin-top:5px;color:#4b5563;">
                                                    امسح الرمز للتحقق من صحة الفاتورة
                                                </p>
                                            </div>
                                            <div class="qr-image-wrapper">
                                                <div class="qr-image">
                                                    @if (class_exists(\SimpleSoftwareIO\QrCode\Facades\QrCode::class))
                                                        {!! \SimpleSoftwareIO\QrCode::size(90)->margin(1)->generate($qrText) !!}
                                                    @else
                                                        <div
                                                            style="width:70%;height:70%;border:1px dashed var(--border);border-radius:6px;">
                                                        </div>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>

                        {{-- FOOTER --}}
                        <div class="footer-bar">
                            <div class="footer-signatures">
                                <div class="sign-block">
                                    <div class="sign-title">المستلم</div>
                                    <div class="sign-sub">Receiver</div>
                                    <div class="sign-line">الاسم الثلاثي / التوقيع</div>
                                </div>
                                <div class="sign-block">
                                    <div class="sign-title">الموظف</div>
                                    <div class="sign-sub">Employee</div>
                                    <div class="sign-line">الاسم الثلاثي / التوقيع</div>
                                </div>
                            </div>

                            @if ($showPageNumbers)
                                <div class="page-number">
                                    صفحة {{ $pageIndex }} من {{ $totalPages }}
                                </div>
                            @endif
                        </div>

                    </div>
                </div>
            @empty
                <div class="invoice-sheet">
                    <div class="invoice-body" style="display:flex;align-items:center;justify-content:center;">
                        <div style="text-align:center;color:#9ca3af;font-size:13px;">
                            لا توجد عناصر لهذه الفاتورة
                        </div>
                    </div>
                </div>
            @endforelse
        </div>

        <div class="action-buttons">
            <a href="{{ \App\Filament\Resources\Pos\PosResource::getUrl('index') }}" class="btn secondary">
                ↩︎ رجوع إلى الفواتير
            </a>
            <button type="button" onclick="window.print()" class="btn primary">
                🖨️ طباعة الفاتورة
            </button>
        </div>
    </div>
</x-filament-panels::page>
