<x-filament-panels::page>
    @php
        $filters = [];

        if (property_exists($this, 'filters') && is_array($this->filters ?? null)) {
            $filters = $this->filters ?? [];
        } elseif (property_exists($this, 'pageFilters') && is_array($this->pageFilters ?? null)) {
            $filters = $this->pageFilters ?? [];
        }

        $dateRange = $filters['dateRange'] ?? 'today';
        $now = \Carbon\Carbon::now();

        // أسبوع العراق (سبت -> جمعة)
        $daysSinceSaturday = ($now->dayOfWeek - 6 + 7) % 7;
        $startOfWeekSat = $now->copy()->subDays($daysSinceSaturday)->startOfDay();
        $endOfWeekFri = $startOfWeekSat->copy()->addDays(6)->endOfDay();

        [$from, $to] = match ($dateRange) {
            'today' => [$now->copy()->startOfDay(), $now->copy()->endOfDay()],
            'yesterday' => [$now->copy()->subDay()->startOfDay(), $now->copy()->subDay()->endOfDay()],
            'this_week' => [$startOfWeekSat->copy(), $endOfWeekFri->copy()],
            'last_week' => [$startOfWeekSat->copy()->subWeek(), $endOfWeekFri->copy()->subWeek()],
            'this_month' => [$now->copy()->startOfMonth()->startOfDay(), $now->copy()->endOfMonth()->endOfDay()],
            'last_month' => [
                $now->copy()->subMonth()->startOfMonth()->startOfDay(),
                $now->copy()->subMonth()->endOfMonth()->endOfDay(),
            ],
            'last_7_days' => [$now->copy()->subDays(6)->startOfDay(), $now->copy()->endOfDay()],
            'last_30_days' => [$now->copy()->subDays(29)->startOfDay(), $now->copy()->endOfDay()],
            'last_90_days' => [$now->copy()->subDays(89)->startOfDay(), $now->copy()->endOfDay()],
            'this_year' => [$now->copy()->startOfYear(), $now->copy()->endOfYear()],
            'last_year' => [$now->copy()->subYear()->startOfYear(), $now->copy()->subYear()->endOfYear()],
            'custom' => [
                !empty($filters['startDate'])
                    ? \Carbon\Carbon::parse($filters['startDate'])->startOfDay()
                    : $now->copy()->startOfDay(),
                !empty($filters['endDate'])
                    ? \Carbon\Carbon::parse($filters['endDate'])->endOfDay()
                    : $now->copy()->endOfDay(),
            ],
            'all' => [null, null],
            default => [$now->copy()->startOfDay(), $now->copy()->endOfDay()],
        };

        if ($from && $to && $from->gt($to)) {
            [$from, $to] = [$to->copy()->startOfDay(), $from->copy()->endOfDay()];
        }

        // احصل على اسم الفترة بالعربي
        $periodName = match ($dateRange) {
            'today' => 'اليوم',
            'yesterday' => 'أمس',
            'this_week' => 'هذا الأسبوع',
            'last_week' => 'الأسبوع الماضي',
            'last_7_days' => 'آخر 7 أيام',
            'this_month' => 'الشهر الحالي',
            'last_month' => 'الشهر الماضي',
            'last_30_days' => 'آخر 30 يوم',
            'last_90_days' => 'آخر 90 يوم',
            'this_year' => 'السنة الحالية',
            'last_year' => 'السنة الماضية',
            'custom' => 'فترة مخصصة',
            'all' => 'جميع الفترات',
            default => 'اليوم',
        };
    @endphp

    <style>
        @keyframes slideIn {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .filter-container {
            animation: slideIn 0.3s ease-out;
        }

        .custom-select {
            background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 20 20'%3e%3cpath stroke='%236b7280' stroke-linecap='round' stroke-linejoin='round' stroke-width='1.5' d='M6 8l4 4 4-4'/%3e%3c/svg%3e");
            background-position: left 0.75rem center;
            background-repeat: no-repeat;
            background-size: 1.5em 1.5em;
            padding-left: 2.75rem;
        }

        .dark .custom-select {
            background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 20 20'%3e%3cpath stroke='%239ca3af' stroke-linecap='round' stroke-linejoin='round' stroke-width='1.5' d='M6 8l4 4 4-4'/%3e%3c/svg%3e");
        }
    </style>

    {{-- شريط الفلتر --}}
    <div class="filter-container mb-6">
        <div
            class="overflow-hidden rounded-2xl bg-white shadow-lg ring-1 ring-gray-950/5 dark:bg-gray-900 dark:ring-white/10">
            <div class="flex flex-col gap-6 px-6 py-5 lg:flex-row lg:items-center lg:justify-between">

                {{-- اليسار: الفلاتر --}}
                <div class="flex flex-col gap-4 lg:flex-row lg:items-center">

                    {{-- الفترة الزمنية مع أيقونة إعادة التعيين --}}
                    <div class="flex items-center gap-3">
                        <div class="relative flex-1 lg:w-64">
                            <select wire:model.live="filters.dateRange"
                                class="custom-select w-full appearance-none rounded-xl border-2 border-gray-200 bg-white py-3 pr-4 pl-11
                                       text-sm font-semibold text-gray-900 shadow-sm transition-all
                                       hover:border-primary-400 focus:border-primary-500 focus:ring-2 focus:ring-primary-500/20
                                       dark:border-gray-700 dark:bg-gray-950 dark:text-white dark:hover:border-primary-500">
                                <option value="today">اليوم</option>
                                <option value="yesterday">أمس</option>
                                <option value="this_week">هذا الأسبوع</option>
                                <option value="last_week">الأسبوع الماضي</option>
                                <option value="last_7_days">آخر 7 أيام</option>
                                <option value="this_month">الشهر الحالي</option>
                                <option value="last_month">الشهر الماضي</option>
                                <option value="last_30_days">آخر 30 يوم</option>
                                <option value="last_90_days">آخر 90 يوم</option>
                                <option value="this_year">السنة الحالية</option>
                                <option value="last_year">السنة الماضية</option>
                                <option value="custom">فترة مخصصة</option>
                                <option value="all">جميع الفترات</option>
                            </select>
                        </div>

                        {{-- أيقونة إعادة التعيين --}}
                        <button wire:click="resetFilters"
                            class="group flex h-[46px] w-[46px] items-center justify-center rounded-xl border-2 border-gray-200
                                       bg-white shadow-sm transition-all hover:border-primary-400 hover:bg-primary-50 hover:shadow-md
                                       dark:border-gray-700 dark:bg-gray-950 dark:hover:border-primary-500 dark:hover:bg-primary-950/50"
                            title="إعادة تعيين الفلتر">
                            <svg class="h-5 w-5 text-gray-600 transition-all group-hover:rotate-180 group-hover:text-primary-600 dark:text-gray-400 dark:group-hover:text-primary-400"
                                fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15" />
                            </svg>
                        </button>
                    </div>

                    {{-- التواريخ المخصصة --}}
                    @if (($filters['dateRange'] ?? 'today') === 'custom')
                        <div class="flex items-center gap-3 rounded-xl bg-gray-50 px-4 py-2 dark:bg-gray-800/50">
                            {{-- من تاريخ --}}
                            <div class="flex items-center gap-2">
                                <span class="text-xs font-semibold text-gray-600 dark:text-gray-400">من:</span>
                                <input type="date" wire:model.live="filters.startDate"
                                    class="rounded-lg border-gray-300 bg-white px-3 py-1.5 text-sm font-medium shadow-sm
                                           focus:border-primary-500 focus:ring-2 focus:ring-primary-500/20
                                           dark:border-gray-600 dark:bg-gray-900 dark:text-white" />
                            </div>

                            <svg class="h-4 w-4 text-gray-400 dark:text-gray-500" fill="none" stroke="currentColor"
                                viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M13 7l5 5m0 0l-5 5m5-5H6" />
                            </svg>

                            {{-- إلى تاريخ --}}
                            <div class="flex items-center gap-2">
                                <span class="text-xs font-semibold text-gray-600 dark:text-gray-400">إلى:</span>
                                <input type="date" wire:model.live="filters.endDate"
                                    class="rounded-lg border-gray-300 bg-white px-3 py-1.5 text-sm font-medium shadow-sm
                                           focus:border-primary-500 focus:ring-2 focus:ring-primary-500/20
                                           dark:border-gray-600 dark:bg-gray-900 dark:text-white" />
                            </div>
                        </div>
                    @endif
                </div>

                {{-- اليمين: العنوان والتاريخ --}}
                <div class="flex flex-col items-start gap-2 lg:items-end">
                    <h2 class="text-2xl font-black text-gray-900 dark:text-white">
                        الإحصائيات
                    </h2>
                    <div class="flex items-center gap-3">
                        <div
                            class="flex items-center gap-2 rounded-lg bg-primary-50 px-3 py-1.5 dark:bg-primary-950/50">
                            <svg class="h-4 w-4 text-primary-600 dark:text-primary-400" fill="none"
                                stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                            </svg>
                            <span class="text-sm font-bold text-primary-900 dark:text-primary-100">
                                {{ $periodName }}
                            </span>
                        </div>
                        @if ($from && $to)
                            <div class="flex items-center gap-2 rounded-lg bg-gray-100 px-3 py-1.5 dark:bg-gray-800">
                                <svg class="h-4 w-4 text-gray-600 dark:text-gray-400" fill="none"
                                    stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                                </svg>
                                <span class="font-mono text-sm font-semibold text-gray-700 dark:text-gray-300">
                                    {{ $from->format('Y/m/d') }}
                                </span>
                                <svg class="h-3 w-3 text-gray-400" fill="none" stroke="currentColor"
                                    viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M13 7l5 5m0 0l-5 5m5-5H6" />
                                </svg>
                                <span class="font-mono text-sm font-semibold text-gray-700 dark:text-gray-300">
                                    {{ $to->format('Y/m/d') }}
                                </span>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- الويدجتات --}}
    <div class="animate-[slideIn_0.4s_ease-out]">
        <x-filament-widgets::widgets :widgets="$this->getWidgets()" :columns="$this->getColumns()" />
    </div>
</x-filament-panels::page>
