<x-filament-panels::page>
    @php
        $user = auth()->user();

        $avatar = $user->avatar_url ?? null;

        $roleName = method_exists($user, 'getRoleNames') ? ($user->getRoleNames()->first() ?: null) : null;

        $roleEnum = $roleName ? \App\Enums\RoleEnum::tryFromValue($roleName) : null;
        $roleLabel = $roleEnum?->getLabel() ?? '—';
        $roleIcon = $roleEnum?->getIcon();

        $branchName = $user->branch?->name ?? '—';

        $isActive = (bool) ($user->status ?? false);
        $statusText = $isActive ? 'نشط' : 'غير نشط';

        $roleBadge =
            'bg-primary-500/10 text-primary-700 ring-1 ring-primary-500/20 dark:bg-primary-500/15 dark:text-primary-300 dark:ring-primary-500/30';

        $statusBadge = $isActive
            ? 'bg-emerald-500/15 text-emerald-700 ring-1 ring-emerald-500/25 dark:bg-emerald-500/15 dark:text-emerald-300 dark:ring-emerald-500/30'
            : 'bg-slate-100 text-slate-600 ring-1 ring-slate-200 dark:bg-white/10 dark:text-white/60 dark:ring-white/10';

        // Fallback initial (أول حرف من الاسم)
        $initial = mb_substr((string) ($user->name ?? 'U'), 0, 1);
    @endphp

    <style>
        @keyframes float {

            0%,
            100% {
                transform: translateY(0px);
            }

            50% {
                transform: translateY(-10px);
            }
        }

        @keyframes pulse-glow {

            0%,
            100% {
                opacity: 1;
            }

            50% {
                opacity: 0.55;
            }
        }

        @keyframes slide-up {
            from {
                opacity: 0;
                transform: translateY(16px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .animate-float {
            animation: float 3.2s ease-in-out infinite;
        }

        .animate-pulse-glow {
            animation: pulse-glow 2s ease-in-out infinite;
        }

        .animate-slide-up {
            animation: slide-up 0.55s ease-out forwards;
        }

        .info-card {
            transition: all 0.28s ease;
        }

        .info-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 14px 30px -10px rgba(0, 0, 0, 0.12);
        }

        .dark .info-card:hover {
            box-shadow: 0 16px 34px -10px rgba(0, 0, 0, 0.55);
        }
    </style>

    <div class="space-y-6">

        {{-- ===== Premium Hero ===== --}}
        <div
            class="relative overflow-hidden rounded-3xl border border-slate-200/60 bg-white shadow-xl shadow-slate-200/50
                    dark:border-white/10 dark:bg-gradient-to-br dark:from-slate-900 dark:to-slate-800 dark:shadow-none">

            {{-- Background Layers --}}
            <div class="relative h-32">
                {{-- Gradient Base --}}
                <div
                    class="absolute inset-0 bg-gradient-to-br from-primary-50 via-white to-primary-50
                            dark:from-primary-950/30 dark:via-slate-900/50 dark:to-primary-950/30">
                </div>

                {{-- Animated Orbs --}}
                <div
                    class="absolute -top-24 -right-12 h-64 w-64 rounded-full bg-gradient-to-br from-primary-400/30 to-primary-500/30 blur-3xl animate-float
                            dark:from-primary-500/20 dark:to-primary-600/20">
                </div>
                <div class="absolute -top-32 left-1/3 h-56 w-56 rounded-full bg-gradient-to-br from-primary-400/20 to-primary-500/20 blur-3xl animate-float"
                    style="animation-delay: 1s; animation-duration: 4s;">
                </div>

                {{-- Pattern Overlay --}}
                <div class="absolute inset-0 opacity-[0.38] dark:opacity-[0.2]"
                    style="background-image: radial-gradient(circle at 1px 1px, currentColor 1px, transparent 0); background-size: 24px 24px;">
                </div>

                {{-- Shine --}}
                <div class="absolute inset-0 bg-gradient-to-r from-transparent via-white/45 to-transparent opacity-0 hover:opacity-100 transition-opacity duration-1000 dark:via-white/10"
                    style="transform: skewX(-20deg);">
                </div>
            </div>

            {{-- Content --}}
            <div class="px-5 pb-7 sm:px-7">
                <div class="-mt-14 flex flex-col gap-6 lg:flex-row lg:items-end lg:justify-between">

                    {{-- User Info --}}
                    <div class="flex items-start gap-5 animate-slide-up">

                        {{-- ===== Avatar (UPDATED Premium) ===== --}}
                        <div class="relative group">

                            {{-- Halo Gradient --}}
                            <div
                                class="absolute -inset-1 rounded-[2.25rem]
                                       bg-gradient-to-br from-primary-500 via-indigo-500 to-fuchsia-500
                                       opacity-70 blur-xl
                                       group-hover:opacity-100 transition duration-500">
                            </div>

                            {{-- Glass Ring --}}
                            <div
                                class="relative h-32 w-32 rounded-[2rem] p-[3px]
                                       bg-white/45 backdrop-blur-xl
                                       ring-1 ring-white/70
                                       shadow-2xl shadow-slate-900/10
                                       transition-transform duration-300
                                       group-hover:scale-[1.04]
                                       dark:bg-white/10 dark:ring-white/10 dark:shadow-black/50">

                                {{-- Image / Fallback --}}
                                <div
                                    class="h-full w-full overflow-hidden rounded-[1.75rem] bg-slate-100 dark:bg-slate-800">
                                    @if ($avatar)
                                        <img src="{{ $avatar }}" alt="avatar"
                                            class="h-full w-full object-cover transition duration-500 group-hover:scale-110" />
                                    @else
                                        <div
                                            class="flex h-full w-full items-center justify-center
                                                   bg-gradient-to-br from-primary-600 to-indigo-600
                                                   text-4xl font-black text-white">
                                            {{ $initial }}
                                        </div>
                                    @endif

                                    {{-- Hover Overlay (اختياري بصري فقط) --}}
                                    <div
                                        class="pointer-events-none absolute inset-[3px] rounded-[1.75rem]
                                               bg-gradient-to-t from-black/35 via-black/0 to-white/0
                                               opacity-0 group-hover:opacity-100 transition duration-500">
                                    </div>
                                </div>
                            </div>

                            {{-- Status Indicator --}}
                            <span
                                class="absolute -bottom-2 -right-2 h-7 w-7 rounded-full ring-4 ring-white
                                       shadow-lg {{ $isActive ? 'bg-emerald-500 animate-pulse-glow' : 'bg-slate-400' }}
                                       dark:ring-slate-900">
                                <span
                                    class="absolute inset-0 rounded-full {{ $isActive ? 'bg-emerald-400 animate-ping' : '' }}"></span>
                            </span>
                        </div>

                        {{-- Name & Info --}}
                        <div class="min-w-0 flex-1">
                            {{-- Name --}}
                            <h1
                                class="text-3xl font-extrabold tracking-tight
                                       bg-gradient-to-r from-slate-900 via-slate-700 to-slate-900
                                       bg-clip-text text-transparent
                                       dark:from-white dark:via-white/80 dark:to-white">
                                {{ $user->name }}
                            </h1>

                            {{-- Badges --}}
                            <div class="mt-3 flex flex-wrap items-center gap-2">
                                <span
                                    class="inline-flex items-center gap-2 rounded-full px-4 py-1.5 text-xs font-bold
                                           backdrop-blur-md shadow-sm {{ $statusBadge }}
                                           hover:scale-[1.03] transition-transform">
                                    <span
                                        class="h-2 w-2 rounded-full {{ $isActive ? 'bg-emerald-500' : 'bg-slate-400' }}"></span>
                                    {{ $statusText }}
                                </span>

                                <span
                                    class="inline-flex items-center gap-1.5 rounded-full px-4 py-1.5 text-xs font-bold
                                           backdrop-blur-md shadow-sm {{ $roleBadge }}
                                           hover:scale-[1.03] transition-transform">
                                    @if (!empty($roleIcon))
                                        <x-filament::icon :icon="$roleIcon" class="h-3.5 w-3.5" />
                                    @endif
                                    {{ $roleLabel }}
                                </span>

                                <span
                                    class="inline-flex items-center gap-1.5 rounded-full px-4 py-1.5 text-xs font-bold
                                           bg-slate-100/80 text-slate-700 ring-1 ring-slate-200/50 shadow-sm
                                           dark:bg-white/10 dark:text-white/70 dark:ring-white/10
                                           hover:scale-[1.03] transition-transform">
                                    <x-heroicon-m-building-office class="h-3.5 w-3.5" />
                                    {{ $branchName }}
                                </span>
                            </div>

                            {{-- Contact Info --}}
                            <div
                                class="mt-4 flex flex-wrap items-center gap-x-6 gap-y-2 text-sm text-slate-600 dark:text-white/60">
                                <div
                                    class="flex items-center gap-2 hover:text-primary-600 transition-colors dark:hover:text-primary-400">
                                    <div class="rounded-lg bg-primary-500/10 p-1.5 dark:bg-primary-500/20">
                                        <x-heroicon-m-envelope class="h-4 w-4 text-primary-600 dark:text-primary-400" />
                                    </div>
                                    <span class="truncate font-medium">{{ $user->email }}</span>
                                </div>

                                @if (!empty($user->phone))
                                    <div
                                        class="flex items-center gap-2 hover:text-emerald-600 transition-colors dark:hover:text-emerald-400">
                                        <div class="rounded-lg bg-emerald-500/10 p-1.5 dark:bg-emerald-500/20">
                                            <x-heroicon-m-phone
                                                class="h-4 w-4 text-emerald-600 dark:text-emerald-400" />
                                        </div>
                                        <span dir="ltr" class="font-medium">{{ $user->phone }}</span>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>

        {{-- ===== Main Layout ===== --}}
        <div class="grid grid-cols-1 gap-6 lg:grid-cols-12">

            {{-- Left: Personal Info --}}
            <div class="lg:col-span-4">
                <div class="lg:sticky lg:top-6 space-y-6">

                    <div class="rounded-3xl border border-slate-200/60 bg-white shadow-lg shadow-slate-200/40
                                dark:border-white/10 dark:bg-gradient-to-br dark:from-slate-900 dark:to-slate-800 dark:shadow-none
                                animate-slide-up"
                        style="animation-delay: 0.1s;">

                        <div class="p-6 sm:p-7">
                            {{-- Header --}}
                            <div class="flex items-center justify-between mb-6">
                                <div>
                                    <div class="flex items-center gap-2">
                                        <div class="rounded-xl bg-primary-500/10 p-2 dark:bg-primary-500/20">
                                            <x-heroicon-m-identification
                                                class="h-5 w-5 text-primary-600 dark:text-primary-400" />
                                        </div>
                                        <div>
                                            <div class="text-base font-bold text-slate-900 dark:text-white/90">المعلومات
                                                الشخصية</div>
                                            <div class="text-xs text-slate-500 dark:text-white/50">تفاصيل الملف الشخصي
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            {{-- Info Cards --}}
                            <div class="space-y-3">

                                {{-- الاسم --}}
                                <div
                                    class="info-card rounded-2xl border border-slate-200/50 bg-gradient-to-br from-slate-50 to-white p-4
                                            dark:border-white/10 dark:from-white/5 dark:to-transparent">
                                    <div class="flex items-center justify-between">
                                        <div class="min-w-0 flex-1">
                                            <div class="text-xs font-medium text-slate-500 dark:text-white/60">الاسم
                                            </div>
                                            <div
                                                class="mt-1 text-sm font-bold text-slate-900 truncate dark:text-white/85">
                                                {{ $user->name ?: '—' }}
                                            </div>
                                        </div>
                                        <div
                                            class="flex h-10 w-10 items-center justify-center rounded-xl bg-primary-500/10 dark:bg-primary-500/20">
                                            <x-heroicon-m-user class="h-5 w-5 text-primary-600 dark:text-primary-400" />
                                        </div>
                                    </div>
                                </div>

                                {{-- اسم المستخدم --}}
                                <div
                                    class="info-card rounded-2xl border border-slate-200/50 bg-gradient-to-br from-slate-50 to-white p-4
                                            dark:border-white/10 dark:from-white/5 dark:to-transparent">
                                    <div class="flex items-center justify-between">
                                        <div class="min-w-0 flex-1">
                                            <div class="text-xs font-medium text-slate-500 dark:text-white/60">اسم
                                                المستخدم</div>
                                            <div
                                                class="mt-1 text-sm font-bold text-slate-900 truncate dark:text-white/85">
                                                {{ $user->username ?: '—' }}
                                            </div>
                                        </div>
                                        <div
                                            class="flex h-10 w-10 items-center justify-center rounded-xl bg-primary-500/10 dark:bg-primary-500/20">
                                            <x-heroicon-m-at-symbol
                                                class="h-5 w-5 text-primary-600 dark:text-primary-400" />
                                        </div>
                                    </div>
                                </div>

                                {{-- البريد --}}
                                <div
                                    class="info-card rounded-2xl border border-slate-200/50 bg-gradient-to-br from-slate-50 to-white p-4
                                            dark:border-white/10 dark:from-white/5 dark:to-transparent">
                                    <div class="flex items-center justify-between">
                                        <div class="min-w-0 flex-1">
                                            <div class="text-xs font-medium text-slate-500 dark:text-white/60">البريد
                                                الإلكتروني</div>
                                            <div
                                                class="mt-1 text-sm font-bold text-slate-900 truncate dark:text-white/85">
                                                {{ $user->email ?: '—' }}
                                            </div>
                                        </div>
                                        <div
                                            class="flex h-10 w-10 items-center justify-center rounded-xl bg-primary-500/10 dark:bg-primary-500/20">
                                            <x-heroicon-m-envelope
                                                class="h-5 w-5 text-primary-600 dark:text-primary-400" />
                                        </div>
                                    </div>
                                </div>

                                {{-- الهاتف --}}
                                <div
                                    class="info-card rounded-2xl border border-slate-200/50 bg-gradient-to-br from-slate-50 to-white p-4
                                            dark:border-white/10 dark:from-white/5 dark:to-transparent">
                                    <div class="flex items-center justify-between">
                                        <div class="min-w-0 flex-1">
                                            <div class="text-xs font-medium text-slate-500 dark:text-white/60">رقم
                                                الهاتف</div>
                                            <div class="mt-1 text-sm font-bold text-slate-900 dark:text-white/85">
                                                @if (!empty($user->phone))
                                                    <span dir="ltr">{{ $user->phone }}</span>
                                                @else
                                                    —
                                                @endif
                                            </div>
                                        </div>
                                        <div
                                            class="flex h-10 w-10 items-center justify-center rounded-xl bg-primary-500/10 dark:bg-primary-500/20">
                                            <x-heroicon-m-phone
                                                class="h-5 w-5 text-primary-600 dark:text-primary-400" />
                                        </div>
                                    </div>
                                </div>

                                {{-- العنوان --}}
                                <div
                                    class="info-card rounded-2xl border border-slate-200/50 bg-gradient-to-br from-slate-50 to-white p-4
                                            dark:border-white/10 dark:from-white/5 dark:to-transparent">
                                    <div class="flex items-start justify-between">
                                        <div class="min-w-0 flex-1">
                                            <div class="text-xs font-medium text-slate-500 dark:text-white/60">العنوان
                                            </div>
                                            <div
                                                class="mt-1 text-sm font-bold text-slate-900 break-words dark:text-white/85">
                                                {{ !empty($user->address) ? $user->address : '—' }}
                                            </div>
                                        </div>
                                        <div
                                            class="flex h-10 w-10 items-center justify-center rounded-xl bg-primary-500/10 dark:bg-primary-500/20">
                                            <x-heroicon-m-map-pin
                                                class="h-5 w-5 text-primary-600 dark:text-primary-400" />
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>

                </div>
            </div>

            {{-- Right: Form Section --}}
            <div class="lg:col-span-8">
                <div class="rounded-3xl border border-slate-200/60 bg-white shadow-lg shadow-slate-200/40
                            dark:border-white/10 dark:bg-gradient-to-br dark:from-slate-900 dark:to-slate-800 dark:shadow-none
                            animate-slide-up"
                    style="animation-delay: 0.2s;">

                    {{-- Header --}}
                    <div class="border-b border-slate-200/60 px-6 py-5 dark:border-white/10">
                        <div class="flex items-center justify-between">
                            <div class="flex items-center gap-3">
                                <div class="rounded-xl bg-primary-500/10 p-2.5 dark:bg-primary-500/20">
                                    <x-heroicon-m-cog-6-tooth class="h-6 w-6 text-primary-600 dark:text-primary-400" />
                                </div>
                                <div>
                                    <div class="text-base font-bold text-slate-900 dark:text-white/90">إعدادات الحساب
                                    </div>
                                    <div class="text-xs text-slate-500 dark:text-white/50">عدّل البيانات ثم احفظ
                                        التغييرات</div>
                                </div>
                            </div>
                        </div>
                    </div>

                    {{-- Form Body --}}
                    <div class="p-6 sm:p-7">
                        {{ $this->form }}
                        {{-- Action Bar --}}
                        <div
                            class="mt-8 rounded-2xl border border-emerald-200/60 bg-gradient-to-br from-emerald-50 to-teal-50 p-5
                                    dark:border-emerald-500/20 dark:from-emerald-950/30 dark:to-teal-950/20">
                            <div class="flex flex-col gap-5 sm:flex-row sm:items-center sm:justify-between">

                                <div class="flex items-start gap-4">
                                    <div
                                        class="flex h-12 w-12 items-center justify-center rounded-2xl bg-gradient-to-br from-emerald-500/20 to-teal-500/20 ring-2 ring-emerald-500/30
                                                dark:from-emerald-500/30 dark:to-teal-500/30 dark:ring-emerald-500/40">
                                        <x-heroicon-m-shield-check
                                            class="h-6 w-6 text-emerald-600 dark:text-emerald-400" />
                                    </div>

                                    <div>
                                        <div class="text-sm font-bold text-emerald-900 dark:text-emerald-200">جاهز
                                            للحفظ</div>
                                        <div class="mt-0.5 text-xs text-emerald-700 dark:text-emerald-300/80">
                                            سيتم حفظ التغييرات على حسابك فورًا وبشكل آمن
                                        </div>
                                    </div>
                                </div>

                                <div class="flex flex-wrap items-center justify-end gap-3">
                                    <x-filament::button type="button" color="gray" onclick="history.back()"
                                        class="shadow-sm">
                                        <x-heroicon-m-arrow-uturn-right class="ml-1.5 h-4 w-4" />
                                        إلغاء
                                    </x-filament::button>

                                    <x-filament::button type="button" wire:click="save"
                                        class="shadow-md hover:shadow-lg transition-shadow">
                                        <x-heroicon-m-check class="ml-1.5 h-4 w-4" />
                                        حفظ التغييرات
                                    </x-filament::button>
                                </div>

                            </div>
                        </div>

                    </div>

                </div>
            </div>

        </div>
    </div>
</x-filament-panels::page>
