@props([
    'activity' => 'تحديث مستخدم',
    'description' => 'بتحديث معلومات مستخدم',
    'ago' => null,
    'actor' => null,
    'target' => null,
    'isNew' => true,
])

@php
    // 🔹 توليد صورة الممثل (Avatar)
    $avatar = null;
    if ($actor) {
        if (method_exists($actor, 'getFilamentAvatarUrl') && $actor->getFilamentAvatarUrl()) {
            $avatar = $actor->getFilamentAvatarUrl();
        } elseif (isset($actor->profile_photo_url)) {
            $avatar = $actor->profile_photo_url;
        } elseif (method_exists($actor, 'getFirstMediaUrl')) {
            $avatar = $actor->getFirstMediaUrl('avatar');
        }

        $avatar ??=
            'https://ui-avatars.com/api/?name=' .
            urlencode($actor->name ?? 'User') .
            '&background=6366f1&color=fff&bold=true&size=160';
    }
@endphp

{{-- ✅ تخطيط بسيط: الصورة على اليمين والمحتوى على اليسار --}}
<div dir="rtl" class="w-full">
    <div class="flex items-start gap-3">

        {{-- الصورة على اليمين --}}
        @if ($actor && $avatar)
            <img src="{{ $avatar }}" alt="{{ $actor->name }}"
                class="h-10 w-10 rounded-lg object-cover ring-1 ring-gray-200 dark:ring-gray-700 flex-none shadow-sm" />
        @endif

        {{-- المحتوى على اليسار --}}
        <div class="flex-1 min-w-0 space-y-1">

            {{-- العنوان + شارة جديد + الوقت --}}
            <div class="flex items-center gap-2 flex-wrap">
                <h3 class="text-sm font-bold text-gray-900 dark:text-white leading-tight">
                    {{ $activity }}
                </h3>

                @if ($isNew)
                    <span
                        class="inline-flex items-center px-2 py-0.5 rounded-md text-[11px] font-bold bg-amber-500 text-white leading-none">
                        جديد
                    </span>
                @endif
            </div>

            {{-- الوصف --}}
            @if ($actor)
                <p class="text-[13px] text-gray-600 dark:text-gray-300 leading-snug">
                    قام
                    <span class="font-bold text-gray-900 dark:text-white">{{ $actor->name }}</span>
                    {{ $description }}
                    @if ($target)
                        <span class="font-bold text-gray-900 dark:text-white">
                            "{{ $target->name ?? ($target->title ?? '#' . $target->id) }}"
                        </span>
                    @endif
                </p>
            @endif

            {{-- شارات إضافية: الفرع + الهاتف --}}
            @if ($target && (isset($target->branch) || isset($target->phone)))
                <div class="flex flex-wrap items-center gap-2 pt-0.5">

                    {{-- الفرع --}}
                    @if (isset($target->branch) && $target->branch)
                        <span
                            class="inline-flex items-center gap-1 px-2.5 py-0.5 rounded-lg bg-blue-900/20 text-[12px] font-medium text-blue-300 whitespace-nowrap">
                            {{ $target->branch->name }}
                        </span>
                    @endif
                </div>
            @endif
        </div>
    </div>
</div>
