@props(['targetId' => null])

<div x-data="{
    score: 0,
    bars() { return [this.score >= 1, this.score >= 2, this.score >= 3]; },
    compute(val) {
        let s = 0;
        if (val.length >= 8) s++;
        if (/[A-Z]/.test(val) && /[a-z]/.test(val)) s++;
        if (/\d/.test(val) && /[^A-Za-z0-9]/.test(val)) s++;
        this.score = s;
    },
    init() {
        const input = document.getElementById(@js($targetId));
        if (!input) return;
        this.compute(input.value ?? '');
        input.addEventListener('input', e => this.compute(e.target.value));
    }
}" class="space-y-2">
    <div class="flex gap-3">
        <template x-for="(active, idx) in bars()" :key="idx">
            <div class="h-1.5 flex-1 rounded-full"
                :class="active
                    ?
                    (score === 1 ? 'bg-red-500/70' :
                        (score === 2 ? 'bg-yellow-500/80' :
                            'bg-green-500/80')) :
                    'bg-gray-200 dark:bg-gray-700'">
            </div>
        </template>
    </div>
</div>
