@php
    /** @var \App\Models\User $user */
    $user = $getRecord();

    $avatar = $user?->avatar_url ?: 'https://placehold.co/160x160?text=Avatar';

    $roleNames = $user->roles?->pluck('name')->implode(' • ') ?: 'مستخدم';
    $branch = $user->branch;

    // نقرأ الـ palette من إعدادات الفرع
    $pal = $branch?->settings?->themePaletteOrGenerate() ?? [];

    // fallback لو ناقص شيء
    $pal = array_merge(
        [
            'base' => '#2563EB', // primary
            'mid' => '#60A5FA', // أفتح قليلاً
            'dark' => '#1D4ED8',
            'muted' => '#6B7280',
            'field' => '#E5E7EB',
            'bg' => '#FFFFFF',
            'pill' => '#EEF2FF',
            'border' => '#E5E7EB',
            'ink' => '#0F172A',
        ],
        $pal,
    );

    $primary = $pal['base'];
    $primaryMid = $pal['mid'];
    $primaryDark = $pal['dark'];
    $muted = $pal['muted'];
    $borderColor = $pal['border'];
    $pillColor = $pal['pill'];
    $inkColor = $pal['ink'];

    $branchName = $branch?->name ?: 'بدون فرع';
    $email = $user->email ?: '—';
    $username = $user->username ?: '—';
@endphp

<style>
    .user-hero {
        position: relative;
        overflow: hidden;
        border-radius: 1.5rem;
    }

    .user-hero-bg {
        background:
            radial-gradient(circle at 0% 0%, {{ $primaryMid }}33 0, transparent 55%),
            radial-gradient(circle at 85% 15%, {{ $primary }}22 0, transparent 55%),
            radial-gradient(circle at 10% 90%, {{ $pillColor }}ff 0, transparent 55%),
            {{ $pal['bg'] }};
    }

    .dark .user-hero-bg {
        background:
            radial-gradient(circle at 0% 0%, {{ $primaryMid }}33 0, transparent 55%),
            radial-gradient(circle at 80% 20%, {{ $primaryDark }}44 0, transparent 55%),
            #020617;
    }

    .user-hero-tabs::-webkit-scrollbar {
        height: 4px;
    }

    .user-hero-pill {
        background-color: {{ $pillColor }};
        border-color: {{ $borderColor }};
        color: {{ $muted }};
    }

    .user-hero-primary-tab {
        border-color: {{ $primary }};
        color: {{ $primaryDark }};
    }

    .user-hero-primary-btn {
        background: linear-gradient(135deg, {{ $primaryMid }}, {{ $primaryDark }});
        border-color: {{ $primaryDark }};
        color: #ffffff;
    }

    .user-hero-primary-btn:hover {
        filter: brightness(1.05);
    }

    .user-hero-card {
        border-color: {{ $borderColor }};
        background-color: {{ $pal['bg'] }};
    }
</style>

<div class="user-hero w-full ring-1 user-hero-card shadow-sm">
    {{-- الخلفية العليا --}}
    <div class="user-hero-bg h-32 sm:h-40 w-full"></div>

    {{-- محتوى البروفايل --}}
    <div class="relative px-6 pb-4 sm:px-10 sm:pb-6">
        {{-- الأفاتار في المنتصف --}}
        <div class="flex justify-center">
            <div
                class="-mt-16 sm:-mt-20 inline-flex items-center justify-center rounded-full ring-4 ring-white dark:ring-gray-900 bg-white dark:bg-gray-900 overflow-hidden shadow-md">
                <img src="{{ $avatar }}" alt="avatar" class="w-24 h-24 sm:w-28 sm:h-28 object-cover" />
            </div>
        </div>

        {{-- الاسم + معلومات مختصرة --}}
        <div class="mt-4 text-center space-y-1">
            <div class="flex items-center justify-center gap-2 flex-wrap">
                <h2 class="text-xl sm:text-2xl font-semibold leading-tight truncate"
                    style="color: {{ $inkColor }}">
                    {{ $user->name }}
                </h2>

                @if ($user->is_active)
                    <x-filament::badge color="success" class="px-2 py-0.5 text-xs sm:text-sm"
                        icon="heroicon-m-check-badge">
                        نشط
                    </x-filament::badge>
                @else
                    <x-filament::badge color="danger" class="px-2 py-0.5 text-xs sm:text-sm"
                        icon="heroicon-m-no-symbol">
                        موقوف
                    </x-filament::badge>
                @endif
            </div>

            <div class="flex items-center justify-center gap-3 text-xs sm:text-sm flex-wrap"
                style="color: {{ $muted }};">
                <span
                    class="inline-flex items-center gap-1 user-hero-pill px-3 py-1 rounded-full border text-[11px] sm:text-xs">
                    <x-filament::icon icon="heroicon-m-building-office-2" class="w-4 h-4" />
                    {{ $branchName }}
                </span>

                <span class="inline-flex items-center gap-1">
                    <x-filament::icon icon="heroicon-m-user-circle" class="w-4 h-4" />
                    {{ $roleNames }}
                </span>

                <span class="inline-flex items-center gap-1">
                    <x-filament::icon icon="heroicon-m-at-symbol" class="w-4 h-4" />
                    {{ $username }}
                </span>

                <span class="inline-flex items-center gap-1">
                    <x-filament::icon icon="heroicon-m-envelope" class="w-4 h-4" />
                    {{ $email }}
                </span>
            </div>
        </div>

        {{-- شريط التابات + الأزرار --}}
        <div class="mt-4 border-t pt-3 flex items-center justify-between gap-3 flex-wrap"
            style="border-color: {{ $borderColor }};">
            <div class="user-hero-tabs flex items-center gap-4 overflow-x-auto text-sm">
                <button type="button" class="pb-2 border-b-2 font-medium whitespace-nowrap user-hero-primary-tab">
                    نظرة عامة
                </button>
                <span class="pb-2 text-gray-500 dark:text-gray-400 whitespace-nowrap">
                    الصلاحيات
                </span>
                <span class="pb-2 text-gray-500 dark:text-gray-400 whitespace-nowrap">
                    السجلات
                </span>
                <span class="pb-2 text-gray-500 dark:text-gray-400 whitespace-nowrap">
                    الفواتير
                </span>
            </div>

            <div class="flex items-center gap-2">
                <a href="{{ \App\Filament\Resources\Users\UserResource::getUrl('edit', ['record' => $user]) }}"
                    class="inline-flex items-center px-4 py-2 rounded-xl text-xs sm:text-sm font-medium shadow-sm user-hero-primary-btn">
                    تعديل المستخدم
                </a>

                @if ($user->is_active)
                    <span
                        class="inline-flex items-center px-3 py-1 rounded-xl text-[11px] sm:text-xs border bg-white/60 dark:bg-gray-900/60"
                        style="border-color: {{ $borderColor }}; color: {{ $muted }};">
                        مستخدم فعّال
                    </span>
                @else
                    <span
                        class="inline-flex items-center px-3 py-1 rounded-xl text-[11px] sm:text-xs border bg-amber-50/80 text-amber-700 dark:bg-amber-900/40 dark:text-amber-200">
                        مستخدم موقوف
                    </span>
                @endif
            </div>
        </div>
    </div>
</div>

{{-- الإحصائيات تحت الهيدر --}}
<div class="mt-4">
    @livewire(\App\Filament\Resources\Users\Widgets\UserStatsOverview::class, ['recordId' => $user->id], key('user-stats-hero-' . $user->id))
</div>
