@php
    use App\Enums\RoleEnum;

    $user = auth()->user();
    $tenant = \Filament\Facades\Filament::getTenant();
    $accountName = $tenant?->name;

    $roles = method_exists($user, 'getRoleNames')
        ? $user->getRoleNames()->toArray()
        : array_filter([$user->role ?? null]);

    $avatarUrl = $user->avatar_url ?? null;
    $initials = collect(preg_split('/\s+/', trim($user->name ?? '')))
        ->filter()
        ->map(fn($p) => mb_substr($p, 0, 1))
        ->implode('');

    $branchName =
        $user->branch->name ??
        null ??
        ($user->branch_name ??
            null ??
            (method_exists($user, 'branches') ? optional($user->branches()->first())->name : null));

    $branchLabel = $branchName ?: 'الإدارة العامة';

    $roleBadges = collect($roles)->map(function ($r) {
        $enum = RoleEnum::tryFrom($r);
        return [
            'label' => $enum?->getLabel() ?? __($r),
            'tone' => $enum?->getColor() ?? 'gray',
        ];
    });
@endphp

<div class="w-full px-4 pt-3 pb-3" dir="rtl">
    <div class="flex items-start gap-3 w-full">
        {{-- الأفاتار على اليمين --}}
        <div class="relative shrink-0">
            @if ($avatarUrl)
                <img src="{{ $avatarUrl }}" alt="{{ $user->name }}"
                    class="h-12 w-12 rounded-full object-cover 
                           ring-2 ring-primary-500/30 dark:ring-primary-500/50
                           transition-all duration-200
                           hover:ring-primary-500" />
            @else
                <div class="h-12 w-12 rounded-full flex items-center justify-center
                            bg-gradient-to-br from-primary-500 to-primary-600
                            text-white text-sm font-bold
                            ring-2 ring-primary-500/30 dark:ring-primary-500/50
                            transition-all duration-200
                            hover:ring-primary-500">
                    {{ $initials }}
                </div>
            @endif
            
            {{-- نقطة الحالة النشطة --}}
            <div class="absolute bottom-0 start-0 h-3.5 w-3.5 rounded-full 
                        bg-success-500 ring-2 ring-gray-900 dark:ring-gray-800">
                <span class="absolute inset-0 rounded-full bg-success-400 animate-ping opacity-75"></span>
            </div>
        </div>

        {{-- معلومات المستخدم --}}
        <div class="flex-1 min-w-0 space-y-1.5">
            {{-- اسم المستخدم --}}
            <div class="text-sm font-bold text-gray-900 dark:text-white leading-tight">
                {{ $user->name }}
            </div>

            {{-- اسم الحساب/المنظمة --}}
            @if ($accountName)
                <div class="flex items-center gap-1.5 justify-start">
                    <svg class="h-3 w-3 text-gray-400 dark:text-gray-500 shrink-0" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" 
                              d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                    </svg>
                    <span class="text-[11px] text-gray-500 dark:text-gray-400 truncate">
                        {{ $accountName }}
                    </span>
                </div>
            @endif

            {{-- الأدوار --}}
            @foreach ($roleBadges as $rb)
                <div class="flex items-center gap-1.5 justify-start">
                    <svg class="h-3 w-3 text-gray-400 dark:text-gray-500 shrink-0" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M12 12a5 5 0 1 0-5-5 5 5 0 0 0 5 5Zm0 2c-4.42 0-8 2.24-8 5v1h16v-1c0-2.76-3.58-5-8-5Z" />
                    </svg>
                    <span class="text-[11px] text-gray-500 dark:text-gray-400 truncate">
                        {{ $rb['label'] }}
                    </span>
                </div>
            @endforeach

            {{-- الفرع --}}
            <div class="flex items-center gap-1.5 justify-start">
                <svg class="h-3 w-3 text-gray-400 dark:text-gray-500 shrink-0" viewBox="0 0 24 24" fill="currentColor">
                    <path d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z" />
                    <path d="M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
                </svg>
                <span class="text-[11px] text-gray-500 dark:text-gray-400 truncate">
                    {{ $branchLabel }}
                </span>
            </div>
        </div>
    </div>
</div>

{{-- فاصل بعرض كامل --}}
<div class="h-px bg-gray-200 dark:bg-white/10"></div>