@extends('layouts.master')
@section('title', $design->name . ' - مكتبة التصاميم')

@section('content')
<div class="min-h-screen bg-gradient-to-br from-[#0a0a0a] via-[#1a1a1a] to-[#0a0a0a]">

    {{-- Back Navigation --}}
    <div class="site-container pt-6">
        <a href="{{ route('designs.index') }}" class="inline-flex items-center gap-2 text-gray-400 hover:text-nassaj-gold transition-colors font-bold text-sm">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" d="M9 15l-6-6m0 0l6-6m-6 6h16" />
            </svg>
            <span>العودة إلى مكتبة التصاميم</span>
        </a>
    </div>

    {{-- Main Content --}}
    <div class="site-container py-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 lg:gap-12">

            {{-- Design Preview --}}
            <div class="relative">
                <div class="aspect-square rounded-3xl overflow-hidden bg-gradient-to-br from-gray-800 to-gray-900 border border-white/10">
                    @if($design->preview_image_url)
                        <img src="{{ $design->preview_image_url }}" alt="{{ $design->name }}" class="w-full h-full object-cover">
                    @else
                        <div class="w-full h-full flex items-center justify-center text-gray-600">
                            <svg class="w-32 h-32" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z" />
                            </svg>
                        </div>
                    @endif
                </div>

                @if($design->is_featured)
                <div class="absolute top-4 right-4 bg-nassaj-gold text-black px-4 py-2 rounded-full text-sm font-black shadow-lg">
                    تصميم مميز
                </div>
                @endif
            </div>

            {{-- Design Info --}}
            <div class="flex flex-col justify-center">
                {{-- Product Badge --}}
                @if($design->productModel)
                <div class="flex items-center gap-2 mb-4">
                    <span class="w-2 h-2 rounded-full bg-nassaj-gold"></span>
                    <span class="text-gray-400 text-sm font-bold">{{ $design->productModel->product->name ?? '' }} — {{ $design->productModel->name }}</span>
                </div>
                @endif

                {{-- Title --}}
                <h1 class="cairo text-4xl md:text-5xl font-black text-white mb-4">
                    {{ $design->name }}
                </h1>

                {{-- Creator --}}
                @if($design->user)
                <div class="flex items-center gap-3 mb-6">
                    <div class="w-10 h-10 rounded-full bg-gradient-to-br from-nassaj-gold to-nassaj-gold-light flex items-center justify-center text-black font-black text-sm">
                        {{ mb_substr($design->user->name ?? '?', 0, 1) }}
                    </div>
                    <div>
                        <p class="text-white font-bold text-sm">{{ $design->user->name ?? 'مجهول' }}</p>
                        <p class="text-gray-500 text-xs">{{ $design->created_at->diffForHumans() }}</p>
                    </div>
                </div>
                @endif

                {{-- Stats --}}
                <div class="flex items-center gap-6 mb-8">
                    <div class="flex items-center gap-2 text-gray-400 text-sm">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M2.036 12.322a1.012 1.012 0 010-.639C3.423 7.51 7.36 4.5 12 4.5c4.638 0 8.573 3.007 9.963 7.178.07.207.07.431 0 .639C20.577 16.49 16.64 19.5 12 19.5c-4.638 0-8.573-3.007-9.963-7.178z" />
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                        </svg>
                        <span>{{ $design->views_count }} مشاهدة</span>
                    </div>
                    <div class="flex items-center gap-2 text-gray-400 text-sm">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M21 8.25c0-2.485-2.099-4.5-4.688-4.5-1.935 0-3.597 1.126-4.312 2.733-.715-1.607-2.377-2.733-4.313-2.733C5.1 3.75 3 5.765 3 8.25c0 7.22 9 12 9 12s9-4.78 9-12z" />
                        </svg>
                        <span>{{ $design->likes_count }} إعجاب</span>
                    </div>
                    <div class="flex items-center gap-2 text-gray-400 text-sm">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M2.25 3h1.386c.51 0 .955.343 1.087.835l.383 1.437M7.5 14.25a3 3 0 00-3 3h15.75m-12.75-3h11.218c1.121-2.3 2.1-4.684 2.924-7.138a60.114 60.114 0 00-16.536-1.84M7.5 14.25L5.106 5.272M6 20.25a.75.75 0 11-1.5 0 .75.75 0 011.5 0zm12.75 0a.75.75 0 11-1.5 0 .75.75 0 011.5 0z" />
                        </svg>
                        <span>{{ $design->purchases_count }} طلب</span>
                    </div>
                </div>

                {{-- Actions --}}
                <div class="flex flex-col sm:flex-row gap-4">
                    @if($design->productModel)
                    <a href="{{ route('configurator.show', $design->productModel) }}"
                       class="flex-1 bg-gradient-to-r from-nassaj-gold via-nassaj-gold-light to-nassaj-gold text-black py-4 rounded-2xl font-black text-center hover:scale-105 transition-all flex items-center justify-center gap-3 text-lg shadow-lg shadow-nassaj-gold/20">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" stroke-width="2.5" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M9.594 3.94c.09-.542.56-.94 1.11-.94h2.593c.55 0 1.02.398 1.11.94l.213 1.281c.063.374.313.686.645.87.074.04.147.083.22.127.324.196.72.257 1.075.124l1.217-.456a1.125 1.125 0 011.37.49l1.296 2.247a1.125 1.125 0 01-.26 1.431l-1.003.827c-.293.24-.438.613-.431.992a6.759 6.759 0 010 .255c-.007.378.138.75.43.99l1.005.828c.424.35.534.954.26 1.43l-1.298 2.247a1.125 1.125 0 01-1.369.491l-1.217-.456c-.355-.133-.75-.072-1.076.124a6.57 6.57 0 01-.22.128c-.331.183-.581.495-.644.869l-.213 1.28c-.09.543-.56.941-1.11.941h-2.594c-.55 0-1.02-.398-1.11-.94l-.213-1.281c-.062-.374-.312-.686-.644-.87a6.52 6.52 0 01-.22-.127c-.325-.196-.72-.257-1.076-.124l-1.217.456a1.125 1.125 0 01-1.369-.49l-1.297-2.247a1.125 1.125 0 01.26-1.431l1.004-.827c.292-.24.437-.613.43-.992a6.932 6.932 0 010-.255c.007-.378-.138-.75-.43-.99l-1.004-.828a1.125 1.125 0 01-.26-1.43l1.297-2.247a1.125 1.125 0 011.37-.491l1.216.456c.356.133.751.072 1.076-.124.072-.044.146-.087.22-.128.332-.183.582-.495.644-.869l.214-1.281z" />
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                        </svg>
                        <span>تخصيص هذا الموديل</span>
                    </a>
                    @endif
                </div>

                {{-- Design Configuration Summary --}}
                @if($design->configuration)
                <div class="mt-8 p-6 bg-white/5 border border-white/10 rounded-2xl">
                    <h3 class="text-white font-black text-sm mb-4 flex items-center gap-2">
                        <svg class="w-4 h-4 text-nassaj-gold" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M11.25 11.25l.041-.02a.75.75 0 011.063.852l-.708 2.836a.75.75 0 001.063.853l.041-.021M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-9-3.75h.008v.008H12V8.25z" />
                        </svg>
                        تفاصيل التصميم
                    </h3>
                    <div class="grid grid-cols-2 gap-4 text-sm">
                        @if(!empty($design->configuration['part_overrides']))
                        <div class="text-gray-400">
                            <span class="text-gray-500">تعديلات الألوان:</span>
                            <span class="text-white font-bold mr-1">{{ count($design->configuration['part_overrides']) }}</span>
                        </div>
                        @endif
                        @if(!empty($design->configuration['decal_layers']))
                        <div class="text-gray-400">
                            <span class="text-gray-500">عناصر مضافة:</span>
                            <span class="text-white font-bold mr-1">{{ count($design->configuration['decal_layers']) }}</span>
                        </div>
                        @endif
                        @if(!empty($design->configuration['version']))
                        <div class="text-gray-400">
                            <span class="text-gray-500">إصدار:</span>
                            <span class="text-white font-bold mr-1">{{ $design->configuration['version'] }}</span>
                        </div>
                        @endif
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>

    {{-- Similar Designs Section --}}
    @if($similarDesigns->count() > 0)
    <section class="py-16 border-t border-white/10">
        <div class="site-container">
            <h2 class="cairo text-3xl font-black text-white mb-8">
                تصاميم <span class="text-nassaj-gold">مشابهة</span>
            </h2>

            <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-6 gap-4">
                @foreach($similarDesigns as $similar)
                <a href="{{ route('designs.show', $similar) }}" class="group relative rounded-2xl overflow-hidden bg-gradient-to-br from-white/5 to-transparent border border-white/10 hover:border-nassaj-gold/50 transition-all">
                    <div class="aspect-square relative overflow-hidden bg-gradient-to-br from-gray-800 to-gray-900">
                        @if($similar->preview_image_url)
                            <img src="{{ $similar->preview_image_url }}" alt="{{ $similar->name }}" class="w-full h-full object-cover transition-transform duration-500 group-hover:scale-110">
                        @else
                            <div class="w-full h-full flex items-center justify-center text-gray-600">
                                <svg class="w-12 h-12" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                </svg>
                            </div>
                        @endif
                    </div>
                    <div class="p-3">
                        <h3 class="text-white font-bold text-xs line-clamp-1 group-hover:text-nassaj-gold transition-colors">
                            {{ $similar->name }}
                        </h3>
                    </div>
                </a>
                @endforeach
            </div>
        </div>
    </section>
    @endif
</div>
@endsection
