@extends('layouts.master')
@section('title', 'مكتبة التصاميم')

@section('content')
<div class="min-h-screen bg-gradient-to-br from-[#0a0a0a] via-[#1a1a1a] to-[#0a0a0a]">
    {{-- Hero Section --}}
    <section class="relative overflow-hidden bg-gradient-to-br from-nassaj-primary/20 to-black/60 border-b border-white/10">
        <div class="site-container py-20">
            <div class="text-center">
                <h1 class="cairo text-5xl md:text-6xl font-black text-white mb-6">
                    مكتبة <span class="text-nassaj-gold">التصاميم</span>
                </h1>
                <p class="text-gray-400 text-lg mb-8 max-w-2xl mx-auto">
                    اكتشف تصاميم مميزة أو قم بإنشاء تصميمك الخاص باستخدام الموديلات ثلاثية الأبعاد
                </p>
                
                {{-- Search Bar --}}
                <div class="max-w-2xl mx-auto">
                    <form action="{{ route('designs.index') }}" method="GET" class="relative">
                        <input type="text" 
                            name="search" 
                            value="{{ request('search') }}" 
                            placeholder="ابحث عن موديل أو تصميم..." 
                            class="w-full px-6 py-4 pr-14 bg-white/5 border border-white/10 rounded-2xl text-white placeholder-gray-500 focus:border-nassaj-gold focus:ring-2 focus:ring-nassaj-gold/20 outline-none transition-all">
                        <button type="submit" class="absolute right-4 top-1/2 -translate-y-1/2 text-gray-400 hover:text-nassaj-gold transition-colors">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M21 21l-5.197-5.197m0 0A7.5 7.5 0 105.196 5.196a7.5 7.5 0 0010.607 10.607z" />
                            </svg>
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </section>

    {{-- Featured Designs Section --}}
    @if($featuredDesigns->count() > 0)
    <section class="py-16 border-b border-white/10">
        <div class="site-container">
            <div class="flex items-center justify-between mb-8">
                <h2 class="cairo text-3xl md:text-4xl font-black text-white">
                    تصاميم <span class="text-nassaj-gold">مميزة</span>
                </h2>
                <a href="{{ route('designs.gallery') }}?sort=featured" class="text-nassaj-gold hover:text-nassaj-gold-light font-bold flex items-center gap-2 transition-colors">
                    <span>عرض الكل</span>
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7" />
                    </svg>
                </a>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                @foreach($featuredDesigns as $design)
                <a href="{{ route('designs.show', $design) }}" class="group relative rounded-3xl overflow-hidden bg-gradient-to-br from-white/5 to-transparent border border-white/10 hover:border-nassaj-gold/50 transition-all">
                    <div class="aspect-square relative overflow-hidden bg-gradient-to-br from-gray-800 to-gray-900">
                        @if($design->preview_image_url)
                            <img src="{{ $design->preview_image_url }}" alt="{{ $design->name }}" class="w-full h-full object-cover transition-transform duration-500 group-hover:scale-110">
                        @else
                            <div class="w-full h-full flex items-center justify-center text-gray-600">
                                <svg class="w-20 h-20" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                </svg>
                            </div>
                        @endif
                        
                        {{-- Featured Badge --}}
                        <div class="absolute top-4 right-4 bg-nassaj-gold text-black px-3 py-1.5 rounded-full text-xs font-black">
                            مميز
                        </div>

                        {{-- Overlay --}}
                        <div class="absolute inset-0 bg-gradient-to-t from-black/80 via-black/20 to-transparent opacity-0 group-hover:opacity-100 transition-opacity">
                            <div class="absolute bottom-0 left-0 right-0 p-4">
                                <div class="flex items-center gap-4 text-white text-sm">
                                    <div class="flex items-center gap-1.5">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M2.036 12.322a1.012 1.012 0 010-.639C3.423 7.51 7.36 4.5 12 4.5c4.638 0 8.573 3.007 9.963 7.178.07.207.07.431 0 .639C20.577 16.49 16.64 19.5 12 19.5c-4.638 0-8.573-3.007-9.963-7.178z" />
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                        </svg>
                                        <span>{{ $design->views_count }}</span>
                                    </div>
                                    <div class="flex items-center gap-1.5">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M21 8.25c0-2.485-2.099-4.5-4.688-4.5-1.935 0-3.597 1.126-4.312 2.733-.715-1.607-2.377-2.733-4.313-2.733C5.1 3.75 3 5.765 3 8.25c0 7.22 9 12 9 12s9-4.78 9-12z" />
                                        </svg>
                                        <span>{{ $design->likes_count }}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="p-4">
                        <h3 class="text-white font-bold text-base mb-2 line-clamp-1 group-hover:text-nassaj-gold transition-colors">
                            {{ $design->name }}
                        </h3>
                        <p class="text-gray-400 text-sm line-clamp-1">
                            {{ $design->productModel->name }}
                        </p>
                    </div>
                </a>
                @endforeach
            </div>
        </div>
    </section>
    @endif

    {{-- Popular Designs Section --}}
    @if($popularDesigns->count() > 0)
    <section class="py-16 border-b border-white/10">
        <div class="site-container">
            <div class="flex items-center justify-between mb-8">
                <h2 class="cairo text-3xl md:text-4xl font-black text-white">
                    الأكثر <span class="text-nassaj-gold">طلباً</span>
                </h2>
                <a href="{{ route('designs.gallery') }}?sort=popular" class="text-nassaj-gold hover:text-nassaj-gold-light font-bold flex items-center gap-2 transition-colors">
                    <span>عرض الكل</span>
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7" />
                    </svg>
                </a>
            </div>

            <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-4 md:gap-6">
                @foreach($popularDesigns as $design)
                <a href="{{ route('designs.show', $design) }}" class="group relative rounded-2xl overflow-hidden bg-gradient-to-br from-white/5 to-transparent border border-white/10 hover:border-nassaj-gold/50 transition-all">
                    <div class="aspect-square relative overflow-hidden bg-gradient-to-br from-gray-800 to-gray-900">
                        @if($design->preview_image_url)
                            <img src="{{ $design->preview_image_url }}" alt="{{ $design->name }}" class="w-full h-full object-cover transition-transform duration-500 group-hover:scale-110">
                        @endif
                        
                        {{-- Stats Badge --}}
                        <div class="absolute top-3 right-3 bg-black/60 backdrop-blur-sm text-white px-2.5 py-1 rounded-lg text-xs font-bold flex items-center gap-1.5">
                            <svg class="w-3.5 h-3.5 text-nassaj-gold" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M2.25 3h1.386c.51 0 .955.343 1.087.835l.383 1.437M7.5 14.25a3 3 0 00-3 3h15.75m-12.75-3h11.218c1.121-2.3 2.1-4.684 2.924-7.138a60.114 60.114 0 00-16.536-1.84M7.5 14.25L5.106 5.272M6 20.25a.75.75 0 11-1.5 0 .75.75 0 011.5 0zm12.75 0a.75.75 0 11-1.5 0 .75.75 0 011.5 0z" />
                            </svg>
                            <span>{{ $design->purchases_count }}</span>
                        </div>
                    </div>

                    <div class="p-3">
                        <h3 class="text-white font-bold text-sm line-clamp-1 group-hover:text-nassaj-gold transition-colors">
                            {{ $design->name }}
                        </h3>
                    </div>
                </a>
                @endforeach
            </div>
        </div>
    </section>
    @endif

    {{-- 3D Models Section --}}
    <section class="py-16">
        <div class="site-container">
            <div class="flex items-center justify-between mb-8">
                <div>
                    <h2 class="cairo text-3xl md:text-4xl font-black text-white mb-2">
                        الموديلات <span class="text-nassaj-gold">ثلاثية الأبعاد</span>
                    </h2>
                    <p class="text-gray-400">اختر موديلاً وابدأ بإنشاء تصميمك الخاص</p>
                </div>

                {{-- Filters --}}
                <div class="flex items-center gap-3">
                    <select name="sort" onchange="window.location.href = this.value" class="px-4 py-2 bg-white/5 border border-white/10 rounded-xl text-white text-sm font-bold focus:border-nassaj-gold focus:ring-2 focus:ring-nassaj-gold/20 outline-none transition-all">
                        <option value="{{ route('designs.index') }}" {{ request('sort') == null ? 'selected' : '' }}>الأحدث</option>
                        <option value="{{ route('designs.index', ['sort' => 'popular']) }}" {{ request('sort') == 'popular' ? 'selected' : '' }}>الأكثر شعبية</option>
                        <option value="{{ route('designs.index', ['sort' => 'featured']) }}" {{ request('sort') == 'featured' ? 'selected' : '' }}>المميزة</option>
                    </select>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                @forelse($models as $model)
                <div class="group relative rounded-3xl overflow-hidden bg-gradient-to-br from-white/5 to-transparent border border-white/10 hover:border-nassaj-gold/50 transition-all">
                    {{-- Image --}}
                    <div class="relative aspect-[4/3] overflow-hidden bg-gradient-to-br from-gray-800 to-gray-900">
                        @if($model->preview_image_url)
                            <img src="{{ $model->preview_image_url }}" alt="{{ $model->name }}" class="w-full h-full object-cover transition-transform duration-500 group-hover:scale-110">
                        @else
                            <div class="w-full h-full flex items-center justify-center text-gray-600">
                                <svg class="w-24 h-24" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1" d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9.003 9.003 0 008.354-5.646z" />
                                </svg>
                            </div>
                        @endif

                        @if($model->is_featured)
                        <div class="absolute top-4 right-4 bg-gradient-to-r from-nassaj-gold to-nassaj-gold-light text-black px-4 py-2 rounded-full text-sm font-black">
                            موديل جديد
                        </div>
                        @endif

                        {{-- Stats --}}
                        <div class="absolute bottom-4 left-4 right-4 flex items-center justify-between">
                            <div class="flex items-center gap-3 text-white text-sm bg-black/60 backdrop-blur-sm px-3 py-1.5 rounded-lg">
                                <div class="flex items-center gap-1.5">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" d="M9.53 16.122a3 3 0 00-5.78 1.128 2.25 2.25 0 01-2.4 2.245 4.5 4.5 0 008.4-2.245c0-.399-.078-.78-.22-1.128zm0 0a15.998 15.998 0 003.388-1.62m-5.043-.025a15.994 15.994 0 011.622-3.395m3.42 3.42a15.995 15.995 0 004.764-4.648l3.876-5.814a1.151 1.151 0 00-1.597-1.597L14.146 6.32a15.996 15.996 0 00-4.649 4.763m3.42 3.42a6.776 6.776 0 00-3.42-3.42" />
                                    </svg>
                                    <span>{{ $model->designs_count }} تصميم</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    {{-- Content --}}
                    <div class="p-6">
                        <h3 class="text-white cairo font-black text-xl mb-2 group-hover:text-nassaj-gold transition-colors">
                            {{ $model->name }}
                        </h3>
                        
                        @if($model->description)
                        <p class="text-gray-400 text-sm mb-4 line-clamp-2">
                            {{ $model->description }}
                        </p>
                        @endif

                        {{-- Product Info --}}
                        <div class="flex items-center gap-2 mb-4 text-gray-500 text-sm">
                            <span class="w-2 h-2 rounded-full bg-nassaj-gold"></span>
                            <span>{{ $model->product->name }}</span>
                        </div>

                        {{-- Preview Designs --}}
                        @if($model->publicDesigns->count() > 0)
                        <div class="flex gap-2 mb-4">
                            @foreach($model->publicDesigns->take(3) as $design)
                            <div class="flex-1 aspect-square rounded-lg overflow-hidden border border-white/10">
                                <img src="{{ $design->preview_image_url }}" alt="{{ $design->name }}" class="w-full h-full object-cover">
                            </div>
                            @endforeach
                        </div>
                        @endif

                        {{-- Actions --}}
                        <div class="flex gap-3">
                            <a href="{{ route('configurator.show', $model) }}" class="flex-1 bg-gradient-to-r from-nassaj-gold via-nassaj-gold-light to-nassaj-gold text-black py-3 rounded-xl font-black text-center hover:scale-105 transition-all flex items-center justify-center gap-2">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2.5" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M9.594 3.94c.09-.542.56-.94 1.11-.94h2.593c.55 0 1.02.398 1.11.94l.213 1.281c.063.374.313.686.645.87.074.04.147.083.22.127.324.196.72.257 1.075.124l1.217-.456a1.125 1.125 0 011.37.49l1.296 2.247a1.125 1.125 0 01-.26 1.431l-1.003.827c-.293.24-.438.613-.431.992a6.759 6.759 0 010 .255c-.007.378.138.75.43.99l1.005.828c.424.35.534.954.26 1.43l-1.298 2.247a1.125 1.125 0 01-1.369.491l-1.217-.456c-.355-.133-.75-.072-1.076.124a6.57 6.57 0 01-.22.128c-.331.183-.581.495-.644.869l-.213 1.28c-.09.543-.56.941-1.11.941h-2.594c-.55 0-1.02-.398-1.11-.94l-.213-1.281c-.062-.374-.312-.686-.644-.87a6.52 6.52 0 01-.22-.127c-.325-.196-.72-.257-1.076-.124l-1.217.456a1.125 1.125 0 01-1.369-.49l-1.297-2.247a1.125 1.125 0 01.26-1.431l1.004-.827c.292-.24.437-.613.43-.992a6.932 6.932 0 010-.255c.007-.378-.138-.75-.43-.99l-1.004-.828a1.125 1.125 0 01-.26-1.43l1.297-2.247a1.125 1.125 0 011.37-.491l1.216.456c.356.133.751.072 1.076-.124.072-.044.146-.087.22-.128.332-.183.582-.495.644-.869l.214-1.281z" />
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                </svg>
                                <span>تخصيص الآن</span>
                            </a>
                            
                            @if($model->publicDesigns->count() > 0)
                            <button onclick="alert('قريباً: عرض التصاميم المشابهة')" class="px-4 py-3 bg-white/5 hover:bg-white/10 border border-white/10 text-white rounded-xl font-bold transition-all">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M3.75 6A2.25 2.25 0 016 3.75h2.25A2.25 2.25 0 0110.5 6v2.25a2.25 2.25 0 01-2.25 2.25H6a2.25 2.25 0 01-2.25-2.25V6zM3.75 15.75A2.25 2.25 0 016 13.5h2.25a2.25 2.25 0 012.25 2.25V18a2.25 2.25 0 01-2.25 2.25H6A2.25 2.25 0 013.75 18v-2.25zM13.5 6a2.25 2.25 0 012.25-2.25H18A2.25 2.25 0 0120.25 6v2.25A2.25 2.25 0 0118 10.5h-2.25a2.25 2.25 0 01-2.25-2.25V6zM13.5 15.75a2.25 2.25 0 012.25-2.25H18a2.25 2.25 0 012.25 2.25V18A2.25 2.25 0 0118 20.25h-2.25A2.25 2.25 0 0113.5 18v-2.25z" />
                                </svg>
                            </button>
                            @endif
                        </div>
                    </div>
                </div>
                @empty
                <div class="col-span-full text-center py-20">
                    <svg class="w-24 h-24 mx-auto text-gray-600 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1" d="M20 13V6a2 2 0 00-2-2H6a2 2 0 00-2 2v7m16 0v5a2 2 0 01-2 2H6a2 2 0 01-2-2v-5m16 0h-2.586a1 1 0 00-.707.293l-2.414 2.414a1 1 0 01-.707.293h-3.172a1 1 0 01-.707-.293l-2.414-2.414A1 1 0 006.586 13H4" />
                    </svg>
                    <h3 class="text-white text-2xl font-black mb-2">لا توجد موديلات متاحة</h3>
                    <p class="text-gray-400">تحقق لاحقاً للحصول على موديلات جديدة</p>
                </div>
                @endforelse
            </div>

            {{-- Pagination --}}
            @if($models->hasPages())
            <div class="mt-12">
                {{ $models->links() }}
            </div>
            @endif
        </div>
    </section>
</div>
@endsection
