@props([
    'product' => null,
    'image' => '',
    'name' => '',
    'price' => 0,
    'oldPrice' => null,
    'badge' => null,
    'rating' => 0,
    'href' => '#',
])

<div {{ $attributes->merge(['class' => 'group relative']) }}>
    <div class="relative bg-white/5 backdrop-blur-sm border border-white/10 rounded-2xl overflow-hidden hover:border-nassaj-gold/40 transition-all duration-500 hover:shadow-2xl hover:shadow-nassaj-gold/20 hover:-translate-y-2">
        <!-- Image Container -->
        <div class="relative aspect-square overflow-hidden bg-gradient-to-br from-nassaj-purple/20 to-black/20">
            <img
                src="{{ $image }}"
                alt="{{ $name }}"
                class="h-full w-full object-cover transition-transform duration-700 group-hover:scale-110"
                loading="lazy"
            >
            
            <!-- Badge -->
            @if($badge)
                <div class="absolute top-3 right-3 z-10">
                    @php
                    $badgeColors = [
                        'sale' => 'bg-gradient-to-r from-red-500 to-red-600',
                        'new' => 'bg-gradient-to-r from-nassaj-gold to-nassaj-gold-dark',
                        'hot' => 'bg-gradient-to-r from-orange-500 to-red-500',
                    ];
                    $badgeClass = $badgeColors[$badge['type']] ?? $badgeColors['new'];
                    @endphp
                    <span class="inline-flex items-center px-3 py-1.5 rounded-full {{ $badgeClass }} text-white text-xs font-bold shadow-lg">
                        {{ $badge['text'] ?? 'جديد' }}
                    </span>
                </div>
            @endif
            
            <!-- Discount Percentage -->
            @if($oldPrice && $oldPrice > $price)
                <div class="absolute top-3 left-3 z-10">
                    <div class="bg-black/80 backdrop-blur-sm text-nassaj-gold px-2 py-1 rounded-lg text-sm font-bold">
                        -{{ round((($oldPrice - $price) / $oldPrice) * 100) }}%
                    </div>
                </div>
            @endif
            
            <!-- Overlay Actions -->
            <div class="absolute inset-0 bg-gradient-to-t from-black/90 via-black/40 to-transparent opacity-0 group-hover:opacity-100 transition-all duration-300 flex items-end justify-center pb-6 gap-2">
                <button
                    onclick="NassajUI.openModal('quick-view-modal')"
                    class="flex items-center gap-2 px-4 py-2.5 rounded-xl bg-white/90 hover:bg-white text-nassaj-purple font-semibold shadow-xl hover:shadow-2xl transform hover:scale-105 transition-all"
                    aria-label="عرض سريع"
                >
                    <svg class="h-5 w-5" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                    </svg>
                    <span class="hidden sm:inline">عرض سريع</span>
                </button>
                
                <button
                    onclick="NassajUI.addToWishlist({{ $product->id ?? 1 }})"
                    class="p-2.5 rounded-xl bg-white/90 hover:bg-white text-red-500 shadow-xl hover:shadow-2xl transform hover:scale-105 transition-all"
                    aria-label="إضافة للمفضلة"
                >
                    <svg class="h-5 w-5" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z" />
                    </svg>
                </button>
            </div>
        </div>
        
        <!-- Product Info -->
        <div class="p-5 space-y-3">
            <a href="{{ $href }}" class="block group/link">
                <h3 class="font-bold text-white line-clamp-2 group-hover/link:text-nassaj-gold transition-colors leading-relaxed">
                    {{ $name }}
                </h3>
            </a>
            
            <!-- Rating -->
            <div class="flex items-center gap-2">
                <div class="flex items-center gap-0.5">
                    @for($i = 1; $i <= 5; $i++)
                        <svg class="h-4 w-4 {{ $i <= $rating ? 'text-nassaj-gold fill-current' : 'text-gray-600' }}" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
                        </svg>
                    @endfor
                </div>
                <span class="text-sm text-gray-400">({{ rand(20, 99) }})</span>
            </div>
            
            <!-- Price -->
            <div class="flex items-center gap-2 flex-wrap">
                <span class="text-xl md:text-2xl font-black text-nassaj-gold">
                    {{ number_format($price, 0, '.', ',') }} <span class="text-sm">د.ع</span>
                </span>
                @if($oldPrice && $oldPrice > $price)
                    <span class="text-sm text-gray-500 line-through">
                        {{ number_format($oldPrice, 0, '.', ',') }} د.ع
                    </span>
                @endif
            </div>
            
            <!-- Add to Cart Button -->
            <button
                onclick="NassajUI.addToCart({{ $product->id ?? 1 }})"
                class="w-full flex items-center justify-center gap-2 px-4 py-3 rounded-xl bg-gradient-to-r from-nassaj-purple to-nassaj-purple-dark hover:from-nassaj-gold hover:to-nassaj-gold-dark text-white font-bold shadow-lg hover:shadow-gold transition-all duration-300 transform hover:scale-105"
            >
                <svg class="h-5 w-5" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z" />
                </svg>
                <span>أضف للسلة</span>
            </button>
        </div>
    </div>
</div>
