{{-- Desktop Sidebar --}}
<aside class="hidden lg:block w-72 shrink-0">
    <div class="bg-[#111111] rounded-2xl border border-white/5 overflow-hidden h-full flex flex-col sticky top-6">
        {{-- User Info --}}
        <div class="p-5 border-b border-white/5">
            <div class="flex items-center gap-3">
                <div class="w-12 h-12 rounded-xl bg-gradient-to-br from-nassaj-gold to-nassaj-gold-dark flex items-center justify-center text-black font-black text-xl">
                    {{ mb_substr(auth('client')->user()->name, 0, 1) }}
                </div>
                <div class="flex-1 min-w-0">
                    <h3 class="text-white font-bold truncate">{{ auth('client')->user()->name }}</h3>
                    <p class="text-gray-500 text-sm direction-ltr text-right">{{ auth('client')->user()->phone }}</p>
                </div>
            </div>
        </div>

        {{-- Navigation --}}
        <nav class="p-3 space-y-1 flex-1">
            <a href="{{ route('client.dashboard') }}"
               class="flex items-center gap-3 px-4 py-3 rounded-xl transition-all {{ request()->routeIs('client.dashboard') ? 'bg-nassaj-gold/15 text-nassaj-gold' : 'text-gray-400 hover:bg-white/5 hover:text-white' }}">
                <svg class="w-5 h-5 shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M2.25 12l8.954-8.955c.44-.439 1.152-.439 1.591 0L21.75 12M4.5 9.75v10.125c0 .621.504 1.125 1.125 1.125H9.75v-4.875c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125V21h4.125c.621 0 1.125-.504 1.125-1.125V9.75M8.25 21h8.25" />
                </svg>
                <span class="font-bold">لوحة التحكم</span>
            </a>

            <a href="{{ route('client.orders') }}"
               class="flex items-center gap-3 px-4 py-3 rounded-xl transition-all {{ request()->routeIs('client.orders*') ? 'bg-nassaj-gold/15 text-nassaj-gold' : 'text-gray-400 hover:bg-white/5 hover:text-white' }}">
                <svg class="w-5 h-5 shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M15.75 10.5V6a3.75 3.75 0 10-7.5 0v4.5m11.356-1.993l1.263 12c.07.665-.45 1.243-1.119 1.243H4.25a1.125 1.125 0 01-1.12-1.243l1.264-12A1.125 1.125 0 015.513 7.5h12.974c.576 0 1.059.435 1.119 1.007zM8.625 10.5a.375.375 0 11-.75 0 .375.375 0 01.75 0zm7.5 0a.375.375 0 11-.75 0 .375.375 0 01.75 0z" />
                </svg>
                <span class="font-bold">طلباتي</span>
                @php $pendingCount = auth('client')->user()->orders()->where('status', 'pending')->count(); @endphp
                @if($pendingCount > 0)
                    <span class="mr-auto bg-amber-500 text-black text-xs font-bold px-2 py-0.5 rounded-full">{{ $pendingCount }}</span>
                @endif
            </a>

            @if(auth('client')->user()->isDesigner())
            {{-- تصاميمي --}}
            <a href="{{ route('client.designs') }}"
               class="flex items-center gap-3 px-4 py-3 rounded-xl transition-all {{ request()->routeIs('client.designs') ? 'bg-nassaj-gold/15 text-nassaj-gold' : 'text-gray-400 hover:bg-white/5 hover:text-white' }}">
                <svg class="w-5 h-5 shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M9.53 16.122a3 3 0 00-5.78 1.128 2.25 2.25 0 01-2.4 2.245 4.5 4.5 0 008.4-2.245c0-.399-.078-.78-.22-1.128zm0 0a15.998 15.998 0 003.388-1.62m-5.043-.025a15.994 15.994 0 011.622-3.395m3.42 3.42a15.995 15.995 0 004.764-4.648l3.876-5.814a1.151 1.151 0 00-1.597-1.597L14.146 6.32a15.996 15.996 0 00-4.649 4.763m3.42 3.42a6.776 6.776 0 00-3.42-3.42" />
                </svg>
                <span class="font-bold">تصاميمي</span>
                @php $designsCount = auth('client')->user()->designs()->count(); @endphp
                @if($designsCount > 0)
                    <span class="mr-auto bg-pink-500/20 text-pink-400 text-xs font-bold px-2 py-0.5 rounded-full">{{ $designsCount }}</span>
                @endif
            </a>

            {{-- مكتبة ملصقاتي --}}
            <a href="{{ route('client.stickers') }}"
               class="flex items-center gap-3 px-4 py-3 rounded-xl transition-all {{ request()->routeIs('client.stickers') ? 'bg-nassaj-gold/15 text-nassaj-gold' : 'text-gray-400 hover:bg-white/5 hover:text-white' }}">
                <svg class="w-5 h-5 shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M11.48 3.499a.562.562 0 011.04 0l2.125 5.111a.563.563 0 00.475.345l5.518.442c.499.04.701.663.321.988l-4.204 3.602a.563.563 0 00-.182.557l1.285 5.385a.562.562 0 01-.84.61l-4.725-2.885a.563.563 0 00-.586 0L6.982 20.54a.562.562 0 01-.84-.61l1.285-5.386a.562.562 0 00-.182-.557l-4.204-3.602a.563.563 0 01.321-.988l5.518-.442a.563.563 0 00.475-.345L11.48 3.5z" />
                </svg>
                <span class="font-bold">مكتبة ملصقاتي</span>
                @php $pendingStickerCount = auth('client')->user()->stickers()->where('status', 'pending')->count(); @endphp
                @if($pendingStickerCount > 0)
                    <span class="mr-auto bg-amber-500 text-black text-xs font-bold px-2 py-0.5 rounded-full">{{ $pendingStickerCount }}</span>
                @endif
            </a>
            @endif

            <a href="{{ route('client.profile') }}"
               class="flex items-center gap-3 px-4 py-3 rounded-xl transition-all {{ request()->routeIs('client.profile') ? 'bg-nassaj-gold/15 text-nassaj-gold' : 'text-gray-400 hover:bg-white/5 hover:text-white' }}">
                <svg class="w-5 h-5 shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M15.75 6a3.75 3.75 0 11-7.5 0 3.75 3.75 0 017.5 0zM4.501 20.118a7.5 7.5 0 0114.998 0A17.933 17.933 0 0112 21.75c-2.676 0-5.216-.584-7.499-1.632z" />
                </svg>
                <span class="font-bold">الملف الشخصي</span>
            </a>

            <a href="{{ route('client.addresses') }}"
               class="flex items-center gap-3 px-4 py-3 rounded-xl transition-all {{ request()->routeIs('client.addresses') ? 'bg-nassaj-gold/15 text-nassaj-gold' : 'text-gray-400 hover:bg-white/5 hover:text-white' }}">
                <svg class="w-5 h-5 shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M15 10.5a3 3 0 11-6 0 3 3 0 016 0z" />
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M19.5 10.5c0 7.142-7.5 11.25-7.5 11.25S4.5 17.642 4.5 10.5a7.5 7.5 0 1115 0z" />
                </svg>
                <span class="font-bold">العناوين</span>
            </a>
        </nav>

        {{-- Logout --}}
        <div class="p-3 border-t border-white/5 mt-auto">
            <form action="{{ route('client.logout') }}" method="POST">
                @csrf
                <button type="submit" class="w-full flex items-center justify-center gap-2 px-4 py-3 rounded-xl bg-red-500/10 text-red-400 hover:bg-red-500/20 transition-all">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M15.75 9V5.25A2.25 2.25 0 0013.5 3h-6a2.25 2.25 0 00-2.25 2.25v13.5A2.25 2.25 0 007.5 21h6a2.25 2.25 0 002.25-2.25V15M12 9l-3 3m0 0l3 3m-3-3h12.75" />
                    </svg>
                    <span class="font-bold">تسجيل الخروج</span>
                </button>
            </form>
        </div>
    </div>
</aside>

{{-- Mobile Header --}}
<div class="lg:hidden mb-6" x-data="{ sidebarOpen: false }">
    <div class="flex items-center justify-between bg-[#111111] rounded-2xl p-4 border border-white/5">
        <div class="flex items-center gap-3">
            <div class="w-10 h-10 rounded-xl bg-gradient-to-br from-nassaj-gold to-nassaj-gold-dark flex items-center justify-center text-black font-black">
                {{ mb_substr(auth('client')->user()->name, 0, 1) }}
            </div>
            <div>
                <h3 class="text-white font-bold text-sm">{{ auth('client')->user()->name }}</h3>
                <p class="text-gray-500 text-xs">{{ $pageTitle ?? 'لوحة التحكم' }}</p>
            </div>
        </div>
        <button @click="sidebarOpen = true" 
                class="w-10 h-10 rounded-xl bg-nassaj-gold/10 text-nassaj-gold flex items-center justify-center">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
            </svg>
        </button>
    </div>

    {{-- Mobile Sidebar Drawer --}}
    <div x-show="sidebarOpen" x-cloak class="fixed inset-0 z-50">
        {{-- Overlay --}}
        <div x-show="sidebarOpen"
             x-transition:enter="transition ease-out duration-300"
             x-transition:enter-start="opacity-0"
             x-transition:enter-end="opacity-100"
             x-transition:leave="transition ease-in duration-200"
             x-transition:leave-start="opacity-100"
             x-transition:leave-end="opacity-0"
             @click="sidebarOpen = false"
             class="absolute inset-0 bg-black/70 backdrop-blur-sm"></div>

        {{-- Drawer --}}
        <div x-show="sidebarOpen"
             x-transition:enter="transition ease-out duration-300"
             x-transition:enter-start="translate-x-full"
             x-transition:enter-end="translate-x-0"
             x-transition:leave="transition ease-in duration-200"
             x-transition:leave-start="translate-x-0"
             x-transition:leave-end="translate-x-full"
             class="absolute left-0 top-0 bottom-0 w-80 max-w-[85vw] bg-[#111111] border-r border-white/10 shadow-2xl">
            
            {{-- Close Button --}}
            <div class="flex items-center justify-between p-4 border-b border-white/5">
                <span class="text-white font-bold">القائمة</span>
                <button @click="sidebarOpen = false" class="w-10 h-10 rounded-xl bg-white/5 flex items-center justify-center text-gray-400 hover:text-white">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>

            {{-- User Info --}}
            <div class="p-4 border-b border-white/5">
                <div class="flex items-center gap-3">
                    <div class="w-12 h-12 rounded-xl bg-gradient-to-br from-nassaj-gold to-nassaj-gold-dark flex items-center justify-center text-black font-black text-xl">
                        {{ mb_substr(auth('client')->user()->name, 0, 1) }}
                    </div>
                    <div class="flex-1 min-w-0">
                        <h3 class="text-white font-bold truncate">{{ auth('client')->user()->name }}</h3>
                        <p class="text-gray-500 text-sm">{{ auth('client')->user()->phone }}</p>
                    </div>
                </div>
            </div>

            {{-- Navigation --}}
            <nav class="p-3 space-y-1">
                <a href="{{ route('client.dashboard') }}" @click="sidebarOpen = false"
                   class="flex items-center gap-3 px-4 py-3.5 rounded-xl transition-all {{ request()->routeIs('client.dashboard') ? 'bg-nassaj-gold/15 text-nassaj-gold' : 'text-gray-400 hover:bg-white/5 hover:text-white' }}">
                    <svg class="w-5 h-5 shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M2.25 12l8.954-8.955c.44-.439 1.152-.439 1.591 0L21.75 12M4.5 9.75v10.125c0 .621.504 1.125 1.125 1.125H9.75v-4.875c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125V21h4.125c.621 0 1.125-.504 1.125-1.125V9.75M8.25 21h8.25" />
                    </svg>
                    <span class="font-bold">لوحة التحكم</span>
                </a>

                <a href="{{ route('client.orders') }}" @click="sidebarOpen = false"
                   class="flex items-center gap-3 px-4 py-3.5 rounded-xl transition-all {{ request()->routeIs('client.orders*') ? 'bg-nassaj-gold/15 text-nassaj-gold' : 'text-gray-400 hover:bg-white/5 hover:text-white' }}">
                    <svg class="w-5 h-5 shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M15.75 10.5V6a3.75 3.75 0 10-7.5 0v4.5m11.356-1.993l1.263 12c.07.665-.45 1.243-1.119 1.243H4.25a1.125 1.125 0 01-1.12-1.243l1.264-12A1.125 1.125 0 015.513 7.5h12.974c.576 0 1.059.435 1.119 1.007zM8.625 10.5a.375.375 0 11-.75 0 .375.375 0 01.75 0zm7.5 0a.375.375 0 11-.75 0 .375.375 0 01.75 0z" />
                    </svg>
                    <span class="font-bold">طلباتي</span>
                    @if($pendingCount > 0)
                        <span class="mr-auto bg-amber-500 text-black text-xs font-bold px-2 py-0.5 rounded-full">{{ $pendingCount }}</span>
                    @endif
                </a>

                @if(auth('client')->user()->isDesigner())
                {{-- تصاميمي --}}
                <a href="{{ route('client.designs') }}" @click="sidebarOpen = false"
                   class="flex items-center gap-3 px-4 py-3.5 rounded-xl transition-all {{ request()->routeIs('client.designs') ? 'bg-nassaj-gold/15 text-nassaj-gold' : 'text-gray-400 hover:bg-white/5 hover:text-white' }}">
                    <svg class="w-5 h-5 shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M9.53 16.122a3 3 0 00-5.78 1.128 2.25 2.25 0 01-2.4 2.245 4.5 4.5 0 008.4-2.245c0-.399-.078-.78-.22-1.128zm0 0a15.998 15.998 0 003.388-1.62m-5.043-.025a15.994 15.994 0 011.622-3.395m3.42 3.42a15.995 15.995 0 004.764-4.648l3.876-5.814a1.151 1.151 0 00-1.597-1.597L14.146 6.32a15.996 15.996 0 00-4.649 4.763m3.42 3.42a6.776 6.776 0 00-3.42-3.42" />
                    </svg>
                    <span class="font-bold">تصاميمي</span>
                    @php $designsCount = auth('client')->user()->designs()->count(); @endphp
                    @if($designsCount > 0)
                        <span class="mr-auto bg-pink-500/20 text-pink-400 text-xs font-bold px-2 py-0.5 rounded-full">{{ $designsCount }}</span>
                    @endif
                </a>

                {{-- مكتبة ملصقاتي --}}
                <a href="{{ route('client.stickers') }}" @click="sidebarOpen = false"
                   class="flex items-center gap-3 px-4 py-3.5 rounded-xl transition-all {{ request()->routeIs('client.stickers') ? 'bg-nassaj-gold/15 text-nassaj-gold' : 'text-gray-400 hover:bg-white/5 hover:text-white' }}">
                    <svg class="w-5 h-5 shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M11.48 3.499a.562.562 0 011.04 0l2.125 5.111a.563.563 0 00.475.345l5.518.442c.499.04.701.663.321.988l-4.204 3.602a.563.563 0 00-.182.557l1.285 5.385a.562.562 0 01-.84.61l-4.725-2.885a.563.563 0 00-.586 0L6.982 20.54a.562.562 0 01-.84-.61l1.285-5.386a.562.562 0 00-.182-.557l-4.204-3.602a.563.563 0 01.321-.988l5.518-.442a.563.563 0 00.475-.345L11.48 3.5z" />
                    </svg>
                    <span class="font-bold">مكتبة ملصقاتي</span>
                    @php $pendingStickerCount = auth('client')->user()->stickers()->where('status', 'pending')->count(); @endphp
                    @if($pendingStickerCount > 0)
                        <span class="mr-auto bg-amber-500 text-black text-xs font-bold px-2 py-0.5 rounded-full">{{ $pendingStickerCount }}</span>
                    @endif
                </a>
                @endif

                <a href="{{ route('client.profile') }}" @click="sidebarOpen = false"
                   class="flex items-center gap-3 px-4 py-3.5 rounded-xl transition-all {{ request()->routeIs('client.profile') ? 'bg-nassaj-gold/15 text-nassaj-gold' : 'text-gray-400 hover:bg-white/5 hover:text-white' }}">
                    <svg class="w-5 h-5 shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M15.75 6a3.75 3.75 0 11-7.5 0 3.75 3.75 0 017.5 0zM4.501 20.118a7.5 7.5 0 0114.998 0A17.933 17.933 0 0112 21.75c-2.676 0-5.216-.584-7.499-1.632z" />
                    </svg>
                    <span class="font-bold">الملف الشخصي</span>
                </a>

                <a href="{{ route('client.addresses') }}" @click="sidebarOpen = false"
                   class="flex items-center gap-3 px-4 py-3.5 rounded-xl transition-all {{ request()->routeIs('client.addresses') ? 'bg-nassaj-gold/15 text-nassaj-gold' : 'text-gray-400 hover:bg-white/5 hover:text-white' }}">
                    <svg class="w-5 h-5 shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M15 10.5a3 3 0 11-6 0 3 3 0 016 0z" />
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M19.5 10.5c0 7.142-7.5 11.25-7.5 11.25S4.5 17.642 4.5 10.5a7.5 7.5 0 1115 0z" />
                    </svg>
                    <span class="font-bold">العناوين</span>
                </a>
            </nav>

            {{-- Logout --}}
            <div class="absolute bottom-0 left-0 right-0 p-4 border-t border-white/5 bg-[#111111]">
                <form action="{{ route('client.logout') }}" method="POST">
                    @csrf
                    <button type="submit" class="w-full flex items-center justify-center gap-2 px-4 py-3 rounded-xl bg-red-500/10 text-red-400 hover:bg-red-500/20 transition-all">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M15.75 9V5.25A2.25 2.25 0 0013.5 3h-6a2.25 2.25 0 00-2.25 2.25v13.5A2.25 2.25 0 007.5 21h6a2.25 2.25 0 002.25-2.25V15M12 9l-3 3m0 0l3 3m-3-3h12.75" />
                        </svg>
                        <span class="font-bold">تسجيل الخروج</span>
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>
