@extends('layouts.master')

@section('title', 'الملف الشخصي')

@section('content')
    <div class="min-h-screen bg-[#0a0a0a] py-6 lg:py-10">
        <div class="site-container">
            <div class="flex flex-col lg:flex-row gap-6 lg:items-stretch">
                {{-- Sidebar --}}
                <x-client-sidebar :pageTitle="'الملف الشخصي'" />

                {{-- Main Content --}}
                <main class="flex-1 min-w-0">
                    {{-- Page Header (Desktop) --}}
                    <div class="hidden lg:block mb-6">
                        <h1 class="cairo text-2xl font-black text-white">الملف الشخصي</h1>
                        <p class="text-gray-500 text-sm mt-1">إدارة معلوماتك الشخصية</p>
                    </div>

                    {{-- Page Content --}}
                    <div class="bg-[#111111] rounded-2xl border border-white/5 p-4 sm:p-6">
                        <div class="space-y-4">
                            {{-- Success/Error Messages --}}
                            @if (session('success'))
                                <div
                                    class="p-4 rounded-2xl bg-emerald-500/10 border border-emerald-500/20 text-emerald-300 flex items-center gap-3">
                                    <svg class="w-5 h-5 shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                    {{ session('success') }}
                                </div>
                            @endif

                            {{-- Profile Info --}}
                            <div class="bg-[#111111] rounded-2xl border border-white/10 overflow-hidden"
                                x-data="{ open: true }">
                                <button @click="open = !open" type="button"
                                    class="w-full px-5 py-4 flex items-center justify-between hover:bg-white/5 transition-colors">
                                    <div class="flex items-center gap-3">
                                        <div class="w-10 h-10 rounded-xl bg-[#D4A356]/10 flex items-center justify-center">
                                            <svg class="w-5 h-5 text-[#D4A356]" fill="none" stroke="currentColor"
                                                viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                                    d="M15.75 6a3.75 3.75 0 11-7.5 0 3.75 3.75 0 017.5 0zM4.501 20.118a7.5 7.5 0 0114.998 0A17.933 17.933 0 0112 21.75c-2.676 0-5.216-.584-7.499-1.632z" />
                                            </svg>
                                        </div>
                                        <h2 class="text-base font-bold text-white">المعلومات الشخصية</h2>
                                    </div>
                                    <svg class="w-5 h-5 text-gray-400 transition-transform duration-300"
                                        :class="{ 'rotate-180': open }" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M19 9l-7 7-7-7" />
                                    </svg>
                                </button>

                                <div x-show="open" x-collapse>
                                    <form action="{{ route('client.profile.update') }}" method="POST"
                                        class="p-5 pt-0 border-t border-white/5">
                                        @csrf
                                        @method('PUT')

                                        <div class="grid grid-cols-1 md:grid-cols-2 gap-5 mt-5">
                                            {{-- Name --}}
                                            <div>
                                                <label class="block text-sm font-bold text-gray-300 mb-2">الاسم
                                                    الكامل</label>
                                                <input type="text" name="name"
                                                    value="{{ old('name', $client->name) }}"
                                                    class="w-full px-4 py-3 rounded-xl bg-white/5 border border-white/10 focus:border-[#D4A356] focus:ring-2 focus:ring-[#D4A356]/20 outline-none transition-all text-white">
                                                @error('name')
                                                    <p class="mt-2 text-sm text-red-400">{{ $message }}</p>
                                                @enderror
                                            </div>

                                            {{-- Company --}}
                                            <div>
                                                <label class="block text-sm font-bold text-gray-300 mb-2">الشركة
                                                    (اختياري)</label>
                                                <input type="text" name="company"
                                                    value="{{ old('company', $client->company) }}"
                                                    class="w-full px-4 py-3 rounded-xl bg-white/5 border border-white/10 focus:border-[#D4A356] focus:ring-2 focus:ring-[#D4A356]/20 outline-none transition-all text-white"
                                                    placeholder="اسم الشركة">
                                                @error('company')
                                                    <p class="mt-2 text-sm text-red-400">{{ $message }}</p>
                                                @enderror
                                            </div>

                                            {{-- Phone --}}
                                            <div>
                                                <label class="block text-sm font-bold text-gray-300 mb-2">رقم الهاتف</label>
                                                <input type="tel" name="phone"
                                                    value="{{ old('phone', $client->phone) }}" maxlength="11" minlength="11"
                                                    pattern="[0-9]{11}"
                                                    oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0, 11)"
                                                    class="w-full px-4 py-3 rounded-xl bg-white/5 border border-white/10 focus:border-[#D4A356] focus:ring-2 focus:ring-[#D4A356]/20 outline-none transition-all text-white"
                                                    placeholder="07xxxxxxxxx">
                                                @error('phone')
                                                    <p class="mt-2 text-sm text-red-400">{{ $message }}</p>
                                                @enderror
                                            </div>

                                            {{-- Phone 2 --}}
                                            <div>
                                                <label class="block text-sm font-bold text-gray-300 mb-2">رقم هاتف إضافي
                                                    (اختياري)</label>
                                                <input type="tel" name="phone2"
                                                    value="{{ old('phone2', $client->phone2) }}" maxlength="11"
                                                    minlength="11" pattern="[0-9]{11}"
                                                    oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0, 11)"
                                                    class="w-full px-4 py-3 rounded-xl bg-white/5 border border-white/10 focus:border-[#D4A356] focus:ring-2 focus:ring-[#D4A356]/20 outline-none transition-all text-white"
                                                    placeholder="07xxxxxxxxx">
                                                @error('phone2')
                                                    <p class="mt-2 text-sm text-red-400">{{ $message }}</p>
                                                @enderror
                                            </div>

                                            {{-- City --}}
                                            <div x-data="{
                                                open: false,
                                                search: '',
                                                selected: '{{ old('city_id', $client->city_id) }}',
                                                selectedName: '{{ $cities->firstWhere('id', old('city_id', $client->city_id))?->name ?? 'اختر المدينة' }}',
                                                cities: @js($cities->map(fn($c) => ['id' => $c->id, 'name' => $c->name])),
                                                get filteredCities() {
                                                    if (!this.search) return this.cities;
                                                    return this.cities.filter(c => c.name.includes(this.search));
                                                }
                                            }">
                                                <label class="block text-sm font-bold text-gray-300 mb-2">المدينة</label>
                                                <input type="hidden" name="city_id" :value="selected">
                                                <div class="relative">
                                                    <button type="button"
                                                        @click="open = !open; $nextTick(() => open && $refs.searchInput.focus())"
                                                        class="w-full px-4 py-3 rounded-xl bg-white/5 border border-white/10 focus:border-[#D4A356] focus:ring-2 focus:ring-[#D4A356]/20 outline-none transition-all text-white flex items-center justify-between">
                                                        <span x-text="selectedName"
                                                            :class="selected ? 'text-white' : 'text-gray-400'"></span>
                                                        <svg class="w-5 h-5 text-gray-400 transition-transform"
                                                            :class="{ 'rotate-180': open }" fill="none"
                                                            stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                stroke-width="2" d="M19 9l-7 7-7-7" />
                                                        </svg>
                                                    </button>
                                                    <div x-show="open" @click.away="open = false; search = ''"
                                                        x-transition:enter="transition ease-out duration-200"
                                                        x-transition:enter-start="opacity-0 -translate-y-2"
                                                        x-transition:enter-end="opacity-100 translate-y-0"
                                                        x-transition:leave="transition ease-in duration-150"
                                                        x-transition:leave-start="opacity-100 translate-y-0"
                                                        x-transition:leave-end="opacity-0 -translate-y-2"
                                                        class="absolute z-50 mt-2 w-full bg-[#1a1a1a] border border-white/10 rounded-xl shadow-xl overflow-hidden">
                                                        {{-- Search Input --}}
                                                        <div class="p-2 border-b border-white/10">
                                                            <div class="relative">
                                                                <svg class="w-4 h-4 text-gray-400 absolute right-3 top-1/2 -translate-y-1/2"
                                                                    fill="none" stroke="currentColor"
                                                                    viewBox="0 0 24 24">
                                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                                        stroke-width="2"
                                                                        d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                                                                </svg>
                                                                <input type="text" x-ref="searchInput"
                                                                    x-model="search" placeholder="ابحث عن مدينة..."
                                                                    class="w-full pl-3 pr-9 py-2 rounded-lg bg-white/5 border border-white/10 focus:border-[#D4A356] outline-none text-white text-sm placeholder-gray-500">
                                                            </div>
                                                        </div>
                                                        {{-- Options --}}
                                                        <div class="max-h-48 overflow-y-auto">
                                                            <div @click="selected = ''; selectedName = 'اختر المدينة'; open = false; search = ''"
                                                                class="px-4 py-3 hover:bg-white/10 cursor-pointer text-gray-400 transition-colors">
                                                                اختر المدينة
                                                            </div>
                                                            <template x-for="city in filteredCities"
                                                                :key="city.id">
                                                                <div @click="selected = city.id; selectedName = city.name; open = false; search = ''"
                                                                    class="px-4 py-3 hover:bg-[#D4A356]/20 cursor-pointer text-white transition-colors"
                                                                    :class="{ 'bg-[#D4A356]/10 text-[#D4A356]': selected == city
                                                                            .id }"
                                                                    x-text="city.name">
                                                                </div>
                                                            </template>
                                                            <div x-show="filteredCities.length === 0"
                                                                class="px-4 py-3 text-gray-500 text-center">
                                                                لا توجد نتائج
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                @error('city_id')
                                                    <p class="mt-2 text-sm text-red-400">{{ $message }}</p>
                                                @enderror
                                            </div>

                                            {{-- Address --}}
                                            <div class="md:col-span-2">
                                                <label class="block text-sm font-bold text-gray-300 mb-2">العنوان
                                                    التفصيلي</label>
                                                <textarea name="address" rows="3"
                                                    class="w-full px-4 py-3 rounded-xl bg-white/5 border border-white/10 focus:border-[#D4A356] focus:ring-2 focus:ring-[#D4A356]/20 outline-none transition-all text-white resize-none"
                                                    placeholder="المنطقة، الشارع، أقرب نقطة دالة...">{{ old('address', $client->address) }}</textarea>
                                                @error('address')
                                                    <p class="mt-2 text-sm text-red-400">{{ $message }}</p>
                                                @enderror
                                            </div>
                                        </div>

                                        <div class="mt-5 flex justify-start">
                                            <button type="submit"
                                                class="px-6 py-2.5 rounded-xl bg-gradient-to-r from-[#D4A356] to-[#442247] text-black font-bold hover:shadow-lg hover:shadow-[#D4A356]/20 transition-all text-sm">
                                                حفظ التغييرات
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>

                            {{-- Change Password --}}
                            <div class="bg-[#111111] rounded-2xl border border-white/10 overflow-hidden"
                                x-data="{ open: false }">
                                <button @click="open = !open" type="button"
                                    class="w-full px-5 py-4 flex items-center justify-between hover:bg-white/5 transition-colors">
                                    <div class="flex items-center gap-3">
                                        <div class="w-10 h-10 rounded-xl bg-[#D4A356]/10 flex items-center justify-center">
                                            <svg class="w-5 h-5 text-[#D4A356]" fill="none" stroke="currentColor"
                                                viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                                    d="M16.5 10.5V6.75a4.5 4.5 0 10-9 0v3.75m-.75 11.25h10.5a2.25 2.25 0 002.25-2.25v-6.75a2.25 2.25 0 00-2.25-2.25H6.75a2.25 2.25 0 00-2.25 2.25v6.75a2.25 2.25 0 002.25 2.25z" />
                                            </svg>
                                        </div>
                                        <h2 class="text-base font-bold text-white">تغيير كلمة المرور</h2>
                                    </div>
                                    <svg class="w-5 h-5 text-gray-400 transition-transform duration-300"
                                        :class="{ 'rotate-180': open }" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M19 9l-7 7-7-7" />
                                    </svg>
                                </button>

                                <div x-show="open" x-collapse>
                                    <form action="{{ route('client.profile.password') }}" method="POST"
                                        class="p-5 pt-0 border-t border-white/5">
                                        @csrf
                                        @method('PUT')

                                        <div class="grid grid-cols-1 md:grid-cols-3 gap-5 mt-5">
                                            {{-- Current Password --}}
                                            <div x-data="{ show: false }">
                                                <label class="block text-sm font-bold text-gray-300 mb-2">كلمة المرور
                                                    الحالية</label>
                                                <div class="relative">
                                                    <input :type="show ? 'text' : 'password'" name="current_password"
                                                        class="w-full px-4 py-3 pe-12 rounded-xl bg-white/5 border border-white/10 focus:border-[#D4A356] focus:ring-2 focus:ring-[#D4A356]/20 outline-none transition-all text-white"
                                                        placeholder="••••••••">
                                                    <button type="button" @click="show = !show"
                                                        class="absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 hover:text-[#D4A356] transition-colors">
                                                        <svg x-show="!show" class="w-5 h-5" fill="none"
                                                            stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                stroke-width="1.5"
                                                                d="M2.036 12.322a1.012 1.012 0 010-.639C3.423 7.51 7.36 4.5 12 4.5c4.638 0 8.573 3.007 9.963 7.178.07.207.07.431 0 .639C20.577 16.49 16.64 19.5 12 19.5c-4.638 0-8.573-3.007-9.963-7.178z" />
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                stroke-width="1.5" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                                        </svg>
                                                        <svg x-show="show" x-cloak class="w-5 h-5" fill="none"
                                                            stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                stroke-width="1.5"
                                                                d="M3.98 8.223A10.477 10.477 0 001.934 12C3.226 16.338 7.244 19.5 12 19.5c.993 0 1.953-.138 2.863-.395M6.228 6.228A10.45 10.45 0 0112 4.5c4.756 0 8.773 3.162 10.065 7.498a10.523 10.523 0 01-4.293 5.774M6.228 6.228L3 3m3.228 3.228l3.65 3.65m7.894 7.894L21 21m-3.228-3.228l-3.65-3.65m0 0a3 3 0 10-4.243-4.243m4.242 4.242L9.88 9.88" />
                                                        </svg>
                                                    </button>
                                                </div>
                                                @error('current_password')
                                                    <p class="mt-2 text-sm text-red-400">{{ $message }}</p>
                                                @enderror
                                            </div>

                                            {{-- New Password --}}
                                            <div x-data="{ show: false }">
                                                <label class="block text-sm font-bold text-gray-300 mb-2">كلمة المرور
                                                    الجديدة</label>
                                                <div class="relative">
                                                    <input :type="show ? 'text' : 'password'" name="password"
                                                        class="w-full px-4 py-3 pe-12 rounded-xl bg-white/5 border border-white/10 focus:border-[#D4A356] focus:ring-2 focus:ring-[#D4A356]/20 outline-none transition-all text-white"
                                                        placeholder="••••••••">
                                                    <button type="button" @click="show = !show"
                                                        class="absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 hover:text-[#D4A356] transition-colors">
                                                        <svg x-show="!show" class="w-5 h-5" fill="none"
                                                            stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                stroke-width="1.5"
                                                                d="M2.036 12.322a1.012 1.012 0 010-.639C3.423 7.51 7.36 4.5 12 4.5c4.638 0 8.573 3.007 9.963 7.178.07.207.07.431 0 .639C20.577 16.49 16.64 19.5 12 19.5c-4.638 0-8.573-3.007-9.963-7.178z" />
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                stroke-width="1.5" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                                        </svg>
                                                        <svg x-show="show" x-cloak class="w-5 h-5" fill="none"
                                                            stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                stroke-width="1.5"
                                                                d="M3.98 8.223A10.477 10.477 0 001.934 12C3.226 16.338 7.244 19.5 12 19.5c.993 0 1.953-.138 2.863-.395M6.228 6.228A10.45 10.45 0 0112 4.5c4.756 0 8.773 3.162 10.065 7.498a10.523 10.523 0 01-4.293 5.774M6.228 6.228L3 3m3.228 3.228l3.65 3.65m7.894 7.894L21 21m-3.228-3.228l-3.65-3.65m0 0a3 3 0 10-4.243-4.243m4.242 4.242L9.88 9.88" />
                                                        </svg>
                                                    </button>
                                                </div>
                                                @error('password')
                                                    <p class="mt-2 text-sm text-red-400">{{ $message }}</p>
                                                @enderror
                                            </div>

                                            {{-- Confirm Password --}}
                                            <div x-data="{ show: false }">
                                                <label class="block text-sm font-bold text-gray-300 mb-2">تأكيد كلمة
                                                    المرور</label>
                                                <div class="relative">
                                                    <input :type="show ? 'text' : 'password'" name="password_confirmation"
                                                        class="w-full px-4 py-3 pe-12 rounded-xl bg-white/5 border border-white/10 focus:border-[#D4A356] focus:ring-2 focus:ring-[#D4A356]/20 outline-none transition-all text-white"
                                                        placeholder="••••••••">
                                                    <button type="button" @click="show = !show"
                                                        class="absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 hover:text-[#D4A356] transition-colors">
                                                        <svg x-show="!show" class="w-5 h-5" fill="none"
                                                            stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                stroke-width="1.5"
                                                                d="M2.036 12.322a1.012 1.012 0 010-.639C3.423 7.51 7.36 4.5 12 4.5c4.638 0 8.573 3.007 9.963 7.178.07.207.07.431 0 .639C20.577 16.49 16.64 19.5 12 19.5c-4.638 0-8.573-3.007-9.963-7.178z" />
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                stroke-width="1.5" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                                        </svg>
                                                        <svg x-show="show" x-cloak class="w-5 h-5" fill="none"
                                                            stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                stroke-width="1.5"
                                                                d="M3.98 8.223A10.477 10.477 0 001.934 12C3.226 16.338 7.244 19.5 12 19.5c.993 0 1.953-.138 2.863-.395M6.228 6.228A10.45 10.45 0 0112 4.5c4.756 0 8.773 3.162 10.065 7.498a10.523 10.523 0 01-4.293 5.774M6.228 6.228L3 3m3.228 3.228l3.65 3.65m7.894 7.894L21 21m-3.228-3.228l-3.65-3.65m0 0a3 3 0 10-4.243-4.243m4.242 4.242L9.88 9.88" />
                                                        </svg>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="mt-5 flex justify-start">
                                            <button type="submit"
                                                class="px-6 py-2.5 rounded-xl bg-white/10 text-white font-bold hover:bg-white/20 transition-all text-sm">
                                                تغيير كلمة المرور
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </main>
            </div>
        </div>
    </div>
@endsection
