{{-- Upload Modal --}}
<div id="stickerUploadModal" class="hidden fixed inset-0 z-50 flex items-center justify-center p-4" dir="rtl">
    <div class="absolute inset-0 bg-black/80 backdrop-blur-md" onclick="document.getElementById('stickerUploadModal').classList.add('hidden')"></div>
    <div class="relative w-full max-w-lg bg-[#141414] border border-white/10 rounded-2xl shadow-2xl overflow-hidden">
        {{-- Header --}}
        <div class="bg-gradient-to-r from-[#D4A356]/10 to-[#442247]/10 border-b border-white/10 px-6 py-4 flex items-center justify-between">
            <h3 class="cairo text-xl font-black text-white">رفع ملصق جديد</h3>
            <button onclick="document.getElementById('stickerUploadModal').classList.add('hidden')" 
                    class="w-8 h-8 rounded-lg bg-white/5 hover:bg-white/10 flex items-center justify-center text-gray-400 hover:text-white transition-colors">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                </svg>
            </button>
        </div>
        
        {{-- Body --}}
        <form action="{{ route('stickers.store') }}" method="POST" enctype="multipart/form-data" id="stickerForm" class="p-6">
            @csrf
            <div class="space-y-5">
                {{-- Name --}}
                <div>
                    <label class="cairo text-white text-sm font-bold mb-2 flex items-center gap-1">
                        اسم الملصق 
                        <span class="text-red-400">*</span>
                    </label>
                    <input type="text" name="name" required 
                           class="cairo w-full px-4 py-3 rounded-xl bg-white/5 border border-white/10 focus:border-[#D4A356] focus:ring-2 focus:ring-[#D4A356]/20 outline-none text-white placeholder-gray-500 text-sm transition-all" 
                           placeholder="مثال: زخرفة إسلامية">
                </div>
                
                {{-- Category --}}
                <div>
                    <label class="cairo text-white text-sm font-bold mb-2 block">التصنيف</label>
                    <div class="relative">
                        <select name="category" 
                                class="cairo w-full px-4 py-3 rounded-xl bg-white/5 border border-white/10 focus:border-[#D4A356] focus:ring-2 focus:ring-[#D4A356]/20 outline-none text-white text-sm transition-all appearance-none cursor-pointer pr-10"
                                style="color-scheme: dark;">
                            <option value="" style="background-color: #0a0a0a; color: white;">اختر تصنيف (اختياري)</option>
                            <option value="زخارف" style="background-color: #0a0a0a; color: white;">🎨 زخارف</option>
                            <option value="نصوص" style="background-color: #0a0a0a; color: white;">📝 نصوص</option>
                            <option value="شعارات" style="background-color: #0a0a0a; color: white;">🏷️ شعارات</option>
                            <option value="أنماط" style="background-color: #0a0a0a; color: white;">✨ أنماط</option>
                            <option value="رموز" style="background-color: #0a0a0a; color: white;">🔰 رموز</option>
                            <option value="أخرى" style="background-color: #0a0a0a; color: white;">📁 أخرى</option>
                        </select>
                        <div class="absolute left-3 top-1/2 -translate-y-1/2 pointer-events-none">
                            <svg class="w-5 h-5 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                            </svg>
                        </div>
                    </div>
                </div>
                
                {{-- Description --}}
                <div>
                    <label class="cairo text-white text-sm font-bold mb-2 block">الوصف</label>
                    <textarea name="description" rows="3" 
                              class="cairo w-full px-4 py-3 rounded-xl bg-white/5 border border-white/10 focus:border-[#D4A356] focus:ring-2 focus:ring-[#D4A356]/20 outline-none text-white placeholder-gray-500 text-sm resize-none transition-all" 
                              placeholder="وصف مختصر للملصق..."></textarea>
                </div>
                
                {{-- Image Upload --}}
                <div>
                    <label class="cairo text-white text-sm font-bold mb-2 flex items-center gap-1">
                        صورة الملصق 
                        <span class="text-red-400">*</span>
                        <span class="text-gray-500 text-xs font-normal mr-auto">(PNG شفاف مفضّل)</span>
                    </label>
                    <input type="file" name="image" required accept="image/*" id="stickerImageInput" class="hidden">
                    <label for="stickerImageInput" 
                           class="block w-full p-6 rounded-xl border-2 border-dashed border-white/10 hover:border-[#D4A356]/50 bg-white/5 hover:bg-[#D4A356]/5 cursor-pointer transition-all group">
                        <div class="flex flex-col items-center gap-3">
                            <div class="w-16 h-16 rounded-xl bg-[#D4A356]/10 flex items-center justify-center group-hover:scale-110 transition-transform">
                                <svg class="w-8 h-8 text-[#D4A356]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M2.25 15.75l5.159-5.159a2.25 2.25 0 013.182 0l5.159 5.159m-1.5-1.5l1.409-1.409a2.25 2.25 0 013.182 0l2.909 2.909M3.75 21h16.5a1.5 1.5 0 001.5-1.5V4.5a1.5 1.5 0 00-1.5-1.5H3.75a1.5 1.5 0 00-1.5 1.5v15a1.5 1.5 0 001.5 1.5zm13.097-13.097a.75.75 0 10-1.06-1.06.75.75 0 001.06 1.06z" />
                                </svg>
                            </div>
                            <div class="text-center">
                                <span class="cairo block text-sm font-bold text-white group-hover:text-[#D4A356] transition-colors">اضغط لاختيار صورة</span>
                                <span class="cairo text-xs text-gray-500 mt-1 block">PNG, JPG, SVG - حتى 5MB</span>
                            </div>
                        </div>
                    </label>
                    <div id="imagePreview" class="hidden mt-3 p-3 rounded-xl bg-white/5 border border-white/10">
                        <div class="flex items-center gap-3">
                            <img src="" alt="معاينة" class="w-20 h-20 rounded-lg object-contain bg-[#0a0a0a]">
                            <div class="flex-1 min-w-0">
                                <p class="text-white text-sm font-bold truncate" id="fileName"></p>
                                <p class="text-gray-500 text-xs" id="fileSize"></p>
                            </div>
                            <button type="button" onclick="clearImagePreview()" class="w-8 h-8 rounded-lg bg-red-500/10 hover:bg-red-500/20 flex items-center justify-center text-red-400 transition-colors">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                                </svg>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            
            {{-- Actions --}}
            <div class="flex gap-3 mt-6 pt-5 border-t border-white/10">
                <button type="button" onclick="document.getElementById('stickerUploadModal').classList.add('hidden')" 
                        class="cairo px-6 py-3 rounded-xl bg-white/5 border border-white/10 text-gray-400 font-bold text-sm hover:bg-white/10 hover:text-white hover:border-white/20 transition-all">
                    إلغاء
                </button>
                <button type="submit" 
                        class="cairo flex-1 py-3 rounded-xl bg-gradient-to-r from-[#D4A356] to-[#B0924E] text-black font-black text-sm hover:scale-[1.02] hover:shadow-xl hover:shadow-[#D4A356]/30 transition-all flex items-center justify-center gap-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"/>
                    </svg>
                    رفع الملصق
                </button>
            </div>
        </form>
    </div>
</div>

@push('scripts')
<script>
    // Image preview
    document.getElementById('stickerImageInput').addEventListener('change', function(e) {
        const file = e.target.files[0];
        if (file) {
            const preview = document.getElementById('imagePreview');
            const img = preview.querySelector('img');
            const fileName = document.getElementById('fileName');
            const fileSize = document.getElementById('fileSize');
            
            img.src = URL.createObjectURL(file);
            fileName.textContent = file.name;
            fileSize.textContent = (file.size / 1024 / 1024).toFixed(2) + ' MB';
            preview.classList.remove('hidden');
        }
    });

    function clearImagePreview() {
        document.getElementById('stickerImageInput').value = '';
        document.getElementById('imagePreview').classList.add('hidden');
    }

    // Form submission
    document.getElementById('stickerForm').addEventListener('submit', async function(e) {
        e.preventDefault();
        
        const form = e.target;
        const submitBtn = form.querySelector('button[type="submit"]');
        const btnText = submitBtn.innerHTML;
        
        // Show loading state
        submitBtn.disabled = true;
        submitBtn.innerHTML = '<svg class="animate-spin w-5 h-5 text-black" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg> جاري الرفع...';
        
        try {
            const formData = new FormData(form);
            const response = await fetch(form.action, {
                method: 'POST',
                body: formData,
                headers: {
                    'X-Requested-With': 'XMLHttpRequest'
                }
            });
            
            if (response.ok) {
                // Success - reload page
                window.location.reload();
            } else {
                // Error
                alert('حدث خطأ أثناء رفع الملصق. يرجى المحاولة مرة أخرى.');
                submitBtn.disabled = false;
                submitBtn.innerHTML = btnText;
            }
        } catch (error) {
            alert('حدث خطأ في الاتصال. يرجى المحاولة مرة أخرى.');
            submitBtn.disabled = false;
            submitBtn.innerHTML = btnText;
        }
    });
</script>
@endpush
